/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.MevAttributes;
import org.tigr.microarray.converter.Converter;
import org.tigr.microarray.converter.MevConverter;
import org.tigr.util.FileReading;
import org.tigr.util.MyTimer;
import org.tigr.util.io.IOUtil;
import org.tigr.util.io.MyIni;

public class AgilentMev
extends MevConverter
implements MevAttributes {
    final String BG_MED_SIGNAL = "BGMedianSignal";
    final String BG_NUM_PIX = "BGNumPix";
    final String COL = "Col";
    final String DESC = "Description";
    final String FEATURES = "FEATURES";
    final String FEATURE_NUM = "FeatureNum";
    final String MED_SIGNAL = "MedianSignal";
    final String NUM_PIX = "NumPix";
    final String POS_X = "PositionX";
    final String RW = "Row";
    String gBkgMedSignalA;
    String gBkgMedSignalB;
    String gBkgPixelA;
    String gBkgPixelB;
    String gChApixel;
    String gChBpixel;
    String gMedSignalA;
    String gMedSignalB;
    private JFrame parent;
    private String inFileNamePath;
    private String mevFileName;
    private String barTitle;
    int gAnnType;
    int gPosX;
    int gColIndex;
    private final int TOTAL = 0;
    private final int MEAN = 1;
    private final int MODE = 2;
    private final int MEDIAN = 3;

    public AgilentMev(String afName, String mfName, String title) {
        this.inFileNames = new Vector(1);
        this.outFileNames = new Vector(1);
        this.inFileNames.add(afName);
        this.outFileNames.add(mfName);
        this.barTitle = title;
    }

    public AgilentMev(JFrame p, Vector afNames, Vector mfNames, String title, int annNum) {
        this.parent = p;
        this.inFileNames = afNames;
        this.outFileNames = mfNames;
        this.barTitle = title;
        this.gAnnType = annNum;
    }

    public void run() {
        String aLine = new String("");
        String densA = new String("");
        String densB = new String("");
        String bgA = new String("");
        String bgB = new String("");
        String medA = new String("null");
        String medB = new String("null");
        String unid = new String("");
        String[] channels = new String[]{"g", "r"};
        String[] annoFile = null;
        StringBuffer mevLine = new StringBuffer(200);
        StringBuffer extraInfo = new StringBuffer(200);
        BufferedWriter mevWriter = null;
        BufferedWriter annoWriter = null;
        FileOutputStream mevFileOut = null;
        this.taskEnd = this.determineTaskEnd();
        if (this.taskEnd == 1) {
            return;
        }
        this.taskEnd <<= 1;
        this.counter = 0;
        int numOfFiles = this.inFileNames.size();
        int i = 0;
        while (i < numOfFiles) {
            Vector aligentFile;
            boolean noError;
            block36: {
                noError = true;
                this.inFileNamePath = (String)this.inFileNames.elementAt(i);
                this.mevFileName = (String)this.outFileNames.elementAt(i);
                try {
                    FileReading fileReader = new FileReading(this.inFileNamePath);
                    if (fileReader.done) {
                        aligentFile = fileReader.getFileContentInLines();
                        break block36;
                    }
                    this.setErrorMessage(fileReader.getProcessMessage());
                    this.taskEnd = 1;
                    this.counter = 1;
                    return;
                }
                catch (IOException e) {
                    this.setErrorMessage(e.getMessage());
                    this.taskEnd = 1;
                    this.counter = 1;
                    return;
                }
            }
            String[] dataStart = this.getValueAndIndex(aligentFile, "FEATURES");
            int hLines = Integer.parseInt(dataStart[1]);
            int lastLine = aligentFile.size() - 1;
            int numSpot = lastLine - hLines;
            aLine = (String)aligentFile.elementAt(hLines);
            this.defineKeys(channels);
            String[] colNames = this.separateLine(aLine);
            aLine = (String)aligentFile.elementAt(lastLine);
            String[] colValues = this.separateLine(aLine);
            if (colValues.length < 2) {
                JOptionPane.showMessageDialog(this.parent, "You might add extra space at the end of file.\nPlease remove it and try again.", this.parent.getTitle(), 0);
                noError = false;
                this.counter += numOfFiles;
            }
            if (noError) {
                int rowIndex = this.findRightCol(colNames, "Row");
                this.gColIndex = this.findRightCol(colNames, "Col");
                int unidLoc = this.findRightCol(colNames, "FeatureNum");
                int ch1AreaLoc = this.findRightCol(colNames, this.gChApixel);
                int ch2AreaLoc = this.findRightCol(colNames, this.gChBpixel);
                int ch1IntenLoc = this.findRightCol(colNames, this.gMedSignalA);
                int ch1Bkg = this.findRightCol(colNames, this.gBkgMedSignalA);
                int ch2IntenLoc = this.findRightCol(colNames, this.gMedSignalB);
                int ch2Bkg = this.findRightCol(colNames, this.gBkgMedSignalB);
                int ch1BkgArea = this.findRightCol(colNames, this.gBkgPixelA);
                int ch2BkgArea = this.findRightCol(colNames, this.gBkgPixelB);
                this.gPosX = this.findRightCol(colNames, "PositionX");
                String annoFileNamePath = IOUtil.dropExtension(this.mevFileName);
                annoFileNamePath = annoFileNamePath + ".ann";
                try {
                    mevFileOut = new FileOutputStream(this.mevFileName);
                    mevWriter = new BufferedWriter(new OutputStreamWriter(mevFileOut));
                    this.sortKeys = new int[3][numSpot];
                    this.outFile = new String[numSpot];
                    String aligentFileName = IOUtil.extractFileNameFromPath(this.inFileNamePath);
                    String[] mevFileHeader = this.generateHeader(colNames, aligentFileName, numSpot, true);
                    int j = 0;
                    while (j < mevFileHeader.length) {
                        mevWriter.write(mevFileHeader[j]);
                        mevWriter.newLine();
                        mevWriter.flush();
                        ++j;
                    }
                    if (this.gAnnType == 1) {
                        annoFile = new String[numSpot];
                        annoWriter = this.createAnnoWriter(colNames, annoFileNamePath, aligentFileName, numSpot);
                    } else if (i < 1) {
                        annoFile = new String[numSpot];
                        annoWriter = this.createAnnoWriter(colNames, annoFileNamePath, aligentFileName, numSpot);
                    }
                    this.counter += hLines;
                    int metaRow = 1;
                    int metaCol = 1;
                    j = hLines + 1;
                    int k = 0;
                    while (j <= lastLine) {
                        int annAddr;
                        int row;
                        aLine = (String)aligentFile.elementAt(j);
                        colValues = this.separateLine(aLine);
                        unid = colValues[unidLoc];
                        int col = Integer.parseInt(colValues[this.gColIndex]);
                        int slideRow = row = Integer.parseInt(colValues[rowIndex]);
                        int slideCol = col;
                        String spAreaA = colValues[ch1AreaLoc];
                        String spAreaB = colValues[ch2AreaLoc];
                        bgA = this.calculateBackground(colValues, ch1Bkg, ch1BkgArea);
                        bgB = this.calculateBackground(colValues, ch2Bkg, ch2BkgArea);
                        mevLine.append(unid).append("\t");
                        if (this.gBkgCorrect) {
                            densA = this.getIntegrateIntensity(colValues, ch1IntenLoc, ch1Bkg, ch1AreaLoc, true);
                            densB = this.getIntegrateIntensity(colValues, ch2IntenLoc, ch2Bkg, ch2AreaLoc, true);
                            medA = this.getMedianIntensity(colValues, ch1IntenLoc, ch1Bkg, true);
                            medB = this.getMedianIntensity(colValues, ch2IntenLoc, ch2Bkg, true);
                        } else {
                            densA = this.getIntegrateIntensity(colValues, ch1IntenLoc, ch1Bkg, ch1AreaLoc, false);
                            densB = this.getIntegrateIntensity(colValues, ch2IntenLoc, ch2Bkg, ch2AreaLoc, false);
                            medA = this.getMedianIntensity(colValues, ch1IntenLoc, ch1Bkg, false);
                            medB = this.getMedianIntensity(colValues, ch2IntenLoc, ch2Bkg, false);
                        }
                        if (this.gUseMedian) {
                            mevLine.append(medA).append("\t").append(medB);
                            aLine = densA + "\t" + densB;
                        } else {
                            mevLine.append(densA).append("\t").append(densB);
                            aLine = medA + "\t" + medB;
                        }
                        mevLine.append("\t").append(slideRow).append("\t").append(slideCol);
                        mevLine.append("\t").append(metaRow).append("\t").append(metaCol);
                        mevLine.append("\t").append(row).append("\t").append(col).append("\t");
                        mevLine.append(bgA).append("\t").append(bgB).append("\t").append(spAreaA);
                        mevLine.append("\t").append(spAreaB).append("\t").append(aLine);
                        this.outFile[k] = new String(mevLine.toString());
                        mevLine.delete(0, mevLine.length());
                        if (this.gAnnType == 1) {
                            extraInfo.append(unid).append("\t").append(slideRow).append("\t");
                            extraInfo.append(slideCol).append("\t");
                            annAddr = this.gColIndex + 1;
                            while (annAddr < this.gPosX - 1) {
                                extraInfo.append(colValues[annAddr]).append("\t");
                                ++annAddr;
                            }
                            extraInfo.append(colValues[annAddr]);
                            annoFile[k] = extraInfo.toString();
                            extraInfo.delete(0, extraInfo.length());
                        } else if (i < 1) {
                            extraInfo.append(unid).append("\t").append(slideRow).append("\t");
                            extraInfo.append(slideCol).append("\t");
                            annAddr = this.gColIndex + 1;
                            while (annAddr < this.gPosX - 1) {
                                extraInfo.append(colValues[annAddr]).append("\t");
                                ++annAddr;
                            }
                            extraInfo.append(colValues[annAddr]);
                            annoFile[k] = extraInfo.toString();
                            extraInfo.delete(0, extraInfo.length());
                        }
                        this.sortKeys[0][k] = k;
                        this.sortKeys[1][k] = slideRow;
                        this.sortKeys[2][k] = slideCol;
                        ++this.counter;
                        ++j;
                        ++k;
                    }
                    if (this.wantSort) {
                        this.sorted = this.sortUnbalancedRowCol();
                        j = 0;
                        while (j < this.outFile.length) {
                            mevWriter.write(this.outFile[this.sorted[j]]);
                            mevWriter.newLine();
                            mevWriter.flush();
                            if (this.gAnnType == 1) {
                                annoWriter.write(annoFile[this.sorted[j]]);
                                annoWriter.newLine();
                                annoWriter.flush();
                            } else if (i < 1) {
                                annoWriter.write(annoFile[this.sorted[j]]);
                                annoWriter.newLine();
                                annoWriter.flush();
                            }
                            ++this.counter;
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < this.outFile.length) {
                            mevWriter.write(this.outFile[j]);
                            mevWriter.newLine();
                            mevWriter.flush();
                            if (this.gAnnType == 1) {
                                annoWriter.write(annoFile[j]);
                                annoWriter.newLine();
                                annoWriter.flush();
                            } else if (i < 1) {
                                annoWriter.write(annoFile[j]);
                                annoWriter.newLine();
                                annoWriter.flush();
                            }
                            ++this.counter;
                            ++j;
                        }
                    }
                    mevFileOut.close();
                    if (this.gAnnType == 1) {
                        annoWriter.close();
                    } else if (i < 1) {
                        annoWriter.close();
                    }
                }
                catch (IOException ie) {
                    this.setErrorMessage("Error in writing file: " + ie.getMessage() + "\n");
                }
            }
            ++i;
        }
        Converter.ready = true;
        this.counter = this.taskEnd;
    }

    private String calculateBackground(String[] tuple, int backg, int area) {
        String bg = new String("");
        try {
            float fPix = Float.parseFloat(tuple[area]);
            float bMedian = Float.parseFloat(tuple[backg]);
            float temp = bMedian * fPix;
            bg = bg + (int)temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            bg = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value to calculate background;\n";
            this.msg = this.msg + "and the background was set to null.\n";
        }
        return bg;
    }

    private String getMedianIntensity(String[] tuple, int med, int backg, boolean bgSub) {
        String den;
        block3: {
            den = new String("");
            try {
                float fMedian = Float.parseFloat(tuple[med]);
                float bMedian = Float.parseFloat(tuple[backg]);
                if (bgSub) {
                    den = den + (int)(fMedian - bMedian);
                    break block3;
                }
                den = den + (int)fMedian;
            }
            catch (NumberFormatException nfex) {
                Converter.minorError = true;
                den = "null";
                this.msg = this.msg + "**********\n";
                this.msg = this.msg + "There is an unacceptable value to calculate intensity and the intensity was set to null.\n";
            }
        }
        return den;
    }

    private String[] generateHeader(String[] cNames, String fName, int numRow, boolean mev) {
        String[] tempHeader = mev ? new String[8] : new String[7];
        String bkgVal = this.gBkgCorrect ? "ON" : "OFF";
        tempHeader[0] = new String("# version: V1.0");
        tempHeader[1] = new String("# format_version:V4.0");
        tempHeader[2] = new String("# date: " + MyTimer.getCurrentDateAndTime('.'));
        tempHeader[3] = new String("# created by: " + this.barTitle);
        tempHeader[4] = new String("# row_count:" + numRow);
        tempHeader[5] = new String("# converted from Agilent file: " + fName);
        if (mev) {
            tempHeader[6] = new String("# background_correction:" + bkgVal);
            tempHeader[7] = this.gUseMedian ? "UID\tMedA\tMedB\tR\tC\tMR\tMC\tSR\tSC\tBkgA\tBkgB\tSAA\tSAB\tIA\tIB" : "UID\tIA\tIB\tR\tC\tMR\tMC\tSR\tSC\tBkgA\tBkgB\tSAA\tSAB\tMedA\tMedB";
        } else {
            tempHeader[6] = "UID\tR\tC\t";
            int i = this.gColIndex + 1;
            while (i < this.gPosX - 1) {
                tempHeader[6] = tempHeader[6] + cNames[i] + "\t";
                ++i;
            }
            tempHeader[6] = tempHeader[6] + cNames[i];
        }
        return tempHeader;
    }

    private String getIntegrateIntensity(String[] tuple, int med, int backg, int areaIndx, boolean bgSub) {
        String den = new String("");
        try {
            float median = Float.parseFloat(tuple[med]);
            float bMed = Float.parseFloat(tuple[backg]);
            float pix = Float.parseFloat(tuple[areaIndx]);
            float temp = bgSub ? (median - bMed) * pix : median * pix;
            den = den + (int)temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            den = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value to calculate intensity and the intensity was set to null.\n";
        }
        return den;
    }

    private String[] getValueAndIndex(Vector fileCont, String key) {
        StringTokenizer token = null;
        int size = fileCont.size();
        String temp = new String("");
        String wantKey = new String("");
        String[] value = new String[2];
        int i = 0;
        while (i < size) {
            temp = (String)fileCont.elementAt(i);
            if (!temp.equals("") && this.isChar(temp.charAt(0)) && (wantKey = (token = new StringTokenizer(temp, "\t")).nextToken()).equalsIgnoreCase(key)) {
                value[0] = new String(MyIni.removeEndSpace(wantKey));
                value[1] = "" + i;
                i = size;
            }
            ++i;
        }
        return value;
    }

    private BufferedWriter createAnnoWriter(String[] cNames, String fName, String inName, int numSpots) {
        BufferedWriter out;
        try {
            FileOutputStream fOut = new FileOutputStream(fName);
            out = new BufferedWriter(new OutputStreamWriter(fOut));
            String[] annoFileHeader = this.generateHeader(cNames, inName, numSpots, false);
            int i = 0;
            while (i < annoFileHeader.length) {
                out.write(annoFileHeader[i]);
                out.newLine();
                out.flush();
                ++i;
            }
        }
        catch (IOException ie) {
            Converter.fetalError = true;
            Converter.ready = false;
            System.out.println("Error in creating ann file: " + ie.getMessage());
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "Error in creating ann file: " + ie.getMessage() + "\n";
            return null;
        }
        return out;
    }

    private void defineKeys(String[] chs) {
        this.gMedSignalA = new String(chs[0] + "MedianSignal");
        this.gMedSignalB = new String(chs[1] + "MedianSignal");
        this.gChApixel = new String(chs[0] + "NumPix");
        this.gChBpixel = new String(chs[1] + "NumPix");
        this.gBkgMedSignalA = new String(chs[0] + "BGMedianSignal");
        this.gBkgMedSignalB = new String(chs[1] + "BGMedianSignal");
        this.gBkgPixelA = new String(chs[0] + "BGNumPix");
        this.gBkgPixelB = new String(chs[1] + "BGNumPix");
    }

    private int findRightCol(String[] str, String key) {
        int addr = 0;
        int size = str.length;
        String temp = new String("");
        int i = 0;
        while (i < str.length) {
            if (str[i].equalsIgnoreCase(key)) {
                addr = i;
                i = str.length;
            }
            ++i;
        }
        return addr;
    }

    private boolean isChar(char x) {
        boolean b = true;
        switch (x) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                b = false;
                break;
            }
            default: {
                b = true;
            }
        }
        return b;
    }
}

