/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.microarray.converter.ExpressConverter;
import org.tigr.util.LongTextChanger;
import org.tigr.util.awt.GBA;
import org.tigr.util.io.IOUtil;

public abstract class ConvertPanel
extends JPanel {
    protected BevelBorder gLow = new BevelBorder(1);
    protected ButtonGroup intenGroup;
    protected JCheckBox sortCB;
    protected JCheckBox gBkgCB;
    protected JLabel emptyLB;
    protected JLabel gInputFileLB;
    protected JLabel gOutputFileLB;
    protected JLabel gFileNumLB;
    protected JList gOutputFileList;
    protected JPanel gIntenPanel;
    protected JPanel gOutputPL;
    protected JPanel gInputPL;
    protected JRadioButton gIntegrateRB;
    protected JRadioButton gMedianRB;
    protected JScrollPane gFilesSP;
    protected JScrollPane gInputSP;
    protected JSplitPane gFileSplitPane;
    protected final String[] FILE_TYPE = new String[]{"tav", "mev"};
    protected final String MEV_FILE = "MEV Files:";
    protected final String TAV_FILE = "TAV Files:";
    protected final String NUM_FILE = "  Number of Files:  ";
    protected final int TAV_OUT = 0;
    protected GBA gba;
    protected ExpressConverter parent;
    protected boolean wantSort;
    protected boolean outputReady;
    protected boolean gUseMedian;
    protected boolean gSubBkg;
    protected Vector selectedFiles;
    protected Vector outputFileNames;
    protected int outputType;

    public ConvertPanel() {
        this((ExpressConverter)null);
    }

    public ConvertPanel(ExpressConverter ec) {
        this.parent = ec;
        this.wantSort = true;
        this.outputReady = false;
        this.gUseMedian = true;
        this.gSubBkg = true;
        this.outputType = 1;
        this.selectedFiles = new Vector(10, 3);
        this.outputFileNames = new Vector(10, 3);
        this.gba = new GBA();
        this.gLow = new BevelBorder(1);
        this.initialComponents();
    }

    public void activeIntensityWay(boolean way) {
        if (way) {
            ((TitledBorder)this.gIntenPanel.getBorder()).setTitleColor(Color.black);
        } else {
            ((TitledBorder)this.gIntenPanel.getBorder()).setTitleColor(Color.gray);
        }
        this.gIntenPanel.setEnabled(way);
        this.gIntegrateRB.setEnabled(way);
        this.gMedianRB.setEnabled(way);
        this.gBkgCB.setEnabled(way);
    }

    public boolean getIntensityType() {
        return this.gUseMedian;
    }

    public int getOutputTypeFromFile() {
        int type = 1;
        if (this.outputFileNames.size() > 0) {
            String temp = (String)this.outputFileNames.elementAt(0);
            type = (temp = IOUtil.getFileNameExtension(temp)).equalsIgnoreCase("tav") ? 0 : 1;
        }
        return type;
    }

    public boolean isBackgroundCorrected() {
        return this.gSubBkg;
    }

    public boolean wantSort() {
        return this.wantSort;
    }

    protected void actionHandler(JRadioButton btn) {
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConvertPanel.this.gUseMedian = !ConvertPanel.this.gIntegrateRB.isSelected();
            }
        });
    }

    protected void actionHandler(JList l) {
        JList list = l;
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                ConvertPanel.this.outputReady = ConvertPanel.this.gOutputFileList.getModel().getSize() > 0;
                ConvertPanel.this.parent.activateButton(ConvertPanel.this.outputReady, ConvertPanel.this.outputReady);
            }
        });
    }

    public void editDirectory(String path) {
        int selected = -1;
        String tempPath = path;
        selected = this.gOutputFileList.getSelectedIndex();
        int num = this.outputFileNames.size();
        int i = 0;
        while (i < num) {
            String tempName = (String)this.outputFileNames.elementAt(i);
            tempName = IOUtil.extractFileNameFromPath(tempName);
            tempName = tempPath + "\\" + tempName;
            this.outputFileNames.setElementAt(tempName, i);
            ++i;
        }
        this.gOutputFileList.setListData(this.outputFileNames);
        if (selected >= 0) {
            this.gOutputFileList.setSelectedIndex(selected);
        } else {
            this.gOutputFileList.setSelectedIndex(0);
        }
    }

    public void editFileName() {
        int selected = -1;
        selected = this.gOutputFileList.getSelectedIndex();
        if (selected >= 0) {
            String tempName = (String)this.gOutputFileList.getModel().getElementAt(selected);
            LongTextChanger changer = new LongTextChanger(this.parent, true, tempName);
            changer.setTitle("ExpressConveter V.1.7");
            changer.show();
            if (changer.isTextChanged()) {
                tempName = changer.getText();
                StringTokenizer token = new StringTokenizer(tempName, ":");
                if (token.countTokens() <= 1) {
                    tempName = "c:\\" + tempName;
                }
                tempName = (tempName = IOUtil.dropExtension(tempName)).lastIndexOf(46) == tempName.length() - 1 ? tempName + this.FILE_TYPE[this.outputType] : tempName + "." + this.FILE_TYPE[this.outputType];
                this.outputFileNames.setElementAt(tempName, selected);
                this.gOutputFileList.setListData(this.outputFileNames);
                this.gOutputFileList.setSelectedIndex(selected);
            }
        }
    }

    protected void showError(String error) {
        this.parent.getToolkit().beep();
        JOptionPane.showMessageDialog(this.parent, error, "ExpressConveter V.1.7", 0);
    }

    private void initialComponents() {
        int sizeX = (int)((double)ExpressConverter.scrWidth * 0.83);
        int sizeY = (int)((double)ExpressConverter.scrHeight * 0.7);
        this.gOutputFileLB = new JLabel("MEV Files:");
        this.gFileNumLB = new JLabel("  Number of Files:  ");
        this.gFileNumLB.setBorder(this.gLow);
        this.gInputPL = new JPanel(new GridBagLayout());
        this.gOutputFileList = new JList();
        this.gOutputFileList.setBorder(this.gLow);
        this.gOutputFileList.setSelectionMode(0);
        this.gInputSP = new JScrollPane(this.gOutputFileList);
        this.gOutputPL = new JPanel(new GridBagLayout());
        this.gIntenPanel = new JPanel();
        this.gIntenPanel.setBorder(new TitledBorder("  Preferred Intensity ... "));
        this.gIntegrateRB = new JRadioButton("Integrated");
        this.gMedianRB = new JRadioButton("Median");
        this.actionHandler(this.gIntegrateRB);
        this.actionHandler(this.gMedianRB);
        this.gFileSplitPane = new JSplitPane(0, true, this.gInputPL, this.gOutputPL);
        this.gFileSplitPane.setSize(sizeX, sizeY >> 1);
        this.gFileSplitPane.setDividerSize(4);
        this.gFileSplitPane.setDividerLocation(0.5);
        this.emptyLB = new JLabel("          ");
        this.gBkgCB = new JCheckBox("Subtract Backgroud:");
        this.gBkgCB.setHorizontalTextPosition(2);
        this.gBkgCB.setSelected(this.gSubBkg);
        this.gBkgCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ce) {
                ConvertPanel.this.gSubBkg = ConvertPanel.this.gBkgCB.isSelected();
            }
        });
        this.intenGroup = new ButtonGroup();
        this.intenGroup.add(this.gIntegrateRB);
        this.intenGroup.add(this.gMedianRB);
        this.gMedianRB.setSelected(this.gUseMedian);
        this.sortCB = new JCheckBox("Sort by Slide Rows and Slide Columns");
        this.sortCB.setSelected(true);
        this.sortCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ce) {
                ConvertPanel.this.wantSort = ConvertPanel.this.sortCB.isSelected();
            }
        });
        this.gba.add(this.gOutputPL, this.gOutputFileLB, 0, 0, 1, 1, 1, 0, 2, 17, 5, 10, 2, 2);
        this.gba.add(this.gOutputPL, this.gInputSP, 0, 1, 1, 1, 1, 1, 1, 10, 1, 2, 5, 2);
        this.gba.add(this.gOutputPL, this.gFileNumLB, 0, 2, 1, 1, 1, 0, 2, 10, 1, 2, 5, 2);
        this.gba.add(this.gIntenPanel, this.gMedianRB, 0, 0, 1, 1, 0, 0, 0, 17, 1, 0, 1, 0);
        this.gba.add(this.gIntenPanel, this.gIntegrateRB, 1, 0, 1, 1, 0, 0, 0, 17, 1, 5, 1, 20);
        this.gba.add(this.gIntenPanel, this.emptyLB, 2, 0, 1, 1, 1, 1, 1, 10, 10, 5, 1, 10);
        this.gba.add(this.gIntenPanel, this.gBkgCB, 3, 0, 1, 1, 0, 0, 0, 13, 1, 10, 1, 2);
    }

    abstract void createGUI();

    abstract Vector getOutputFileNames();

    abstract void setSelectedFiles(String[] var1);

    abstract void adjustGUI(int var1);

    abstract void removeFileFromList();

    abstract void reset();
}

