/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.microarray.converter.ExpressConverter;
import org.tigr.util.awt.GBA;
import org.tigr.util.io.MyIni;

public class ConverterOption
extends JDialog
implements ActionListener,
ListSelectionListener,
ChangeListener {
    private GBA gba;
    private JButton gCancelButn;
    private JButton gFileTypeAddButn;
    private JButton gFileTypeEditButn;
    private JButton gFileTypeRemoveButn;
    private JButton gOkButn;
    private JLabel gFileTypeLB;
    private JLabel gFileLineLB;
    private JList gFileTypeList;
    private JPanel gFileTypeButnPL;
    private JPanel gFileTypeEntryPL;
    private JPanel gFileTypePL;
    private JPanel gFxnPL;
    private JPanel gNumPL;
    private JPanel gSelectionPL;
    private JScrollPane gFileTypeSP;
    private JSpinner gNumSP;
    private JTabbedPane gSetSelectionTP;
    public boolean dataEntered = false;
    public boolean dirtyData = false;
    private int gNumLine;
    private Dimension gParentSize;
    private int sizeX = 230;
    private int sizeY = 200;
    private int x;
    private int y;
    private ExpressConverter parent;
    private String gFileExts;
    private Vector gFileTypes;

    public ConverterOption(ExpressConverter p, boolean modal) {
        super((Frame)p, modal);
        this.parent = p;
        this.gFileTypes = this.parent.getCustomizedFileTypes();
        this.gNumLine = this.parent.getPreviewLine();
        this.initComponents(this.parent);
        this.pack();
    }

    public String getCustomizedFileNameExtensions() {
        return this.gFileExts;
    }

    public int getPreviewFileSize() {
        return this.gNumLine;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.gCancelButn) {
            this.dataEntered = false;
            this.setVisible(false);
            this.dispose();
        } else if (ae.getSource() == this.gOkButn) {
            if (this.setData()) {
                this.dataEntered = true;
                this.setVisible(false);
                this.dispose();
            }
        } else if (ae.getSource() == this.gFileTypeAddButn) {
            this.addCustomizedFileType();
        } else if (ae.getSource() == this.gFileTypeEditButn) {
            this.editFileTypes(true);
        } else if (ae.getSource() == this.gFileTypeRemoveButn) {
            this.editFileTypes(false);
        }
    }

    public void stateChanged(ChangeEvent ce) {
        this.gNumLine = Integer.parseInt(this.gNumSP.getValue().toString());
        this.dirtyData = true;
        if (this.gNumLine < 1) {
            this.gNumSP.setValue(new Integer(1));
        }
    }

    public void valueChanged(ListSelectionEvent ie) {
        this.dirtyData = true;
    }

    private void addCustomizedFileType() {
        String newName = new String("");
        newName = JOptionPane.showInputDialog(this, "Please entey new file name extension.", this.getTitle(), 1);
        if (newName != null && !newName.equals("")) {
            if (this.isValidEntry(newName)) {
                this.updateFileTypes(newName);
            } else {
                this.showError("The file extension has 3 character limit and requires no space in it.");
            }
        }
    }

    private Vector addAndOrderList(Vector vec, String str) {
        Vector temp = vec;
        boolean last = true;
        int size = vec.size();
        int i = 0;
        while (i < size) {
            String tempStr = (String)temp.elementAt(i);
            if (tempStr.compareToIgnoreCase(str) > 0) {
                temp.insertElementAt(str, i);
                last = false;
                i = size;
            }
            ++i;
        }
        if (last) {
            temp.add(str);
        }
        return temp;
    }

    private void initComponents(Frame p) {
        int butnWide = 75;
        int butnHigh = 27;
        BevelBorder high = new BevelBorder(0);
        BevelBorder low = new BevelBorder(1);
        this.gba = new GBA();
        this.setTitle("ExpressConveter V.1.6" + " -- Preference");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConverterOption.this.dataEntered = false;
                ConverterOption.this.setVisible(false);
                ConverterOption.this.dispose();
            }
        });
        this.gSelectionPL = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)this.gSelectionPL, "Center");
        this.gFileTypePL = new JPanel(new GridBagLayout());
        this.gFileTypePL.setPreferredSize(new Dimension(290, 240));
        this.gFileTypeButnPL = new JPanel(new GridBagLayout());
        this.gSetSelectionTP = new JTabbedPane();
        this.gSetSelectionTP.setPreferredSize(new Dimension(this.sizeX - 10, this.sizeY - 10));
        this.gSelectionPL.add(this.gSetSelectionTP);
        this.gSetSelectionTP.addTab(" Customized Input File ", null, this.gFileTypePL);
        this.gFileTypeEntryPL = new JPanel(new GridBagLayout());
        this.gFileTypeEntryPL.setPreferredSize(new Dimension(270, 150));
        this.gFileTypeLB = new JLabel("File Name Extension:");
        this.gFileTypeList = new JList(this.gFileTypes);
        this.gFileTypeList.addListSelectionListener(this);
        this.gFileTypeSP = new JScrollPane(this.gFileTypeList, 20, 30);
        this.gFileTypeList.setBorder(low);
        this.gFileTypeList.setPreferredSize(new Dimension(this.sizeX / 3, butnHigh));
        this.gFileTypeAddButn = new JButton("Add");
        this.gFileTypeAddButn.setBorder(high);
        this.gFileTypeAddButn.setPreferredSize(new Dimension(60, 23));
        this.gFileTypeAddButn.setMinimumSize(new Dimension(60, 23));
        this.gFileTypeAddButn.addActionListener(this);
        this.gFileTypeEditButn = new JButton("Edit");
        this.gFileTypeEditButn.setBorder(high);
        this.gFileTypeEditButn.setPreferredSize(new Dimension(60, 23));
        this.gFileTypeEditButn.setMinimumSize(new Dimension(60, 23));
        this.gFileTypeEditButn.addActionListener(this);
        this.gFileTypeRemoveButn = new JButton("Remove");
        this.gFileTypeRemoveButn.setBorder(high);
        this.gFileTypeRemoveButn.setPreferredSize(new Dimension(60, 23));
        this.gFileTypeRemoveButn.setMinimumSize(new Dimension(60, 23));
        this.gFileTypeRemoveButn.addActionListener(this);
        this.gNumPL = new JPanel(new GridBagLayout());
        this.gFileLineLB = new JLabel("Preview Lines:");
        this.gNumSP = new JSpinner();
        this.gNumSP.setValue(new Integer(this.gNumLine));
        this.gNumSP.setMinimumSize(new Dimension(50, 23));
        this.gNumSP.addChangeListener(this);
        this.gFxnPL = new JPanel();
        this.gFxnPL.setPreferredSize(new Dimension(290, 37));
        this.gFxnPL.setMinimumSize(new Dimension(80, 37));
        this.gFxnPL.setLayout(new GridBagLayout());
        this.gOkButn = new JButton("OK");
        this.gOkButn.setPreferredSize(new Dimension(butnWide, butnHigh));
        this.gOkButn.setBorder(new BevelBorder(0));
        this.gOkButn.addActionListener(this);
        this.gCancelButn = new JButton("Cancel");
        this.gCancelButn.setPreferredSize(new Dimension(butnWide, butnHigh));
        this.gCancelButn.setBorder(new BevelBorder(0));
        this.gCancelButn.addActionListener(this);
        this.gba.add(this.gSelectionPL, this.gSetSelectionTP, 0, 0, 1, 1, 1, 1, 1, 10, 5, 5, 5, 5);
        this.gba.add(this.gSelectionPL, this.gFxnPL, 0, 1, 1, 1, 0, 0, 2, 10, 5, 5, 5, 5);
        this.gba.add(this.gFileTypePL, this.gFileTypeEntryPL, 0, 0, 1, 1, 1, 1, 1, 10, 10, 5, 5, 2);
        this.gba.add(this.gFileTypePL, this.gFileTypeButnPL, 1, 0, 1, 1, 1, 1, 1, 10, 10, 2, 5, 5);
        this.gba.add(this.gFileTypePL, this.gNumPL, 0, 1, 1, 1, 1, 0, 2, 10, 2, 5, 10, 5);
        this.gba.add(this.gFileTypeEntryPL, this.gFileTypeLB, 0, 0, 1, 1, 0, 0, 2, 10, 5, 5, 2, 2);
        this.gba.add(this.gFileTypeEntryPL, this.gFileTypeSP, 0, 1, 1, 1, 1, 1, 1, 10, 2, 5, 5, 5);
        this.gba.add(this.gFileTypeButnPL, this.gFileTypeAddButn, 0, 0, 1, 1, 0, 0, 0, 13, 20, 2, 5, 5);
        this.gba.add(this.gFileTypeButnPL, this.gFileTypeEditButn, 0, 1, 1, 1, 0, 0, 0, 13, 2, 2, 5, 5);
        this.gba.add(this.gFileTypeButnPL, this.gFileTypeRemoveButn, 0, 2, 1, 1, 0, 0, 0, 13, 2, 2, 5, 5);
        this.gba.add(this.gNumPL, this.gFileLineLB, 0, 0, 1, 1, 0, 0, 0, 17, 1, 10, 1, 5);
        this.gba.add(this.gNumPL, this.gNumSP, 1, 0, 1, 1, 1, 0, 2, 17, 1, 10, 1, 2);
        this.gba.add(this.gFxnPL, this.gOkButn, 0, 0, 1, 1, 0, 0, 2, 10, 5, 5, 5, 5);
        this.gba.add(this.gFxnPL, this.gCancelButn, 1, 0, 1, 1, 0, 0, 2, 10, 5, 5, 5, 5);
        this.resize(this.sizeX, this.sizeY);
        this.gParentSize = this.parent.getSize();
        this.x = this.gParentSize.width - this.sizeX - 25 >> 1;
        this.y = this.gParentSize.height - this.sizeY - 35 >> 1;
        this.x += this.parent.getLocationX();
        this.y += this.parent.getLocationY();
        this.setLocation(this.x, this.y);
    }

    private boolean isValidEntry(String beTest) {
        boolean b = true;
        String str = beTest;
        int length = beTest.length();
        if (length != 3) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (str.charAt(i) == ' ') {
                b = false;
                i = length;
            }
            ++i;
        }
        return b;
    }

    private void editFileTypes(boolean edit) {
        String newName = new String("");
        String selName = new String("");
        int path = 0;
        path = this.gFileTypeList.getSelectedIndex();
        if (path >= 0) {
            selName = (String)this.gFileTypeList.getModel().getElementAt(path);
            if (edit) {
                newName = (String)JOptionPane.showInputDialog(this, "Please make a change:", "Madam Edit ...", 1, null, null, selName);
                if (newName != null && !newName.equals("")) {
                    if (this.isValidEntry(newName)) {
                        this.gFileTypes.remove(selName);
                        if (!this.gFileTypes.contains(newName)) {
                            this.updateFileTypes(newName);
                        }
                    } else {
                        this.showError("The file extension has 3 character limit and requires no space in it.");
                    }
                }
            } else {
                if (this.gFileTypes.size() < 2) {
                    this.showError("You cannot remove the last extension.");
                    return;
                }
                this.gFileTypes.remove(selName);
                this.updateFileTypes(null);
            }
        } else {
            this.showError("Please select a name extension.");
        }
    }

    private boolean setData() {
        this.gFileExts = new String("");
        int i = 0;
        while (i < this.gFileTypes.size()) {
            this.gFileExts = this.gFileExts + (String)this.gFileTypes.elementAt(i) + " ";
            ++i;
        }
        this.gFileExts = MyIni.removeEndSpace(this.gFileExts);
        return true;
    }

    private void showError(String msg) {
        this.getToolkit().beep();
        JOptionPane.showMessageDialog(this, msg, "Error in ...", 0);
    }

    private void updateFileTypes(String name) {
        if (name != null && !this.gFileTypes.contains(name)) {
            this.gFileTypes = this.addAndOrderList(this.gFileTypes, name);
        }
        this.gFileTypeList.setListData(this.gFileTypes);
        this.dirtyData = true;
    }
}

