/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.tigr.microarray.MevAttributes;
import org.tigr.microarray.converter.ConvertPanel;
import org.tigr.microarray.converter.CustomerHeader;
import org.tigr.microarray.converter.ExpressConverter;
import org.tigr.util.ConfirmUsers;
import org.tigr.util.FileReading;
import org.tigr.util.LongTextChanger;
import org.tigr.util.MadamFileFilter;
import org.tigr.util.MyStringTokenizer;
import org.tigr.util.formula.Variant;
import org.tigr.util.io.IOUtil;
import org.tigr.util.swing.InputHeaderSelector;
import org.tigr.util.swing.MessageDropper;
import org.tigr.util.swing.MultiInputOutputs;

public class CustomerPanel
extends ConvertPanel
implements PropertyChangeListener,
DropTargetListener,
ItemListener,
MouseListener,
MevAttributes,
Variant,
ChangeListener,
ListSelectionListener {
    private final Font smallFont = new Font("Arial", 0, 11);
    private Icon gAddIcon;
    private Icon gCellCleanIcon;
    private Icon gDivIcon;
    private Icon gHeaderSelIcon;
    private Icon gLeftBraceIcon;
    private Icon gMulIcon;
    private Icon gRightBraceIcon;
    private Icon gSubIcon;
    private JCheckBox gAnnClearAllCB;
    private JCheckBox gClearAllCB;
    private JLabel gAnnHeaderLB;
    private JLabel gMevHeaderLB;
    private JLabel gInHeaderLB;
    private JList gAnnColList;
    private JPanel gSymbolPL;
    private JPanel gHeaderPL;
    private JPanel gInHeaders;
    private JPanel gMevHeaderPL;
    private JPanel gAnnHeaderPL;
    private JScrollPane gAnnColSP;
    private JScrollPane gMevColSP;
    private JScrollPane gInputColSP;
    private JTable gMevCol;
    private JTabbedPane gMevTP;
    private MessageDropper gAdd;
    private MessageDropper gCellClean;
    private MessageDropper gDiv;
    private MessageDropper gHeaderSel;
    private MessageDropper gLeftBrace;
    private MessageDropper gMul;
    private MessageDropper gRightBrace;
    private MessageDropper gSub;
    private MessageDropper[] gInputHeaders;
    private MevTableModel gMtm;
    private MultiInputOutputs inOut;
    private final String ADD = "+";
    private final String CLEAR = "c";
    private final String DIV = "/";
    private final String HEADER = "h";
    private final String LEFT_BRACE = "(";
    private final String[] MEV_HEADER = new String[]{"UID", "IA", "IB", "R", "C", "MR", "MC", "SR", "SC", "BkgA", "BkgB", "FlagA", "FlagB", "SAA", "SAB", "QC", "QCA", "QCB", "SDA", "SDB", "MedA", "MedB"};
    private final String MUL = "*";
    private final String RIGHT_BRACE = ")";
    private final String SUB = "-";
    private final String[] gHdType = new String[]{"ech"};
    private boolean gAnnTab = false;
    private boolean gClearAllMev = false;
    private boolean gClearAllAnn = false;
    private boolean gHeaderReady = false;
    private boolean gHeaderSelected = false;
    private DropTarget gDropTarget;
    private DropTarget gAnnDrop;
    private int gSelMevCol = 0;
    private int gSelInputCol = -1;
    private int gInHeaderAddr = -1;
    private int[] gSelAnnHdx;
    private String[] gEquation;
    private String[] gEqShow;
    private String[] gHeader;
    private String[][] gMevColData = new String[1][this.MEV_HEADER.length];
    private Vector gAnnCols;
    private Vector gAnnColShow;

    public CustomerPanel() {
        this((ExpressConverter)null);
    }

    public CustomerPanel(ExpressConverter ec) {
        super(ec);
        this.gEquation = new String[this.MEV_HEADER.length];
        this.gEqShow = new String[this.MEV_HEADER.length];
        int i = 0;
        while (i < this.MEV_HEADER.length) {
            this.gMevColData[0][i] = new String(" ");
            this.gEquation[i] = new String("");
            this.gEqShow[i] = new String("");
            ++i;
        }
        this.gAnnCols = new Vector(40, 10);
        this.gAnnColShow = new Vector(40, 10);
        this.createGUI();
        this.activateSort(false);
    }

    public void adjustGUI(int index) {
        String tmpName = new String("");
        this.outputType = index;
        this.inOut.setOutputLabel("MEV Files:");
        int numFiles = this.outputFileNames.size();
        int i = 0;
        while (i < numFiles) {
            tmpName = (String)this.outputFileNames.elementAt(i);
            tmpName = IOUtil.dropExtension(tmpName);
            tmpName = tmpName + "." + this.FILE_TYPE[this.outputType];
            this.outputFileNames.setElementAt(tmpName, i);
            ++i;
        }
        this.validate();
    }

    public void changeFileList(Vector inFiles, Vector outFiles) {
        this.selectedFiles = inFiles;
        this.outputFileNames = outFiles;
        this.inOut.setInputListData(inFiles);
        this.inOut.setOutputListData(outFiles);
        this.inOut.showNumberOfFiles(this.selectedFiles.size());
    }

    public void drop(DropTargetDropEvent e) {
        if (e.getSource() == this.gDropTarget) {
            this.updateMevHeader(e);
        } else if (e.getSource() == this.gAnnDrop) {
            this.updateAnnHeader(e);
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void editDirectory(String path) {
        int selected = -1;
        String tempPath = path;
        selected = this.inOut.getSelectedOutputIndex();
        int num = this.outputFileNames.size();
        int i = 0;
        while (i < num) {
            String tempName = (String)this.outputFileNames.elementAt(i);
            tempName = IOUtil.extractFileNameFromPath(tempName);
            tempName = tempPath + "\\" + tempName;
            this.outputFileNames.setElementAt(tempName, i);
            ++i;
        }
        this.inOut.setOutputListData(this.outputFileNames);
        if (selected >= 0) {
            this.inOut.setOutputSelectedIndex(selected);
        } else {
            this.inOut.setOutputSelectedIndex(0);
        }
    }

    public void editFileName() {
        int selected = -1;
        selected = this.inOut.getSelectedOutputIndex();
        if (selected >= 0) {
            String tempName = this.inOut.getSelectedOutputName(selected);
            LongTextChanger changer = new LongTextChanger(this.parent, true, tempName);
            changer.setTitle("ExpressConveter V.1.6");
            changer.show();
            if (changer.isTextChanged()) {
                tempName = changer.getText();
                StringTokenizer token = new StringTokenizer(tempName, ":");
                if (token.countTokens() <= 1) {
                    tempName = "c:\\" + tempName;
                }
                tempName = (tempName = IOUtil.dropExtension(tempName)).lastIndexOf(46) == tempName.length() - 1 ? tempName + this.FILE_TYPE[this.outputType] : tempName + "." + this.FILE_TYPE[this.outputType];
                this.outputFileNames.setElementAt(tempName, selected);
                this.inOut.setOutputListData(this.outputFileNames);
                this.inOut.setOutputSelectedIndex(selected);
            }
        }
    }

    public String[] getConvertEquations() {
        return this.gEquation;
    }

    public String[] getInputHeaders() {
        return this.gHeader;
    }

    public int getInputHeaderOffset() {
        return this.gInHeaderAddr;
    }

    public String[] getMevHeaders() {
        return this.MEV_HEADER;
    }

    public Vector getOutputFileNames() {
        return this.outputFileNames;
    }

    public boolean getOutputReady() {
        return this.inOut.isOutputReady();
    }

    public Vector getSelectedFiles() {
        return this.selectedFiles;
    }

    public int[] getSelecteColumnForAnn() {
        int num = this.gAnnCols.size();
        int[] temp = new int[num];
        int i = 0;
        while (i < num) {
            temp[i] = Integer.parseInt((String)this.gAnnCols.elementAt(i));
            ++i;
        }
        return temp;
    }

    public boolean isValidEquation() {
        boolean res = true;
        String[] eq = null;
        int i = 0;
        while (i < this.gEquation.length) {
            eq = this.parseEquation(this.gEquation[i]);
            if (eq.length > 1) {
                if (!this.parenthesisPaired(this.gEquation[i])) {
                    this.showError("Invalid parenthesis in " + this.gEqShow[i]);
                    return false;
                }
                if (this.isOperator(this.gEquation[i].charAt(this.gEquation[i].length() - 1))) {
                    this.showError("Uncompleted formula: " + this.gEqShow[i]);
                    return false;
                }
            }
            ++i;
        }
        return res;
    }

    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.gClearAllCB) {
            this.gClearAllMev = ie.getStateChange() == 1;
        } else if (ie.getSource() == this.gAnnClearAllCB) {
            this.gClearAllAnn = ie.getStateChange() == 1;
        }
    }

    public void loadHeader(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            CustomerHeader ch = (CustomerHeader)ois.readObject();
            this.gInHeaderAddr = ch.getHeaderOffset();
            this.gHeader = ch.getHeaders();
            this.gEquation = ch.getFormula();
            this.gEqShow = ch.getReadibleFormula();
            this.gAnnColShow = ch.getAnnColumn();
            this.gAnnCols = ch.getAnnColumnIndices();
            this.initInputHeader();
            int i = 0;
            while (i < this.gEqShow.length) {
                this.gMevCol.setValueAt("", 0, i);
                String temp = this.gEqShow[i];
                if (temp.length() > 0) {
                    this.gMevCol.setValueAt(temp, 0, i);
                }
                ++i;
            }
            this.gAnnColList.setListData(this.gAnnColShow);
            this.validate();
            this.toolsReady();
        }
        catch (FileNotFoundException fnfx) {
            this.showError("Failed to find the file " + file.getName());
            ExpressConverter.logFileContent.add("\n***********\nFailed to find the file " + file.getPath() + "due to:\n" + fnfx.toString());
        }
        catch (IOException ie) {
            this.showError("Failed to open/read the file " + file.getName());
            ExpressConverter.logFileContent.add("\n***********\nFailed to open/read the file " + file.getPath() + "due to:\n" + ie.toString());
        }
        catch (ClassNotFoundException ce) {
            this.showError("Failed to read " + file.getName());
            ExpressConverter.logFileContent.add("\n***********\nFailed to read the file " + file.getPath() + "due to:\n" + ce.toString());
        }
    }

    public void mouseClicked(MouseEvent me) {
        this.gSelMevCol = this.gMevCol.getSelectedColumn();
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        if (me.getSource() != this.gMevCol) {
            this.gSelInputCol = this.getInputSelectedColum(((MessageDropper)me.getSource()).getName());
        }
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String pName = pce.getPropertyName();
        if (pName.equals(this.inOut.OUT_READY)) {
            if (pce.getNewValue().toString().equals("true") && this.gHeaderReady) {
                this.parent.activateButton(this.inOut.isOutputReady(), this.inOut.isOutputReady());
            }
        } else if (pName.equals("h")) {
            if (this.selectedFiles.size() > 0) {
                this.setInputHeader((String)this.selectedFiles.elementAt(0));
            }
        } else if (pName.equals("c")) {
            if (this.gAnnTab) {
                this.clearAnnHeader(this.gClearAllAnn);
            } else {
                this.clearEquations(this.gClearAllMev);
            }
        }
    }

    public void removeFileFromList() {
        int[] addrs = this.inOut.getSelectedInputIndices();
        if (addrs.length > 0) {
            int i = 0;
            while (i < addrs.length) {
                this.selectedFiles.remove(addrs[i]);
                this.outputFileNames.remove(addrs[i]);
                ++i;
            }
            this.inOut.setInputListData(this.selectedFiles);
            this.inOut.setOutputListData(this.outputFileNames);
            if (this.outputFileNames.size() > 0) {
                this.inOut.setOutputSelectedIndex(0);
            }
            this.inOut.showNumberOfFiles(this.selectedFiles.size());
        }
    }

    public String saveHeader(String dir) {
        CustomerHeader header = new CustomerHeader(this.parent.getVersion());
        JFileChooser fileChooser = new JFileChooser(dir);
        MadamFileFilter wanted = new MadamFileFilter(this.gHdType, "Customer Header File");
        fileChooser.setFileFilter(wanted);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle("ExpressConveter V.1.6" + " -- Saving a header file");
        int result = fileChooser.showSaveDialog(this);
        if (result == 1 || result < 0) {
            return dir;
        }
        File file = fileChooser.getSelectedFile();
        String fName = file.getPath();
        dir = IOUtil.extractPath(fName);
        fName = IOUtil.dropExtension(fName);
        result = this.parent.validFile(fName = fName + "." + this.gHdType[0], true, ConfirmUsers.YES_NO_CANCEL);
        if (result <= 0) {
            return dir;
        }
        header.setFormula(this.gEquation);
        header.setReadilbeFormula(this.gEqShow);
        header.setAnnColumn(this.gAnnColShow);
        header.setAnnColumnIndices(this.gAnnCols);
        header.setHeaderOffset(this.gInHeaderAddr);
        header.setHeaders(this.gHeader);
        try {
            FileOutputStream fos = new FileOutputStream(fName);
            ObjectOutputStream hdOut = new ObjectOutputStream(fos);
            hdOut.writeObject(header);
            hdOut.flush();
            hdOut.close();
        }
        catch (IOException ie) {
            ExpressConverter.logFileContent.add("\n***********\nError in saving header info: " + ie.toString());
        }
        return dir;
    }

    public void setSelectedFiles(String[] newFiles) {
        String temp = new String("");
        int num = newFiles.length;
        int i = 0;
        while (i < num) {
            if (!this.selectedFiles.contains(newFiles[i])) {
                this.selectedFiles.add(newFiles[i]);
                this.outputFileNames.add(IOUtil.dropExtension(newFiles[i]) + "." + this.FILE_TYPE[this.outputType]);
            }
            ++i;
        }
        this.inOut.addDataToLists(this.selectedFiles, this.outputFileNames);
        this.inOut.setOutputSelectedIndex(0);
        this.inOut.showNumberOfFiles(this.selectedFiles.size());
        if (!this.gHeaderSelected) {
            this.setInputHeader((String)this.selectedFiles.elementAt(0));
        }
        this.parent.activateButton(false, false);
    }

    public void reset() {
        this.selectedFiles.removeAllElements();
        this.outputFileNames.removeAllElements();
        this.inOut.showNumberOfFiles(0);
        this.inOut.setInputListData(this.selectedFiles);
        this.inOut.setOutputListData(this.outputFileNames);
        this.sortCB.setSelected(true);
        this.wantSort = true;
        this.outputReady = false;
        this.gClearAllMev = false;
        this.gClearAllAnn = false;
        this.gHeaderReady = false;
        this.gHeaderSelected = false;
        this.clearEquations(true);
        this.clearAnnHeader(true);
        this.gInHeaders.removeAll();
        this.gInHeaders.repaint();
        this.validate();
    }

    public void stateChanged(ChangeEvent ce) {
        this.gAnnTab = this.gMevTP.getSelectedComponent() != this.gMevHeaderPL;
    }

    public void valueChanged(ListSelectionEvent lse) {
        this.gSelAnnHdx = this.gAnnColList.getSelectedIndices();
    }

    protected void createGUI() {
        int sizeX = (int)((double)ExpressConverter.scrWidth * 0.83);
        int sizeY = (int)((double)ExpressConverter.scrHeight * 0.7);
        BevelBorder low = new BevelBorder(1);
        Dimension iconSize = new Dimension(19, 19);
        this.setLayout(new GridBagLayout());
        this.gHeaderSelIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/selheader.gif")));
        this.gCellCleanIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/cellerase.gif")));
        this.gAddIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/add.gif")));
        this.gSubIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/minus.gif")));
        this.gMulIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/multip.gif")));
        this.gDivIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/divsion.gif")));
        this.gLeftBraceIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/lbrace.gif")));
        this.gRightBraceIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/rbrace.gif")));
        this.gSymbolPL = new JPanel(new GridBagLayout());
        this.gHeaderPL = new JPanel(new GridBagLayout());
        this.gHeaderSel = new MessageDropper(this.gHeaderSelIcon);
        this.gHeaderSel.setPreferredSize(iconSize);
        this.gHeaderSel.setName("h");
        this.gHeaderSel.setToolTipText("Select the header from your input file.");
        this.gHeaderSel.addPropertyChangeListener(this);
        this.gCellClean = new MessageDropper(this.gCellCleanIcon);
        this.gCellClean.setPreferredSize(iconSize);
        this.gCellClean.setName("c");
        this.gCellClean.setToolTipText("Clear the header matches.");
        this.gCellClean.addPropertyChangeListener(this);
        this.gAdd = new MessageDropper(this.gAddIcon, "+");
        this.gAdd.setPreferredSize(iconSize);
        this.gAdd.setName("+");
        this.gAdd.setToolTipText("Add addtion symbol.");
        this.gSub = new MessageDropper(this.gSubIcon, "-");
        this.gSub.setPreferredSize(iconSize);
        this.gSub.setName("-");
        this.gSub.setToolTipText("Add subtraction symbol.");
        this.gMul = new MessageDropper(this.gMulIcon, "*");
        this.gMul.setPreferredSize(iconSize);
        this.gMul.setName("*");
        this.gMul.setToolTipText("Add multiplication symbol.");
        this.gDiv = new MessageDropper(this.gDivIcon, "/");
        this.gDiv.setPreferredSize(iconSize);
        this.gDiv.setName("/");
        this.gDiv.setToolTipText("Add division symbol.");
        this.gLeftBrace = new MessageDropper(this.gLeftBraceIcon, "(");
        this.gLeftBrace.setPreferredSize(iconSize);
        this.gLeftBrace.setName("(");
        this.gLeftBrace.setToolTipText("Add left parenthesis.");
        this.gRightBrace = new MessageDropper(this.gRightBraceIcon, ")");
        this.gRightBrace.setPreferredSize(iconSize);
        this.gRightBrace.setName(")");
        this.gRightBrace.setToolTipText("Add right parenthesis.");
        this.gMevHeaderPL = new JPanel(new GridBagLayout());
        this.gAnnHeaderPL = new JPanel(new GridBagLayout());
        this.gMevTP = new JTabbedPane(2);
        this.gMevTP.add("Mev", this.gMevHeaderPL);
        this.gMevTP.add("Ann", this.gAnnHeaderPL);
        this.gMevTP.addChangeListener(this);
        this.gMevHeaderLB = new JLabel("Header:");
        this.gClearAllCB = new JCheckBox("Clean All:");
        this.gClearAllCB.setHorizontalTextPosition(2);
        this.gClearAllCB.setFont(this.smallFont);
        this.gClearAllCB.setBorder(low);
        this.gClearAllCB.addItemListener(this);
        this.gMtm = new MevTableModel(this.gMevColData, this.MEV_HEADER);
        this.gMevCol = new JTable(this.gMtm);
        this.gMevCol.setRowHeight(23);
        this.gMevCol.setAutoResizeMode(0);
        this.gMevCol.setDragEnabled(false);
        this.gMevCol.getTableHeader().setReorderingAllowed(false);
        this.gMevCol.setSelectionBackground(Color.white);
        this.gMevCol.setSelectionForeground(Color.black);
        this.gMevCol.addMouseListener(this);
        this.gMevColSP = new JScrollPane(this.gMevCol, 21, 30);
        this.gMevColSP.setBorder(low);
        this.gAnnHeaderLB = new JLabel("Header:");
        this.gAnnClearAllCB = new JCheckBox("Clean All:");
        this.gAnnClearAllCB.setHorizontalTextPosition(2);
        this.gAnnClearAllCB.setFont(this.smallFont);
        this.gAnnClearAllCB.setBorder(low);
        this.gAnnClearAllCB.addItemListener(this);
        this.gAnnColList = new JList();
        this.gAnnColList.setVisibleRowCount(1);
        this.gAnnColList.setCellRenderer(new AnnCellRenderer());
        this.gAnnColList.setLayoutOrientation(2);
        this.gAnnColList.addListSelectionListener(this);
        this.gAnnColSP = new JScrollPane(this.gAnnColList, 21, 30);
        this.gAnnColSP.setBorder(low);
        this.gInHeaderLB = new JLabel("Input Header:");
        this.gInHeaders = new JPanel(new GridBagLayout());
        this.gInputSP = new JScrollPane(this.gInHeaders, 21, 30);
        this.gInputSP.setBorder(low);
        this.gDropTarget = new DropTarget(this.gMevCol, 3, this);
        this.gAnnDrop = new DropTarget(this.gAnnColList, 3, this);
        this.inOut = new MultiInputOutputs(sizeX, sizeY);
        this.inOut.setLabelTexts("Files to be Converted:", "MEV Files:");
        this.inOut.setDividerLocation(0.3);
        this.inOut.addPropertyChangeListener(this);
        this.gIntenPanel.remove(this.emptyLB);
        this.gIntenPanel.remove(this.gBkgCB);
        this.gba.add(this, this.gSymbolPL, 0, 0, 2, 1, 1, 0, 2, 17, 5, 55, 5, 5);
        this.gba.add(this, this.gHeaderPL, 0, 1, 2, 1, 1, 0, 2, 10, 0, 5, 5, 5);
        this.gba.add(this, this.inOut, 0, 2, 2, 2, 1, 1, 1, 10, 5, 5, 10, 5);
        this.gba.add(this, this.sortCB, 0, 4, 1, 1, 1, 0, 2, 10, 10, 15, 3, 5);
        this.gba.add(this, this.gIntenPanel, 1, 4, 1, 2, 1, 0, 2, 17, 10, 0, 3, 5);
        this.gba.add(this.gSymbolPL, this.gHeaderSel, 0, 0, 1, 1, 0, 0, 0, 17, 4, 5, 5, 1);
        this.gba.add(this.gSymbolPL, this.gCellClean, 1, 0, 1, 1, 0, 0, 0, 17, 4, 1, 5, 1);
        this.gba.add(this.gSymbolPL, this.gAdd, 2, 0, 1, 1, 0, 0, 0, 17, 4, 1, 5, 1);
        this.gba.add(this.gSymbolPL, this.gSub, 3, 0, 1, 1, 0, 0, 0, 17, 4, 1, 5, 1);
        this.gba.add(this.gSymbolPL, this.gMul, 4, 0, 1, 1, 0, 0, 0, 17, 4, 1, 5, 1);
        this.gba.add(this.gSymbolPL, this.gDiv, 5, 0, 1, 1, 0, 0, 0, 17, 4, 1, 5, 1);
        this.gba.add(this.gSymbolPL, this.gLeftBrace, 6, 0, 1, 1, 0, 0, 0, 17, 4, 1, 5, 1);
        this.gba.add(this.gSymbolPL, this.gRightBrace, 7, 0, 1, 1, 0, 0, 0, 17, 4, 1, 5, 1);
        this.gba.add(this.gSymbolPL, new JLabel(" "), 8, 0, 1, 1, 1, 0, 2, 17, 4, 1, 5, 5);
        this.gba.add(this.gHeaderPL, this.gMevTP, 0, 0, 2, 1, 1, 1, 1, 10, 0, 0, 0, 5);
        this.gba.add(this.gHeaderPL, this.gInHeaderLB, 0, 1, 1, 1, 0, 0, 0, 17, 5, 5, 5, 5);
        this.gba.add(this.gHeaderPL, this.gInputSP, 1, 1, 1, 2, 1, 1, 1, 17, 5, 5, 5, 5);
        this.gba.add(this.gHeaderPL, new JLabel(" "), 0, 2, 1, 1, 0, 0, 0, 17, 5, 5, 5, 5);
        this.gba.add(this.gMevHeaderPL, this.gMevHeaderLB, 0, 0, 1, 1, 0, 0, 0, 17, 4, 5, 5, 5);
        this.gba.add(this.gMevHeaderPL, this.gMevColSP, 1, 0, 1, 3, 1, 1, 1, 17, 2, 5, 5, 5);
        this.gba.add(this.gMevHeaderPL, this.gClearAllCB, 0, 1, 1, 1, 0, 0, 0, 17, 1, 5, 5, 5);
        this.gba.add(this.gMevHeaderPL, new JLabel(" "), 0, 2, 1, 1, 0, 0, 0, 17, 1, 5, 1, 5);
        this.gba.add(this.gAnnHeaderPL, this.gAnnHeaderLB, 0, 0, 1, 1, 0, 0, 0, 17, 4, 5, 5, 5);
        this.gba.add(this.gAnnHeaderPL, this.gAnnColSP, 1, 0, 1, 2, 1, 1, 1, 17, 2, 0, 0, 5);
        this.gba.add(this.gAnnHeaderPL, this.gAnnClearAllCB, 0, 1, 1, 1, 0, 0, 0, 17, 1, 5, 5, 5);
        this.gba.add(this.gAnnHeaderPL, new JLabel(" "), 0, 2, 1, 1, 0, 0, 0, 17, 1, 5, 1, 5);
    }

    private boolean isOperator(char ch) {
        boolean yes = false;
        int numOps = 4;
        int i = 0;
        while (i < numOps) {
            if (ch == Variant.OPERATORS[i]) {
                yes = true;
                i = numOps;
            }
            ++i;
        }
        return yes;
    }

    private int isRightEntry(String entry, String eq) {
        int right = 0;
        int eqLength = eq.length();
        boolean inSym = false;
        boolean eqSym = false;
        boolean inRb = false;
        boolean inLb = false;
        boolean eqRb = false;
        boolean eqLb = false;
        if (entry.equals("+") || entry.equals("-") || entry.equals("*") || entry.equals("/")) {
            inSym = true;
        } else if (entry.equals("(")) {
            inLb = true;
        } else if (entry.equals(")")) {
            inRb = true;
        }
        if (eqLength < 1 && !inSym && !inRb) {
            return right;
        }
        if (inRb && this.parenthesisPaired(eq)) {
            return 3;
        }
        if (eqLength > 0) {
            char eqEnd = eq.charAt(eq.length() - 1);
            if (eqEnd == '+' || eqEnd == '-' || eqEnd == '*' || eqEnd == '/') {
                eqSym = true;
            } else if (eqEnd == '(') {
                eqLb = true;
            } else if (eqEnd == ')') {
                eqRb = true;
            }
        }
        right = inSym && eqSym && !inRb && !eqLb ? 1 : (!inSym && !eqSym && !inRb && !inLb && !eqLb ? 2 : (eqLength < 1 && (inRb || inSym) || !eqSym && inLb && !eqLb || eqLb && (inSym || inRb) || eqSym && inRb ? 3 : 0));
        return right;
    }

    private void initInputHeader() {
        this.gInputHeaders = new MessageDropper[this.gHeader.length];
        this.gInHeaders.removeAll();
        this.gInHeaders.repaint();
        int count = 0;
        int i = 0;
        while (i < this.gHeader.length) {
            String temp = this.gHeader[i];
            if (temp != null && !temp.equals("")) {
                this.gInputHeaders[i] = new MessageDropper(temp, temp);
                this.gInputHeaders[i].needBorder(true);
                this.gInputHeaders[i].setBorderActive(false);
                this.gInputHeaders[i].setName("" + count++);
                this.gInputHeaders[i].addMouseListener(this);
                this.gba.add(this.gInHeaders, this.gInputHeaders[i], i, 0, 1, 1, 0, 0, 0, 17, 1, 2, 1, 2);
            }
            ++i;
        }
    }

    private boolean isMathSymbol(String dropIn) {
        return dropIn.equals("+") || dropIn.equals("-") || dropIn.equals("*") || dropIn.equals("/") || dropIn.equals("(") || dropIn.equals(")");
    }

    private void activateSort(boolean b) {
        this.wantSort = b;
        this.sortCB.setEnabled(this.wantSort);
    }

    private void clearAnnHeader(boolean all) {
        if (all) {
            this.gAnnCols.removeAllElements();
            this.gAnnColShow.removeAllElements();
        } else if (this.gSelAnnHdx != null) {
            int i = this.gSelAnnHdx.length - 1;
            while (i >= 0) {
                this.gAnnCols.remove(this.gSelAnnHdx[i]);
                this.gAnnColShow.remove(this.gSelAnnHdx[i]);
                --i;
            }
        }
        this.gAnnColList.setListData(this.gAnnColShow);
    }

    private void clearEquations(boolean all) {
        int i;
        boolean empty = true;
        if (all) {
            i = 0;
            while (i < this.gEquation.length) {
                this.gEquation[i] = "";
                this.gEqShow[i] = "";
                this.gMevCol.setValueAt("", 0, i);
                ++i;
            }
        } else {
            this.gEquation[this.gSelMevCol] = "";
            this.gEqShow[this.gSelMevCol] = "";
            this.gMevCol.setValueAt("", 0, this.gSelMevCol);
        }
        i = 0;
        while (i < this.gEquation.length) {
            if (!this.gEquation[i].equals("")) {
                empty = false;
                i = this.gEquation.length;
            }
            ++i;
        }
        if (this.gEquation[3].length() <= 0 || this.gEquation[4].length() <= 0) {
            this.activateSort(false);
        }
        if (empty) {
            this.gHeaderReady = false;
            this.parent.activateButton(this.gHeaderReady, this.inOut.isOutputReady());
        }
    }

    private int getInputSelectedColum(String sName) {
        int addr = -1;
        try {
            addr = Integer.parseInt(sName);
        }
        catch (NumberFormatException nfe) {
            addr = -1;
        }
        return addr;
    }

    private boolean parenthesisPaired(String equ) {
        boolean pair = true;
        if (equ.lastIndexOf(40) < 0) {
            return true;
        }
        int numLeft = 0;
        int numRight = 0;
        int i = 0;
        while (i < equ.length()) {
            if (equ.charAt(i) == '(') {
                ++numLeft;
            } else if (equ.charAt(i) == ')') {
                ++numRight;
            }
            ++i;
        }
        pair = numLeft == numRight;
        return pair;
    }

    private String[] parseEquation(String eq) {
        int count = 0;
        MyStringTokenizer token = new MyStringTokenizer(eq, Variant.OPERATORS, true);
        String[] temp = new String[token.countTokens()];
        while (token.hasMoreTokens()) {
            temp[count++] = token.nextToken();
        }
        return temp;
    }

    private void setInputHeader(String fName) {
        block3: {
            String[] partFile = null;
            try {
                FileReading fr = new FileReading(fName, 1, this.parent.getPreviewLine());
                if (fr.done) {
                    partFile = fr.getFileContentAsArray();
                    InputHeaderSelector ihs = new InputHeaderSelector(this.parent, partFile, "ExpressConveter V.1.6" + " -- " + IOUtil.extractFileNameFromPath(fName), true);
                    ihs.show(true);
                    if (!ihs.isDataReady()) break block3;
                    this.gInHeaderAddr = ihs.getHeaderOffset();
                    this.gHeader = ihs.getHeader();
                    this.initInputHeader();
                    this.validate();
                    this.clearEquations(true);
                    this.gHeaderSelected = true;
                    ihs = null;
                    break block3;
                }
                ExpressConverter.logFileContent.add("\n***********\n" + fr.getProcessMessage());
                this.gHeaderReady = false;
            }
            catch (IOException e) {
                ExpressConverter.logFileContent.add("\n***********\n" + e.getMessage());
                this.gHeaderReady = false;
            }
        }
    }

    private void toolsReady() {
        if (this.gEquation[1].length() > 0 && this.gEquation[2].length() > 0) {
            this.gHeaderReady = true;
            this.parent.activateButton(this.inOut.isOutputReady(), this.inOut.isOutputReady());
        }
        if (this.gEquation[3].length() > 0 && this.gEquation[4].length() > 0) {
            this.activateSort(true);
        }
    }

    private void updateAnnHeader(DropTargetDropEvent de) {
        block5: {
            if (this.gSelMevCol < 0 || this.gEquation == null) break block5;
            try {
                DataFlavor stringFlavor = DataFlavor.stringFlavor;
                Transferable tr = de.getTransferable();
                if (de.isDataFlavorSupported(stringFlavor)) {
                    String temp = (String)tr.getTransferData(stringFlavor);
                    if (!this.isMathSymbol(temp) && !this.gAnnCols.contains("" + this.gSelInputCol)) {
                        this.gAnnCols.add("" + this.gSelInputCol);
                        this.gAnnColShow.add(temp);
                    }
                    de.acceptDrop(3);
                    this.gAnnColList.setListData(this.gAnnColShow);
                    de.dropComplete(true);
                    break block5;
                }
                de.rejectDrop();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (UnsupportedFlavorException ufe) {
                ufe.printStackTrace();
            }
        }
    }

    private void updateMevHeader(DropTargetDropEvent de) {
        block12: {
            if (this.gSelMevCol < 0 || this.gEquation == null) break block12;
            String eqShow = this.gEqShow[this.gSelMevCol];
            String equation = this.gEquation[this.gSelMevCol];
            int eqType = 0;
            try {
                DataFlavor stringFlavor = DataFlavor.stringFlavor;
                Transferable tr = de.getTransferable();
                if (de.isDataFlavorSupported(stringFlavor)) {
                    String temp = (String)tr.getTransferData(stringFlavor);
                    eqType = this.isRightEntry(temp, equation);
                    switch (eqType) {
                        case 0: {
                            eqShow = eqShow + temp;
                            if (this.isMathSymbol(temp)) {
                                equation = equation + temp;
                                break;
                            }
                            equation = equation + this.gSelInputCol;
                            break;
                        }
                        case 1: {
                            eqShow = eqShow.substring(0, eqShow.length() - 1);
                            eqShow = eqShow + temp;
                            equation = equation.substring(0, equation.length() - 1);
                            equation = equation + temp;
                            break;
                        }
                        case 2: {
                            try {
                                String[] offset = this.parseEquation(equation);
                                String lastItem = offset[offset.length - 1];
                                String hn = this.gHeader[Integer.parseInt(lastItem)];
                                eqShow = eqShow.substring(0, eqShow.length() - hn.length());
                                eqShow = eqShow + temp;
                                equation = equation.substring(0, equation.length() - lastItem.length());
                                equation = equation + this.gSelInputCol;
                            }
                            catch (NumberFormatException nfe) {}
                            break;
                        }
                    }
                    de.acceptDrop(3);
                    this.gMevCol.setValueAt(eqShow, 0, this.gSelMevCol);
                    this.gEqShow[this.gSelMevCol] = eqShow;
                    this.gEquation[this.gSelMevCol] = equation;
                    de.dropComplete(true);
                    this.toolsReady();
                    break block12;
                }
                de.rejectDrop();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (UnsupportedFlavorException ufe) {
                ufe.printStackTrace();
            }
        }
    }

    class AnnCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Color lightBlue;
        private final Font smallFont = new Font("Arial", 0, 12);

        public AnnCellRenderer() {
            this.setOpaque(true);
            this.lightBlue = new Color(209, 210, 249);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setFont(this.smallFont);
            this.setBorder(new LineBorder(Color.gray, 1));
            this.setBackground(isSelected ? this.lightBlue : Color.white);
            return this;
        }
    }

    class MevTableModel
    extends DefaultTableModel {
        MevTableModel(String[][] data, String[] h) {
            super(data, h);
        }

        public boolean isCellEditable(int x, int y) {
            return false;
        }
    }
}

