/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.converter.Converter;
import org.tigr.microarray.converter.ImaGeneAttributes;
import org.tigr.util.FileReading;
import org.tigr.util.StringSplitter;

public class ImaGeneTav
extends Converter
implements ImaGeneAttributes {
    private JFrame parent;
    private String ch1FileName;
    private String ch2FileName;
    private Vector ig2FileNames;
    private Vector tavFileNames;
    private StringSplitter spliter;
    private boolean keepAll;
    private final int NUM_SORT = 3;
    private final int ROW = 1;
    private final int COL = 2;

    public ImaGeneTav(String gfName, String tfName) {
        this.tavFileNames = new Vector(1);
        this.inFileNames.add(gfName);
        this.tavFileNames.add(tfName);
        this.keepAll = true;
    }

    public ImaGeneTav(JFrame frame, Vector ig1Names, Vector ig2Names, Vector tfNames) {
        this.parent = frame;
        this.inFileNames = ig1Names;
        this.ig2FileNames = ig2Names;
        this.tavFileNames = tfNames;
        this.keepAll = true;
    }

    public void attachGeneId(boolean b) {
        this.keepAll = b;
    }

    public String getFileNameForChannel1() {
        return this.ch1FileName;
    }

    public void run() {
        String aLine = new String("");
        String densA = new String("");
        String densB = new String("");
        String tavLine = new String("");
        String flagA = new String("");
        String flagB = new String("");
        String bgA = new String("");
        String bgB = new String("");
        String spAreaA = new String("");
        String spAreaB = new String("");
        String geneId = new String("");
        int maxRow = 0;
        int maxCol = 0;
        BufferedWriter bufWriter = null;
        FileOutputStream fileOut = null;
        this.taskEnd = this.determineTaskEnd();
        if (this.taskEnd == 1) {
            return;
        }
        this.taskEnd <<= 1;
        this.counter = 0;
        int numOfFiles = this.inFileNames.size();
        int i = 0;
        while (i < numOfFiles) {
            boolean noError = true;
            this.ch1FileName = (String)this.inFileNames.elementAt(i);
            this.ch2FileName = (String)this.ig2FileNames.elementAt(i);
            String tavFileName = (String)this.tavFileNames.elementAt(i);
            Vector ch1File = this.readInput(this.ch1FileName);
            Vector ch2File = this.readInput(this.ch2FileName);
            int ch1HeaderLines = this.getHeaderLines(ch1File);
            int ch2HeaderLines = this.getHeaderLines(ch2File);
            aLine = (String)ch1File.elementAt(ch1HeaderLines + 1);
            String[] f1ColNames = this.separateLine(aLine);
            aLine = (String)ch2File.elementAt(ch2HeaderLines + 1);
            String[] f2ColNames = this.separateLine(aLine);
            int mRowIndex = this.findRightCol(f1ColNames, "Meta Row");
            int mColIndex = this.findRightCol(f1ColNames, "Meta Column");
            int colIndex = this.findRightCol(f1ColNames, "Column");
            int rowIndex = this.findRightCol(f1ColNames, "Row");
            int[] ch1NumSpotsAndMaxMetaCol = this.noSpotDropped(this.ch1FileName, ch1File, ch1HeaderLines, mRowIndex, mColIndex, rowIndex, colIndex);
            int[] ch2NumSpotsAndMaxMetaCol = this.noSpotDropped(this.ch2FileName, ch2File, ch2HeaderLines, mRowIndex, mColIndex, rowIndex, colIndex);
            if (ch1NumSpotsAndMaxMetaCol[0] < 0 || ch2NumSpotsAndMaxMetaCol[0] < 0 || ch1NumSpotsAndMaxMetaCol[0] != ch2NumSpotsAndMaxMetaCol[0]) {
                noError = false;
                this.counter += numOfFiles;
            }
            if (noError) {
                int f1FlagIndex = this.findRightCol(f1ColNames, "Flag");
                int f2FlagIndex = this.findRightCol(f2ColNames, "Flag");
                int f1SignalArea = this.findRightCol(f1ColNames, "Signal Area");
                int f2SignalArea = this.findRightCol(f2ColNames, "Signal Area");
                if (f1SignalArea < 1 || f2SignalArea < 1) {
                    JOptionPane.showMessageDialog(this.parent, "The Signal Area is missing in either of the data files \nso that converter cannot process these pair of files; however,\nConverting will continue for the remaining files", this.parent.getTitle(), 0);
                    noError = false;
                    this.counter += numOfFiles;
                }
                if (noError) {
                    int f1SignalMedian = this.findRightCol(f1ColNames, "Signal Median");
                    int f1BgMedian = this.findRightCol(f1ColNames, "Background Median");
                    int f1SignalTotal = this.findRightCol(f1ColNames, "Signal Total");
                    int f1BgTotal = this.findRightCol(f1ColNames, "Background Total");
                    int f1BgArea = this.findRightCol(f1ColNames, "Background Area");
                    int f2SignalMedian = this.findRightCol(f2ColNames, "Signal Median");
                    int f2BgMedian = this.findRightCol(f2ColNames, "Background Median");
                    int f2SignalTotal = this.findRightCol(f2ColNames, "Background Total");
                    int f2BgTotal = this.findRightCol(f2ColNames, "Background Total");
                    int f2BgArea = this.findRightCol(f2ColNames, "Background Area");
                    int geneIndex = this.findRightCol(f1ColNames, "Gene ID");
                    try {
                        int slideCol;
                        int slideRow;
                        int row;
                        int col;
                        int metaCol;
                        int metaRow;
                        String[] f2ColValues;
                        String[] f1ColValues;
                        int k;
                        int j;
                        fileOut = new FileOutputStream(tavFileName);
                        bufWriter = new BufferedWriter(new OutputStreamWriter(fileOut));
                        this.sortKeys = new int[3][ch1NumSpotsAndMaxMetaCol[0]];
                        this.outFile = new String[ch1NumSpotsAndMaxMetaCol[0]];
                        this.counter += ch1HeaderLines;
                        int numSpots = ch1NumSpotsAndMaxMetaCol[0] + ch1HeaderLines + 2;
                        if (f1SignalMedian > 1 && f2SignalMedian > 1) {
                            j = ch1HeaderLines + 2;
                            k = 0;
                            while (j < numSpots) {
                                aLine = (String)ch1File.elementAt(j);
                                f1ColValues = this.separateLine(aLine);
                                aLine = (String)ch2File.elementAt(j);
                                f2ColValues = this.separateLine(aLine);
                                metaRow = Integer.parseInt(f1ColValues[mRowIndex]);
                                metaCol = Integer.parseInt(f1ColValues[mColIndex]);
                                col = Integer.parseInt(f1ColValues[colIndex]);
                                row = Integer.parseInt(f1ColValues[rowIndex]);
                                densA = this.calculateDensity(f1ColValues, f1SignalMedian, f1BgMedian, f1SignalArea);
                                densB = this.calculateDensity(f2ColValues, f2SignalMedian, f2BgMedian, f2SignalArea);
                                spAreaA = f1ColValues[f1SignalArea];
                                spAreaB = f2ColValues[f2SignalArea];
                                bgA = this.calculateBackground(f1ColValues, f1BgMedian, f1SignalArea);
                                bgB = this.calculateBackground(f2ColValues, f2BgMedian, f2SignalArea);
                                flagA = this.setFlag(f1ColValues, f1FlagIndex);
                                flagB = this.setFlag(f2ColValues, f2FlagIndex);
                                maxRow = ch1NumSpotsAndMaxMetaCol[2];
                                maxCol = ch1NumSpotsAndMaxMetaCol[3];
                                slideRow = (metaRow - 1) * maxRow + row;
                                slideCol = (metaCol - 1) * maxCol + col;
                                tavLine = slideRow + "\t" + slideCol + "\t" + metaRow + "\t" + metaCol + "\t" + row + "\t" + col + "\t" + densA + "\t" + densB + "\t" + spAreaA + "\t" + spAreaB + "\tnull\tnull\tnull\t" + bgA + "\t" + bgB + "\t" + flagA + "\t" + flagB;
                                if (this.keepAll) {
                                    geneId = f1ColValues[geneIndex];
                                    tavLine = tavLine + "\t" + geneId;
                                }
                                this.outFile[k] = new String(tavLine);
                                this.sortKeys[0][k] = k;
                                this.sortKeys[1][k] = slideRow;
                                this.sortKeys[2][k] = slideCol;
                                ++this.counter;
                                ++j;
                                ++k;
                            }
                        } else {
                            j = ch1HeaderLines + 2;
                            k = 0;
                            while (j < numSpots) {
                                aLine = (String)ch1File.elementAt(j);
                                f1ColValues = this.separateLine(aLine);
                                aLine = (String)ch2File.elementAt(j);
                                f2ColValues = this.separateLine(aLine);
                                metaRow = Integer.parseInt(f1ColValues[mRowIndex]);
                                metaCol = Integer.parseInt(f1ColValues[mColIndex]);
                                col = Integer.parseInt(f1ColValues[colIndex]);
                                row = Integer.parseInt(f1ColValues[rowIndex]);
                                densA = this.calculateDensity(f1ColValues, f1SignalTotal, f1BgTotal, f1BgArea, f1SignalArea);
                                densB = this.calculateDensity(f2ColValues, f2SignalTotal, f2BgTotal, f2BgArea, f2SignalArea);
                                spAreaA = f1ColValues[f1SignalArea];
                                spAreaB = f2ColValues[f2SignalArea];
                                bgA = f1ColValues[f1BgTotal];
                                bgB = f2ColValues[f2BgTotal];
                                flagA = this.setFlag(f1ColValues, f1FlagIndex);
                                flagB = this.setFlag(f2ColValues, f2FlagIndex);
                                maxRow = ch1NumSpotsAndMaxMetaCol[2];
                                maxCol = ch1NumSpotsAndMaxMetaCol[3];
                                slideRow = (metaRow - 1) * maxRow + row;
                                slideCol = (metaCol - 1) * maxCol + col;
                                tavLine = slideRow + "\t" + slideCol + "\t" + metaRow + "\t" + metaCol + "\t" + row + "\t" + col + "\t" + densA + "\t" + densB + "\t" + spAreaA + "\t" + spAreaB + "\t" + bgA + "\t" + bgB + "\t" + flagA + "\t" + flagB;
                                if (this.keepAll) {
                                    geneId = f1ColValues[geneIndex];
                                    tavLine = tavLine + "\t" + geneId;
                                }
                                this.outFile[k] = new String(tavLine);
                                this.sortKeys[0][k] = k;
                                this.sortKeys[1][k] = slideRow;
                                this.sortKeys[2][k] = slideCol;
                                ++this.counter;
                                ++j;
                                ++k;
                            }
                        }
                        if (this.wantSort) {
                            this.sorted = this.sortRowCol(ch1NumSpotsAndMaxMetaCol[1], maxCol);
                            j = 0;
                            while (j < this.outFile.length) {
                                bufWriter.write(this.outFile[this.sorted[j]]);
                                bufWriter.newLine();
                                bufWriter.flush();
                                ++this.counter;
                                ++j;
                            }
                        } else {
                            j = 0;
                            while (j < this.outFile.length) {
                                bufWriter.write(this.outFile[j]);
                                bufWriter.newLine();
                                bufWriter.flush();
                                ++this.counter;
                                ++j;
                            }
                        }
                        fileOut.close();
                    }
                    catch (IOException ie) {
                        Converter.fetalError = true;
                        System.out.println("Error in writing file: " + ie.getMessage());
                        this.msg = this.msg + "**********\n";
                        this.msg = this.msg + "Error in writing file: " + ie.getMessage() + "\n";
                    }
                }
            }
            ++i;
        }
        Converter.ready = true;
        this.counter = this.taskEnd;
    }

    public void setSortSpots(boolean b) {
        this.wantSort = b;
    }

    public void setKeepAllInformation(boolean b) {
        this.keepAll = b;
    }

    private String calculateBackground(String[] tuple, int backg, int area) {
        String bg = new String("");
        try {
            float fPix = Float.parseFloat(tuple[area]);
            float bMedian = Float.parseFloat(tuple[backg]);
            int temp = (int)(bMedian * fPix);
            bg = bg + temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            bg = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value for either Signal Area or Backgroud Median; and the background was set to null.\n";
        }
        return bg;
    }

    private String calculateDensity(String[] tuple, int med, int backg, int sArea) {
        String den = new String("");
        try {
            float signal = Float.parseFloat(tuple[med]);
            float bg = Float.parseFloat(tuple[backg]);
            float area = Float.parseFloat(tuple[sArea]);
            int temp = (int)((signal - bg) * area);
            den = den + temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            den = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value for either Signal or Backgroud Median; and the intensity was set to null.\n";
        }
        return den;
    }

    private String calculateDensity(String[] tuple, int sigTot, int bgTot, int bgArea, int sArea) {
        String den = new String("");
        float st = Float.parseFloat(tuple[sigTot]);
        float bt = Float.parseFloat(tuple[bgTot]);
        float ba = Float.parseFloat(tuple[bgArea]);
        float area = Float.parseFloat(tuple[sArea]);
        int temp = (int)(st - bt / ba * area);
        den = den + temp;
        return den;
    }

    private int getDataEndLine(Vector dataFile) {
        int end = 0;
        int i = dataFile.size() - 1;
        while (i > 0) {
            String line = (String)dataFile.elementAt(i);
            String[] elements = this.separateLine(line);
            end = i;
            int j = 0;
            while (j < elements.length) {
                String temp = elements[j];
                if (temp.equalsIgnoreCase("End Raw Data")) {
                    j = elements.length;
                    i = 0;
                }
                ++j;
            }
            --i;
        }
        return end - 1;
    }

    private int getHeaderLines(Vector dataFile) {
        int numLine = 0;
        int i = 0;
        while (i < dataFile.size()) {
            String line = (String)dataFile.elementAt(i);
            String[] elements = this.separateLine(line);
            numLine = i;
            int j = 0;
            while (j < elements.length) {
                String temp = elements[j];
                if (temp.equalsIgnoreCase("Begin Raw Data")) {
                    j = elements.length;
                    i = dataFile.size();
                }
                ++j;
            }
            ++i;
        }
        return numLine;
    }

    private int findRightCol(String[] str, String key) {
        int addr = 0;
        int size = str.length;
        String temp = new String("");
        int i = 0;
        while (i < str.length) {
            if (str[i].equalsIgnoreCase(key)) {
                addr = i;
                i = str.length;
            }
            ++i;
        }
        return addr;
    }

    private boolean isChar(char x) {
        boolean b = true;
        switch (x) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                b = false;
                break;
            }
            default: {
                b = true;
            }
        }
        return b;
    }

    private boolean isNumber(String x) {
        boolean b = true;
        int length = x.length();
        int i = 0;
        while (i < length) {
            if (this.isChar(x.charAt(i))) {
                b = false;
                i = length;
            }
            ++i;
        }
        return b;
    }

    private int[] noSpotDropped(String fName, Vector dataFile, int dataStart, int mRow, int mCol, int row, int col) {
        int[] num = new int[5];
        int heading = dataStart;
        int dataEnd = this.getDataEndLine(dataFile);
        String tempLine = (String)dataFile.elementAt(dataEnd);
        String[] vecVal = this.separateLine(tempLine);
        int maxMetaRow = Integer.parseInt(vecVal[mRow]);
        int maxMetaCol = Integer.parseInt(vecVal[mCol]);
        int maxRow = Integer.parseInt(vecVal[row]);
        int maxCol = Integer.parseInt(vecVal[col]);
        num[0] = maxMetaRow * maxMetaCol * maxRow * maxCol;
        num[1] = maxMetaCol;
        num[2] = maxRow;
        num[3] = maxCol;
        num[4] = dataEnd;
        if (num[0] != dataEnd - heading - 1) {
            JOptionPane.showMessageDialog(null, "You might have dropped some of your spots in the file \n(" + fName + ".\nThe converter requires an original ImaGene output file." + "\nConverting will continue for the remaining files", this.parent.getTitle(), 0);
            num[0] = -1;
        }
        return num;
    }

    private Vector readInput(String inName) {
        Vector tempVec;
        block3: {
            tempVec = new Vector();
            try {
                FileReading fileReader = new FileReading(inName);
                if (fileReader.done) {
                    tempVec = fileReader.getFileContentInLines();
                    break block3;
                }
                Converter.fetalError = true;
                this.msg = this.msg + "**********\n";
                this.msg = this.msg + fileReader.getProcessMessage() + "\n";
                this.taskEnd = 1;
                this.counter = 1;
            }
            catch (IOException ie) {}
        }
        return tempVec;
    }

    private String setFlag(String[] tuple, int indx) {
        String f = new String("");
        int flagInt = Integer.parseInt(tuple[indx]);
        f = flagInt != 0 ? "X" : "B";
        return f;
    }
}

