/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import org.tigr.util.awt.GBA;

public class ConfirmUsers
extends JDialog
implements ActionListener {
    public static int YES_NO = 1;
    public static int YES_NO_HELP = 2;
    public static int YES_ALL_NO_CANCEL = 3;
    public static int YES_NO_CANCEL = 4;
    private JPanel messagePL;
    private JPanel buttonPL;
    private JTextArea infoBoard;
    private JButton yesBtn;
    private JButton noBtn;
    private JButton yesAllBtn;
    private JButton cancelBtn;
    public JButton helpBtn;
    private Dimension screenSize;
    private GBA gba;
    private String info;
    private int confirm;
    private int showBtn;
    private final int NO_FILE = 0;
    private final int ONE_FILE = 1;
    private final int ALL_FILES = 2;
    private final int QUIT = -1;

    public ConfirmUsers(JFrame frame, String title, String msg, boolean modal) {
        super(frame, title, modal);
        this.info = new String(msg);
        this.showBtn = 0;
        this.confirm = -1;
        this.makeFace();
    }

    public ConfirmUsers(JFrame frame, String title, String msg, int buttonPolicy, boolean modal) {
        super(frame, title, modal);
        this.showBtn = buttonPolicy;
        this.info = new String(msg);
        this.confirm = -1;
        this.makeFace();
    }

    public void makeFace() {
        this.gba = new GBA();
        BevelBorder high = new BevelBorder(0);
        int sizeX = 400;
        int sizeY = 150;
        int btnWide = 65;
        int btnHigh = 23;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                ConfirmUsers.this.confirm = -1;
                ConfirmUsers.this.cancel();
            }
        });
        this.messagePL = new JPanel(new GridBagLayout());
        this.buttonPL = new JPanel(new GridBagLayout());
        this.buttonPL.setSize(sizeX, btnHigh + 6);
        this.buttonPL.setPreferredSize(this.buttonPL.getSize());
        this.infoBoard = new JTextArea(this.info);
        this.infoBoard.setPreferredSize(new Dimension(sizeX, sizeY));
        this.infoBoard.setBackground(this.getBackground());
        this.infoBoard.setCaretColor(this.getBackground());
        this.infoBoard.setEditable(false);
        this.infoBoard.setWrapStyleWord(true);
        this.infoBoard.setLineWrap(true);
        this.yesBtn = new JButton("Yes");
        this.yesBtn.setBorder(high);
        this.yesBtn.setPreferredSize(new Dimension(btnWide, btnHigh));
        this.yesBtn.addActionListener(this);
        this.yesAllBtn = new JButton("Yes to All");
        this.yesAllBtn.setBorder(high);
        this.yesAllBtn.setPreferredSize(new Dimension(btnWide, btnHigh));
        this.yesAllBtn.addActionListener(this);
        this.noBtn = new JButton("No");
        this.noBtn.setBorder(high);
        this.noBtn.setPreferredSize(new Dimension(btnWide, btnHigh));
        this.noBtn.addActionListener(this);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.setBorder(high);
        this.cancelBtn.setPreferredSize(new Dimension(btnWide, btnHigh));
        this.cancelBtn.addActionListener(this);
        this.helpBtn = new JButton("Help");
        this.helpBtn.setBorder(high);
        this.helpBtn.setPreferredSize(new Dimension(btnWide, btnHigh));
        this.getContentPane().add(this.messagePL);
        this.gba.add(this.messagePL, this.infoBoard, 0, 0, 1, 1, 1, 1, 1, 10, 15, 10, 5, 10);
        this.gba.add(this.messagePL, this.buttonPL, 0, 1, 1, 1, 1, 1, 1, 10, 5, 5, 5, 5);
        this.gba.add(this.buttonPL, this.yesBtn, 0, 0, 1, 1, 0, 0, 0, 10, 0, 5, 0, 3);
        this.gba.add(this.buttonPL, this.noBtn, 2, 0, 1, 1, 0, 0, 0, 10, 0, 3, 0, 3);
        if (this.showBtn == YES_ALL_NO_CANCEL) {
            this.gba.add(this.buttonPL, this.yesAllBtn, 1, 0, 1, 1, 0, 0, 0, 10, 0, 3, 0, 3);
            this.gba.add(this.buttonPL, this.cancelBtn, 3, 0, 1, 1, 0, 0, 0, 10, 0, 3, 0, 3);
        } else if (this.showBtn != YES_NO) {
            if (this.showBtn == YES_NO_CANCEL) {
                this.gba.add(this.buttonPL, this.cancelBtn, 3, 0, 1, 1, 0, 0, 0, 10, 0, 3, 0, 3);
            } else if (this.showBtn == YES_NO_HELP) {
                this.gba.add(this.buttonPL, this.helpBtn, 4, 0, 1, 1, 0, 0, 0, 10, 0, 3, 0, 5);
            } else {
                this.gba.add(this.buttonPL, this.yesAllBtn, 1, 0, 1, 1, 0, 0, 0, 10, 0, 3, 0, 3);
                this.gba.add(this.buttonPL, this.cancelBtn, 3, 0, 1, 1, 0, 0, 0, 10, 0, 3, 0, 3);
                this.gba.add(this.buttonPL, this.helpBtn, 4, 0, 1, 1, 0, 0, 0, 10, 0, 3, 0, 5);
            }
        }
        this.resize(sizeX, sizeY + this.buttonPL.getHeight());
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = this.screenSize.width - sizeX >> 1;
        int y = this.screenSize.height - sizeY >> 1;
        this.setLocation(x, y);
        this.setResizable(false);
        this.show();
        this.pack();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.yesBtn) {
            this.confirm = 1;
        } else if (ae.getSource() == this.yesAllBtn) {
            this.confirm = 2;
        } else if (ae.getSource() == this.noBtn) {
            this.confirm = 0;
        }
        this.cancel();
    }

    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    public int getConfirmed() {
        return this.confirm;
    }
}

