/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util;

import java.util.Vector;

public class MyStringTokenizer {
    private boolean needDel;
    private String str;
    private char[] delimiter;
    private Vector tokens;
    private int nextTokenIndex;

    public MyStringTokenizer(String string, char[] del) {
        this(string, del, false);
    }

    public MyStringTokenizer(String string, char[] del, boolean includeDelimiter) {
        Vector<String> indxs = new Vector<String>(5, 2);
        this.str = new String(string);
        this.tokens = new Vector(10, 3);
        this.delimiter = del;
        int numDel = del.length;
        this.needDel = includeDelimiter;
        int i = 0;
        while (i < this.str.length()) {
            char ch = this.str.charAt(i);
            int j = 0;
            while (j < numDel) {
                if (ch == this.delimiter[j]) {
                    indxs.add("" + i);
                }
                ++j;
            }
            ++i;
        }
        numDel = indxs.size();
        int first = 0;
        int last = 0;
        i = 0;
        while (i < numDel) {
            last = Integer.parseInt((String)indxs.elementAt(i));
            this.tokens.add(this.str.substring(first, last));
            if (this.needDel) {
                this.tokens.add(this.str.substring(last, last + 1));
            }
            first = last + 1;
            ++i;
        }
        this.tokens.addElement(this.str.substring(first));
        this.nextTokenIndex = 0;
    }

    public int countTokens() {
        return this.tokens.size();
    }

    public boolean hasMoreTokens() {
        return this.nextTokenIndex >= 0 && this.nextTokenIndex + 1 <= this.tokens.size();
    }

    public String nextToken() {
        if (this.hasMoreTokens()) {
            String token = (String)this.tokens.elementAt(this.nextTokenIndex);
            ++this.nextTokenIndex;
            return token;
        }
        throw new ArrayIndexOutOfBoundsException();
    }
}

