/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import org.tigr.util.awt.GBA;

public class Proface
extends JPanel {
    public static final int SHOW_INFO = 1;
    public static final int SHOW_INFO_BUTTON = 2;
    public static final String CREDIT = "credit";
    public static final String CLOSE = "close";
    Color bgColor;
    GBA gba;
    JButton creditBtn;
    JButton closeBtn;
    JScrollPane scrollPane;
    JTextArea infoTA;
    private String gifName;
    private ImageIcon fig;
    private ImageIcon infoPic;
    private JLabel figLB;
    private JLabel infoLB;
    private int imgX;
    private int imgY;
    final int BOARD_HEIGHT = 18;
    final int BORDER_LAYOUT = 1;
    final int GRAD_LAYOUT = 2;

    public Proface(String name) {
        this(name, new Color(225, 153, 0));
    }

    public Proface(String name, Color c) {
        this.bgColor = c;
        this.gifName = name;
        this.fig = new ImageIcon(this.gifName);
        this.initial(1);
    }

    public Proface(Image img) {
        this.fig = new ImageIcon(img);
        this.bgColor = new Color(255, 153, 0);
        this.initial(1);
    }

    public Proface(Image img, Color c) {
        this.bgColor = c;
        this.initial(1);
        this.fig = new ImageIcon(img);
        this.imgY = this.fig.getIconHeight();
        this.imgX = this.fig.getIconWidth();
    }

    public Proface(JTextArea area, String text, Color c) {
        this.gba = new GBA();
        this.bgColor = c;
        this.setLayout(new GridBagLayout());
        this.setBackground(this.bgColor);
        this.setBorder(null);
        this.imgX = area.getWidth();
        this.imgY = area.getHeight();
        this.infoTA = area;
        this.infoTA.setText(text);
        this.infoTA.setEditable(false);
        this.infoTA.setBackground(c);
        this.infoTA.setBorder(null);
        this.closeBtn = new JButton("Close");
        this.closeBtn.setBackground(this.bgColor);
        this.closeBtn.setBorder(null);
        this.buttonFace(this.closeBtn);
        this.scrollPane = new JScrollPane(this.infoTA);
        this.scrollPane.setPreferredSize(new Dimension(this.imgX, this.imgY));
        this.scrollPane.setBorder(null);
        this.gba.add(this, this.scrollPane, 0, 0, 1, 1, 1, 1, 1, 10, 5, 5, 5, 5);
        this.gba.add(this, this.closeBtn, 0, 1, 1, 1, 1, 0, 2, 10, 5, 0, 5, 0);
    }

    public Proface(Image img, boolean infoBoard, Color c) {
        this.bgColor = c;
        this.fig = new ImageIcon(img);
        this.figLB = new JLabel();
        this.figLB.setIcon(this.fig);
        this.setLayout(new BorderLayout());
        this.setBackground(this.bgColor);
        this.imgY = this.fig.getIconHeight();
        this.imgX = this.fig.getIconWidth();
        if (infoBoard) {
            this.infoLB = new JLabel(" ");
            this.infoLB.setPreferredSize(new Dimension(200, 18));
            this.infoLB.setBackground(c);
            this.add((Component)this.figLB, "Center");
            this.add((Component)this.infoLB, "South");
        } else {
            this.add((Component)this.figLB, "Center");
        }
    }

    public Proface(Image img, int type, Color c) {
        this.fig = new ImageIcon(img);
        this.gba = new GBA();
        this.bgColor = c;
        this.initial(2);
        this.imgY = this.fig.getIconHeight();
        this.imgX = this.fig.getIconWidth();
        this.infoLB = new JLabel(" ");
        this.infoLB.setPreferredSize(new Dimension(200, 18));
        this.infoLB.setBackground(c);
        if (type == 1) {
            this.gba.add(this, this.figLB, 0, 0, 1, 1, 1, 1, 1, 10);
            this.gba.add(this, this.infoLB, 0, 1, 1, 1, 1, 0, 2, 10);
        } else if (type == 2) {
            this.creditBtn = new JButton(" ");
            this.creditBtn.setBackground(this.bgColor);
            this.creditBtn.setBorder(null);
            this.buttonFace(this.creditBtn);
            this.gba.add(this, this.figLB, 0, 0, 2, 1, 1, 1, 1, 10);
            this.gba.add(this, this.infoLB, 0, 1, 1, 1, 1, 0, 2, 10);
            this.gba.add(this, this.creditBtn, 1, 1, 1, 1, 0, 0, 0, 10);
        } else {
            this.gba.add(this, this.figLB, 0, 0, 1, 1, 1, 1, 1, 10);
        }
        this.setBackground(this.bgColor);
    }

    public int getImageWidth() {
        return this.imgX;
    }

    public int getImageHeight() {
        return this.imgY;
    }

    public void setInfoImage(Image img) {
        if (this.infoLB != null) {
            this.infoPic = new ImageIcon(img);
            this.infoLB.setIcon(this.infoPic);
        }
    }

    public void setButtonText(String text) {
        if (this.creditBtn != null) {
            this.creditBtn.setText(text);
            this.creditBtn.setBorder(new BevelBorder(2));
        }
    }

    public void setInfoText(String text) {
        if (this.infoLB != null) {
            this.infoLB.setText(text);
        }
        if (this.infoTA != null) {
            this.infoTA.setText(text);
        }
    }

    public void setButtonTextColor(Color color) {
        if (this.creditBtn != null) {
            this.creditBtn.setForeground(color);
        }
        if (this.closeBtn != null) {
            this.closeBtn.setForeground(color);
        }
    }

    public void setTextColor(Color color) {
        if (this.infoLB != null) {
            this.infoLB.setForeground(color);
        }
        if (this.infoTA != null) {
            this.infoTA.setForeground(color);
        }
    }

    private void buttonFace(JButton btn) {
        btn.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent me) {
                if (Proface.this.creditBtn != null) {
                    Proface.this.creditBtn.setBackground(Color.gray);
                }
                if (Proface.this.closeBtn != null) {
                    Proface.this.closeBtn.setBackground(Color.gray);
                }
            }
        });
        btn.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent me) {
                if (Proface.this.creditBtn != null) {
                    Proface.this.creditBtn.setBackground(Proface.this.bgColor);
                }
                if (Proface.this.closeBtn != null) {
                    Proface.this.closeBtn.setBackground(Proface.this.bgColor);
                }
            }
        });
        btn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                Proface.this.buttonFire(me);
            }
        });
    }

    private void buttonFire(MouseEvent me) {
        if (me.getSource() == this.creditBtn) {
            this.firePropertyChange(CREDIT, false, true);
        } else if (me.getSource() == this.closeBtn) {
            this.firePropertyChange(CLOSE, false, true);
        }
    }

    private void initial(int layout) {
        this.figLB = new JLabel();
        this.figLB.setIcon(this.fig);
        if (layout == 1) {
            this.setLayout(new BorderLayout());
            this.add((Component)this.figLB, "Center");
        } else {
            this.setLayout(new GridBagLayout());
        }
        this.setBackground(this.bgColor);
    }
}

