/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.io;

import java.util.StringTokenizer;
import java.util.Vector;

public class MyIni {
    private static int getNextAddress(Vector iniFile, int start) {
        Vector ini = iniFile;
        int index = 0;
        int size = ini.size();
        String temp = new String("");
        int i = start;
        while (i < size) {
            temp = (String)ini.elementAt(i);
            if (!temp.equals("") && temp.charAt(0) == '[') {
                index = i;
                i = size;
            }
            ++i;
        }
        return index;
    }

    public static Vector getMultiValuesFromIni(Vector initFile, String key) {
        StringTokenizer token = null;
        int size = initFile.size();
        String temp = new String("");
        Vector values = null;
        int i = 0;
        while (i < size) {
            temp = (String)initFile.elementAt(i);
            if (!temp.equals("") && temp.charAt(0) != '[') {
                token = new StringTokenizer(temp, "=");
                if (token.nextToken().equals(key)) {
                    values = MyIni.splitString(token.nextToken(), " ");
                    i = size;
                } else {
                    values = null;
                }
            }
            ++i;
        }
        return values;
    }

    public static Vector getMultiValues(Vector initFile, String key, Vector vec) {
        StringTokenizer token = null;
        int size = initFile.size();
        String temp = new String("");
        Vector tempVec = null;
        int num = vec.size();
        Vector<Vector> values = new Vector<Vector>(num, num >> 2);
        int i = 0;
        while (i < size) {
            temp = (String)initFile.elementAt(i);
            if (!temp.equals("") && temp.charAt(0) != '[' && (token = new StringTokenizer(temp, "=")).nextToken().equals(key)) {
                int j = 0;
                while (j < num) {
                    temp = (String)initFile.elementAt(j + i + 1);
                    token = new StringTokenizer(temp, "=");
                    if (token.nextToken().equals((String)vec.elementAt(j))) {
                        tempVec = MyIni.splitString(token.nextToken(), " ");
                    }
                    values.add(tempVec);
                    ++j;
                }
                i = size;
            }
            ++i;
        }
        return values;
    }

    public static String getSingleValueFromIni(Vector initFile, String key) {
        StringTokenizer token = null;
        int size = initFile.size();
        int num = 0;
        String temp = new String("");
        String value = null;
        int i = 0;
        while (i < size) {
            temp = (String)initFile.elementAt(i);
            if (!temp.equals("") && temp.charAt(0) != '[') {
                token = new StringTokenizer(temp, "=");
                num = token.countTokens();
                if (token.nextToken().equals(key) && num > 1) {
                    value = new String(MyIni.removeEndSpace(token.nextToken()));
                    i = size;
                }
            }
            ++i;
        }
        return value;
    }

    public static String getStarLine(int num) {
        StringBuffer star = new StringBuffer(num);
        int i = 0;
        while (i < num) {
            star.append("*");
            ++i;
        }
        return star.toString();
    }

    public static String[] getValueAndIndexFromIni(Vector initFile, String key) {
        StringTokenizer token = null;
        int size = initFile.size();
        String temp = new String("");
        String[] value = new String[2];
        int i = 0;
        while (i < size) {
            temp = (String)initFile.elementAt(i);
            if (!temp.equals("") && temp.charAt(0) != '[' && (token = new StringTokenizer(temp, "=")).nextToken().equals(key)) {
                value[0] = new String(MyIni.removeEndSpace(token.nextToken()));
                value[1] = "" + i;
                i = size;
            }
            ++i;
        }
        return value;
    }

    public static String removeAllEndSpaces(String str) {
        String temp = new String(str);
        if (temp.length() > 0) {
            while (temp.charAt(temp.length() - 1) == ' ') {
                if ((temp = temp.substring(0, temp.length() - 1)).length() <= 0) break;
            }
        }
        return temp;
    }

    public static String removeEndSpace(String str) {
        boolean spc = false;
        String temp = new String(str);
        int length = temp.length();
        int addr = length - 1;
        int i = length;
        while (i > 0) {
            if (temp.charAt(i - 1) == ' ') {
                addr = i - 1;
                spc = true;
            } else {
                i = 0;
            }
            if (spc) {
                temp = temp.substring(0, addr);
            }
            --i;
        }
        return temp;
    }

    public static String removeAllHeadSpaces(String str) {
        boolean spc = false;
        String temp = new String(str);
        int length = temp.length();
        if (length > 0) {
            while (temp.charAt(0) == ' ') {
                if ((temp = temp.substring(1)).length() <= 0) break;
            }
        }
        return temp;
    }

    public static Vector setMultiValuesToFile(Vector iniFile, String key, Vector val, Vector val2, boolean drop) {
        Vector ini = iniFile;
        StringTokenizer token = null;
        int size = ini.size();
        String temp = new String("");
        String tempKey = new String("");
        String str = new String("");
        int i = 0;
        while (i < size) {
            temp = (String)ini.elementAt(i);
            if (!temp.equals("") && temp.charAt(0) != '[') {
                int j;
                int addr = 0;
                int nextAddr = 0;
                token = new StringTokenizer(temp, "=");
                if (token.nextToken().equals(key)) {
                    j = 0;
                    while (j < val.size()) {
                        tempKey = (String)val.elementAt(j);
                        str = tempKey + "=";
                        Vector tempVec = (Vector)val2.elementAt(j);
                        int k = 0;
                        while (k < tempVec.size()) {
                            token = new StringTokenizer((String)tempVec.elementAt(k), " ");
                            if (token.hasMoreTokens()) {
                                str = str + token.nextToken() + " ";
                            }
                            ++k;
                        }
                        addr = i + j + 1;
                        nextAddr = MyIni.getNextAddress(ini, addr);
                        temp = (String)ini.elementAt(addr);
                        token = new StringTokenizer(temp, "=");
                        if (token.countTokens() > 0) {
                            ini.setElementAt(str, addr);
                        } else {
                            ini.insertElementAt(str, addr);
                        }
                        ++j;
                    }
                    i = size;
                }
                if (nextAddr - addr > 2 && drop) {
                    j = addr + 1;
                    while (j < nextAddr - 1) {
                        ini.remove(j);
                        --nextAddr;
                    }
                }
            }
            ++i;
        }
        return ini;
    }

    public static Vector setValueToFile(Vector iniFile, String key, String val) {
        Vector ini = iniFile;
        StringTokenizer token = null;
        int size = ini.size();
        String temp = new String("");
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < size) {
            temp = (String)ini.elementAt(i);
            if (!temp.equals("") && temp.charAt(0) != '[' && (token = new StringTokenizer(temp, "=")).nextToken().equals(key)) {
                str.append(key);
                str.append("=");
                str.append(val);
                ini.setElementAt(str.toString(), i);
                i = size;
            }
            ++i;
        }
        return ini;
    }

    public static Vector setValueToFile(Vector iniFile, String key, Vector val) {
        Vector ini = iniFile;
        StringTokenizer token = null;
        int size = ini.size();
        String temp = new String("");
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < size) {
            temp = (String)ini.elementAt(i);
            if (!temp.equals("") && temp.charAt(0) != '[' && (token = new StringTokenizer(temp, "=")).nextToken().equals(key)) {
                str.append(key);
                str.append("=");
                int j = 0;
                while (j < val.size()) {
                    str.append((String)val.elementAt(j));
                    str.append(" ");
                    ++j;
                }
                ini.setElementAt(str.toString(), i);
                i = size;
            }
            ++i;
        }
        return ini;
    }

    public static Vector splitString(String target, String dilimer) {
        StringTokenizer token = new StringTokenizer(target, dilimer);
        Vector<String> temp = new Vector<String>(5, 2);
        if (token.countTokens() > 1) {
            while (token.hasMoreTokens()) {
                temp.add(MyIni.removeEndSpace(token.nextToken()));
            }
        } else {
            temp.add(MyIni.removeEndSpace(target));
        }
        return temp;
    }
}

