/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.tigr.midas.Constant;
import org.tigr.midas.display.FileBrowserPane;
import org.tigr.midas.display.Midas;
import org.tigr.midas.report.AcrobatSetupPane;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.GBA;
import org.tigr.midas.util.ProgramRunner;

public class FileBrowserPane
extends JScrollPane {
    public boolean abort;
    protected int fSelectionAction = 99903;
    protected int selectedCount;
    public static Vector selectedFilesVec;
    protected String fPath;
    private int selectedFilesType;
    private FileTreePane fileTree;
    private GBA gba = new GBA();

    public FileBrowserPane() {
        this.setBackground(Color.white);
        this.setForeground(Color.white);
        selectedFilesVec = new Vector();
        this.fileTree = new FileTreePane();
        this.pasteFileTree(this.fileTree);
        this.fPath = this.fileTree.getSelection();
    }

    public void pasteFileTree(FileTreePane fileTree) {
        this.getViewport().add(fileTree);
    }

    public String getfPath() {
        return this.fPath;
    }

    public void setfPath(String dirStr) {
        this.fPath = dirStr;
    }

    public Vector getSelectedFilesVec() {
        return selectedFilesVec;
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("FileBroswerPane Test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        FileBrowserPane rPane = new FileBrowserPane();
        System.out.println(rPane.getSelectedFilesVec().toString());
        frame.getContentPane().add(rPane);
        frame.pack();
        frame.setVisible(true);
    }

    static /* synthetic */ FileTreePane access$102(FileBrowserPane x0, FileTreePane x1) {
        x0.fileTree = x1;
        return x0.fileTree;
    }

    static /* synthetic */ FileTreePane access$100(FileBrowserPane x0) {
        return x0.fileTree;
    }

    static /* synthetic */ int access$200(FileBrowserPane x0) {
        return x0.selectedFilesType;
    }

    static /* synthetic */ int access$202(FileBrowserPane x0, int x1) {
        x0.selectedFilesType = x1;
        return x0.selectedFilesType;
    }

    class FileNode {
        protected File m_file;

        public FileNode(File file) {
            this.m_file = file;
        }

        public File getFile() {
            return this.m_file;
        }

        public String toString() {
            return this.m_file.getName().length() > 0 ? this.m_file.getName() : this.m_file.getPath();
        }

        public boolean expand(DefaultMutableTreeNode parent) {
            DefaultMutableTreeNode flag = (DefaultMutableTreeNode)parent.getFirstChild();
            if (flag == null) {
                return false;
            }
            Object obj = flag.getUserObject();
            if (!(obj instanceof Boolean)) {
                return false;
            }
            parent.removeAllChildren();
            File[] files = this.listFiles();
            if (files == null) {
                return true;
            }
            Vector<FileNode> u = new Vector<FileNode>();
            Vector<FileNode> v = new Vector<FileNode>();
            int k = 0;
            while (k < files.length) {
                File f = files[k];
                FileNode newNode = new FileNode(f);
                boolean isAdded = false;
                if (!f.isDirectory()) {
                    String[] exts = new String[]{"ity", "lty", "his", "prc", "rrc", "box", "mev", "sam", "pdf"};
                    int j = 0;
                    while (j < exts.length) {
                        if (f.getAbsolutePath().endsWith(exts[j])) {
                            u.addElement(newNode);
                            break;
                        }
                        ++j;
                    }
                } else {
                    int i = 0;
                    while (i < v.size()) {
                        FileNode nd = (FileNode)v.elementAt(i);
                        if (newNode.compareTo(nd) < 0) {
                            v.insertElementAt(newNode, i);
                            isAdded = true;
                            break;
                        }
                        ++i;
                    }
                    if (!isAdded) {
                        v.addElement(newNode);
                    }
                }
                ++k;
            }
            int i = 0;
            while (i < u.size()) {
                DefaultMutableTreeNode node;
                IconData idata;
                FileNode nd = (FileNode)u.elementAt(i);
                if (nd.toString().endsWith("mev")) {
                    idata = new IconData(Constant.ICON_MEVDATAFILE, Constant.ICON_EXPANDEDFOLDER, nd);
                    node = new DefaultMutableTreeNode(idata);
                    parent.add(node);
                } else if (nd.toString().endsWith("pdf")) {
                    idata = new IconData(Constant.ICON_PDFFILE, Constant.ICON_EXPANDEDFOLDER, nd);
                    node = new DefaultMutableTreeNode(idata);
                    parent.add(node);
                } else {
                    idata = new IconData(Constant.ICON_GRAPHFILE, Constant.ICON_EXPANDEDFOLDER, nd);
                    node = new DefaultMutableTreeNode(idata);
                    parent.add(node);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < v.size()) {
                FileNode nd = (FileNode)v.elementAt(i2);
                IconData idata = new IconData(Constant.ICON_FOLDER, Constant.ICON_EXPANDEDFOLDER, nd);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(idata);
                parent.add(node);
                node.add(new DefaultMutableTreeNode(new Boolean(true)));
                ++i2;
            }
            return true;
        }

        public boolean hasSubDirs() {
            File[] files = this.listFiles();
            if (files == null) {
                return false;
            }
            int k = 0;
            while (k < files.length) {
                if (files[k].isDirectory()) {
                    return true;
                }
                ++k;
            }
            return false;
        }

        public int compareTo(FileNode toCompare) {
            return this.m_file.getName().compareToIgnoreCase(toCompare.m_file.getName());
        }

        protected File[] listFiles() {
            if (!this.m_file.isDirectory()) {
                return null;
            }
            try {
                return this.m_file.listFiles();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Error reading directory " + this.m_file.getAbsolutePath(), "Warning", 2);
                return null;
            }
        }
    }

    class IconData {
        protected Icon m_icon;
        protected Icon m_expandedIcon;
        protected Object m_data;

        public IconData(Icon icon, Object data) {
            this.m_icon = icon;
            this.m_expandedIcon = null;
            this.m_data = data;
        }

        public IconData(Icon icon, Icon expandedIcon, Object data) {
            this.m_icon = icon;
            this.m_expandedIcon = expandedIcon;
            this.m_data = data;
        }

        public Icon getIcon() {
            return this.m_icon;
        }

        public Icon getExpandedIcon() {
            return this.m_expandedIcon != null ? this.m_expandedIcon : this.m_icon;
        }

        public Object getObject() {
            return this.m_data;
        }

        public String toString() {
            return this.m_data.toString();
        }
    }

    class IconCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        protected Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        protected Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
        protected Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
        protected Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
        protected boolean m_selected;

        public IconCellRenderer() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            this.setText(obj.toString());
            if (obj instanceof Boolean) {
                this.setText("Retrieving data...");
            }
            if (obj instanceof IconData) {
                IconData idata = (IconData)obj;
                if (expanded) {
                    this.setIcon(idata.getExpandedIcon());
                } else {
                    this.setIcon(idata.getIcon());
                }
            } else {
                this.setIcon(null);
            }
            this.setFont(tree.getFont());
            this.setForeground(sel ? this.m_textSelectionColor : this.m_textNonSelectionColor);
            this.setBackground(sel ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
            this.m_selected = sel;
            return this;
        }

        public void paintComponent(Graphics g) {
            Color bColor = this.getBackground();
            Icon icon = this.getIcon();
            g.setColor(bColor);
            int offset = 0;
            if (icon != null && this.getText() != null) {
                offset = icon.getIconWidth() + this.getIconTextGap();
            }
            g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            if (this.m_selected) {
                g.setColor(this.m_borderSelectionColor);
                g.drawRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            }
            super.paintComponent(g);
        }
    }

    class FileTreePane
    extends JPanel {
        protected JTree m_tree;
        protected DefaultTreeModel m_model;
        protected JTextField m_display;
        protected JPopupMenu m_file_popup;
        protected JPopupMenu m_dir_popup;
        protected Action m_action;
        protected Action r_action;
        protected TreePath m_clickedPath;
        protected boolean isDirSelected;

        public FileTreePane() {
            JPanel fillerPane = new JPanel();
            FileBrowserPane.this.fPath = "";
            this.setPreferredSize(new Dimension(306, 545));
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            DefaultMutableTreeNode top = new DefaultMutableTreeNode(new IconData(Constant.ICON_COMPUTER, null, "Computer"));
            File[] roots = File.listRoots();
            int k = 0;
            while (k < roots.length) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(new IconData(Constant.ICON_DISK, null, new FileNode(roots[k])));
                top.add(node);
                node.add(new DefaultMutableTreeNode(new Boolean(true)));
                ++k;
            }
            this.m_model = new DefaultTreeModel(top);
            this.m_tree = new JTree(this.m_model);
            this.m_tree.getSelectionModel().setSelectionMode(1);
            this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
            IconCellRenderer renderer = new IconCellRenderer();
            this.m_tree.setCellRenderer(renderer);
            this.m_tree.addTreeExpansionListener(new DirExpansionListener());
            this.m_tree.addTreeSelectionListener(new DirSelectionListener());
            this.m_tree.setShowsRootHandles(true);
            this.m_tree.setEditable(false);
            this.m_file_popup = new JPopupMenu();
            this.m_dir_popup = new JPopupMenu();
            this.m_action = new AbstractAction(this){
                private final /* synthetic */ FileTreePane this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.this$1.m_clickedPath == null) {
                        return;
                    }
                    if (this.this$1.m_tree.isExpanded(this.this$1.m_clickedPath)) {
                        this.this$1.m_tree.collapsePath(this.this$1.m_clickedPath);
                    } else {
                        this.this$1.m_tree.expandPath(this.this$1.m_clickedPath);
                    }
                }
            };
            this.r_action = new AbstractAction(this){
                private final /* synthetic */ FileTreePane this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    FileBrowserPane.access$102(FileTreePane.access$000(this.this$1), FileTreePane.access$000(this.this$1).new FileTreePane());
                    FileTreePane.access$000(this.this$1).pasteFileTree(FileBrowserPane.access$100(FileTreePane.access$000(this.this$1)));
                }
            };
            this.m_dir_popup.add(this.m_action);
            this.m_dir_popup.addSeparator();
            this.m_dir_popup.add(this.r_action);
            AbstractAction a1 = new AbstractAction(this, "Plot / View"){
                private final /* synthetic */ FileTreePane this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.m_tree.repaint();
                    if (FileTreePane.access$000((FileTreePane)this.this$1).fPath.endsWith(".his")) {
                        if (selectedFilesVec.size() == 0) {
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        } else if (FileBrowserPane.access$200(FileTreePane.access$000(this.this$1)) == 99904) {
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        } else {
                            selectedFilesVec = new Vector<E>();
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        }
                        FileBrowserPane.access$202(FileTreePane.access$000(this.this$1), 99904);
                        if (selectedFilesVec.size() > 0) {
                            Midas.viewHolderPane.makeGraphs(selectedFilesVec, FileBrowserPane.access$200(FileTreePane.access$000(this.this$1)));
                        }
                    } else if (FileTreePane.access$000((FileTreePane)this.this$1).fPath.endsWith(".prc")) {
                        if (selectedFilesVec.size() == 0) {
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        } else if (FileBrowserPane.access$200(FileTreePane.access$000(this.this$1)) == 99903) {
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        } else {
                            selectedFilesVec = new Vector<E>();
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        }
                        FileBrowserPane.access$202(FileTreePane.access$000(this.this$1), 99903);
                        if (selectedFilesVec.size() > 0) {
                            Midas.viewHolderPane.makeGraphs(selectedFilesVec, FileBrowserPane.access$200(FileTreePane.access$000(this.this$1)));
                        }
                    } else if (FileTreePane.access$000((FileTreePane)this.this$1).fPath.endsWith(".rrc")) {
                        if (selectedFilesVec.size() == 0) {
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        } else if (FileBrowserPane.access$200(FileTreePane.access$000(this.this$1)) == 99906) {
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        } else {
                            selectedFilesVec = new Vector<E>();
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        }
                        FileBrowserPane.access$202(FileTreePane.access$000(this.this$1), 99906);
                        if (selectedFilesVec.size() > 0) {
                            Midas.viewHolderPane.makeGraphs(selectedFilesVec, FileBrowserPane.access$200(FileTreePane.access$000(this.this$1)));
                        }
                    } else if (FileTreePane.access$000((FileTreePane)this.this$1).fPath.endsWith(".ity")) {
                        if (FileBrowserPane.access$200(FileTreePane.access$000(this.this$1)) == 99901) {
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        } else {
                            selectedFilesVec = new Vector<E>();
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        }
                        FileBrowserPane.access$202(FileTreePane.access$000(this.this$1), 99901);
                        if (selectedFilesVec.size() > 0) {
                            Midas.viewHolderPane.makeGraphs(selectedFilesVec, FileBrowserPane.access$200(FileTreePane.access$000(this.this$1)));
                        }
                    } else if (FileTreePane.access$000((FileTreePane)this.this$1).fPath.endsWith(".lty")) {
                        if (selectedFilesVec.size() == 0) {
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        } else if (FileBrowserPane.access$200(FileTreePane.access$000(this.this$1)) == 99902) {
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        } else {
                            selectedFilesVec = new Vector<E>();
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        }
                        FileBrowserPane.access$202(FileTreePane.access$000(this.this$1), 99902);
                        if (selectedFilesVec.size() > 0) {
                            Midas.viewHolderPane.makeGraphs(selectedFilesVec, FileBrowserPane.access$200(FileTreePane.access$000(this.this$1)));
                        }
                    } else if (FileTreePane.access$000((FileTreePane)this.this$1).fPath.endsWith(".box")) {
                        if (selectedFilesVec.size() == 0) {
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        } else if (FileBrowserPane.access$200(FileTreePane.access$000(this.this$1)) == 99905) {
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        } else {
                            selectedFilesVec = new Vector<E>();
                            selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        }
                        FileBrowserPane.access$202(FileTreePane.access$000(this.this$1), 99905);
                        if (selectedFilesVec.size() > 0) {
                            Midas.viewHolderPane.makeGraphs(selectedFilesVec, FileBrowserPane.access$200(FileTreePane.access$000(this.this$1)));
                        }
                    } else if (FileTreePane.access$000((FileTreePane)this.this$1).fPath.endsWith(".sam")) {
                        FileBrowserPane.access$202(FileTreePane.access$000(this.this$1), 99907);
                        selectedFilesVec = new Vector<E>();
                        selectedFilesVec.add(FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        Midas.viewHolderPane.makeGraphs(selectedFilesVec, FileBrowserPane.access$200(FileTreePane.access$000(this.this$1)));
                    } else if (FileTreePane.access$000((FileTreePane)this.this$1).fPath.endsWith(".mev")) {
                        Midas.viewHolderPane.makeDataView(new File(FileTreePane.access$000((FileTreePane)this.this$1).fPath));
                    } else if (FileTreePane.access$000((FileTreePane)this.this$1).fPath.endsWith(".pdf")) {
                        if (Midas.getIni("AcrobatReader").equals("unregistered")) {
                            AcrobatSetupPane abPane = new AcrobatSetupPane();
                            abPane.pack();
                            abPane.setVisible(true);
                        }
                        ProgramRunner runner = new ProgramRunner(Midas.getIni("AcrobatReader"), FileTreePane.access$000((FileTreePane)this.this$1).fPath);
                        runner.start();
                    } else {
                        System.out.println("----> Invalid plot file type!");
                    }
                }
            };
            this.m_file_popup.add(a1);
            AbstractAction a2 = new AbstractAction(this, "View"){
                private final /* synthetic */ FileTreePane this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.m_tree.repaint();
                    if (FileTreePane.access$000((FileTreePane)this.this$1).fPath.endsWith(".mev")) {
                        System.out.println("---- Now should show mev data in Viewer");
                    }
                }
            };
            AbstractAction a3 = new AbstractAction(this, "Rename"){
                private final /* synthetic */ FileTreePane this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.m_tree.repaint();
                }
            };
            JScrollPane s = new JScrollPane();
            s.getViewport().add(this.m_tree);
            this.m_display = new JTextField();
            this.m_display.setEditable(false);
            FileBrowser fBrowser = new FileBrowser(FileBrowserPane.this.fPath, FileBrowserPane.this.fSelectionAction);
            Vector retrievedFileNames = fBrowser.getFileNamesVec("short");
            this.setLayout(new BorderLayout());
            this.add(s);
        }

        public String getSelection() {
            return FileBrowserPane.this.fPath;
        }

        private DefaultMutableTreeNode getTreeNode(TreePath path) {
            return (DefaultMutableTreeNode)path.getLastPathComponent();
        }

        private FileNode getFileNode(DefaultMutableTreeNode node) {
            if (node == null) {
                return null;
            }
            Object obj = node.getUserObject();
            if (obj instanceof IconData) {
                obj = ((IconData)obj).getObject();
            }
            if (obj instanceof FileNode) {
                return (FileNode)obj;
            }
            return null;
        }

        class DirSelectionListener
        implements TreeSelectionListener {
            DirSelectionListener() {
            }

            public void valueChanged(TreeSelectionEvent event) {
                DefaultMutableTreeNode node = FileTreePane.this.getTreeNode(event.getPath());
                FileNode fnode = FileTreePane.this.getFileNode(node);
                if (fnode != null) {
                    FileTreePane.this.m_display.setText(fnode.getFile().getAbsolutePath());
                    ((FileTreePane)FileTreePane.this).FileBrowserPane.this.fPath = fnode.getFile().getAbsolutePath();
                    FileTreePane.this.isDirSelected = fnode.getFile().isDirectory();
                    FileTreePane.this.m_tree.addMouseListener(new PopupTrigger());
                } else {
                    FileTreePane.this.m_display.setText("");
                    ((FileTreePane)FileTreePane.this).FileBrowserPane.this.fPath = "";
                }
            }
        }

        class DirExpansionListener
        implements TreeExpansionListener {
            DirExpansionListener() {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                DefaultMutableTreeNode node = FileTreePane.this.getTreeNode(event.getPath());
                FileNode fnode = FileTreePane.this.getFileNode(node);
                Thread runner = new Thread(this, fnode, node){
                    private final /* synthetic */ FileNode val$fnode;
                    private final /* synthetic */ DefaultMutableTreeNode val$node;
                    private final /* synthetic */ DirExpansionListener this$2;
                    {
                        this.this$2 = this$2;
                        this.val$fnode = val$fnode;
                        this.val$node = val$node;
                    }

                    public void run() {
                        if (this.val$fnode != null && this.val$fnode.expand(this.val$node)) {
                            Runnable runnable = new Runnable(this){
                                private final /* synthetic */ 6 this$3;
                                {
                                    this.this$3 = this$3;
                                }

                                public void run() {
                                    DirExpansionListener.access$700((DirExpansionListener)6.access$600(this.this$3)).m_model.reload(6.access$500(this.this$3));
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                        }
                    }

                    static /* synthetic */ DefaultMutableTreeNode access$500(6 x0) {
                        return x0.val$node;
                    }

                    static /* synthetic */ DirExpansionListener access$600(6 x0) {
                        return x0.this$2;
                    }
                };
                runner.start();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            static /* synthetic */ FileTreePane access$700(DirExpansionListener x0) {
                return x0.FileTreePane.this;
            }
        }

        class PopupTrigger
        extends MouseAdapter {
            PopupTrigger() {
            }

            public void mouseReleased(MouseEvent e) {
                int y;
                int x;
                TreePath path;
                if (e.isPopupTrigger() && (path = FileTreePane.this.m_tree.getPathForLocation(x = e.getX(), y = e.getY())) != null) {
                    if (FileTreePane.this.m_tree.isExpanded(path)) {
                        FileTreePane.this.m_action.putValue("Name", "Collapse");
                        FileTreePane.this.r_action.putValue("Name", "Refresh");
                    } else {
                        FileTreePane.this.m_action.putValue("Name", "Expand");
                        FileTreePane.this.r_action.putValue("Name", "Refresh");
                    }
                    if (FileTreePane.this.isDirSelected) {
                        FileTreePane.this.m_dir_popup.show(FileTreePane.this.m_tree, x, y);
                        FileTreePane.this.m_clickedPath = path;
                    } else {
                        if (!((FileTreePane)FileTreePane.this).FileBrowserPane.this.fPath.endsWith("mev")) {
                            FileTreePane.this.m_action.putValue("Name", "Plot");
                        } else if (((FileTreePane)FileTreePane.this).FileBrowserPane.this.fPath.endsWith("mev")) {
                            FileTreePane.this.m_action.putValue("Name", "View");
                        }
                        FileTreePane.this.m_file_popup.show(FileTreePane.this.m_tree, x, y);
                        FileTreePane.this.m_clickedPath = path;
                    }
                }
            }

            public void mousePressed(MouseEvent e) {
                int y;
                int x;
                TreePath path;
                if (e.isPopupTrigger() && (path = FileTreePane.this.m_tree.getPathForLocation(x = e.getX(), y = e.getY())) != null) {
                    if (FileTreePane.this.m_tree.isExpanded(path)) {
                        FileTreePane.this.m_action.putValue("Name", "Collapse");
                        FileTreePane.this.r_action.putValue("Name", "Refresh");
                    } else {
                        FileTreePane.this.m_action.putValue("Name", "Expand");
                        FileTreePane.this.r_action.putValue("Name", "Refresh");
                    }
                    if (FileTreePane.this.isDirSelected) {
                        FileTreePane.this.m_dir_popup.show(FileTreePane.this.m_tree, x, y);
                        FileTreePane.this.m_clickedPath = path;
                    } else {
                        if (!((FileTreePane)FileTreePane.this).FileBrowserPane.this.fPath.endsWith("mev")) {
                            FileTreePane.this.m_action.putValue("Name", "Plot");
                        } else if (((FileTreePane)FileTreePane.this).FileBrowserPane.this.fPath.endsWith("mev")) {
                            FileTreePane.this.m_action.putValue("Name", "View");
                        }
                        FileTreePane.this.m_file_popup.show(FileTreePane.this.m_tree, x, y);
                        FileTreePane.this.m_clickedPath = path;
                    }
                }
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    // empty if block
                }
            }
        }
    }
}

