/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Timer;

public class InformationPane
extends JPanel {
    public Timer MyTimer;
    private ImageIcon DNAIcon;
    int InfoPosition;
    int MemoryPosition;
    private String Java3DTitle;
    private String Java3DVendor;
    private String Java3DVersion;

    public InformationPane() {
        block3: {
            this.InfoPosition = 350;
            this.setBackground(new Color(0, 71, 153));
            this.MyTimer = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    InformationPane.this.repaint(40, InformationPane.this.MemoryPosition, 500, 100);
                }
            });
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                classLoader.loadClass("com.sun.j3d.utils.universe.SimpleUniverse");
                Package p = Package.getPackage("javax.media.j3d");
                if (p == null) {
                    this.Java3DTitle = "not installed";
                    this.Java3DVendor = "not available";
                    this.Java3DVersion = "not available";
                    break block3;
                }
                this.Java3DTitle = p.getImplementationTitle();
                this.Java3DVendor = p.getImplementationVendor();
                this.Java3DVersion = p.getImplementationVersion();
            }
            catch (Exception e) {
                this.Java3DTitle = "not installed";
                this.Java3DVendor = "not available";
                this.Java3DVersion = "not available";
            }
        }
    }

    public void Start() {
        this.MyTimer.start();
    }

    public void Stop() {
        this.MyTimer.stop();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(Color.white);
        Font HeadlineFont = new Font("serif", 1, 54);
        g2.setFont(HeadlineFont);
        g2.drawString("TIGR MIDAS", 40, 70);
        Font InfoFont = new Font("monospaced", 1, 14);
        g2.setFont(InfoFont);
        g2.drawString("Version 2.19", 40, 90);
        int CurrentPosition = 150;
        g2.setColor(new Color(155, 180, 215));
        g2.drawString("Java Runtime Environment version:", 40, CurrentPosition);
        g2.drawString(System.getProperty("java.version"), this.InfoPosition, CurrentPosition);
        g2.drawString("Java Runtime Environment vendor:", 40, CurrentPosition += 20);
        g2.drawString(System.getProperty("java.vendor"), this.InfoPosition, CurrentPosition);
        g2.drawString("Java Virtual Machine name:", 40, CurrentPosition += 20);
        g2.drawString(System.getProperty("java.vm.name"), this.InfoPosition, CurrentPosition);
        g2.drawString("Java Virtual Machine version:", 40, CurrentPosition += 20);
        g2.drawString(System.getProperty("java.vm.version"), this.InfoPosition, CurrentPosition);
        g2.drawString("Java Virtual Machine vendor:", 40, CurrentPosition += 20);
        g2.drawString(System.getProperty("java.vm.vendor"), this.InfoPosition, CurrentPosition);
        g2.drawString("Java 3D Runtime Environment:", 40, CurrentPosition += 20);
        g2.drawString(this.Java3DTitle, this.InfoPosition, CurrentPosition);
        g2.drawString("Java 3D Runtime Environment vendor:", 40, CurrentPosition += 20);
        g2.drawString(this.Java3DVendor, this.InfoPosition, CurrentPosition);
        g2.drawString("Java 3D Runtime Environment version:", 40, CurrentPosition += 20);
        g2.drawString(this.Java3DVersion, this.InfoPosition, CurrentPosition);
        g2.drawString("Operating System name:", 40, CurrentPosition += 20);
        g2.drawString(System.getProperty("os.name"), this.InfoPosition, CurrentPosition);
        g2.drawString("Operating System version:", 40, CurrentPosition += 20);
        g2.drawString(System.getProperty("os.version"), this.InfoPosition, CurrentPosition);
        g2.drawString("Operating System architecture:", 40, CurrentPosition += 20);
        g2.drawString(System.getProperty("os.arch"), this.InfoPosition, CurrentPosition);
        g2.drawString("User's account name:", 40, CurrentPosition += 20);
        g2.drawString(System.getProperty("user.name"), this.InfoPosition, CurrentPosition);
        g2.drawString("User's home directory:", 40, CurrentPosition += 20);
        g2.drawString(System.getProperty("user.home"), this.InfoPosition, CurrentPosition);
        g2.drawString("User's current working directory:", 40, CurrentPosition += 20);
        g2.drawString(System.getProperty("user.dir"), this.InfoPosition, CurrentPosition);
        DecimalFormat format = new DecimalFormat();
        format.setGroupingSize(3);
        this.MemoryPosition = CurrentPosition;
        g2.drawString("Free System Memory:", 40, CurrentPosition += 20);
        long FreeMemory = Runtime.getRuntime().freeMemory();
        g2.drawString(format.format(FreeMemory) + " Bytes", this.InfoPosition, CurrentPosition);
        g2.drawString("Total System Memory:", 40, CurrentPosition += 20);
        long TotalMemory = Runtime.getRuntime().totalMemory();
        g2.drawString(format.format(TotalMemory) + " Bytes", this.InfoPosition, CurrentPosition);
        CurrentPosition += 20;
        g2.setColor(new Color(55, 110, 175));
        g2.setColor(new Color(110, 150, 200));
        double OnePercent = (double)TotalMemory / 175.0;
        g2.setColor(new Color(110, 150, 200));
        int i = 0;
        while (i < 175) {
            if (Math.round(OnePercent * (double)i) >= FreeMemory) {
                g2.setColor(new Color(55, 110, 175));
            }
            g2.fillRect(40 + i * 3, CurrentPosition, 2, 20);
            ++i;
        }
    }

    public String getJava3DRunTimeEnvironment() {
        return this.Java3DTitle;
    }

    public String getJava3DVendor() {
        return this.Java3DVendor;
    }

    public String getJava3DVersion() {
        return this.Java3DVersion;
    }
}

