/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.tigr.midas.display.ActionManager;
import org.tigr.midas.display.AppRunningIndicator;
import org.tigr.midas.display.FlowImageHolderPane;
import org.tigr.midas.display.IconBar;
import org.tigr.midas.display.InvestigationPane;
import org.tigr.midas.display.MenuBar;
import org.tigr.midas.display.MessageHolderPane;
import org.tigr.midas.display.MessagePane;
import org.tigr.midas.display.ParameterHolderPane;
import org.tigr.midas.display.Proface;
import org.tigr.midas.display.ProfaceProjector;
import org.tigr.midas.display.ReviewHolderPane;
import org.tigr.midas.display.ToolHolderPane;
import org.tigr.midas.display.ViewHolderPane;
import org.tigr.midas.util.GBA;
import org.tigr.midas.util.MemObserver;

public class Midas {
    public static final String version = "2.19";
    public static final String ini = System.getProperty("user.dir") + System.getProperty("file.separator") + "midas.ini";
    public static ProfaceProjector projector;
    public static FlowImageHolderPane flowImageHolderPane;
    public static ParameterHolderPane paramHolderPane;
    public static MessageHolderPane messageHolderPane;
    public static ReviewHolderPane reviewHolderPane;
    public static ToolHolderPane toolHolderPane;
    public static ViewHolderPane viewHolderPane;
    public static Vector envec;
    public static JFrame frame;
    private static ActionManager am;
    private GBA gba = new GBA();
    static /* synthetic */ Class class$org$tigr$midas$display$Midas;

    public Container createMidasPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        IconBar iconBar = new IconBar();
        JTabbedPane midasPane = new JTabbedPane();
        JComponent designPane = this.makeDesignPane();
        midasPane.addTab("Design", null, designPane, "Design");
        designPane.setPreferredSize(new Dimension(990, 570));
        JComponent invPane = this.makeInvestigationPane();
        midasPane.addTab("Investigation", null, invPane, "Investigation");
        invPane.setPreferredSize(new Dimension(990, 570));
        am.respondTo(iconBar);
        contentPane.add((Component)iconBar, "North");
        contentPane.add((Component)midasPane, "Center");
        return contentPane;
    }

    protected JComponent makeDesignPane() {
        flowImageHolderPane = new FlowImageHolderPane();
        paramHolderPane = new ParameterHolderPane();
        reviewHolderPane = new ReviewHolderPane();
        messageHolderPane = new MessageHolderPane();
        MessagePane messagePane = new MessagePane("Welcome to use TIGR MIDAS.", Color.blue);
        messageHolderPane.pasteMessagePane(messagePane);
        messageHolderPane.pasteIndicatorPane(new AppRunningIndicator(AppRunningIndicator.logoImage));
        JPanel dPane = new JPanel();
        dPane.setLayout(new GridBagLayout());
        dPane.setBackground(Color.white);
        this.gba.add(dPane, flowImageHolderPane, 0, 0, 2, 2, 1, 1, 1, 10, 0, 0, 0, 0);
        this.gba.add(dPane, paramHolderPane, 2, 0, 1, 1, 1, 0, 1, 11, 0, 0, 0, 0);
        this.gba.add(dPane, reviewHolderPane, 2, 1, 2, 1, 0, 1, 1, 10, 0, 0, 0, 0);
        this.gba.add(dPane, messageHolderPane, 0, 2, 4, 2, 1, 0, 1, 15, 0, 0, 0, 0);
        return dPane;
    }

    protected JComponent makeInvestigationPane() {
        return new InvestigationPane();
    }

    protected static String getIni(String key) {
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(ini));
            String ln = "";
            do {
                if (!(ln = inFile.readLine()).startsWith(key)) continue;
                return ln.substring(ln.indexOf("=") + 1, ln.length());
            } while (ln != null);
        }
        catch (NullPointerException e) {
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return "unregistered";
    }

    public static void setIni(String inif, String s) {
        String key = s.substring(0, s.indexOf(61));
        try {
            if (new File(inif).createNewFile()) {
                System.out.println("-- Creating midas.ini ...");
            } else {
                System.out.println("-- Writing midas.ini ...");
            }
            BufferedReader inFile = new BufferedReader(new FileReader(inif));
            BufferedWriter outFile = new BufferedWriter(new FileWriter(inif, false));
            envec = new Vector(4, 1);
            String ln = "";
            boolean keyFound = false;
            do {
                if ((ln = inFile.readLine()) == null) {
                    ln = "";
                } else if (ln.startsWith(key)) {
                    keyFound = true;
                    envec.addElement(s);
                    outFile.write(s);
                } else {
                    envec.addElement(ln);
                    outFile.write(ln);
                }
                outFile.write(System.getProperty("line.separator"));
            } while (ln.length() != 0);
            if (!keyFound) {
                envec.addElement(s);
                outFile.write(s);
            }
            outFile.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(false);
        frame = new JFrame("TIGR MIDAS V2.19");
        frame.setDefaultCloseOperation(3);
        MenuBar menuBar = new MenuBar();
        frame.setJMenuBar(menuBar);
        am.respondTo(menuBar);
        frame.setContentPane(new Midas().createMidasPane());
        frame.setResizable(true);
        frame.setSize(1000, 700);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - 1000) / 2;
        int y = (screenSize.height - 700) / 2;
        frame.setLocation(x, y);
        frame.setVisible(true);
    }

    public static void showAbout(boolean load) {
        Color bgColor = new Color(128, 181, 231);
        Color txtColor = new Color(255, 255, 255);
        try {
            Image image = Toolkit.getDefaultToolkit().getImage((class$org$tigr$midas$display$Midas == null ? (class$org$tigr$midas$display$Midas = Midas.class$("org.tigr.midas.display.Midas")) : class$org$tigr$midas$display$Midas).getClassLoader().getResource("org/tigr/midas/images/midas_copyright1.gif"));
            Proface proPic = load ? new Proface(image, true, bgColor) : new Proface(image, bgColor);
            projector = new ProfaceProjector(proPic, load);
            projector.run();
            projector.setTextColor(txtColor);
            projector.setInfoText("  Launching application ...");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.out.println("*****************************************************************");
        System.out.println("*             TIGR Microarray Data Analysis System              *");
        System.out.println("*****************************************************************");
        System.out.println("*                                                               *");
        System.out.println("* Authors:                                                      *");
        System.out.println("*     Wei Liang and John Quackenbush                            *");
        System.out.println("*                                                               *");
        System.out.println("* Copyright Notice:                                             *");
        System.out.println("*     Copyright@ 2001-2004 The Institute For Genomic Research   *");
        System.out.println("*     9712 Medical Center Drive, Rockville, MD 20850            *");
        System.out.println("*                                                               *");
        System.out.println("*     This program is made available as freeware and may be     *");
        System.out.println("*     copied, or used for any academic or other non-commercial  *");
        System.out.println("*     purposes.  It may NOT be offered for sale under any       *");
        System.out.println("*     conditions.                                               *");
        System.out.println("*                                                               *");
        System.out.println("* Website:                                                      *");
        System.out.println("*     www.tigr.org/software/tm4/midas.html                      *");
        System.out.println("*                                                               *");
        System.out.println("*****************************************************************");
        System.out.println("                                                                 ");
        System.out.println("MIDAS Version: 2.19");
        System.out.println("MIDAS Configurations File: " + ini);
        System.out.println("Java Runtime Environment version: " + System.getProperty("java.version"));
        System.out.println("Java Runtime Environment vendor: " + System.getProperty("java.vendor"));
        System.out.println("Java Virtual Machine name: " + System.getProperty("java.vm.name"));
        System.out.println("Java Virtual Machine version: " + System.getProperty("java.vm.version"));
        System.out.println("Java Virtual Machine vendor: " + System.getProperty("java.vm.vendor"));
        System.out.println("Operating System name: " + System.getProperty("os.name"));
        System.out.println("Operating System version: " + System.getProperty("os.version"));
        System.out.println("Operating System architecture: " + System.getProperty("os.arch"));
        MemObserver.mem();
        System.out.println("-----------------------------------------------------------------");
        System.out.println("                                                                 ");
        Midas.showAbout(true);
        projector.setInfoText("  Launching application ...");
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Midas.createAndShowGUI();
            }
        });
        projector.terminate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        am = new ActionManager();
    }
}

