/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import org.tigr.midas.engine.SliceAnalysis;
import org.tigr.midas.exception.SliceAnalysisException;
import org.tigr.midas.util.ColumnWorker;

public class BatchSliceAnalysis {
    private ColumnWorker[] dCW;

    public BatchSliceAnalysis(ColumnWorker[] folderCW, int sliceDataPop, float sliceDataRangeLtVal, float sliceDataRangeGtVal) throws SliceAnalysisException {
        int fileCounts = folderCW.length;
        this.dCW = new ColumnWorker[fileCounts];
        try {
            int fileIndex = 0;
            while (fileIndex < fileCounts) {
                SliceAnalysis eachSA = new SliceAnalysis(folderCW[fileIndex], sliceDataPop, sliceDataRangeLtVal, sliceDataRangeGtVal);
                this.dCW[fileIndex] = eachSA.getFileSAColumnWorker();
                ++fileIndex;
            }
        }
        catch (SliceAnalysisException saex) {
            throw saex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final ColumnWorker[] getFolderSAColumnWorker() {
        return this.dCW;
    }
}

