/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import org.tigr.midas.exception.ReportException;

public class ErrorReport {
    private PrintStream out;

    public ErrorReport(String errRptName) throws Exception {
        try {
            this.out = new PrintStream(new FileOutputStream(new File(errRptName)));
            this.appendTitle();
            this.appendGeneral();
            this.appendCurrentTime("Error occurred at: ");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ReportException("Report Error.");
        }
    }

    public void appendTitle() {
        this.appendLine("***************************************************************************");
        this.appendLine("*                        TIGR MIDAS Error Report                          *");
        this.appendLine("***************************************************************************");
        this.appendLine("");
    }

    public void appendGeneral() {
        this.appendCaption("MIDAS Version: 2.19");
        this.appendCaption("Java Runtime Environment version: " + System.getProperty("java.version"));
        this.appendCaption("Java Runtime Environment vendor: " + System.getProperty("java.vendor"));
        this.appendCaption("Java Virtual Machine name: " + System.getProperty("java.vm.name"));
        this.appendCaption("Java Virtual Machine version: " + System.getProperty("java.vm.version"));
        this.appendCaption("Java Virtual Machine vendor: " + System.getProperty("java.vm.vendor"));
        this.appendCaption("Operating System name: " + System.getProperty("os.name"));
        this.appendCaption("Operating System version: " + System.getProperty("os.version"));
        this.appendCaption("Operating System architecture: " + System.getProperty("os.arch"));
        this.appendCaption("System MAX Memory: " + Long.toString(Runtime.getRuntime().maxMemory()));
        this.appendLine("");
    }

    public void appendError(String error) {
        this.appendLine(error);
        this.appendTrailer();
    }

    public void appendCurrentTime(String prefix) {
        Date now = new Date(System.currentTimeMillis());
        this.out.println();
        this.out.println("* " + prefix + now.toString());
        this.out.println();
    }

    public PrintStream getErrorPrintStream() {
        return this.out;
    }

    public void close() {
        this.out.close();
    }

    public final void appendCaption(String caption) {
        this.out.println("* " + caption);
    }

    public final void appendLine(String text) {
        this.out.println(text);
    }

    public final void appendTrailer() {
        this.appendLine("");
        this.appendLine("");
        this.appendLine("");
        this.appendLine("");
        this.appendLine("");
        this.appendLine("");
        this.appendLine(" You may send this report along with your project file (.prj) and your *");
        this.appendLine(" data file(s) to midas@tigr.org. We will try to contact you and slove  *");
        this.appendLine(" the problem. Thanks for supporting MIDAS.                             *");
        this.appendLine("");
        this.appendLine("************************************************************************");
        this.appendLine("*                           End of Error Report                        *");
        this.appendLine("************************************************************************");
        this.close();
    }
}

