/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.Vector;
import org.tigr.midas.engine.Module;
import org.tigr.midas.engine.Parameter;
import org.tigr.midas.util.ColumnInserter;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.NegateFlags;

public class FileBuilder
extends Module {
    private ColumnInserter ci;
    public static String badFileName = "";

    public FileBuilder(ColumnWorker fileCW) throws NumberFormatException, FileNotFoundException, Exception {
        float[] colm1 = fileCW.getColumnOneArray();
        float[] colm2 = fileCW.getColumnTwoArray();
        float[] rawColm1 = fileCW.getColumnOneArrayRaw();
        float[] rawColm2 = fileCW.getColumnTwoArrayRaw();
        boolean[] outFlag = fileCW.getRowFlagArray();
        boolean[] negativeOutFlag = new boolean[outFlag.length];
        long[] fileNewCyArrayOne = new long[colm1.length];
        long[] fileNewCyArrayTwo = new long[colm2.length];
        long[] fileRawCyArrayOne = new long[colm1.length];
        long[] fileRawCyArrayTwo = new long[colm2.length];
        int outputGeneCount = 0;
        String[] uid = fileCW.getUID();
        int i = 0;
        while (i < fileCW.getRowCounts()) {
            fileNewCyArrayOne[i] = new Float(colm1[i]).longValue();
            fileNewCyArrayTwo[i] = new Float(colm2[i]).longValue();
            fileRawCyArrayOne[i] = new Float(rawColm1[i]).longValue();
            fileRawCyArrayTwo[i] = new Float(rawColm2[i]).longValue();
            boolean bl = negativeOutFlag[i] = !outFlag[i];
            if (outFlag[i]) {
                ++outputGeneCount;
            }
            ++i;
        }
        try {
            String ext = fileCW.file_type == 11100 ? ".mev" : (fileCW.file_type == 11102 ? ".tav" : ".tav");
            String inputFile = Parameter.pSingleFileStr;
            String outputFile = Module.proj.getProjPath() + inputFile.substring(inputFile.lastIndexOf(FileBrowser.fsep), inputFile.lastIndexOf(".")) + "_MDS" + ext;
            this.ci = new ColumnInserter(inputFile, outputFile, fileNewCyArrayOne, fileNewCyArrayTwo, Parameter.pVtrimOpt, Parameter.pReNumberOpt, outFlag, uid);
            if (Parameter.pOutputTrimmedDataOpt) {
                String pTrimFileStr = Parameter.pOutFileStr.substring(0, Parameter.pOutFileStr.length() - 7) + "MDStrim" + ext;
                this.ci = new ColumnInserter(Parameter.pSingleFileStr, pTrimFileStr, fileRawCyArrayOne, fileRawCyArrayTwo, false, false, negativeOutFlag, uid);
            }
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("identity", new Integer(100));
            hash.put("output data file:     ", outputFile.substring(outputFile.lastIndexOf(FileBrowser.fsep) + 1, outputFile.length()));
            hash.put("output data count:    ", new Integer(outputGeneCount));
            String[] moduleNotes = new String[]{"output data file:     ", "output data count:    "};
            hash.put("module_notes", moduleNotes);
            Module.proj.insertReportItem("write", hash);
        }
        catch (FileNotFoundException nfex) {
            badFileName = Parameter.pSingleFileStr;
            throw nfex;
        }
        catch (NumberFormatException nex) {
            badFileName = Parameter.pSingleFileStr;
            throw nex;
        }
        catch (Exception ex) {
            badFileName = Parameter.pSingleFileStr;
            throw ex;
        }
    }

    public FileBuilder(ColumnWorker[] pairCW, String dummy) throws NumberFormatException, FileNotFoundException, Exception {
        int pairCounts = pairCW.length;
        long[][] pairNewCyArrayOne = new long[pairCounts][];
        long[][] pairNewCyArrayTwo = new long[pairCounts][];
        long[][] pairRawCyArrayOne = new long[pairCounts][];
        long[][] pairRawCyArrayTwo = new long[pairCounts][];
        int[] outputGeneCounts = new int[pairCounts];
        int pairIndex = 0;
        while (pairIndex < Parameter.pFilePairVec.size()) {
            Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairIndex);
            String fileName1 = eachPairVec.elementAt(0).toString();
            String fileName2 = eachPairVec.elementAt(1).toString();
            String ext = fileName1.substring(fileName1.length() - 4, fileName1.length());
            String outputFileName = Module.proj.getProjPath() + fileName1.substring(fileName1.lastIndexOf(FileBrowser.fsep) + 1, fileName1.lastIndexOf(46)) + "_" + fileName2.substring(fileName2.lastIndexOf(FileBrowser.fsep) + 1, fileName2.lastIndexOf(46)) + "_MDS" + ext;
            boolean[] outFlag = pairCW[pairIndex].getRowFlagArray();
            boolean[] negativeOutFlag = new boolean[outFlag.length];
            float[] colm1 = pairCW[pairIndex].getColumnOneArray();
            float[] colm2 = pairCW[pairIndex].getColumnTwoArray();
            pairNewCyArrayOne[pairIndex] = new long[pairCW[pairIndex].getRowCounts()];
            pairNewCyArrayTwo[pairIndex] = new long[pairCW[pairIndex].getRowCounts()];
            pairRawCyArrayOne[pairIndex] = new long[pairCW[pairIndex].getRowCounts()];
            pairRawCyArrayTwo[pairIndex] = new long[pairCW[pairIndex].getRowCounts()];
            String[] uid = pairCW[pairIndex].getUID();
            int i = 0;
            while (i < pairCW[pairIndex].getRowCounts()) {
                pairNewCyArrayOne[pairIndex][i] = new Double(colm1[i]).longValue();
                pairNewCyArrayTwo[pairIndex][i] = new Double(colm2[i]).longValue();
                boolean bl = negativeOutFlag[i] = !outFlag[i];
                if (outFlag[i]) {
                    int n = pairIndex;
                    outputGeneCounts[n] = outputGeneCounts[n] + 1;
                }
                ++i;
            }
            System.out.println("    Writing " + outputFileName + " ...");
            try {
                this.ci = new ColumnInserter(fileName1, outputFileName, pairNewCyArrayOne[pairIndex], pairNewCyArrayTwo[pairIndex], Parameter.pVtrimOpt, Parameter.pReNumberOpt, outFlag, uid);
                if (Parameter.pOutputTrimmedDataOpt) {
                    String pTrimFileStr = outputFileName.substring(0, outputFileName.length() - 7) + "MDStrim" + ext;
                    this.ci = new ColumnInserter(fileName1, pTrimFileStr, pairRawCyArrayOne[pairIndex], pairRawCyArrayTwo[pairIndex], false, false, negativeOutFlag, uid);
                }
            }
            catch (FileNotFoundException nfex) {
                badFileName = fileName1 + "or" + fileName2;
                throw nfex;
            }
            catch (NumberFormatException nex) {
                badFileName = fileName1 + "or" + fileName2;
                throw nex;
            }
            catch (Exception ex) {
                badFileName = fileName1 + "or" + fileName2;
                throw ex;
            }
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("identity", new Integer(100));
            hash.put("output data file:     ", outputFileName.substring(outputFileName.lastIndexOf(FileBrowser.fsep) + 1, outputFileName.length()));
            hash.put("output data count:    ", new Integer(outputGeneCounts[pairIndex]));
            String[] moduleNotes = new String[]{"output data file:     ", "output data count:    "};
            hash.put("module_notes", moduleNotes);
            Module.proj.insertReportItem("write_for_pair_" + pairIndex, hash);
            ++pairIndex;
        }
    }

    /*
     * Unable to fully structure code
     */
    public FileBuilder(ColumnWorker[] folderCW) throws NumberFormatException, FileNotFoundException, Exception {
        super();
        fileCounts = folderCW.length;
        outFlag = new boolean[folderCW[0].getRowCounts()];
        negativeOutFlag = new boolean[folderCW[0].getRowCounts()];
        flagCountsArray = new int[folderCW[0].getRowCounts()];
        folderNewCyArrayOne = new long[fileCounts][];
        folderNewCyArrayTwo = new long[fileCounts][];
        folderRawCyArrayOne = new long[fileCounts][];
        folderRawCyArrayTwo = new long[fileCounts][];
        outputGeneCount = 0;
        outputGeneCounts = new int[fileCounts];
        fileIndex = 0;
        while (fileIndex < fileCounts) {
            colm1 = folderCW[fileIndex].getColumnOneArray();
            colm2 = folderCW[fileIndex].getColumnTwoArray();
            rawColm1 = folderCW[fileIndex].getColumnOneArrayRaw();
            rawColm2 = folderCW[fileIndex].getColumnTwoArrayRaw();
            flag = folderCW[fileIndex].getRowFlagArray();
            folderNewCyArrayOne[fileIndex] = new long[folderCW[fileIndex].getRowCounts()];
            folderNewCyArrayTwo[fileIndex] = new long[folderCW[fileIndex].getRowCounts()];
            folderRawCyArrayOne[fileIndex] = new long[folderCW[fileIndex].getRowCounts()];
            folderRawCyArrayTwo[fileIndex] = new long[folderCW[fileIndex].getRowCounts()];
            uid = folderCW[fileIndex].getUID();
            i = 0;
            while (i < folderCW[fileIndex].getRowCounts()) {
                folderNewCyArrayOne[fileIndex][i] = new Float(colm1[i]).longValue();
                folderNewCyArrayTwo[fileIndex][i] = new Float(colm2[i]).longValue();
                folderRawCyArrayOne[fileIndex][i] = new Float(rawColm1[i]).longValue();
                folderRawCyArrayTwo[fileIndex][i] = new Float(rawColm2[i]).longValue();
                if (flag[i]) {
                    v0 = i;
                    flagCountsArray[v0] = flagCountsArray[v0] + 1;
                }
                ++i;
            }
            ++fileIndex;
        }
        if (Parameter.pUseCrossFileTrimOpt) {
            outputGeneCount = 0;
            i = 0;
            while (i < outFlag.length) {
                if ((float)flagCountsArray[i] / (float)fileCounts >= Parameter.pCrossFilePct) {
                    outFlag[i] = true;
                    negativeOutFlag[i] = false;
                    ++outputGeneCount;
                } else {
                    outFlag[i] = false;
                    negativeOutFlag[i] = true;
                }
                ++i;
            }
        }
        fileIndex = 0;
        while (fileIndex < fileCounts) {
            uid = folderCW[fileIndex].getUID();
            ext = folderCW[fileIndex].file_type == 11100 ? ".mev" : ".tav";
            inFileName = Parameter.pFolderStr + folderCW[fileIndex].getFileName() + ext;
            outFileName = Module.proj.getProjPath() + folderCW[fileIndex].getFileName() + "_MDS" + ext;
            if (Parameter.pUseCrossFileTrimOpt) {
                outputGeneCounts[fileIndex] = outputGeneCount;
                try {
                    System.out.println("    Writing " + outFileName + " ...");
                    this.ci = new ColumnInserter(inFileName, outFileName, folderNewCyArrayOne[fileIndex], folderNewCyArrayTwo[fileIndex], Parameter.pVtrimOpt, Parameter.pReNumberOpt, outFlag, uid);
                    if (!Parameter.pOutputTrimmedDataOpt) ** GOTO lbl99
                    pTrimFileStr = outFileName.substring(0, outFileName.length() - 7) + "MDStrim" + ext;
                    this.ci = new ColumnInserter(inFileName, pTrimFileStr, folderRawCyArrayOne[fileIndex], folderRawCyArrayTwo[fileIndex], false, false, negativeOutFlag, uid);
                }
                catch (FileNotFoundException nfex) {
                    FileBuilder.badFileName = inFileName;
                    throw nfex;
                }
                catch (NumberFormatException nex) {
                    FileBuilder.badFileName = inFileName;
                    throw nex;
                }
                catch (Exception ex) {
                    FileBuilder.badFileName = inFileName;
                    throw ex;
                }
            } else {
                flag = folderCW[fileIndex].getRowFlagArray();
                negateFlag = new NegateFlags(flag).getNegateFlag();
                m = 0;
                while (m < flag.length) {
                    if (flag[m]) {
                        v1 = fileIndex;
                        outputGeneCounts[v1] = outputGeneCounts[v1] + 1;
                    }
                    ++m;
                }
                try {
                    System.out.println("    Writing " + outFileName + " ...");
                    this.ci = new ColumnInserter(inFileName, outFileName, folderNewCyArrayOne[fileIndex], folderNewCyArrayTwo[fileIndex], Parameter.pVtrimOpt, Parameter.pReNumberOpt, flag, uid);
                    if (Parameter.pOutputTrimmedDataOpt) {
                        pTrimFileStr = outFileName.substring(0, outFileName.length() - 7) + "MDStrim" + inFileName.substring(inFileName.length() - 4, inFileName.length());
                        this.ci = new ColumnInserter(inFileName, pTrimFileStr, folderRawCyArrayOne[fileIndex], folderRawCyArrayTwo[fileIndex], false, false, negateFlag, uid);
                    }
                }
                catch (FileNotFoundException nfex) {
                    FileBuilder.badFileName = inFileName;
                    throw nfex;
                }
                catch (NumberFormatException nex) {
                    FileBuilder.badFileName = inFileName;
                    throw nex;
                }
                catch (Exception ex) {
                    FileBuilder.badFileName = inFileName;
                    throw ex;
                }
            }
lbl99:
            // 3 sources

            hash = new Hashtable<String, Object>();
            hash.put("identity", new Integer(100));
            hash.put("output data file:     ", outFileName.substring(outFileName.lastIndexOf(FileBrowser.fsep) + 1, outFileName.length()));
            hash.put("output data count:    ", new Integer(outputGeneCounts[fileIndex]));
            moduleNotes = new String[]{"output data file:     ", "output data count:    "};
            hash.put("module_notes", moduleNotes);
            Module.proj.insertReportItem("write_for_file_" + fileIndex, hash);
            ++fileIndex;
        }
    }
}

