/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.util.Hashtable;
import org.tigr.midas.engine.DataPrep;
import org.tigr.midas.engine.DataReporter;
import org.tigr.midas.engine.Module;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.math.StatsTools;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.IndexAdjuster;

public class FlipDye
extends Module {
    private ColumnWorker[] pCW;
    private float[] fileOneColOne;
    private float[] fileOneColTwo;
    private float[] fileTwoColOne;
    private float[] fileTwoColTwo;

    public FlipDye(ColumnWorker[][] pairCW, String cutoffMethod, float range) {
        FileBrowser projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
        String flipdyeFB = projFolderFB.createSubDir("flip_dye");
        this.pCW = new ColumnWorker[pairCW.length];
        int pairIndex = 0;
        while (pairIndex < pairCW.length) {
            System.out.println("    -------- pairIndex = " + (pairIndex + 1) + " ---------");
            this.fileOneColOne = pairCW[pairIndex][0].getColumnOneArray();
            this.fileOneColTwo = pairCW[pairIndex][0].getColumnTwoArray();
            this.fileTwoColOne = pairCW[pairIndex][1].getColumnOneArray();
            this.fileTwoColTwo = pairCW[pairIndex][1].getColumnTwoArray();
            String comboFileName = pairCW[pairIndex][0].getFileName() + "_" + pairCW[pairIndex][1].getFileName();
            StatsTools s = new StatsTools();
            float[] a1 = new float[this.fileOneColOne.length];
            float[] a2 = new float[this.fileTwoColOne.length];
            float[] b1 = new float[this.fileOneColTwo.length];
            float[] b2 = new float[this.fileTwoColTwo.length];
            System.arraycopy(this.fileOneColOne, 0, a1, 0, this.fileOneColOne.length);
            System.arraycopy(this.fileTwoColOne, 0, a2, 0, this.fileTwoColOne.length);
            System.arraycopy(this.fileOneColTwo, 0, b1, 0, this.fileOneColTwo.length);
            System.arraycopy(this.fileTwoColTwo, 0, b2, 0, this.fileTwoColTwo.length);
            DataPrep dataPrep = new DataPrep(a1, a2);
            String a1a2LtyName = Module.proj.getProjPath() + "flip_dye" + FileBrowser.fsep + comboFileName + "_prefilter_a1a2.lty";
            DataReporter dr = new DataReporter(a1a2LtyName, dataPrep.getLogX(), dataPrep.getLogY(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dataPrep = new DataPrep(b1, b2);
            String b1b2LtyName = Module.proj.getProjPath() + "flip_dye" + FileBrowser.fsep + comboFileName + "_prefilter_b1b2.lty";
            dr = new DataReporter(b1b2LtyName, dataPrep.getLogX(), dataPrep.getLogY(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dataPrep = new DataPrep(a1, b1);
            String a1b1LtyName = Module.proj.getProjPath() + "flip_dye" + FileBrowser.fsep + comboFileName + "_prefilter_a1b1.lty";
            dr = new DataReporter(a1b1LtyName, dataPrep.getLogX(), dataPrep.getLogY(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dataPrep = new DataPrep(a2, b2);
            String a2b2LtyName = Module.proj.getProjPath() + "flip_dye" + FileBrowser.fsep + comboFileName + "_prefilter_a2b2.lty";
            dr = new DataReporter(a2b2LtyName, dataPrep.getLogX(), dataPrep.getLogY(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dataPrep = new DataPrep(a1, b2);
            String a1b2LtyName = Module.proj.getProjPath() + "flip_dye" + FileBrowser.fsep + comboFileName + "_prefilter_a1b2.lty";
            dr = new DataReporter(a1b2LtyName, dataPrep.getLogX(), dataPrep.getLogY(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dataPrep = new DataPrep(a2, b1);
            String a2b1LtyName = Module.proj.getProjPath() + "flip_dye" + FileBrowser.fsep + comboFileName + "_prefilter_a2b1.lty";
            dr = new DataReporter(a2b1LtyName, dataPrep.getLogX(), dataPrep.getLogY(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            int totalRowCounts = pairCW[pairIndex][0].getRowCounts();
            float[] fileOnePlainRatio = pairCW[pairIndex][0].getPlainRatioArray();
            float[] fileTwoPlainRatio = pairCW[pairIndex][1].getPlainRatioArray();
            float[] fileOneLogRatio = pairCW[pairIndex][0].getLogRatioArray();
            float[] fileTwoFlipLogRatio = pairCW[pairIndex][1].getFlipLogRatioArray();
            float[] wholeLogRatio = new float[totalRowCounts];
            float[] halfLogRatio = new float[totalRowCounts];
            float[] goodWholeLogRatio = new float[totalRowCounts];
            float[] newG = new float[totalRowCounts];
            float[] newR = new float[totalRowCounts];
            s.linearRegression(fileOneLogRatio, fileTwoFlipLogRatio);
            int goodLogRatioCounts = 0;
            String preRrcName = Module.proj.getProjPath() + "flip_dye" + FileBrowser.fsep + comboFileName + "_prefilter.rrc";
            dr = new DataReporter(preRrcName, fileOneLogRatio, fileTwoFlipLogRatio, true);
            int rowIndex = 0;
            while (rowIndex < totalRowCounts) {
                if (fileOnePlainRatio[rowIndex] > 0.0f && fileTwoPlainRatio[rowIndex] > 0.0f) {
                    wholeLogRatio[rowIndex] = MathTools.log2(fileOnePlainRatio[rowIndex] * fileTwoPlainRatio[rowIndex]);
                    halfLogRatio[rowIndex] = wholeLogRatio[rowIndex] / 2.0f;
                    newG[rowIndex] = (float)Math.sqrt(this.fileOneColOne[rowIndex] * this.fileTwoColTwo[rowIndex]);
                    newR[rowIndex] = (float)Math.sqrt(this.fileOneColTwo[rowIndex] * this.fileTwoColOne[rowIndex]);
                    goodWholeLogRatio[goodLogRatioCounts] = wholeLogRatio[rowIndex];
                    ++goodLogRatioCounts;
                } else {
                    wholeLogRatio[rowIndex] = Float.NaN;
                    halfLogRatio[rowIndex] = Float.NaN;
                    newG[rowIndex] = 0.0f;
                    newR[rowIndex] = 0.0f;
                }
                ++rowIndex;
            }
            this.pCW[pairIndex] = pairCW[pairIndex][0];
            this.pCW[pairIndex].setFileName(comboFileName);
            float[] t = new float[goodWholeLogRatio.length];
            System.arraycopy(goodWholeLogRatio, 0, t, 0, goodWholeLogRatio.length);
            goodWholeLogRatio = new float[goodLogRatioCounts];
            System.arraycopy(t, 0, goodWholeLogRatio, 0, goodLogRatioCounts);
            s.computeMeanSD(goodWholeLogRatio);
            float pairMeans = s.getXMean();
            float pairStds = s.getXSD();
            System.out.println("    validCount = " + s.getValidCount());
            System.out.println("    goodLogRatioCounts = " + goodLogRatioCounts);
            System.out.println("    pairMeans = " + pairMeans);
            System.out.println("    pairStds = " + pairStds);
            int unConfidentRowCounts = 0;
            int confidentRowCounts = 0;
            int disperseCounts = 0;
            boolean[] outputFlag = new boolean[totalRowCounts];
            float[] qualifiedFileOneLogRatio = new float[totalRowCounts];
            float[] qualifiedFileTwoLogRatio = new float[totalRowCounts];
            int rowIndex2 = 0;
            while (rowIndex2 < totalRowCounts) {
                if (cutoffMethod.equalsIgnoreCase("threshold cut")) {
                    if (!Float.isNaN(wholeLogRatio[rowIndex2]) && Math.abs(wholeLogRatio[rowIndex2] - pairMeans) <= Math.abs(range)) {
                        ++confidentRowCounts;
                        outputFlag[rowIndex2] = true;
                    } else {
                        fileOneLogRatio[rowIndex2] = Float.NaN;
                        fileTwoFlipLogRatio[rowIndex2] = Float.NaN;
                        ++unConfidentRowCounts;
                        if (!Float.isNaN(wholeLogRatio[rowIndex2])) {
                            ++disperseCounts;
                        }
                        newG[rowIndex2] = 0.0f;
                        newR[rowIndex2] = 0.0f;
                        outputFlag[rowIndex2] = false;
                    }
                } else if (cutoffMethod.equalsIgnoreCase("SD cut")) {
                    float leftCut = pairMeans - pairStds * range;
                    float rightCut = pairMeans + pairStds * range;
                    if (!Float.isNaN(wholeLogRatio[rowIndex2]) && wholeLogRatio[rowIndex2] >= leftCut && wholeLogRatio[rowIndex2] <= rightCut) {
                        ++confidentRowCounts;
                        outputFlag[rowIndex2] = true;
                    } else {
                        fileOneLogRatio[rowIndex2] = Float.NaN;
                        fileTwoFlipLogRatio[rowIndex2] = Float.NaN;
                        if (!Float.isNaN(wholeLogRatio[rowIndex2])) {
                            ++unConfidentRowCounts;
                        }
                        newG[rowIndex2] = 0.0f;
                        newR[rowIndex2] = 0.0f;
                        outputFlag[rowIndex2] = false;
                    }
                    if (!Float.isNaN(wholeLogRatio[rowIndex2]) && (double)Math.abs(wholeLogRatio[rowIndex2] - pairMeans) > 1.0) {
                        ++disperseCounts;
                    }
                } else {
                    System.out.println("Error! ====> Unknown Flip-Dye cutoff method!");
                }
                ++rowIndex2;
            }
            float confidentFactor = (float)confidentRowCounts / (float)goodLogRatioCounts;
            float disperseFactor = (float)disperseCounts / (float)goodLogRatioCounts;
            System.out.println("    pre-filtering Corr.Coeff. = " + s.getCorrelationCoeff());
            System.out.println("    confidentRowCounts = " + confidentRowCounts + ", unConfidentRowCounts = " + unConfidentRowCounts);
            System.out.println("    ConfidenceFactor = " + confidentFactor);
            System.out.println("    DispersionFactor = " + disperseFactor);
            this.pCW[pairIndex].setColOneArray(newG);
            this.pCW[pairIndex].setColTwoArray(newR);
            this.pCW[pairIndex].setRowFlag(outputFlag);
            String ityName = Module.proj.getProjPath() + "flip_dye" + FileBrowser.fsep + this.pCW[pairIndex].getFileName() + "_flipdye.ity";
            String ltyName = Module.proj.getProjPath() + "flip_dye" + FileBrowser.fsep + this.pCW[pairIndex].getFileName() + "_flipdye.lty";
            String prcName = Module.proj.getProjPath() + "flip_dye" + FileBrowser.fsep + this.pCW[pairIndex].getFileName() + "_flipdye.prc";
            String hisName = Module.proj.getProjPath() + "flip_dye" + FileBrowser.fsep + this.pCW[pairIndex].getFileName() + "_flipdye.his";
            String boxName = Module.proj.getProjPath() + "flip_dye" + FileBrowser.fsep + this.pCW[pairIndex].getFileName() + "_flipdye_block.box";
            String rrcName = Module.proj.getProjPath() + "flip_dye" + FileBrowser.fsep + this.pCW[pairIndex].getFileName() + "_postfilter.rrc";
            dataPrep = new DataPrep(this.pCW[pairIndex]);
            dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
            dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
            dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
            dr = new DataReporter(rrcName, fileOneLogRatio, fileTwoFlipLogRatio, true);
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("identity", new Integer(40));
            hash.put(CodeBook.lookup(99901), ityName);
            hash.put(CodeBook.lookup(99902), ltyName);
            hash.put(CodeBook.lookup(99903), prcName);
            hash.put(CodeBook.lookup(99904), hisName);
            hash.put(CodeBook.lookup(99905), boxName);
            hash.put(CodeBook.lookup(99906), rrcName);
            hash.put("experiment data pair:      ", this.pCW[pairIndex].getFileNameWithExtension());
            hash.put("processed data count:      ", new Integer(goodLogRatioCounts));
            hash.put("pre-filtering corr. coeff: ", new Float(s.getCorrelationCoeff()));
            hash.put("post-filtering data count: ", new Integer(dataPrep.getNonZeroCount()));
            hash.put("confidence factor:         ", new Float(confidentFactor));
            hash.put("dispersion factor:         ", new Float(disperseFactor));
            String[] moduleNotes = new String[]{"experiment data pair:      ", "processed data count:      ", "pre-filtering corr. coeff: ", "post-filtering data count: ", "confidence factor:         ", "dispersion factor:         "};
            hash.put("module_notes", moduleNotes);
            Module.proj.insertReportItem("flip_dye_for_pair" + pairIndex, hash);
            ++pairIndex;
        }
    }

    public final ColumnWorker[] getFlipDyeColumnWorker() {
        return this.pCW;
    }
}

