/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.Vector;
import org.tigr.midas.engine.DataPrep;
import org.tigr.midas.engine.DataReporter;
import org.tigr.midas.engine.Module;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.math.StatsTools;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.IDAssigner;
import org.tigr.midas.util.IndexAdjuster;
import org.tigr.midas.util.VecToArray;

public class InReplicatesAnalysis
extends Module {
    private ColumnWorker fCW;
    private ColumnWorker ffCW;

    public InReplicatesAnalysis(ColumnWorker fileCW, Object featNameCol) throws NumberFormatException, FileNotFoundException, Exception {
        FileBrowser projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
        String inRAFB = projFolderFB.createSubDir("inSlide_replicates_analysis");
        try {
            this.fCW = fileCW;
            this.fCW.setColumnForIdentifier(featNameCol);
            String[] featNameArray = this.fCW.getFeatNameArray();
            int totalRowCount = this.fCW.getRowCounts();
            String[] UIDArray = new String[totalRowCount];
            float[] cy3Column = this.fCW.getColumnOneArray();
            float[] cy5Column = this.fCW.getColumnTwoArray();
            if (this.fCW.file_type == 11100) {
                this.fCW.setColumnsForUID();
                UIDArray = this.fCW.getUID();
            }
            DataPrep dataPrep = new DataPrep(fileCW);
            int inCount = dataPrep.getNonZeroCount();
            IDAssigner idAssigner = new IDAssigner();
            Vector grpVec = new Vector();
            int[] geneGrpNdx = new int[totalRowCount];
            int row = 0;
            while (row < totalRowCount) {
                idAssigner.findUniqueID(featNameArray[row], grpVec);
                geneGrpNdx[row] = idAssigner.getID();
                ++row;
            }
            int grpNumber = idAssigner.getIDVec().size();
            float[][] grpCy3 = new float[grpNumber][];
            float[][] grpCy5 = new float[grpNumber][];
            int[][] origIndex = new int[grpNumber][];
            int[] grpRowCount = new int[grpNumber];
            int i = 0;
            while (i < grpNumber) {
                grpCy3[i] = new float[Integer.parseInt(idAssigner.getIDRepeatCount().get(i).toString())];
                grpCy5[i] = new float[Integer.parseInt(idAssigner.getIDRepeatCount().get(i).toString())];
                origIndex[i] = new int[Integer.parseInt(idAssigner.getIDRepeatCount().get(i).toString())];
                ++i;
            }
            int row2 = 0;
            while (row2 < totalRowCount) {
                grpCy3[geneGrpNdx[row2]][grpRowCount[geneGrpNdx[row2]]] = cy3Column[row2];
                grpCy5[geneGrpNdx[row2]][grpRowCount[geneGrpNdx[row2]]] = cy5Column[row2];
                origIndex[geneGrpNdx[row2]][grpRowCount[geneGrpNdx[row2]]] = row2;
                int n = geneGrpNdx[row2];
                grpRowCount[n] = grpRowCount[n] + 1;
                ++row2;
            }
            float[] mergedGrpCy3 = new float[grpNumber];
            float[] mergedGrpCy5 = new float[grpNumber];
            int[] grpOrigNdx = new int[grpNumber];
            float[] grpSD = new float[grpNumber];
            float[] grpMean = new float[grpNumber];
            float[] grpCV = new float[grpNumber];
            int[] grpRepCount = new int[grpNumber];
            String[] grpRepUID = new String[grpNumber];
            boolean[] grpCyFlag = new boolean[grpNumber];
            int nonZeroGrpNumber = 0;
            int grp = 0;
            while (grp < grpNumber) {
                float subGrpCy3Prod = 1.0f;
                float subGrpCy5Prod = 1.0f;
                int subGrpCounter = 0;
                Vector<Double> grpLogRatiosVec = new Vector<Double>();
                grpOrigNdx[grp] = origIndex[grp][0];
                int subGrp = 0;
                while (subGrp < grpCy3[grp].length) {
                    if (fileCW.file_type == 11100) {
                        if (subGrp == 0) {
                            grpRepUID[grp] = UIDArray[origIndex[grp][subGrp]];
                        } else if (subGrp > 0) {
                            String tail = UIDArray[origIndex[grp][subGrp]].substring(UIDArray[origIndex[grp][subGrp]].lastIndexOf(58) + 1, UIDArray[origIndex[grp][subGrp]].length());
                            grpRepUID[grp] = grpRepUID[grp] + ":" + tail;
                        }
                    }
                    if (idAssigner.getKeyBank().elementAt(grp).toString().equalsIgnoreCase("blank")) {
                        subGrpCounter = 0;
                    } else if (idAssigner.getKeyBank().elementAt(grp).toString().equalsIgnoreCase("null")) {
                        subGrpCounter = 0;
                    } else if (grpCy3[grp][subGrp] > 0.0f && grpCy5[grp][subGrp] > 0.0f) {
                        grpLogRatiosVec.addElement(new Double(MathTools.log2(grpCy5[grp][subGrp] / grpCy3[grp][subGrp])));
                        subGrpCy3Prod *= grpCy3[grp][subGrp];
                        subGrpCy5Prod *= grpCy5[grp][subGrp];
                        ++subGrpCounter;
                    }
                    ++subGrp;
                }
                if (subGrpCounter == 0) {
                    mergedGrpCy3[grp] = 0.0f;
                    mergedGrpCy5[grp] = 0.0f;
                    grpCyFlag[grp] = false;
                } else {
                    mergedGrpCy3[grp] = MathTools.nthRoot(subGrpCy3Prod, subGrpCounter);
                    mergedGrpCy5[grp] = MathTools.nthRoot(subGrpCy5Prod, subGrpCounter);
                    grpCyFlag[grp] = true;
                    ++nonZeroGrpNumber;
                }
                grpRepCount[grp] = subGrpCounter;
                float[] grpLogRatios = VecToArray.toFloat(grpLogRatiosVec);
                StatsTools s = new StatsTools();
                s.computeMeanSD(grpLogRatios);
                grpSD[grp] = s.getXSD();
                grpMean[grp] = s.getXMean();
                grpCV[grp] = grpSD[grp] / grpMean[grp];
                ++grp;
            }
            this.fCW = new ColumnWorker(grpNumber);
            this.fCW.setColOneArray(mergedGrpCy3);
            this.fCW.setColTwoArray(mergedGrpCy5);
            this.fCW.setNdxArray(grpOrigNdx);
            this.fCW.setRowFlag(grpCyFlag);
            this.ffCW = fileCW;
            float[] strechedMergedCy3 = new float[totalRowCount];
            float[] strechedMergedCy5 = new float[totalRowCount];
            boolean[] strechedOutFlag = new boolean[totalRowCount];
            int[] strechedRepCount = new int[totalRowCount];
            float[] strechedSD = new float[totalRowCount];
            String[] strechedRepUID = new String[totalRowCount];
            int rowIndex = 0;
            while (rowIndex < totalRowCount) {
                int ctrlIndex = 0;
                while (ctrlIndex < grpNumber) {
                    if (rowIndex == grpOrigNdx[ctrlIndex]) {
                        strechedMergedCy3[rowIndex] = mergedGrpCy3[ctrlIndex];
                        strechedMergedCy5[rowIndex] = mergedGrpCy5[ctrlIndex];
                        strechedOutFlag[rowIndex] = true;
                        break;
                    }
                    strechedMergedCy3[rowIndex] = 0.0f;
                    strechedMergedCy5[rowIndex] = 0.0f;
                    strechedOutFlag[rowIndex] = false;
                    ++ctrlIndex;
                }
                strechedRepUID[rowIndex] = grpRepUID[geneGrpNdx[rowIndex]];
                ++rowIndex;
            }
            this.ffCW.setColOneArray(strechedMergedCy3);
            this.ffCW.setColTwoArray(strechedMergedCy5);
            this.ffCW.setRowFlag(strechedOutFlag);
            this.ffCW.setUIDArray(strechedRepUID);
            String ityName = Module.proj.getProjPath() + "inSlide_replicates_analysis" + FileBrowser.fsep + this.ffCW.getFileName() + "_inSlideRep.ity";
            String ltyName = Module.proj.getProjPath() + "inSlide_replicates_analysis" + FileBrowser.fsep + this.ffCW.getFileName() + "_inSlideRep.lty";
            String prcName = Module.proj.getProjPath() + "inSlide_replicates_analysis" + FileBrowser.fsep + this.ffCW.getFileName() + "_inSlideRep.prc";
            String hisName = Module.proj.getProjPath() + "inSlide_replicates_analysis" + FileBrowser.fsep + this.ffCW.getFileName() + "_inSlideRep.his";
            String boxName = Module.proj.getProjPath() + "inSlide_replicates_analysis" + FileBrowser.fsep + this.ffCW.getFileName() + "_inSlideRep_block.box";
            dataPrep = new DataPrep(this.ffCW);
            DataReporter dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
            dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
            dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("identity", new Integer(30));
            hash.put(CodeBook.lookup(99901), ityName);
            hash.put(CodeBook.lookup(99902), ltyName);
            hash.put(CodeBook.lookup(99903), prcName);
            hash.put(CodeBook.lookup(99904), hisName);
            hash.put(CodeBook.lookup(99905), boxName);
            hash.put("experiment data file:   ", fileCW.getFileNameWithExtension());
            hash.put("processed data count:   ", new Integer(inCount));
            hash.put("replicates group count: ", new Integer(grpNumber));
            String[] moduleNotes = new String[]{"experiment data file:   ", "processed data count:   ", "replicates group count: "};
            hash.put("module_notes", moduleNotes);
            Module.proj.insertReportItem("inSliceRep_for_" + this.ffCW.getFileName(), hash);
        }
        catch (FileNotFoundException nfex) {
            throw nfex;
        }
        catch (NumberFormatException nex) {
            throw nex;
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    public final ColumnWorker getFileRAColumnWorker() {
        return this.ffCW;
    }
}

