/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import org.tigr.midas.display.AlertDialogPane;
import org.tigr.midas.engine.MaAnovaParameter;
import org.tigr.midas.engine.Parameter;
import org.tigr.midas.engine.Project;
import org.tigr.midas.util.StringSplitter;

public class ProjRecorder {
    public ProjRecorder(Project proj) {
        int ifWritePrj = 0;
        if (proj.getProjFile().exists()) {
            AlertDialogPane aPane = new AlertDialogPane(2, "The prj file you specified already exists, do you want to overwrite it? ");
            ifWritePrj = aPane.retVal;
        }
        if (ifWritePrj == 0) {
            try {
                boolean isReadFolder = false;
                FileOutputStream out = new FileOutputStream(proj.getProjFile());
                Date now = new Date(System.currentTimeMillis());
                String flowStr = proj.getFlow();
                ObjectOutputStream s = new ObjectOutputStream(out);
                s.writeObject("#MIDAS V2.19 Project file <Date> " + now.toString() + " <JVM> " + System.getProperty("java.vm.version") + " <OS> " + System.getProperty("os.name") + " <OS Version> " + System.getProperty("os.version") + " <Mem> " + Runtime.getRuntime().freeMemory());
                s.writeObject("#");
                s.writeObject("#Flow:" + flowStr);
                s.writeObject("#");
                s.writeObject("#Parameters:");
                StringSplitter st = new StringSplitter(flowStr, '>');
                block22: while (st.hasMoreTokens()) {
                    int currentCall = Integer.parseInt(st.nextToken());
                    switch (currentCall) {
                        case 0: {
                            s.writeObject(Parameter.pSingleFileStr);
                            s.writeObject(Parameter.pOneBadChannelPolicyStr);
                            s.writeBoolean(Parameter.pUseCh1FlagOpt);
                            s.writeBoolean(Parameter.pUseCh2FlagOpt);
                            if (Parameter.pUseCh1FlagOpt) {
                                s.writeInt(Parameter.pUseCh1FlagCol);
                            }
                            if (Parameter.pUseCh2FlagOpt) {
                                s.writeInt(Parameter.pUseCh2FlagCol);
                            }
                            s.writeBoolean(Parameter.pCh1BkgdOpt);
                            s.writeBoolean(Parameter.pCh2BkgdOpt);
                            if (!Parameter.pCh1BkgdOpt || !Parameter.pCh2BkgdOpt) continue block22;
                            s.writeInt(Parameter.pCh1BkgdCol);
                            s.writeInt(Parameter.pCh2BkgdCol);
                            s.writeFloat(Parameter.pBkgdSNRatioVal);
                            break;
                        }
                        case 1: {
                            s.writeObject(Parameter.pFilePairVec);
                            s.writeObject(Parameter.pOneBadChannelPolicyStr);
                            s.writeBoolean(Parameter.pUseCh1FlagOpt);
                            s.writeBoolean(Parameter.pUseCh2FlagOpt);
                            if (Parameter.pUseCh1FlagOpt) {
                                s.writeInt(Parameter.pUseCh1FlagCol);
                            }
                            if (Parameter.pUseCh2FlagOpt) {
                                s.writeInt(Parameter.pUseCh2FlagCol);
                            }
                            s.writeBoolean(Parameter.pCh1BkgdOpt);
                            s.writeBoolean(Parameter.pCh2BkgdOpt);
                            if (!Parameter.pCh1BkgdOpt || !Parameter.pCh2BkgdOpt) continue block22;
                            s.writeInt(Parameter.pCh1BkgdCol);
                            s.writeInt(Parameter.pCh2BkgdCol);
                            s.writeFloat(Parameter.pBkgdSNRatioVal);
                            break;
                        }
                        case 2: {
                            isReadFolder = true;
                            s.writeObject(Parameter.pFolderStr);
                            s.writeObject(Parameter.pFolderFilesVec);
                            s.writeObject(Parameter.pOneBadChannelPolicyStr);
                            s.writeBoolean(Parameter.pUseCh1FlagOpt);
                            s.writeBoolean(Parameter.pUseCh2FlagOpt);
                            if (Parameter.pUseCh1FlagOpt) {
                                s.writeInt(Parameter.pUseCh1FlagCol);
                            }
                            if (Parameter.pUseCh2FlagOpt) {
                                s.writeInt(Parameter.pUseCh2FlagCol);
                            }
                            s.writeBoolean(Parameter.pCh1BkgdOpt);
                            s.writeBoolean(Parameter.pCh2BkgdOpt);
                            if (!Parameter.pCh1BkgdOpt || !Parameter.pCh2BkgdOpt) continue block22;
                            s.writeInt(Parameter.pCh1BkgdCol);
                            s.writeInt(Parameter.pCh2BkgdCol);
                            s.writeFloat(Parameter.pBkgdSNRatioVal);
                            break;
                        }
                        case 12: {
                            s.writeObject(Parameter.pRefStr);
                            break;
                        }
                        case 11: {
                            s.writeObject(Parameter.pLocfitModeStr);
                            s.writeFloat(Parameter.pSmoothParaVal);
                            s.writeObject(Parameter.pRefStr);
                            break;
                        }
                        case 15: {
                            s.writeObject(Parameter.pIterLinRegModeStr);
                            s.writeFloat(Parameter.pIterLinRegSDRangeVal);
                            s.writeObject(Parameter.pRefStr);
                            break;
                        }
                        case 14: {
                            s.writeFloat(Parameter.pIterLogMeanSDRangeVal);
                            s.writeObject(Parameter.pRefStr);
                            break;
                        }
                        case 13: {
                            s.writeBoolean(Parameter.pBlockSDRegOpt);
                            s.writeBoolean(Parameter.pSlideSDRegOpt);
                            s.writeObject(Parameter.pRefStr);
                            break;
                        }
                        case 16: {
                            s.writeBoolean(Parameter.pRatioStatsCIChkOpt);
                            s.writeInt(Parameter.pRatioStatsCIVal);
                            s.writeObject(Parameter.pRefStr);
                            break;
                        }
                        case 10: {
                            s.writeLong(Parameter.pCy3CutoffVal);
                            s.writeLong(Parameter.pCy5CutoffVal);
                            break;
                        }
                        case 20: {
                            s.writeInt(Parameter.pSliceDataPopVal);
                            s.writeFloat(Parameter.pSliceDataRangeLtVal);
                            s.writeFloat(Parameter.pSliceDataRangeGtVal);
                            break;
                        }
                        case 30: {
                            s.writeObject(Parameter.pIdentifierCol.toString());
                            break;
                        }
                        case 31: {
                            break;
                        }
                        case 32: {
                            s.writeFloat(Parameter.pTtestHypoMean);
                            s.writeInt(Parameter.pTtestPValBase);
                            s.writeFloat(Parameter.pTtestAlpha);
                            s.writeInt(Parameter.pTtestSigMethod);
                            break;
                        }
                        case 33: {
                            s.writeFloat(Parameter.pSAMHypoMean);
                            s.writeBoolean(Parameter.pSAMAllUniquePerm);
                            s.writeInt(Parameter.pSAMPermutationsNumber);
                            s.writeInt(Parameter.pSAMS0Method);
                            s.writeInt(Parameter.pSAMImputationEngine);
                            s.writeInt(Parameter.pSAMNearestNeighborsNumber);
                        }
                        case 40: {
                            s.writeObject(Parameter.pFlipdyeCutOptionStr);
                            s.writeFloat(Parameter.pFlipdyeDataKeepRangeVal);
                            break;
                        }
                        case 41: {
                            s.writeInt(MaAnovaParameter.elistSize);
                            s.writeInt(MaAnovaParameter.getDim());
                            s.writeObject(MaAnovaParameter.pExpListStr);
                            s.writeObject(MaAnovaParameter.pFolderStr);
                            s.writeObject(MaAnovaParameter.getAnovaModelVector());
                            s.writeObject(MaAnovaParameter.getMatrixVector());
                            s.writeObject(MaAnovaParameter.getArrayStVector());
                            s.writeObject(MaAnovaParameter.ExpListObject);
                        }
                        case 100: {
                            s.writeObject(Parameter.pOutFileStr);
                            s.writeBoolean(Parameter.pVtrimOpt);
                            s.writeBoolean(Parameter.pReNumberOpt);
                            s.writeBoolean(Parameter.pOutputTrimmedDataOpt);
                            if (!isReadFolder) break;
                            s.writeBoolean(Parameter.pUseCrossFileTrimOpt);
                            if (!Parameter.pUseCrossFileTrimOpt) break;
                            s.writeFloat(Parameter.pCrossFilePct);
                        }
                    }
                }
                s.writeObject("END");
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            System.out.println("Abort writing prj file.");
        }
    }
}

