/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.io.FileNotFoundException;
import java.util.Hashtable;
import org.tigr.midas.engine.DataPrep;
import org.tigr.midas.engine.DataReporter;
import org.tigr.midas.engine.Module;
import org.tigr.midas.engine.Parameter;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.IndexAdjuster;

public class RatioStats
extends Module {
    private static final float[] meanCoef = new float[]{1.001f, -0.0427f, 1.279f, 0.364f};
    private static final float[] stdCoef = new float[]{0.00225f, 1.341f, 0.19f, 6.259f};
    private static final float[] low95Coef = new float[]{0.979f, -2.706f, 2.911f, -2.805f};
    private static final float[] high95Coef = new float[]{0.989f, 3.082f, -2.83f, 28.664f};
    private static final float[] low99Coef = new float[]{0.9968f, -3.496f, 4.462f, -5.002f};
    private static final float[] high99Coef = new float[]{0.9648f, 4.81f, -15.161f, 78.349f};
    private ColumnWorker fCW;
    private float[] cy3Column;
    private float[] cy5Column;
    private float calcMean;
    private float plainMean;
    private float cVal;
    private float calcSD;
    private float high99;
    private float low99;
    private float high95;
    private float low95;
    private int validRatioCounts;
    private int confidentCounts;
    private int iterCount;

    public RatioStats(ColumnWorker fileCW, boolean confidenceChk, int pctConfidence, String ref) throws Exception {
        FileBrowser projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
        String iterLinRegFB = projFolderFB.createSubDir("ratio_stats");
        double mLimit = 1.0E-10;
        int maxIterations = 100;
        this.fCW = fileCW;
        this.cy3Column = fileCW.getColumnOneArray();
        this.cy5Column = fileCW.getColumnTwoArray();
        boolean[] tempFlag = fileCW.getRowFlagArray();
        boolean[] outputFlag = new boolean[tempFlag.length];
        System.arraycopy(tempFlag, 0, outputFlag, 0, tempFlag.length);
        float[] ratios = new float[this.fCW.getRowCounts()];
        float oldCalcMean = 1.0f;
        float ratioSum = 0.0f;
        this.plainMean = 0.0f;
        this.calcMean = 1.0f;
        this.validRatioCounts = 0;
        this.confidentCounts = 0;
        int totalRowCount = this.fCW.getRowCounts();
        int rawNdx = 0;
        while (rawNdx < this.fCW.getRowCounts()) {
            if (this.cy3Column[rawNdx] > 1.0f && this.cy5Column[rawNdx] > 1.0f && outputFlag[rawNdx]) {
                ratios[rawNdx] = this.cy5Column[rawNdx] / this.cy3Column[rawNdx];
                ratioSum += ratios[rawNdx];
                ++this.validRatioCounts;
            } else {
                ratios[rawNdx] = 0.0f;
                outputFlag[rawNdx] = false;
            }
            ++rawNdx;
        }
        System.out.println("    Valid Ratio Counts = " + this.validRatioCounts);
        this.iterCount = 1;
        while (true) {
            float accumulator = 0.0f;
            this.plainMean = ratioSum / (float)this.validRatioCounts / oldCalcMean;
            ratioSum = 0.0f;
            int i = 0;
            while (i < this.fCW.getRowCounts()) {
                if (outputFlag[i]) {
                    int n = i;
                    ratios[n] = ratios[n] / this.plainMean;
                    accumulator += MathTools.sqr(ratios[i] - 1.0f) / (1.0f + MathTools.sqr(ratios[i]));
                    ratioSum += ratios[i];
                }
                ++i;
            }
            this.cVal = (float)Math.sqrt(accumulator / (float)this.validRatioCounts);
            this.calcMean = meanCoef[3] * this.cVal * this.cVal * this.cVal + meanCoef[2] * this.cVal * this.cVal + meanCoef[1] * this.cVal + meanCoef[0];
            System.out.println("    ---- Iteration " + this.iterCount + ", plainMean = " + this.plainMean + ", calcMean = " + this.calcMean);
            if ((double)Math.abs(this.calcMean - oldCalcMean) < mLimit || this.iterCount >= maxIterations) break;
            oldCalcMean = this.calcMean;
            ++this.iterCount;
        }
        this.calcSD = stdCoef[3] * this.cVal * this.cVal * this.cVal + stdCoef[2] * this.cVal * this.cVal + stdCoef[1] * this.cVal + stdCoef[0];
        this.high99 = high99Coef[3] * this.cVal * this.cVal * this.cVal + high99Coef[2] * this.cVal * this.cVal + high99Coef[1] * this.cVal + high99Coef[0];
        this.high99 *= this.plainMean;
        this.low99 = low99Coef[3] * this.cVal * this.cVal * this.cVal + low99Coef[2] * this.cVal * this.cVal + low99Coef[1] * this.cVal + low99Coef[0];
        this.low99 *= this.plainMean;
        this.high95 = high95Coef[3] * this.cVal * this.cVal * this.cVal + high95Coef[2] * this.cVal * this.cVal + high95Coef[1] * this.cVal + high95Coef[0];
        this.high95 *= this.plainMean;
        this.low95 = low95Coef[3] * this.cVal * this.cVal * this.cVal + low95Coef[2] * this.cVal * this.cVal + low95Coef[1] * this.cVal + low95Coef[0];
        this.low95 *= this.plainMean;
        System.out.println("    ratio mean = " + this.plainMean);
        System.out.println("    ratio function mean = " + this.calcMean);
        System.out.println("    ratio density SD = " + this.calcSD);
        System.out.println("    maximum-likelyhood estimator = " + this.cVal);
        System.out.println("    95% confidence lower limit = " + this.low95 + ", upper limit = " + this.high95);
        System.out.println("    99% confidence lower limit = " + this.low99 + ", upper limit = " + this.high99);
        int rawNdx2 = 0;
        while (rawNdx2 < this.fCW.getRowCounts()) {
            if (outputFlag[rawNdx2]) {
                if (confidenceChk) {
                    if (pctConfidence == 95) {
                        if (ratios[rawNdx2] > this.low95 && ratios[rawNdx2] < this.high95) {
                            if (Parameter.pRefStr.equalsIgnoreCase("Cy3")) {
                                this.cy5Column[rawNdx2] = this.cy3Column[rawNdx2] * ratios[rawNdx2];
                            } else {
                                this.cy3Column[rawNdx2] = this.cy5Column[rawNdx2] / ratios[rawNdx2];
                            }
                            ++this.confidentCounts;
                        } else {
                            outputFlag[rawNdx2] = false;
                        }
                    } else if (ratios[rawNdx2] > this.low99 && ratios[rawNdx2] < this.high99) {
                        if (ref.equalsIgnoreCase("Cy3")) {
                            this.cy5Column[rawNdx2] = this.cy3Column[rawNdx2] * ratios[rawNdx2];
                        } else {
                            this.cy3Column[rawNdx2] = this.cy5Column[rawNdx2] / ratios[rawNdx2];
                        }
                        ++this.confidentCounts;
                    } else {
                        outputFlag[rawNdx2] = false;
                    }
                } else if (Parameter.pRefStr.equalsIgnoreCase("Cy3")) {
                    this.cy5Column[rawNdx2] = this.cy3Column[rawNdx2] * ratios[rawNdx2];
                } else {
                    this.cy3Column[rawNdx2] = this.cy5Column[rawNdx2] / ratios[rawNdx2];
                }
            } else {
                this.cy3Column[rawNdx2] = 0.0f;
                this.cy5Column[rawNdx2] = 0.0f;
            }
            ++rawNdx2;
        }
        if (confidenceChk) {
            System.out.println("    Gene counts within confidence range = " + this.confidentCounts);
        }
        this.fCW.setColOneArray(this.cy3Column);
        this.fCW.setColTwoArray(this.cy5Column);
        this.fCW.setRowFlag(outputFlag);
        String ityName = Module.proj.getProjPath() + "ratio_stats" + FileBrowser.fsep + fileCW.getFileName() + "_ratiostats.ity";
        String ltyName = Module.proj.getProjPath() + "ratio_stats" + FileBrowser.fsep + fileCW.getFileName() + "_ratiostats.lty";
        String prcName = Module.proj.getProjPath() + "ratio_stats" + FileBrowser.fsep + fileCW.getFileName() + "_ratiostats.prc";
        String hisName = Module.proj.getProjPath() + "ratio_stats" + FileBrowser.fsep + fileCW.getFileName() + "_ratiostats.his";
        String boxName = Module.proj.getProjPath() + "ratio_stats" + FileBrowser.fsep + fileCW.getFileName() + "_ratiostats_block.box";
        DataPrep dataPrep = new DataPrep(fileCW);
        DataReporter dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
        dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
        dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
        dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
        dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        hash.put("identity", new Integer(16));
        hash.put(CodeBook.lookup(99901), ityName);
        hash.put(CodeBook.lookup(99902), ltyName);
        hash.put(CodeBook.lookup(99903), prcName);
        hash.put(CodeBook.lookup(99904), hisName);
        hash.put(CodeBook.lookup(99905), boxName);
        hash.put("experiment data file:      ", fileCW.getFileNameWithExtension());
        hash.put("processed data count:      ", new Integer(this.validRatioCounts));
        hash.put("post-filtering data count: ", new Integer(dataPrep.getNonZeroCount()));
        String[] moduleNotes = new String[]{"experiment data file:      ", "processed data count:      ", "post-filtering data count: "};
        hash.put("module_notes", moduleNotes);
        Module.proj.insertReportItem("ratiostats_for_" + fileCW.getFileName(), hash);
    }

    public final ColumnWorker getRatioStatsColumnWorker() {
        return this.fCW;
    }

    public final float getPlainMean() {
        return this.plainMean;
    }

    public final float getCalcMean() {
        return this.calcMean;
    }

    public final float getCalcSD() {
        return this.calcSD;
    }

    public final float getLow95() {
        return this.low95;
    }

    public final float getHigh95() {
        return this.high95;
    }

    public final float getLow99() {
        return this.low95;
    }

    public final float getHigh99() {
        return this.high95;
    }

    public final float getCval() {
        return this.cVal;
    }

    public final int getIterationCounts() {
        return this.iterCount;
    }

    public final int getValidRatioCounts() {
        return this.validRatioCounts;
    }

    public final int getConfidentCounts() {
        return this.confidentCounts;
    }

    public static void main(String[] args) {
        try {
            ColumnWorker fileCW = new ColumnWorker("C:\\DataFiles0\\32K\\SimonData\\1233259D2F.tav");
            fileCW.setColumnsForMeta(2, 3);
            fileCW.setColumns(6, 7, 15, 16);
            fileCW.computeGoodRatiosAndLogRatios(0L, 0L);
            RatioStats ratioStats = new RatioStats(fileCW, true, 99, "Cy3");
        }
        catch (FileNotFoundException nfex) {
            nfex.printStackTrace();
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

