/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.midas.display.Midas;
import org.tigr.midas.graph.ActionInfoDialog;
import org.tigr.midas.graph.ActionInfoEvent;
import org.tigr.midas.util.GBA;

public class GraphSettingsDialog
extends ActionInfoDialog {
    private JFrame parent;
    JLabel lowerxLabel;
    JLabel upperxLabel;
    JLabel xStepLabel;
    JLabel loweryLabel;
    JLabel upperyLabel;
    JLabel yStepLabel;
    JTextField titleTextField;
    JTextField lowerxTextField;
    JTextField upperxTextField;
    JTextField xStepTextField;
    JTextField loweryTextField;
    JTextField upperyTextField;
    JTextField yStepTextField;
    JCheckBox refLines;
    boolean[] ifShownForSet;
    JCheckBox[] checkBox;
    JButton[] colorButton;
    Color[] dataColors;
    JButton okButton;
    JButton cancelButton;
    Font boundariesDialogFont;
    GBA gba;

    public GraphSettingsDialog(JFrame parent, String title, double lowerx, double upperx, double xStep, double lowery, double uppery, double yStep, Color[] dataColors, boolean[] ifShownForSet, boolean refOn) {
        super(parent, true);
        try {
            this.parent = parent;
            this.dataColors = dataColors;
            this.ifShownForSet = ifShownForSet;
            this.gba = new GBA();
            JPanel titlePane = new JPanel();
            titlePane.setBorder(new TitledBorder(new EtchedBorder(), " Title "));
            titlePane.setPreferredSize(new Dimension(400, 60));
            this.titleTextField = new JTextField(30);
            this.titleTextField.setForeground(Color.blue);
            this.titleTextField.setText("" + title);
            titlePane.add(this.titleTextField);
            JPanel xAxisPane = new JPanel();
            xAxisPane.setBorder(new TitledBorder(new EtchedBorder(), " X-Axis "));
            xAxisPane.setPreferredSize(new Dimension(400, 80));
            xAxisPane.setLayout(new GridBagLayout());
            this.lowerxLabel = new JLabel("    Lower X: (" + lowerx + ")");
            this.upperxLabel = new JLabel("    Upper X: (" + upperx + ")");
            this.xStepLabel = new JLabel("    X step: (" + xStep + ")");
            this.lowerxTextField = new JTextField(12);
            this.lowerxTextField.setForeground(Color.blue);
            this.lowerxTextField.setText("" + lowerx);
            this.upperxTextField = new JTextField(12);
            this.upperxTextField.setText("" + upperx);
            this.upperxTextField.setForeground(Color.blue);
            this.xStepTextField = new JTextField(12);
            this.xStepTextField.setText("" + xStep);
            this.xStepTextField.setForeground(Color.blue);
            this.gba.add(xAxisPane, this.lowerxLabel, 0, 0, 1, 1, 0, 1, 0, 17, 2, 2, 2, 2, 0, 0);
            this.gba.add(xAxisPane, this.lowerxTextField, 1, 0, 1, 1, 1, 1, 1, 17, 2, 2, 2, 2, 0, 0);
            this.gba.add(xAxisPane, this.upperxLabel, 0, 1, 1, 1, 0, 1, 0, 17, 2, 2, 2, 2, 0, 0);
            this.gba.add(xAxisPane, this.upperxTextField, 1, 1, 1, 1, 1, 1, 1, 17, 2, 2, 2, 2, 0, 0);
            JPanel yAxisPane = new JPanel();
            yAxisPane.setBorder(new TitledBorder(new EtchedBorder(), " Y-Axis "));
            yAxisPane.setPreferredSize(new Dimension(400, 80));
            yAxisPane.setLayout(new GridBagLayout());
            this.loweryLabel = new JLabel("    Lower Y: (" + lowery + ")");
            this.upperyLabel = new JLabel("    Upper Y: (" + uppery + ")");
            this.yStepLabel = new JLabel("    Y step: (" + yStep + ")");
            this.loweryTextField = new JTextField(12);
            this.loweryTextField.setText("" + lowery);
            this.loweryTextField.setForeground(Color.blue);
            this.upperyTextField = new JTextField(12);
            this.upperyTextField.setText("" + uppery);
            this.upperyTextField.setForeground(Color.blue);
            this.yStepTextField = new JTextField(12);
            this.yStepTextField.setText("" + yStep);
            this.yStepTextField.setForeground(Color.blue);
            this.gba.add(yAxisPane, this.loweryLabel, 0, 0, 1, 1, 0, 1, 0, 17, 2, 2, 2, 2, 0, 0);
            this.gba.add(yAxisPane, this.loweryTextField, 1, 0, 1, 1, 1, 1, 1, 17, 2, 2, 2, 2, 0, 0);
            this.gba.add(yAxisPane, this.upperyLabel, 0, 1, 1, 1, 0, 1, 0, 17, 2, 2, 2, 2, 0, 0);
            this.gba.add(yAxisPane, this.upperyTextField, 1, 1, 1, 1, 1, 1, 1, 17, 2, 2, 2, 2, 0, 0);
            JPanel dataPointPane = new JPanel();
            dataPointPane.setBorder(new TitledBorder(new EtchedBorder(), " Data Points "));
            dataPointPane.setPreferredSize(new Dimension(400, 80));
            this.checkBox = new JCheckBox[ifShownForSet.length];
            this.colorButton = new JButton[ifShownForSet.length];
            int i = 0;
            while (i < ifShownForSet.length) {
                this.checkBox[i] = new JCheckBox("Set " + (i + 1));
                this.checkBox[i].setSelected(ifShownForSet[i]);
                this.colorButton[i] = new JButton();
                this.colorButton[i].setBackground(dataColors[i]);
                this.colorButton[i].addActionListener(new ColorListener());
                dataPointPane.add(this.checkBox[i]);
                dataPointPane.add(this.colorButton[i]);
                ++i;
            }
            this.refLines = new JCheckBox("Refenence lines");
            this.refLines.setSelected(refOn);
            this.refLines.addActionListener(new EventListener());
            JPanel butnPane = new JPanel();
            this.okButton = new JButton("Apply");
            this.okButton.addActionListener(new EventListener());
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new EventListener());
            butnPane.add(this.okButton);
            butnPane.add(this.cancelButton);
            this.contentPane.setLayout(new GridBagLayout());
            this.gba.add(this.contentPane, titlePane, 0, 0, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.gba.add(this.contentPane, xAxisPane, 0, 1, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.gba.add(this.contentPane, yAxisPane, 0, 2, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.gba.add(this.contentPane, dataPointPane, 0, 3, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.gba.add(this.contentPane, this.refLines, 0, 4, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.gba.add(this.contentPane, butnPane, 0, 5, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.pack();
            this.setResizable(false);
            this.setTitle("Graph settings");
            this.okButton.grabFocus();
            this.setLocation(300, 300);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class EventListener
    implements ActionListener,
    KeyListener {
        EventListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == GraphSettingsDialog.this.okButton) {
                String title = GraphSettingsDialog.this.titleTextField.getText();
                String lowerx = GraphSettingsDialog.this.lowerxTextField.getText();
                String upperx = GraphSettingsDialog.this.upperxTextField.getText();
                String xStep = GraphSettingsDialog.this.xStepTextField.getText();
                String lowery = GraphSettingsDialog.this.loweryTextField.getText();
                String uppery = GraphSettingsDialog.this.upperyTextField.getText();
                String yStep = GraphSettingsDialog.this.yStepTextField.getText();
                String refLinesOn = GraphSettingsDialog.this.refLines.isSelected() ? "true" : "false";
                GraphSettingsDialog.this.hide();
                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                hash.put(new String("title"), title);
                hash.put(new String("lowerx"), lowerx);
                hash.put(new String("upperx"), upperx);
                hash.put(new String("xStep"), xStep);
                hash.put(new String("lowery"), lowery);
                hash.put(new String("uppery"), uppery);
                hash.put(new String("yStep"), yStep);
                int i = 0;
                while (i < GraphSettingsDialog.this.ifShownForSet.length) {
                    String setShown = GraphSettingsDialog.this.checkBox[i].isSelected() ? "true" : "false";
                    hash.put(new String("ifShownForSet" + i), setShown);
                    hash.put(new String("ColorForSet" + i), GraphSettingsDialog.this.colorButton[i].getBackground());
                    ++i;
                }
                hash.put(new String("refLinesOn"), refLinesOn);
                GraphSettingsDialog.this.fireEvent(new ActionInfoEvent(this, hash));
                GraphSettingsDialog.this.dispose();
            } else if (event.getSource() == GraphSettingsDialog.this.cancelButton) {
                GraphSettingsDialog.this.dispose();
            }
        }

        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                String title = GraphSettingsDialog.this.titleTextField.getText();
                String lowerx = GraphSettingsDialog.this.lowerxTextField.getText();
                String upperx = GraphSettingsDialog.this.upperxTextField.getText();
                String xStep = GraphSettingsDialog.this.xStepTextField.getText();
                String lowery = GraphSettingsDialog.this.loweryTextField.getText();
                String uppery = GraphSettingsDialog.this.upperyTextField.getText();
                String yStep = GraphSettingsDialog.this.yStepTextField.getText();
                String refLinesOn = GraphSettingsDialog.this.refLines.isSelected() ? "true" : "false";
                GraphSettingsDialog.this.hide();
                Hashtable<String, String> hash = new Hashtable<String, String>();
                hash.put(new String("title"), title);
                hash.put(new String("lowerx"), lowerx);
                hash.put(new String("upperx"), upperx);
                hash.put(new String("xStep"), xStep);
                hash.put(new String("lowery"), lowery);
                hash.put(new String("uppery"), uppery);
                hash.put(new String("yStep"), yStep);
                hash.put(new String("refLinesOn"), refLinesOn);
                GraphSettingsDialog.this.fireEvent(new ActionInfoEvent(this, hash));
                GraphSettingsDialog.this.dispose();
            }
        }

        public void keyReleased(KeyEvent event) {
        }

        public void keyTyped(KeyEvent event) {
        }
    }

    class ColorListener
    implements ActionListener,
    ChangeListener {
        ColorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color newColor = JColorChooser.showDialog(Midas.frame, "Choose Data Color", ((JButton)actionEvent.getSource()).getBackground());
            if (newColor != null) {
                ((JButton)actionEvent.getSource()).setBackground(newColor);
            }
        }

        public void stateChanged(ChangeEvent e) {
        }
    }
}

