/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.graph;

import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.DecimalFormat;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.tigr.midas.Constant;
import org.tigr.midas.graph.Drawable;
import org.tigr.midas.graph.Viewer;
import org.tigr.midas.util.GBA;
import org.tigr.midas.util.PrintUtilities;

public class SAMGraphViewer
extends Viewer {
    protected int startx;
    protected int stopx;
    protected int starty;
    protected int stopy;
    protected int preXSpacing;
    protected int postXSpacing;
    protected int preYSpacing;
    protected int postYSpacing;
    private double[] yArray;
    private double[] xArray;
    private double delta;
    int originX;
    int originY;
    protected Drawable canvas;
    protected GBA gba;
    protected FontMetrics metrics;
    protected JButton clearButton = new JButton("Clear");
    protected JButton saveButton = new JButton("Save");
    protected JButton printButton = new JButton("Print");
    protected JPanel buttonPane = new JPanel();
    protected BufferedImage image;
    protected EventListener eventListener;

    public SAMGraphViewer(int startx, int stopx, int starty, int stopy, int preXSpacing, int postXSpacing, int preYSpacing, int postYSpacing, double[] xArray, double[] yArray, double delta) {
        this.startx = startx;
        this.stopx = stopx;
        this.starty = starty;
        this.stopy = stopy;
        this.preXSpacing = preXSpacing;
        this.postXSpacing = postXSpacing;
        this.preYSpacing = preYSpacing;
        this.postYSpacing = postYSpacing;
        this.yArray = yArray;
        this.xArray = xArray;
        this.delta = delta;
        this.setBackground(Color.white);
        this.initializeViewer();
        this.initializeCanvas();
    }

    private void initializeViewer() {
        this.setLayout(new GridBagLayout());
        this.eventListener = new EventListener();
        this.gba = new GBA();
        this.setBackground(Color.white);
        this.setSize(this.stopx - this.startx + this.preXSpacing + this.postXSpacing, this.stopy - this.starty + this.preYSpacing + this.postYSpacing);
    }

    private void initializeCanvas() {
        this.canvas = new Drawable(this.startx, this.stopx, this.starty, this.stopy){

            public void controlPaint(Graphics g) {
                SAMGraphViewer.this.display(g);
            }
        };
        this.canvas.setBackground(Color.white);
        this.initializeControls();
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas, "Center");
        this.add((Component)this.buttonPane, "South");
    }

    private void initializeControls() {
        this.clearButton.addActionListener(this.eventListener);
        this.saveButton.addActionListener(this.eventListener);
        this.printButton.addActionListener(this.eventListener);
        this.buttonPane.setBackground(Color.white);
        this.buttonPane.add(this.clearButton);
        this.buttonPane.add(this.saveButton);
        this.buttonPane.add(this.printButton);
    }

    public void display(Graphics g1D) {
        Graphics2D g = (Graphics2D)g1D;
        this.metrics = g.getFontMetrics();
        this.paint(g);
    }

    public void paint(Graphics g) {
        int i;
        int i2;
        Graphics2D g2D = (Graphics2D)g;
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        this.originX = (int)Math.round((double)(this.getWidth() / 2));
        this.originY = (int)Math.round((double)(this.getHeight() / 2));
        double origMaxXValue = this.getMax(this.xArray);
        double origMaxYValue = this.getMax(this.yArray);
        double origMinXValue = this.getMin(this.xArray);
        double origMinYValue = this.getMin(this.yArray);
        double xScalingFactor = this.getXScalingFactor(origMaxXValue, origMinXValue);
        double yScalingFactor = this.getYScalingFactor(origMaxYValue, origMinYValue);
        float[] dash1 = new float[]{10.0f};
        g2D.setStroke(new BasicStroke(1.2f));
        g2D.setColor(Color.black);
        g2D.drawLine(0, (int)Math.round((double)(this.getHeight() / 2)), this.getWidth(), (int)Math.round((double)(this.getHeight() / 2)));
        g2D.drawLine((int)Math.round((double)(this.getWidth() / 2)), 0, (int)Math.round((double)(this.getWidth() / 2)), this.getHeight());
        double[] xIntervalArray = new double[6];
        double[] yIntervalArray = new double[6];
        double xIncrement = 0.0;
        double yIncrement = 0.0;
        xIncrement = Math.abs(origMaxXValue) > Math.abs(origMinXValue) ? Math.abs(origMaxXValue / 5.0) : Math.abs(origMinXValue / 5.0);
        yIncrement = Math.abs(origMaxYValue) > Math.abs(origMinYValue) ? Math.abs(origMaxYValue / 5.0) : Math.abs(origMinYValue / 5.0);
        double xCounter = 0.0;
        double yCounter = 0.0;
        int i3 = 0;
        while (i3 < xIntervalArray.length) {
            xIntervalArray[i3] = xCounter;
            xCounter += xIncrement;
            yIntervalArray[i3] = yCounter;
            yCounter += yIncrement;
            ++i3;
        }
        g2D.setStroke(new BasicStroke(1.2f));
        g2D.setColor(Color.black);
        int i4 = 1;
        while (i4 < xIntervalArray.length) {
            g2D.drawLine((int)Math.round(xIntervalArray[i4] * xScalingFactor) + this.getWidth() / 2, this.getHeight() / 2 - 5, (int)Math.round(xIntervalArray[i4] * xScalingFactor) + this.getWidth() / 2, this.getHeight() / 2 + 5);
            ++i4;
        }
        int i5 = 1;
        while (i5 < xIntervalArray.length) {
            g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[i5] * xScalingFactor), this.getHeight() / 2 - 5, this.getWidth() / 2 - (int)Math.round(xIntervalArray[i5] * xScalingFactor), this.getHeight() / 2 + 5);
            ++i5;
        }
        g2D.setStroke(new BasicStroke(1.2f));
        g2D.setColor(Constant.dark_blue_1);
        g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 + (int)Math.round(xIntervalArray[5] * yScalingFactor), this.getWidth() / 2 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 - (int)Math.round(xIntervalArray[5] * yScalingFactor));
        g2D.setStroke(new BasicStroke(0.7f));
        g2D.setColor(Color.gray);
        int i6 = 1;
        while (i6 < yIntervalArray.length) {
            g2D.drawLine(0, this.getHeight() / 2 + (int)Math.round(yIntervalArray[i6] * yScalingFactor), this.getWidth(), this.getHeight() / 2 + (int)Math.round(yIntervalArray[i6] * yScalingFactor));
            ++i6;
        }
        int i7 = 1;
        while (i7 < yIntervalArray.length) {
            g2D.drawLine(0, this.getHeight() / 2 - (int)Math.round(yIntervalArray[i7] * yScalingFactor), this.getWidth(), this.getHeight() / 2 - (int)Math.round(yIntervalArray[i7] * yScalingFactor));
            ++i7;
        }
        g2D.setStroke(new BasicStroke(1.2f));
        g2D.setColor(Color.black);
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(2);
        int i8 = 1;
        while (i8 < xIntervalArray.length) {
            g2D.drawString(nf.format(xIntervalArray[i8]), (int)Math.round(xIntervalArray[i8] * xScalingFactor) + this.getWidth() / 2 - 10, this.getHeight() / 2 + 20);
            ++i8;
        }
        int i9 = 1;
        while (i9 < xIntervalArray.length) {
            g2D.drawString("-" + nf.format(xIntervalArray[i9]), this.getWidth() / 2 - (int)Math.round(xIntervalArray[i9] * xScalingFactor) - 10, this.getHeight() / 2 + 20);
            ++i9;
        }
        int i10 = 1;
        while (i10 < yIntervalArray.length) {
            g2D.drawString(" " + nf.format(yIntervalArray[i10]), this.getWidth() / 2 - 37, this.getHeight() / 2 - (int)Math.round(yIntervalArray[i10] * yScalingFactor) - 5);
            ++i10;
        }
        int i11 = 1;
        while (i11 < yIntervalArray.length) {
            g2D.drawString("-" + nf.format(yIntervalArray[i11]), this.getWidth() / 2 - 37, this.getHeight() / 2 + (int)Math.round(yIntervalArray[i11] * yScalingFactor) - 5);
            ++i11;
        }
        int deltaOffset = (int)Math.round(this.delta * yScalingFactor);
        BasicStroke dashed = new BasicStroke(1.2f, 0, 0, 10.0f, dash1, 0.0f);
        g2D.setColor(Constant.dark_blue_1);
        g2D.setStroke(dashed);
        g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 + (int)Math.round(xIntervalArray[5] * yScalingFactor) - deltaOffset, this.getWidth() / 2 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 - (int)Math.round(xIntervalArray[5] * yScalingFactor) - deltaOffset);
        g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 + (int)Math.round(xIntervalArray[5] * yScalingFactor) + deltaOffset, this.getWidth() / 2 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 - (int)Math.round(xIntervalArray[5] * yScalingFactor) + deltaOffset);
        g2D.setStroke(new BasicStroke(1.2f));
        boolean posSigEncountered = false;
        boolean negSigEncountered = false;
        int lowestPosSigIndex = 0;
        int highestNegSigIndex = 0;
        int i12 = 0;
        while (i12 < this.xArray.length) {
            if (this.xArray[i12] > 0.0 && this.yArray[i12] - this.xArray[i12] > this.delta) {
                lowestPosSigIndex = i12;
                posSigEncountered = true;
                break;
            }
            ++i12;
        }
        int i13 = 0;
        while (i13 < this.xArray.length) {
            if (this.xArray[i13] < 0.0 && this.xArray[i13] - this.yArray[i13] > this.delta) {
                highestNegSigIndex = i13;
                negSigEncountered = true;
            }
            ++i13;
        }
        Color[] pointColor = new Color[this.xArray.length];
        if (posSigEncountered && negSigEncountered) {
            i2 = 0;
            while (i2 < highestNegSigIndex + 1) {
                pointColor[i2] = Color.green.darker();
                ++i2;
            }
            i = highestNegSigIndex + 1;
            while (i < lowestPosSigIndex) {
                pointColor[i] = Color.black;
                ++i;
            }
            int i14 = lowestPosSigIndex;
            while (i14 < this.xArray.length) {
                pointColor[i14] = Color.red;
                ++i14;
            }
        } else if (posSigEncountered && !negSigEncountered) {
            i2 = 0;
            while (i2 < lowestPosSigIndex) {
                pointColor[i2] = Color.black;
                ++i2;
            }
            i = lowestPosSigIndex;
            while (i < this.xArray.length) {
                pointColor[i] = Color.red;
                ++i;
            }
        } else if (!posSigEncountered && negSigEncountered) {
            i2 = 0;
            while (i2 < highestNegSigIndex + 1) {
                pointColor[i2] = Color.green.darker();
                ++i2;
            }
            i = highestNegSigIndex + 1;
            while (i < this.xArray.length) {
                pointColor[i] = Color.black;
                ++i;
            }
        } else if (!posSigEncountered && !negSigEncountered) {
            i2 = 0;
            while (i2 < this.xArray.length) {
                pointColor[i2] = Color.black;
                ++i2;
            }
        }
        i2 = 0;
        while (i2 < this.xArray.length) {
            g2D.setColor(pointColor[i2]);
            this.drawPoint(g2D, this.xArray[i2], this.yArray[i2], this.getXScalingFactor(origMaxXValue, origMinXValue), this.getYScalingFactor(origMaxYValue, origMinYValue), 3);
            g2D.setColor(Color.black);
            ++i2;
        }
        g2D.drawString("X axis = Expected, Y axis = Observed", this.getWidth() / 2 + 25, this.getHeight() - 25);
    }

    private void drawPoint(Graphics2D g2D, double xValue, double yValue, double xScale, double yScale, int diameter) {
        int xRaw = (int)Math.round(xValue * xScale);
        int yRaw = (int)Math.round(yValue * yScale);
        int xCoord = 0;
        int yCoord = 0;
        xCoord = (int)Math.round((double)(this.getWidth() / 2)) + xRaw;
        yCoord = (int)Math.round((double)(this.getHeight() / 2)) - yRaw;
        g2D.fillOval(xCoord, yCoord, diameter, diameter);
    }

    private double getMax(double[] array) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < array.length) {
            if (max < array[i]) {
                max = array[i];
            }
            ++i;
        }
        return max;
    }

    private double getMin(double[] array) {
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < array.length) {
            if (min > array[i]) {
                min = array[i];
            }
            ++i;
        }
        return min;
    }

    private double getXScalingFactor(double maxValue, double minValue) {
        double largest = 1.0;
        if (maxValue > 0.0 && minValue > 0.0) {
            largest = maxValue;
        } else if (maxValue > 0.0 && minValue < 0.0) {
            largest = maxValue > Math.abs(minValue) ? maxValue : Math.abs(minValue);
        } else if (maxValue <= 0.0) {
            largest = Math.abs(minValue);
        } else if (minValue == 0.0) {
            largest = maxValue;
        }
        double scalingFactor = 0.0;
        scalingFactor = (double)(this.getWidth() / 2 - 50) / largest;
        return scalingFactor;
    }

    private double getYScalingFactor(double maxValue, double minValue) {
        double largest = 1.0;
        if (maxValue > 0.0 && minValue > 0.0) {
            largest = maxValue;
        } else if (maxValue > 0.0 && minValue < 0.0) {
            largest = maxValue > Math.abs(minValue) ? maxValue : Math.abs(minValue);
        } else if (maxValue <= 0.0) {
            largest = Math.abs(minValue);
        } else if (minValue == 0.0) {
            largest = maxValue;
        }
        double scalingFactor = 0.0;
        scalingFactor = (double)(this.getHeight() / 2 - 50) / largest;
        return scalingFactor;
    }

    private void clear() {
        this.removeAll();
        this.repaint();
    }

    public void printImage() {
        PrintUtilities.printComponent(this.canvas);
    }

    public void saveImage() {
        block8: {
            BufferedImage image;
            File imageFile;
            JFileChooser chooser;
            block11: {
                block10: {
                    block9: {
                        chooser = new JFileChooser(System.getProperty("user.dir"));
                        chooser.setCurrentDirectory(new File(chooser.getCurrentDirectory().getParentFile(), "Data"));
                        chooser.addChoosableFileFilter(new FileFilter(){

                            public boolean accept(File f) {
                                String extension = "";
                                if (f.isDirectory()) {
                                    return true;
                                }
                                int i = f.getName().lastIndexOf(46);
                                if (i > 0) {
                                    extension = f.getName().substring(i + 1).toLowerCase();
                                }
                                return extension.equals("bmp");
                            }

                            public String getDescription() {
                                return "Bitmap Files (*.bmp)";
                            }
                        });
                        chooser.addChoosableFileFilter(new FileFilter(){

                            public boolean accept(File f) {
                                String extension = "";
                                if (f.isDirectory()) {
                                    return true;
                                }
                                int i = f.getName().lastIndexOf(46);
                                if (i > 0) {
                                    extension = f.getName().substring(i + 1).toLowerCase();
                                }
                                return extension.equals("jpg") || extension.equals("jpeg");
                            }

                            public String getDescription() {
                                return "JPEG Files (*.jpg; *.jpeg)";
                            }
                        });
                        chooser.addChoosableFileFilter(new FileFilter(){

                            public boolean accept(File f) {
                                String extension = "";
                                if (f.isDirectory()) {
                                    return true;
                                }
                                int i = f.getName().lastIndexOf(46);
                                if (i > 0) {
                                    extension = f.getName().substring(i + 1).toLowerCase();
                                }
                                return extension.equals("png");
                            }

                            public String getDescription() {
                                return "PNG Files (*.png)";
                            }
                        });
                        chooser.addChoosableFileFilter(new FileFilter(){

                            public boolean accept(File f) {
                                String extension = "";
                                if (f.isDirectory()) {
                                    return true;
                                }
                                int i = f.getName().lastIndexOf(46);
                                if (i > 0) {
                                    extension = f.getName().substring(i + 1).toLowerCase();
                                }
                                return extension.equals("tif") || extension.equals("tiff");
                            }

                            public String getDescription() {
                                return "TIFF Files (*.tif; *.tiff)";
                            }
                        });
                        int chooserState = chooser.showSaveDialog(this.getFrame());
                        if (chooserState != 0) break block8;
                        imageFile = chooser.getSelectedFile();
                        image = new BufferedImage(this.canvas.getWidth(), this.canvas.getHeight(), 5);
                        Graphics2D g = image.createGraphics();
                        g.setColor(Color.white);
                        g.fillRect(0, 0, image.getWidth(), image.getHeight());
                        this.paint(g);
                        if (chooser.getFileFilter().getDescription() != "Bitmap Files (*.bmp)") break block9;
                        try {
                            Thread thread = new Thread(){

                                public void run() {
                                    RenderedOp renderedOp = JAI.create((String)"filestore", (RenderedImage)image, (Object)(imageFile.getPath() + ".bmp"), (Object)"BMP");
                                }
                            };
                            thread.setPriority(1);
                            thread.start();
                        }
                        catch (Exception e) {
                            System.out.println(e);
                        }
                        break block8;
                    }
                    if (chooser.getFileFilter().getDescription() != "JPEG Files (*.jpg; *.jpeg)") break block10;
                    try {
                        Thread thread = new Thread(){

                            public void run() {
                                JPEGEncodeParam encoder = new JPEGEncodeParam();
                                encoder.setQuality(1.0f);
                                RenderedOp renderedOp = JAI.create((String)"filestore", (RenderedImage)image, (Object)(imageFile.getPath() + ".jpg"), (Object)"JPEG", (Object)encoder);
                            }
                        };
                        thread.setPriority(1);
                        thread.start();
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                    break block8;
                }
                if (chooser.getFileFilter().getDescription() != "PNG Files (*.png)") break block11;
                try {
                    Thread thread = new Thread(){

                        public void run() {
                            RenderedOp renderedOp = JAI.create((String)"filestore", (RenderedImage)image, (Object)(imageFile.getPath() + ".png"), (Object)"PNG");
                        }
                    };
                    thread.setPriority(1);
                    thread.start();
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                break block8;
            }
            if (chooser.getFileFilter().getDescription() != "TIFF Files (*.tif; *.tiff)") break block8;
            try {
                Thread thread = new Thread(){

                    public void run() {
                        TIFFEncodeParam encoder = new TIFFEncodeParam();
                        encoder.setCompression(1);
                        RenderedOp renderedOp = JAI.create((String)"filestore", (RenderedImage)image, (Object)(imageFile.getPath() + ".tif"), (Object)"TIFF", (Object)encoder);
                    }
                };
                thread.setPriority(1);
                thread.start();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public BufferedImage ggetImage() {
        this.image = new BufferedImage(800, 600, 5);
        Graphics2D g = this.image.createGraphics();
        g.setColor(Color.white);
        this.canvas.setSize(this.image.getWidth(), this.image.getHeight());
        g.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        this.paint(g);
        return this.image;
    }

    private class EventListener
    implements ActionListener,
    KeyListener,
    MouseListener,
    MouseMotionListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == SAMGraphViewer.this.clearButton) {
                SAMGraphViewer.this.clear();
            } else if (event.getSource() == SAMGraphViewer.this.saveButton) {
                SAMGraphViewer.this.saveImage();
            } else if (event.getSource() == SAMGraphViewer.this.printButton) {
                SAMGraphViewer.this.printImage();
            }
        }

        public void keyPressed(KeyEvent event) {
        }

        public void keyReleased(KeyEvent event) {
        }

        public void keyTyped(KeyEvent event) {
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseDragged(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
            SAMGraphViewer.this.setXOldEvent(-1);
            SAMGraphViewer.this.setYOldEvent(-1);
            SAMGraphViewer.this.repaint();
        }

        public void mouseMoved(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            SAMGraphViewer.this.setXOldEvent(x);
            SAMGraphViewer.this.setYOldEvent(y);
            SAMGraphViewer.this.repaint();
        }

        public void mousePressed(MouseEvent event) {
        }

        public void mouseReleased(MouseEvent event) {
        }
    }
}

