/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class Viewer
extends JPanel
implements Serializable,
Printable {
    protected JFrame frame;
    protected Vector palette;
    protected int xOldEvent;
    protected int yOldEvent;
    public boolean mouseInside = false;

    public Viewer(JFrame frame) {
        this.frame = frame;
    }

    public Viewer() {
    }

    public int print(Graphics g, PageFormat format, int pagenum) {
        return 0;
    }

    public void setVisible(boolean state) {
        super.setVisible(state);
        if (this.frame != null) {
            this.frame.setVisible(state);
        }
    }

    public boolean hasFrame() {
        return this.frame != null;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setCursor(int cursor) {
        this.setCursor(Cursor.getPredefinedCursor(cursor));
    }

    public void setXOldEvent(int xEvent) {
        this.xOldEvent = xEvent;
    }

    public int getXOldEvent() {
        return this.xOldEvent;
    }

    public void setYOldEvent(int yEvent) {
        this.yOldEvent = yEvent;
    }

    public int getYOldEvent() {
        return this.yOldEvent;
    }

    public Vector buildPalette() {
        this.palette = new Vector(256);
        Color newColor = new Color(0, 0, 0);
        this.palette.addElement(newColor);
        int i = 1;
        while (i < 256) {
            i = 255 - i;
            double r = 0.0;
            double g = 0.0;
            double b = 0.0;
            if (i < 33) {
                r = 255.0;
            } else if (i > 32 && i < 108) {
                r = Math.abs(255.0 * Math.cos((double)(i - 32) * Math.PI / 151.0));
            } else if (i > 107) {
                r = 0.0;
            }
            if (i < 5) {
                g = 0.0;
            } else if (i > 4 && i < 101) {
                g = Math.abs(255.0 * Math.cos((double)(i - 100) * Math.PI / 189.0));
            } else if (i > 100 && i < 229) {
                g = Math.abs(255.0 * Math.cos((double)(i - 100) * Math.PI / 294.0));
            } else if (i > 230) {
                g = 0.0;
            }
            if (i < 72) {
                b = 0.0;
            } else if (i > 71 && i < 200) {
                b = Math.abs(255.0 * Math.cos((double)(i - 199) * Math.PI / 256.0));
            } else if (i > 199) {
                b = Math.abs(255.0 * Math.cos((double)(i - 199) * Math.PI / 175.0));
            }
            newColor = new Color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
            this.palette.addElement(newColor);
            i = 255 - i;
            ++i;
        }
        return this.palette;
    }
}

