/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.graph.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.tigr.midas.graph.GraphConstant;
import org.tigr.midas.graph.GraphLine;
import org.tigr.midas.graph.GraphPoint;
import org.tigr.midas.graph.GraphTick;
import org.tigr.midas.graph.GraphViewer;
import org.tigr.midas.graph.plot.Plot;
import org.tigr.midas.graph.plot.PlotData;
import org.tigr.midas.graph.plot.PlotFileParser;
import org.tigr.midas.math.QSort;

public class HistogramPlot
extends Plot {
    private GraphViewer graph;
    protected Image image;
    private PlotFileParser plotFileParser;
    private float xMin;
    private float xMax;
    private int bins;
    private float xStep;
    private int yStep;
    private float[] zScores;
    private int[] binCounts;
    private ArrayList binCountsList;
    private int dataCounts;
    private GraphPoint gp;
    private GraphLine gl;
    private GraphTick gt;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HistogramPlot(String fileName) {
        int[] c = new int[]{0};
        PlotData plotData = new PlotData(1);
        plotData.setTitle("Z-score Histogram");
        plotData.setXLabel("Z-Scores");
        plotData.setYLabel("Frequency");
        this.binCountsList = new ArrayList(plotData.fNumber);
        try {
            this.plotFileParser = new PlotFileParser(fileName);
            plotData.setXBound(this.plotFileParser.getColArrays(c)[0]);
            this.xMin = plotData.getXMin();
            this.xMax = plotData.getXMax();
            this.dataCounts = this.plotFileParser.getDataCount();
            QSort qSort = new QSort(this.plotFileParser.getColArrays(c)[0]);
            float[] sortedZ = qSort.getSorted();
            this.xStep = 0.05f;
            this.bins = new Float(Math.ceil((this.xMax - this.xMin) / this.xStep)).intValue() + 1;
            this.binCounts = new int[this.bins];
            float left = this.xMin;
            float right = this.xMin + this.xStep;
            int binNdx = 0;
            int ndx = 0;
            while (true) {
                if (ndx >= sortedZ.length) {
                    plotData.setYBound(this.binCounts);
                    break;
                }
                while (sortedZ[ndx] >= left) {
                    if (sortedZ[ndx] < right) {
                        int n = binNdx;
                        this.binCounts[n] = this.binCounts[n] + 1;
                        break;
                    }
                    if (sortedZ[ndx] == this.xMax && binNdx == this.bins - 1) {
                        int n = binNdx;
                        this.binCounts[n] = this.binCounts[n] + 1;
                        break;
                    }
                    ++binNdx;
                    left = right;
                    right += this.xStep;
                }
                ++ndx;
            }
        }
        catch (FileNotFoundException nfex) {
            nfex.printStackTrace();
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.binCountsList.add(this.binCounts);
        this.createPlot(plotData);
        super.setGraph(this.graph);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HistogramPlot(Vector plotFilesVec) {
        int[] c = new int[]{0};
        PlotData plotData = new PlotData(plotFilesVec.size());
        plotData.setTitle("Z-score Histogram");
        plotData.setXLabel("Z-Scores");
        plotData.setYLabel("Frequency");
        this.binCountsList = new ArrayList(plotData.fNumber);
        int ndx = 0;
        while (ndx < plotFilesVec.size()) {
            String fileName = (String)plotFilesVec.elementAt(ndx);
            try {
                this.plotFileParser = new PlotFileParser(fileName);
                plotData.setXBound(this.plotFileParser.getColArrays(c)[0]);
                this.xMin = plotData.getXMin();
                this.xMax = plotData.getXMax();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++ndx;
        }
        int ndx2 = 0;
        while (ndx2 < plotFilesVec.size()) {
            String fileName = (String)plotFilesVec.elementAt(ndx2);
            try {
                this.plotFileParser = new PlotFileParser(fileName);
                this.dataCounts = this.plotFileParser.getDataCount();
                QSort qSort = new QSort(this.plotFileParser.getColArrays(c)[0]);
                float[] sortedZ = qSort.getSorted();
                this.xStep = 0.05f;
                this.bins = new Float(Math.ceil((this.xMax - this.xMin) / this.xStep)).intValue() + 1;
                this.binCounts = new int[this.bins];
                float left = this.xMin;
                float right = this.xMin + this.xStep;
                int binNdx = 0;
                int i = 0;
                while (true) {
                    if (i >= sortedZ.length) {
                        plotData.setYBound(this.binCounts);
                        break;
                    }
                    while (sortedZ[i] >= left) {
                        if (sortedZ[i] < right) {
                            int n = binNdx;
                            this.binCounts[n] = this.binCounts[n] + 1;
                            break;
                        }
                        if (sortedZ[i] == this.xMax && binNdx == this.bins - 1) {
                            int n = binNdx;
                            this.binCounts[n] = this.binCounts[n] + 1;
                            break;
                        }
                        ++binNdx;
                        left = right;
                        right += this.xStep;
                    }
                    ++i;
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.binCountsList.add(this.binCounts);
            ++ndx2;
        }
        this.createPlot(plotData);
        super.setGraph(this.graph);
    }

    protected void createPlot(PlotData plotData) {
        try {
            int xLo = new Double(Math.ceil(plotData.getXMin())).intValue() - 1;
            int xHi = new Double(Math.ceil(plotData.getXMax())).intValue();
            int yLo = 0;
            int yHi = plotData.getYMaxI() / 10 * 10;
            this.yStep = plotData.getYMaxI() / 10;
            boolean[] initShown = new boolean[plotData.fNumber];
            Color[] initColors = new Color[plotData.fNumber];
            int i = 0;
            while (i < initShown.length) {
                initColors[i] = GraphConstant.COLORARRAY[i];
                initShown[i] = !initShown[i];
                ++i;
            }
            this.graph = new GraphViewer(0, 750, 0, 500, xLo, xHi, this.xStep, yLo, yHi, this.yStep, 55, 30, 40, 60, plotData.title, plotData.xLabel, plotData.yLabel, initColors, initShown);
            int i2 = xLo;
            while (i2 <= xHi) {
                this.gl = new GraphLine(i2, yLo, i2, yHi, this.netColor);
                this.graph.addGraphElement(this.gl);
                ++i2;
            }
            float i3 = yLo;
            while (i3 <= (float)yHi) {
                this.gl = new GraphLine(xLo, i3, xHi, i3, this.netColor);
                this.graph.addGraphElement(this.gl);
                i3 += (float)this.yStep;
            }
            int i4 = xLo;
            while (i4 <= xHi) {
                this.gt = new GraphTick(i4, 8, Color.black, 0, 0, "" + i4, Color.black);
                this.graph.addGraphElement(this.gt);
                ++i4;
            }
            int i5 = yLo;
            while (i5 <= yHi) {
                this.gt = i5 == 0 ? new GraphTick(i5, 8, Color.black, 1, 0, "0", Color.black) : new GraphTick(i5, 8, Color.black, 1, 0, "" + i5, Color.black);
                this.graph.addGraphElement(this.gt);
                i5 += this.yStep;
            }
            int ndx = 0;
            while (ndx < plotData.fNumber) {
                int[] theBinCounts = (int[])this.binCountsList.get(ndx);
                if (initShown[ndx]) {
                    int i6 = 0;
                    while (i6 < this.bins) {
                        this.gl = new GraphLine(this.xMin + (float)i6 * this.xStep, 0.0, this.xMin + (float)i6 * this.xStep, new Double(theBinCounts[i6]).floatValue(), initColors[ndx]);
                        this.gl.setBelong(ndx);
                        this.graph.addGraphElement(this.gl);
                        ++i6;
                    }
                }
                ++ndx;
            }
            this.graph.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        HistogramPlot p = new HistogramPlot("C:\\2.19Test\\MBL2\\one_class_sam\\NFE005d0001_sam.his");
        JFrame frame = new JFrame("HistogramPlot Test");
        frame.getContentPane().add(new JButton(new ImageIcon(p.getImage())));
        frame.setSize(new Dimension(800, 600));
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}

