/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.graph.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JFrame;
import org.tigr.midas.graph.GraphConstant;
import org.tigr.midas.graph.GraphLine;
import org.tigr.midas.graph.GraphPoint;
import org.tigr.midas.graph.GraphTick;
import org.tigr.midas.graph.GraphViewer;
import org.tigr.midas.graph.plot.Plot;
import org.tigr.midas.graph.plot.PlotData;
import org.tigr.midas.graph.plot.PlotFileParser;
import org.tigr.midas.math.MathTools;

public class IntensityPlot
extends Plot {
    private GraphViewer graph;
    protected Image image;
    private PlotFileParser plotFileParser;
    private int dataCounts;
    private GraphPoint gp;
    private GraphLine gl;
    private GraphTick gt;

    public IntensityPlot(String fileName) {
        int[] c = new int[]{0, 1};
        PlotData plotData = new PlotData(1);
        plotData.setTitle("ChannelB Intensity vs. ChannelA Intensity");
        plotData.setXLabel("I(A)");
        plotData.setYLabel("I(B)");
        try {
            this.plotFileParser = new PlotFileParser(fileName);
            this.dataCounts = this.plotFileParser.getDataCount();
            plotData.addXData(this.plotFileParser.getColArrays(c)[0]);
            plotData.addYData(this.plotFileParser.getColArrays(c)[1]);
            plotData.setXBound(this.plotFileParser.getColArrays(c)[0]);
            plotData.setYBound(this.plotFileParser.getColArrays(c)[1]);
            this.createPlot(plotData);
            super.setGraph(this.graph);
        }
        catch (FileNotFoundException nfex) {
            nfex.printStackTrace();
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public IntensityPlot(Vector plotFilesVec) {
        int[] c = new int[]{0, 1};
        PlotData plotData = new PlotData(plotFilesVec.size());
        plotData.setTitle("ChannelB Intensity vs. ChannelA Intensity");
        plotData.setXLabel("I(A)");
        plotData.setYLabel("I(B)");
        int ndx = 0;
        while (ndx < plotFilesVec.size()) {
            String fileName = (String)plotFilesVec.elementAt(ndx);
            try {
                this.plotFileParser = new PlotFileParser(fileName);
                this.dataCounts = this.plotFileParser.getDataCount();
                plotData.addXData(this.plotFileParser.getColArrays(c)[0]);
                plotData.addYData(this.plotFileParser.getColArrays(c)[1]);
                plotData.setXBound(this.plotFileParser.getColArrays(c)[0]);
                plotData.setYBound(this.plotFileParser.getColArrays(c)[1]);
            }
            catch (FileNotFoundException nfex) {
                nfex.printStackTrace();
            }
            catch (NumberFormatException nex) {
                nex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++ndx;
        }
        this.createPlot(plotData);
        super.setGraph(this.graph);
    }

    protected void createPlot(PlotData plotData) {
        boolean[] initShown = new boolean[plotData.fNumber];
        Color[] initColors = new Color[plotData.fNumber];
        int i = 0;
        while (i < initShown.length) {
            initColors[i] = GraphConstant.COLORARRAY[i];
            initShown[i] = !initShown[i];
            ++i;
        }
        float xMin = plotData.getXMin();
        float xMax = plotData.getXMax();
        float xLo = MathTools.roundUpToPlace(xMin, 0);
        float xHi = MathTools.roundUpToPlace(xMax, 0);
        float xGap = xHi - xLo;
        float xStep = MathTools.roundUpToPlace(new Float(xGap).intValue() / 10, -3);
        xHi += xStep;
        float yMin = plotData.getYMin();
        float yMax = plotData.getYMax();
        float yLo = MathTools.roundUpToPlace(yMin, 0);
        float yHi = MathTools.roundUpToPlace(yMax, 0);
        float yGap = yHi - yLo;
        float yStep = MathTools.roundUpToPlace(new Float(yGap).intValue() / 10, -3);
        this.graph = new GraphViewer(0, 750, 0, 500, xLo, xHi, xStep, yLo, yHi += yStep, yStep, 55, 30, 40, 60, plotData.title, plotData.xLabel, plotData.yLabel, initColors, initShown);
        float i2 = xLo;
        while (i2 <= xHi) {
            this.gl = new GraphLine(i2, yLo, i2, yHi, this.netColor);
            this.graph.addGraphElement(this.gl);
            i2 += xStep;
        }
        this.gl = new GraphLine(xHi, yLo, xHi, yHi, this.netColor);
        this.graph.addGraphElement(this.gl);
        float i3 = yLo;
        while (i3 <= yHi) {
            this.gl = new GraphLine(xLo, i3, xHi, i3, this.netColor);
            this.graph.addGraphElement(this.gl);
            i3 += yStep;
        }
        this.gl = new GraphLine(xLo, yHi, xHi, yHi, this.netColor);
        this.graph.addGraphElement(this.gl);
        float i4 = yLo;
        while (i4 <= yHi) {
            if (i4 == 0.0f) {
                this.gt = new GraphTick(i4, 8, Color.black, 1, 0, "" + i4, Color.black);
            } else {
                String yStepStr = new DecimalFormat("0.0E0").format(i4);
                this.gt = new GraphTick(i4, 8, Color.black, 1, 0, "" + yStepStr, Color.black);
            }
            this.graph.addGraphElement(this.gt);
            i4 += yStep;
        }
        float i5 = xLo;
        while (i5 <= xHi) {
            if (i5 == 0.0f) {
                this.gt = new GraphTick(i5, 8, Color.black, 0, 0, "" + i5, Color.black);
            } else {
                String xStepStr = new DecimalFormat("0.0E0").format(i5);
                this.gt = new GraphTick(i5, 8, Color.black, 0, 0, "" + xStepStr, Color.black);
            }
            this.graph.addGraphElement(this.gt);
            i5 += xStep;
        }
        int ndx = 0;
        while (ndx < plotData.fNumber) {
            if (initShown[ndx]) {
                float[] x = (float[])plotData.xList.get(ndx);
                float[] y = (float[])plotData.yList.get(ndx);
                int i6 = 0;
                while (i6 < x.length) {
                    this.gp = new GraphPoint(x[i6], y[i6], initColors[ndx], 3);
                    this.gp.setBelong(ndx);
                    this.graph.addGraphElement(this.gp);
                    ++i6;
                }
            }
            ++ndx;
        }
        this.plotFacts = this.plotFacts + "- Total data points:  " + this.dataCounts + "\r";
        this.plotFacts = this.plotFacts + "- I(A) minimum: " + plotData.getXMin() + "\r";
        this.plotFacts = this.plotFacts + "- I(A) maximum: " + plotData.getXMax() + "\r";
        this.plotFacts = this.plotFacts + "- I(B) minimum: " + plotData.getYMin() + "\r";
        this.plotFacts = this.plotFacts + "- I(B) maximum: " + plotData.getYMax();
        this.graph.setVisible(true);
    }

    public static void main(String[] args) {
        Vector<String> v = new Vector<String>();
        v.addElement("C:\\2.19Test\\CGHTest5\\raw\\CGH_FCy5_MCy3_12863867_MeV_raw.ity");
        v.addElement("C:\\2.19Test\\CGHTest5\\raw\\CGH_MCy5_FCy3_12857609_MeV_raw.ity");
        IntensityPlot p = new IntensityPlot(v);
        JFrame frame = new JFrame("IntensityPlot Test");
        frame.getContentPane().add(p.getGraph());
        frame.setSize(new Dimension(800, 600));
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}

