/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.graph.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.tigr.midas.graph.GraphConstant;
import org.tigr.midas.graph.GraphLine;
import org.tigr.midas.graph.GraphPoint;
import org.tigr.midas.graph.GraphTick;
import org.tigr.midas.graph.GraphViewer;
import org.tigr.midas.graph.plot.Plot;
import org.tigr.midas.graph.plot.PlotData;
import org.tigr.midas.graph.plot.PlotFileParser;

public class RIPlot
extends Plot {
    private GraphViewer graph;
    private Image image;
    private PlotFileParser plotFileParser;
    private int dataCounts;
    private GraphPoint gp;
    private GraphLine gl;
    private GraphTick gt;

    public RIPlot(String fileName) {
        int[] c = new int[]{0, 1};
        PlotData plotData = new PlotData(1);
        plotData.setTitle("R-I");
        plotData.setXLabel("log\u2081\u2080[I(A)\u22c5I(B)]");
        plotData.setYLabel("log\u2082[I(B)/I(A)]");
        try {
            this.plotFileParser = new PlotFileParser(fileName);
            this.dataCounts = this.plotFileParser.getDataCount();
            plotData.addXData(this.plotFileParser.getColArrays(c)[0]);
            plotData.addYData(this.plotFileParser.getColArrays(c)[1]);
            plotData.setXBound(this.plotFileParser.getColArrays(c)[0]);
            plotData.setYBound(this.plotFileParser.getColArrays(c)[1]);
            this.createPlot(plotData);
            super.setGraph(this.graph);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public RIPlot(Vector plotFilesVec) {
        int[] c = new int[]{0, 1};
        PlotData plotData = new PlotData(plotFilesVec.size());
        plotData.setTitle("R-I");
        plotData.setXLabel("log\u2081\u2080[I(a)\u22c5I(b)]");
        plotData.setYLabel("log\u2082[I(b)/I(a)]");
        int ndx = 0;
        while (ndx < plotFilesVec.size()) {
            String fileName = (String)plotFilesVec.elementAt(ndx);
            try {
                this.plotFileParser = new PlotFileParser(fileName);
                this.dataCounts = this.plotFileParser.getDataCount();
                plotData.addXData(this.plotFileParser.getColArrays(c)[0]);
                plotData.addYData(this.plotFileParser.getColArrays(c)[1]);
                plotData.setXBound(this.plotFileParser.getColArrays(c)[0]);
                plotData.setYBound(this.plotFileParser.getColArrays(c)[1]);
            }
            catch (FileNotFoundException nfex) {
                nfex.printStackTrace();
            }
            catch (NumberFormatException nex) {
                nex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++ndx;
        }
        this.createPlot(plotData);
        super.setGraph(this.graph);
    }

    protected void createPlot(PlotData plotData) {
        boolean[] initShown = new boolean[plotData.fNumber];
        Color[] initColors = new Color[plotData.fNumber];
        int i = 0;
        while (i < initShown.length) {
            initColors[i] = GraphConstant.COLORARRAY[i];
            initShown[i] = !initShown[i];
            ++i;
        }
        float xMin = plotData.getXMin();
        float xMax = plotData.getXMax();
        float xGap = xMax - xMin;
        float xStep = new Float(xGap).intValue() / 10;
        float yMin = plotData.getYMin();
        float yMax = plotData.getYMax();
        float yLo = new Float(yMin).intValue() - 1;
        float yHi = new Float(yMax).intValue() + 1;
        float yGap = yHi - yLo;
        float yStep = new Float(yGap).intValue() / 10;
        if ((double)xStep <= 0.5) {
            xStep = 0.5f;
        } else if (xStep <= 2.0f) {
            xStep = 1.0f;
        } else if (xStep <= 5.0f) {
            xStep = 2.0f;
        } else if (xStep <= 10.0f) {
            xStep = 5.0f;
        } else if (xStep <= 100.0f) {
            xStep = 10.0f;
        }
        float xLo = new Float(xMin).intValue();
        float xHi = new Float(xMax).intValue() + 1;
        if ((double)yStep <= 0.5) {
            yStep = 0.5f;
        } else if (xStep <= 2.0f) {
            yStep = 1.0f;
        } else if (xStep <= 5.0f) {
            yStep = 2.0f;
        } else if (xStep <= 10.0f) {
            yStep = 5.0f;
        } else if (xStep <= 100.0f) {
            yStep = 10.0f;
        }
        this.graph = new GraphViewer(0, 750, 0, 500, xLo, xHi, xStep, yLo, yHi, yStep, 55, 30, 40, 60, plotData.title, plotData.xLabel, plotData.yLabel, initColors, initShown);
        int ndx = 0;
        while (ndx < plotData.fNumber) {
            if (initShown[ndx]) {
                float[] x = (float[])plotData.xList.get(ndx);
                float[] y = (float[])plotData.yList.get(ndx);
                int i2 = 0;
                while (i2 < x.length) {
                    this.gp = new GraphPoint(x[i2], y[i2], initColors[ndx], 3);
                    this.gp.setBelong(ndx);
                    this.graph.addGraphElement(this.gp);
                    ++i2;
                }
            }
            ++ndx;
        }
        float i3 = xLo;
        while (i3 <= xHi) {
            this.gl = new GraphLine(i3, yLo, i3, yHi, this.netColor);
            this.graph.addGraphElement(this.gl);
            i3 += xStep;
        }
        float i4 = yLo;
        while (i4 <= yHi) {
            this.gl = new GraphLine(xLo, i4, xHi, i4, this.netColor);
            this.graph.addGraphElement(this.gl);
            i4 += yStep;
        }
        float i5 = yLo;
        while (i5 <= yHi) {
            this.gt = i5 == yLo ? new GraphTick(i5, 8, Color.black, 1, 0, "" + i5, Color.black) : new GraphTick(i5, 8, Color.black, 1, 0, "" + i5, Color.black);
            this.graph.addGraphElement(this.gt);
            i5 += yStep;
        }
        float i6 = xLo;
        while (i6 <= xHi) {
            this.gt = i6 == xLo ? new GraphTick(i6, 8, Color.black, 0, 0, "" + i6, Color.black) : new GraphTick(i6, 8, Color.black, 0, 0, "" + i6, Color.black);
            this.graph.addGraphElement(this.gt);
            i6 += xStep;
        }
        this.plotFacts = this.plotFacts + "- Total data points:  " + this.dataCounts + "\r";
        this.plotFacts = this.plotFacts + "- log\u2081\u2080[I(A)\u22c5I(B)] minimum: " + plotData.getXMin() + "\r";
        this.plotFacts = this.plotFacts + "- log\u2081\u2080[I(A)\u22c5I(B)] maximum: " + plotData.getXMax() + "\r";
        this.plotFacts = this.plotFacts + "- log\u2082[I(B)/I(A)] minimum: " + plotData.getYMin() + "\r";
        this.plotFacts = this.plotFacts + "- log\u2082[I(B)/I(A)] maximum: " + plotData.getYMax();
        this.graph.setVisible(true);
    }

    public static void main(String[] args) {
        Vector<String> v = new Vector<String>();
        v.addElement("C:\\2.18Test\\1pair_sa1\\slice_analysis\\Slide12304683-AMHvsAMS_Slide12333263-AMSvsAMH_post.prc");
        RIPlot p = new RIPlot(v);
        JFrame frame = new JFrame("RIPlot Test");
        frame.getContentPane().add(new JButton(new ImageIcon(p.getImage())));
        frame.setSize(new Dimension(850, 650));
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}

