/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.graph.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.util.Vector;
import javax.swing.JFrame;
import org.tigr.midas.graph.GraphConstant;
import org.tigr.midas.graph.GraphLine;
import org.tigr.midas.graph.GraphPoint;
import org.tigr.midas.graph.GraphTick;
import org.tigr.midas.graph.GraphViewer;
import org.tigr.midas.graph.plot.Plot;
import org.tigr.midas.graph.plot.PlotData;
import org.tigr.midas.graph.plot.PlotFileParser;
import org.tigr.midas.math.StatsTools;

public class RatioRatioPlot
extends Plot {
    private GraphViewer graph;
    private Image image;
    private PlotFileParser plotFileParser;
    private Vector cwVec = new Vector();
    private int dataCounts;
    private GraphPoint gp;
    private GraphLine gl;
    private GraphTick gt;

    public RatioRatioPlot(String fileName) {
        int[] c = new int[]{0, 1};
        PlotData plotData = new PlotData(1);
        plotData.setTitle("Flip Dye Diagnostic Plot");
        plotData.setXLabel("log\u2082[I(b)/I(a)] [File 1]");
        plotData.setYLabel("log\u2082[I(a)/I(b)] [File 2]");
        try {
            this.plotFileParser = new PlotFileParser(fileName);
            this.dataCounts = this.plotFileParser.getDataCount();
            plotData.addXData(this.plotFileParser.getColArrays(c)[0]);
            plotData.addYData(this.plotFileParser.getColArrays(c)[1]);
            plotData.setXBound(this.plotFileParser.getColArrays(c)[0]);
            plotData.setYBound(this.plotFileParser.getColArrays(c)[1]);
            this.createPlot(plotData);
            super.setGraph(this.graph);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public RatioRatioPlot(Vector plotFilesVec) {
        int[] c = new int[]{0, 1};
        PlotData plotData = new PlotData(plotFilesVec.size());
        plotData.setTitle("Flip Dye Diagnostic Plot");
        plotData.setXLabel("log\u2082[I(B)/I(A)] [File 1]");
        plotData.setYLabel("log\u2082[I(A)/I(B)] [File 2]");
        int ndx = 0;
        while (ndx < plotFilesVec.size()) {
            String fileName = (String)plotFilesVec.elementAt(ndx);
            try {
                this.plotFileParser = new PlotFileParser(fileName);
                this.dataCounts = this.plotFileParser.getDataCount();
                plotData.addXData(this.plotFileParser.getColArrays(c)[0]);
                plotData.addYData(this.plotFileParser.getColArrays(c)[1]);
                plotData.setXBound(this.plotFileParser.getColArrays(c)[0]);
                plotData.setYBound(this.plotFileParser.getColArrays(c)[1]);
            }
            catch (FileNotFoundException nfex) {
                nfex.printStackTrace();
            }
            catch (NumberFormatException nex) {
                nex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++ndx;
        }
        this.createPlot(plotData);
        super.setGraph(this.graph);
    }

    protected void createPlot(PlotData plotData) {
        boolean[] initShown = new boolean[plotData.fNumber];
        Color[] initColors = new Color[plotData.fNumber];
        int i = 0;
        while (i < initShown.length) {
            initColors[i] = GraphConstant.COLORARRAY[i];
            initShown[i] = !initShown[i];
            ++i;
        }
        float xMin = plotData.getXMin();
        float xMax = plotData.getXMax();
        float xLo = new Float(xMin).intValue() - 1;
        float xHi = new Float(xMax).intValue() + 1;
        float xGap = xHi - xLo;
        float xStep = new Float(xGap).intValue() / 10;
        if ((double)xStep <= 0.5) {
            xStep = 0.5f;
        } else if (xStep <= 2.0f) {
            xStep = 1.0f;
        } else if (xStep <= 5.0f) {
            xStep = 2.0f;
        } else if (xStep <= 10.0f) {
            xStep = 5.0f;
        } else if (xStep <= 100.0f) {
            xStep = 10.0f;
        }
        float yMin = plotData.getYMin();
        float yMax = plotData.getYMax();
        float yLo = new Float(yMin).intValue() - 1;
        float yHi = new Float(yMax).intValue() + 1;
        float yGap = yHi - yLo;
        float yStep = new Float(yGap).intValue() / 10;
        if ((double)yStep <= 0.5) {
            yStep = 0.5f;
        } else if (xStep <= 2.0f) {
            yStep = 1.0f;
        } else if (xStep <= 5.0f) {
            yStep = 2.0f;
        } else if (xStep <= 10.0f) {
            yStep = 5.0f;
        } else if (xStep <= 100.0f) {
            yStep = 10.0f;
        }
        this.graph = new GraphViewer(0, 750, 0, 500, xLo, xHi, xStep, yLo, yHi, yStep, 55, 30, 40, 60, plotData.title, plotData.xLabel, plotData.yLabel, initColors, initShown);
        float i2 = xLo;
        while (i2 <= xHi) {
            this.gl = new GraphLine(i2, yLo, i2, yHi, this.netColor);
            this.graph.addGraphElement(this.gl);
            i2 += xStep;
        }
        this.gl = new GraphLine(xHi, yLo, xHi, yHi, this.netColor);
        this.graph.addGraphElement(this.gl);
        float i3 = yLo;
        while (i3 <= yHi) {
            this.gl = new GraphLine(xLo, i3, xHi, i3, this.netColor);
            this.graph.addGraphElement(this.gl);
            i3 += yStep;
        }
        this.gl = new GraphLine(xLo, yHi, xHi, yHi, this.netColor);
        this.graph.addGraphElement(this.gl);
        float i4 = yLo;
        while (i4 <= yHi) {
            this.gt = i4 == 0.0f ? new GraphTick(i4, 8, Color.black, 1, 0, "0", Color.black) : new GraphTick(i4, 8, Color.black, 1, 0, "" + i4, Color.black);
            this.graph.addGraphElement(this.gt);
            i4 += yStep;
        }
        float i5 = xLo;
        while (i5 <= xHi) {
            this.gt = i5 == 0.0f ? new GraphTick(i5, 8, Color.black, 0, 0, "" + i5, Color.black) : new GraphTick(i5, 8, Color.black, 0, 0, "" + i5, Color.black);
            this.graph.addGraphElement(this.gt);
            i5 += xStep;
        }
        float corrCoeff = 0.0f;
        int ndx = 0;
        while (ndx < plotData.fNumber) {
            if (initShown[ndx]) {
                float[] x = (float[])plotData.xList.get(ndx);
                float[] y = (float[])plotData.yList.get(ndx);
                int i6 = 0;
                while (i6 < x.length) {
                    this.gp = new GraphPoint(x[i6], y[i6], initColors[ndx], 3);
                    this.gp.setBelong(ndx);
                    this.graph.addGraphElement(this.gp);
                    ++i6;
                }
                StatsTools s = new StatsTools();
                s.linearRegression(x, y);
                corrCoeff = s.getCorrelationCoeff();
            }
            ++ndx;
        }
        this.gl = new GraphLine(xMin, 0.0, xMax, 0.0, Color.red);
        this.graph.addGraphElement(this.gl);
        this.gl = new GraphLine(0.0, yMin, 0.0, yMax, Color.red);
        this.graph.addGraphElement(this.gl);
        this.gl = new GraphLine(Math.max(xLo, yLo), Math.max(xLo, yLo), Math.min(xHi, yHi), Math.min(xHi, yHi), this.refColor);
        this.graph.addGraphElement(this.gl);
        this.plotFacts = this.plotFacts + "- Total data points:  " + this.dataCounts + "\r";
        this.plotFacts = this.plotFacts + "- log\u2082[I(B)/I(A)] [File 1] minimum: " + plotData.getXMin() + "\r";
        this.plotFacts = this.plotFacts + "- log\u2082[I(B)/I(A)] [File 1] maximum: " + plotData.getXMax() + "\r";
        this.plotFacts = this.plotFacts + "- log\u2082[I(A)/I(B)] [File 2] minimum: " + plotData.getYMin() + "\r";
        this.plotFacts = this.plotFacts + "- log\u2082[I(A)/I(B)] [File 2] maximum: " + plotData.getYMax() + "\r";
        this.plotFacts = this.plotFacts + "- Correlation Coefficient: " + corrCoeff;
        this.graph.setVisible(true);
    }

    public static void main(String[] args) {
        Vector<String> v = new Vector<String>();
        v.addElement("C:\\2.17Test\\All\\flip_dye\\Slide12304683-AMHvsAMS_Slide12333263-AMSvsAMH_post.rrc");
        RatioRatioPlot p = new RatioRatioPlot(v);
        JFrame frame = new JFrame("R-R Plot Test");
        frame.getContentPane().add(p.getGraph());
        frame.setSize(new Dimension(800, 600));
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}

