/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.mev;

import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import org.tigr.midas.mev.ExpressionFileFilter;
import org.tigr.midas.mev.ExpressionFileView;
import org.tigr.midas.mev.data.Experiment;
import org.tigr.midas.mev.data.IData;

public class ExperimentUtil {
    public static final int INTEGER_TYPE = 10;
    public static final int FLOAT_TYPE = 11;
    public static final int DOUBLE_TYPE = 12;
    public static final int STRING_TYPE = 13;
    public static final int BOOLEAN_TYPE = 14;

    public static void saveExperiment(Frame frame, Experiment experiment, IData data) throws Exception {
        ExperimentUtil.saveExperiment(frame, experiment, data, ExperimentUtil.createDefaultRows(experiment.getNumberOfGenes()));
    }

    public static void saveExperiment(Frame frame, IData data, int[] rows) throws Exception {
        ExperimentUtil.saveExperiment(frame, data.getExperiment(), data, rows);
    }

    public static void saveExperiment(Frame frame, Experiment experiment, IData data, int[] rows) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveCluster(file, experiment, data, rows);
        }
    }

    public static void saveExperiment(Frame frame, Experiment experiment, IData data, int[][] clusters) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            int i = 0;
            while (i < clusters.length) {
                if (clusters[i] != null && clusters[i].length != 0) {
                    File aFile = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                    ExperimentUtil.saveCluster(aFile, experiment, data, clusters[i]);
                }
                ++i;
            }
        }
    }

    public static void saveAllGeneClustersWithAux(Frame frame, Experiment experiment, IData data, int[][] clusters, String[] auxTitles, Object[][] auxData) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            int i = 0;
            while (i < clusters.length) {
                if (clusters[i] != null && clusters[i].length != 0) {
                    File aFile = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                    ExperimentUtil.saveGeneClusterWithAux(aFile, experiment, data, clusters[i], auxTitles, auxData);
                }
                ++i;
            }
        }
    }

    private static void saveGeneClusterWithAux(File file, Experiment experiment, IData data, int[] rows, String[] auxTitles, Object[][] auxData) throws Exception {
        int[] typeArray = ExperimentUtil.getTypes(auxData);
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        if (fieldNames == null) {
            return;
        }
        out.print("Original row");
        out.print("\t");
        int i = 0;
        while (i < fieldNames.length) {
            out.print(fieldNames[i]);
            if (i < fieldNames.length - 1) {
                out.print("\t");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < auxTitles.length) {
            out.print("\t" + auxTitles[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < experiment.getNumberOfSamples()) {
            out.print("\t");
            out.print(data.getFullSampleName(experiment.getSampleIndex(i3)));
            ++i3;
        }
        out.print("\n");
        int i4 = 0;
        while (i4 < rows.length) {
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(rows[i4]) + 1));
            out.print("\t");
            int k = 0;
            while (k < fieldNames.length) {
                out.print(data.getElementAttribute(experiment.getGeneIndexMappedToData(rows[i4]), k));
                if (k < fieldNames.length - 1) {
                    out.print("\t");
                }
                ++k;
            }
            int j = 0;
            while (j < auxData[0].length) {
                out.print("\t");
                ExperimentUtil.printDataType(out, auxData[rows[i4]][j], typeArray[j]);
                ++j;
            }
            int j2 = 0;
            while (j2 < experiment.getNumberOfSamples()) {
                out.print("\t");
                out.print(Float.toString(experiment.get(rows[i4], j2)));
                ++j2;
            }
            out.print("\n");
            ++i4;
        }
        out.flush();
        out.close();
    }

    private static File getFile(Frame frame) {
        File file = null;
        JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
        fc.addChoosableFileFilter(new ExpressionFileFilter());
        fc.setFileView(new ExpressionFileView());
        int ret = fc.showSaveDialog(frame);
        if (ret == 0) {
            file = fc.getSelectedFile();
        }
        return file;
    }

    public static void saveGeneCluster(Frame frame, IData data, int[] rows) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveGeneCluster(file, data, rows);
        }
    }

    private static void saveGeneCluster(File file, IData data, int[] rows) throws Exception {
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        if (fieldNames == null) {
            return;
        }
        out.print("Original row");
        out.print("\t");
        int i = 0;
        while (i < fieldNames.length) {
            out.print(fieldNames[i]);
            if (i < fieldNames.length - 1) {
                out.print("\t");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < data.getFeaturesCount()) {
            out.print("\t");
            out.print(data.getFullSampleName(i2));
            ++i2;
        }
        out.print("\n");
        int i3 = 0;
        while (i3 < rows.length) {
            out.print(Integer.toString(rows[i3] + 1));
            out.print("\t");
            int k = 0;
            while (k < fieldNames.length) {
                out.print(data.getElementAttribute(rows[i3], k));
                if (k < fieldNames.length - 1) {
                    out.print("\t");
                }
                ++k;
            }
            int j = 0;
            while (j < data.getFeaturesCount()) {
                out.print("\t");
                out.print(Float.toString(data.getRatio(j, rows[i3], 1)));
                ++j;
            }
            out.print("\n");
            ++i3;
        }
        out.flush();
        out.close();
    }

    public static void saveGeneClusterWithAux(Frame frame, Experiment experiment, IData data, int[] rows, String[] auxTitles, Object[][] auxData) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveGeneClusterWithAux(file, experiment, data, rows, auxTitles, auxData);
        }
    }

    private static void saveCluster(File file, Experiment experiment, IData data, int[] rows) throws Exception {
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        if (fieldNames == null) {
            return;
        }
        out.print("Original row");
        out.print("\t");
        int i = 0;
        while (i < fieldNames.length) {
            out.print(fieldNames[i]);
            if (i < fieldNames.length - 1) {
                out.print("\t");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < experiment.getNumberOfSamples()) {
            out.print("\t");
            out.print(data.getFullSampleName(experiment.getSampleIndex(i2)));
            ++i2;
        }
        out.print("\n");
        int i3 = 0;
        while (i3 < rows.length) {
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(rows[i3]) + 1));
            out.print("\t");
            int k = 0;
            while (k < fieldNames.length) {
                out.print(data.getElementAttribute(experiment.getGeneIndexMappedToData(rows[i3]), k));
                if (k < fieldNames.length - 1) {
                    out.print("\t");
                }
                ++k;
            }
            int j = 0;
            while (j < experiment.getNumberOfSamples()) {
                out.print("\t");
                out.print(Float.toString(experiment.get(rows[i3], j)));
                ++j;
            }
            out.print("\n");
            ++i3;
        }
        out.flush();
        out.close();
    }

    public static void saveExperimentCluster(Frame frame, Experiment experiment, IData data, int[] rows) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveExperimentCluster(file, experiment, data, rows);
        }
    }

    public static void saveAllExperimentClusters(Frame frame, Experiment experiment, IData data, int[][] clusters) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            int i = 0;
            while (i < clusters.length) {
                if (clusters[i] != null && clusters[i].length != 0) {
                    File aFile = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                    ExperimentUtil.saveExperimentCluster(aFile, experiment, data, clusters[i]);
                }
                ++i;
            }
        }
    }

    public static void saveAllExperimentClustersWithAux(Frame frame, Experiment experiment, IData data, int[][] clusters, String[] auxTitles, Object[][] auxData) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            int i = 0;
            while (i < clusters.length) {
                if (clusters[i] != null && clusters[i].length != 0) {
                    File aFile = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                    ExperimentUtil.saveExperimentClusterWithAux(aFile, experiment, data, clusters[i], auxTitles, auxData);
                }
                ++i;
            }
        }
    }

    public static void saveExperimentClusterWithAux(Frame frame, Experiment experiment, IData data, int[] rows, String[] auxTitles, Object[][] auxData) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveExperimentClusterWithAux(file, experiment, data, rows, auxTitles, auxData);
        }
    }

    private static void saveExperimentClusterWithAux(File file, Experiment experiment, IData data, int[] experiments, String[] auxTitles, Object[][] auxData) throws Exception {
        int[] typeArray = ExperimentUtil.getTypes(auxData);
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        int numberOfGenes = experiment.getNumberOfGenes();
        out.print("Original row");
        out.print("\t");
        int i = 0;
        while (i < fieldNames.length) {
            out.print(fieldNames[i]);
            if (i < fieldNames.length - 1) {
                out.print("\t");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < experiments.length) {
            out.print("\t");
            out.print(data.getFullSampleName(experiment.getSampleIndex(experiments[i2])));
            ++i2;
        }
        out.print("\n");
        int i3 = 0;
        while (i3 < auxTitles.length) {
            out.print(auxTitles[i3] + "\t");
            int k = 0;
            while (k < fieldNames.length) {
                out.print("\t");
                ++k;
            }
            int j = 0;
            while (j < experiments.length) {
                ExperimentUtil.printDataType(out, auxData[experiments[j]][i3], typeArray[i3]);
                if (j < experiments.length - 1) {
                    out.print("\t");
                }
                ++j;
            }
            out.print("\n");
            ++i3;
        }
        int i4 = 0;
        while (i4 < numberOfGenes) {
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(i4) + 1));
            out.print("\t");
            int k = 0;
            while (k < fieldNames.length) {
                out.print(data.getElementAttribute(experiment.getGeneIndexMappedToData(i4), k));
                if (k < fieldNames.length - 1) {
                    out.print("\t");
                }
                ++k;
            }
            int j = 0;
            while (j < experiments.length) {
                out.print("\t");
                out.print(Float.toString(experiment.get(i4, experiment.getSampleIndex(experiments[j]))));
                ++j;
            }
            out.print("\n");
            ++i4;
        }
        out.flush();
        out.close();
    }

    private static void saveExperimentCluster(File file, Experiment experiment, IData data, int[] experiments) throws Exception {
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        int numberOfGenes = experiment.getNumberOfGenes();
        out.print("Original row");
        out.print("\t");
        int i = 0;
        while (i < fieldNames.length) {
            out.print(fieldNames[i]);
            if (i < fieldNames.length - 1) {
                out.print("\t");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < experiments.length) {
            out.print("\t");
            out.print(data.getFullSampleName(experiment.getSampleIndex(experiments[i2])));
            ++i2;
        }
        out.print("\n");
        int i3 = 0;
        while (i3 < numberOfGenes) {
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(i3) + 1));
            out.print("\t");
            int k = 0;
            while (k < fieldNames.length) {
                out.print(data.getElementAttribute(experiment.getGeneIndexMappedToData(i3), k));
                if (k < fieldNames.length - 1) {
                    out.print("\t");
                }
                ++k;
            }
            int j = 0;
            while (j < experiments.length) {
                out.print("\t");
                out.print(Float.toString(experiment.get(i3, experiment.getSampleIndex(experiments[j]))));
                ++j;
            }
            out.print("\n");
            ++i3;
        }
        out.flush();
        out.close();
    }

    private static int[] createDefaultRows(int genes) {
        int[] rows = new int[genes];
        int i = 0;
        while (i < genes) {
            rows[i] = i;
            ++i;
        }
        return rows;
    }

    private static void printDataType(PrintWriter out, Object obj, int dataType) {
        switch (dataType) {
            case 14: {
                out.print((Boolean)obj);
                break;
            }
            case 12: {
                out.print((Double)obj);
                break;
            }
            case 11: {
                out.print(((Float)obj).floatValue());
                break;
            }
            case 10: {
                out.print((Integer)obj);
                break;
            }
            case 13: {
                out.print((String)obj);
                break;
            }
            default: {
                out.print(obj);
            }
        }
    }

    private static int[] getTypes(Object[][] objData) {
        int[] types = new int[objData[0].length];
        int i = 0;
        while (i < types.length) {
            types[i] = ExperimentUtil.getObjectType(objData[0][i]);
            ++i;
        }
        return types;
    }

    private static int getObjectType(Object obj) {
        int obType = -1;
        if (obj instanceof Boolean) {
            return 14;
        }
        if (obj instanceof Double) {
            return 12;
        }
        if (obj instanceof Float) {
            return 11;
        }
        if (obj instanceof Integer) {
            return 10;
        }
        if (obj instanceof String) {
            return 13;
        }
        return obType;
    }
}

