/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.util;

import java.util.Vector;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.IDAssigner;

public class BlockFiller {
    private static int blockNumber;
    private float[][] blockCy3;
    private float[][] blockCy5;
    private int[][] origIndex;
    private int[] blockRowCount;
    private IDAssigner idAssigner;

    public BlockFiller(ColumnWorker fileCW) {
        String[] metaCombo = fileCW.getMetaCombo();
        int totalRowCount = fileCW.getRowCounts();
        float[] cy3Column = fileCW.getColumnOneArray();
        float[] cy5Column = fileCW.getColumnTwoArray();
        this.idAssigner = new IDAssigner();
        Vector metaComboVec = new Vector();
        int[] geneBlockNdx = new int[totalRowCount];
        int row = 0;
        while (row < totalRowCount) {
            this.idAssigner.findUniqueID(metaCombo[row], metaComboVec);
            geneBlockNdx[row] = this.idAssigner.getID();
            ++row;
        }
        System.out.println("    Block meta:        " + this.idAssigner.getKeyBank().toString());
        System.out.println("    Block id:          " + this.idAssigner.getIDVec());
        System.out.println("    Block gene counts: " + this.idAssigner.getIDRepeatCount().toString());
        blockNumber = this.idAssigner.getIDVec().size();
        this.blockCy3 = new float[blockNumber][];
        this.blockCy5 = new float[blockNumber][];
        this.origIndex = new int[blockNumber][];
        this.blockRowCount = new int[blockNumber];
        int i = 0;
        while (i < blockNumber) {
            this.blockCy3[i] = new float[Integer.parseInt(this.idAssigner.getIDRepeatCount().get(i).toString())];
            this.blockCy5[i] = new float[Integer.parseInt(this.idAssigner.getIDRepeatCount().get(i).toString())];
            this.origIndex[i] = new int[Integer.parseInt(this.idAssigner.getIDRepeatCount().get(i).toString())];
            ++i;
        }
        int row2 = 0;
        while (row2 < totalRowCount) {
            this.blockCy3[geneBlockNdx[row2]][this.blockRowCount[geneBlockNdx[row2]]] = cy3Column[row2];
            this.blockCy5[geneBlockNdx[row2]][this.blockRowCount[geneBlockNdx[row2]]] = cy5Column[row2];
            this.origIndex[geneBlockNdx[row2]][this.blockRowCount[geneBlockNdx[row2]]] = row2;
            int n = geneBlockNdx[row2];
            this.blockRowCount[n] = this.blockRowCount[n] + 1;
            ++row2;
        }
    }

    public final float[] getBlockCy3(int blockIndx) {
        int blockSize = Integer.parseInt(this.idAssigner.getIDRepeatCount().get(blockIndx).toString());
        float[] blkCy3 = new float[blockSize];
        System.arraycopy(this.blockCy3[blockIndx], 0, blkCy3, 0, blockSize);
        return blkCy3;
    }

    public final float[] getBlockCy5(int blockIndx) {
        int blockSize = Integer.parseInt(this.idAssigner.getIDRepeatCount().get(blockIndx).toString());
        float[] blkCy5 = new float[blockSize];
        System.arraycopy(this.blockCy5[blockIndx], 0, blkCy5, 0, blockSize);
        return blkCy5;
    }

    public final int[] getOrigIndex(int blockIndx) {
        int blockSize = Integer.parseInt(this.idAssigner.getIDRepeatCount().get(blockIndx).toString());
        int[] origNdx = new int[blockSize];
        System.arraycopy(this.origIndex[blockIndx], 0, origNdx, 0, blockSize);
        return origNdx;
    }

    public final int getBlockSize(int blockIndx) {
        return Integer.parseInt(this.idAssigner.getIDRepeatCount().get(blockIndx).toString());
    }

    public final int getBlockNumber() {
        return blockNumber;
    }
}

