/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public class PrintUtilities
implements Printable {
    private Component componentToBePrinted;

    public static void printComponent(Component c) {
        new PrintUtilities(c).print();
    }

    public PrintUtilities(Component componentToBePrinted) {
        this.componentToBePrinted = componentToBePrinted;
    }

    public void print() {
        block2: {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPrintable(this);
            if (!printJob.printDialog()) break block2;
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        if (pageFormat.getImageableWidth() / (double)this.componentToBePrinted.getWidth() < pageFormat.getImageableHeight() / (double)this.componentToBePrinted.getHeight()) {
            g2.scale(pageFormat.getImageableWidth() / (double)this.componentToBePrinted.getWidth(), pageFormat.getImageableWidth() / (double)this.componentToBePrinted.getWidth());
        } else {
            g2.scale(pageFormat.getImageableHeight() / (double)this.componentToBePrinted.getHeight(), pageFormat.getImageableHeight() / (double)this.componentToBePrinted.getHeight());
        }
        this.componentToBePrinted.paint(g2);
        PrintUtilities.disableDoubleBuffering(this.componentToBePrinted);
        this.componentToBePrinted.paint(g2);
        PrintUtilities.enableDoubleBuffering(this.componentToBePrinted);
        return 0;
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

