/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.util;

import java.util.NoSuchElementException;

public class StringSplitter {
    private String str;
    private char delimiter;
    private int curPosition;
    private int maxPosition;

    public StringSplitter(char delimiter) {
        this.init("", delimiter);
    }

    public StringSplitter(String str, char delimiter) {
        this.init(str, delimiter);
    }

    public void init(String str) {
        this.init(str, this.delimiter);
    }

    private void init(String str, char delimiter) {
        this.str = str;
        this.delimiter = delimiter;
        this.curPosition = 0;
        this.maxPosition = str.length();
    }

    private int scanToken(int startPos) {
        int position = startPos;
        while (position < this.maxPosition) {
            char c = this.str.charAt(position);
            if (c == this.delimiter) break;
            ++position;
        }
        return position;
    }

    public boolean hasMoreTokens() {
        return this.curPosition < this.maxPosition;
    }

    public String nextToken() {
        if (this.curPosition >= this.maxPosition) {
            throw new NoSuchElementException("There are no more tokens!");
        }
        int start = this.curPosition;
        this.curPosition = this.scanToken(this.curPosition);
        String result = this.str.substring(start, this.curPosition);
        ++this.curPosition;
        return result;
    }

    public int countTokens() {
        int count = 0;
        int pos = 0;
        while (pos < this.maxPosition) {
            if (this.str.charAt(pos) == this.delimiter) {
                ++count;
            }
            ++pos;
        }
        return count;
    }

    public final void passTokens(int count) {
        int i = count;
        while (--i >= 0) {
            this.curPosition = this.scanToken(this.curPosition);
            ++this.curPosition;
        }
    }

    public final int nextIntToken() {
        return this.nextIntToken(0);
    }

    public final int nextIntToken(int defValue) {
        String token = this.nextToken();
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public final long nextLongToken() {
        return this.nextLongToken(0L);
    }

    public final long nextLongToken(boolean rounded) {
        return Math.round(this.nextDoubleToken(0.0));
    }

    public final long nextLongToken(long defValue) {
        String token = this.nextToken();
        try {
            return Long.parseLong(token);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public final double nextDoubleToken(double defValue) {
        String token = this.nextToken();
        try {
            return Double.parseDouble(token);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public final float nextFloatToken(float defValue) {
        String token = this.nextToken();
        try {
            return Float.parseFloat(token);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }
}

