/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.util;

import java.io.File;
import java.util.Vector;
import org.tigr.midas.util.mevFileParser.FieldNotFoundException;
import org.tigr.midas.util.mevFileParser.MevFileParser;

public class VecToArray {
    public static float[] toFloat(Vector v) {
        float[] d = new float[v.size()];
        int i = 0;
        while (i < v.size()) {
            try {
                d[i] = Float.parseFloat(v.elementAt(i).toString());
            }
            catch (NumberFormatException ex) {
                System.out.println("******* " + (i + 1) + "th element in the vector is an invalid float number ********");
                ex.printStackTrace();
                break;
            }
            ++i;
        }
        return d;
    }

    public static String[] toString(Vector v) {
        String[] s = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            s[i] = v.elementAt(i).toString();
            ++i;
        }
        return s;
    }

    public static int[] toInt(Vector v) {
        int[] n = new int[v.size()];
        int i = 0;
        while (i < v.size()) {
            try {
                n[i] = Integer.parseInt(v.elementAt(i).toString());
            }
            catch (NumberFormatException ex) {
                System.out.println("******* " + (i + 1) + "th element in the vector is an invalid integer number ********");
                ex.printStackTrace();
                break;
            }
            ++i;
        }
        return n;
    }

    public static void main(String[] args) {
        MevFileParser mfp = new MevFileParser();
        File thisFile = new File("C:\\DataFiles0\\mev\\cortex.mev");
        try {
            if (MevFileParser.validate(thisFile) == 1) {
                mfp.loadFile(thisFile);
                Vector aVec = mfp.getColumnNamed("IA");
                Vector bVec = mfp.getColumnNamed("IB");
                float[] a = VecToArray.toFloat(aVec);
                float[] b = VecToArray.toFloat(bVec);
                System.out.println("**** a.length = " + a.length + ", b.length = " + b.length);
                int i = 0;
                while (i < 20) {
                    System.out.println(" i = " + i + ", a = " + a[i] + ", b = " + b[i]);
                    ++i;
                }
            } else {
                System.out.println("Invalid MEV file!");
            }
        }
        catch (FieldNotFoundException ex) {
            System.out.println("Field not found!");
        }
    }
}

