/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.util.mevFileParser;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.tigr.midas.util.mevFileParser.FieldNotFoundException;

public class MevFileParser {
    public static final int INVALID_FILE = 0;
    public static final int MEV_FILE = 1;
    public static final String UNIQUE_ID_STRING = "UID";
    private Vector columnHeaders;
    private Vector rawLines;
    private IntVector dataLinesMap;
    private Object[] commentLineArray;
    private boolean mevFileLoaded;

    public static File selectFile(Component dialogParent) {
        return MevFileParser.selectFile(new File(System.getProperty("user.dir")), dialogParent);
    }

    public static File selectFile(File defaultDirectory, Component dialogParent) {
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        chooser.setDialogTitle("Select an mev file");
        chooser.setCurrentDirectory(defaultDirectory);
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                String extension = "";
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".mev");
            }

            public String getDescription() {
                return "TIGR MeV Files (*.mev)";
            }
        });
        if (chooser.showOpenDialog(dialogParent) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static int validate(File targetFile) {
        IntVector dataLinesMap = new IntVector();
        Vector<String> rawLines = new Vector<String>();
        Vector<String> columnHeaders = new Vector<String>();
        String currentLine = new String();
        BufferedReader reader = null;
        boolean readHeaders = false;
        boolean valid1 = false;
        boolean valid2 = true;
        boolean valid3 = false;
        boolean valid4 = true;
        try {
            reader = new BufferedReader(new FileReader(targetFile));
            int lineCount = 0;
            while ((currentLine = reader.readLine()) != null) {
                rawLines.add(currentLine);
                if (!currentLine.startsWith("#")) {
                    if (!readHeaders) {
                        readHeaders = true;
                        StringTokenizer st = new StringTokenizer(currentLine, "\t");
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            if (token.equals(UNIQUE_ID_STRING)) {
                                valid1 = true;
                            }
                            int i = 0;
                            while (i < columnHeaders.size()) {
                                String headerValue = (String)columnHeaders.elementAt(i);
                                if (token.equals(headerValue)) {
                                    valid2 = false;
                                    return 0;
                                }
                                ++i;
                            }
                            columnHeaders.add(token);
                        }
                    } else {
                        dataLinesMap.add(lineCount);
                    }
                }
                ++lineCount;
            }
            if (dataLinesMap.size() > 0) {
                valid3 = true;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return 0;
        }
        if (valid1 && valid2 && valid3 && valid4) {
            return 1;
        }
        return 0;
    }

    public void loadFile(File targetFile) {
        this.dataLinesMap = new IntVector();
        this.rawLines = new Vector();
        this.columnHeaders = new Vector();
        Vector<String> commentLineVec = new Vector<String>();
        String currentLine = new String();
        BufferedReader reader = null;
        boolean readHeaders = false;
        try {
            reader = new BufferedReader(new FileReader(targetFile));
            int lineCount = 0;
            while ((currentLine = reader.readLine()) != null) {
                this.rawLines.add(currentLine);
                if (!currentLine.startsWith("#")) {
                    if (!readHeaders) {
                        readHeaders = true;
                        StringTokenizer st = new StringTokenizer(currentLine, "\t");
                        while (st.hasMoreTokens()) {
                            this.columnHeaders.add(st.nextToken());
                        }
                    } else {
                        this.dataLinesMap.add(lineCount);
                    }
                } else {
                    commentLineVec.add(currentLine);
                }
                ++lineCount;
            }
            this.commentLineArray = commentLineVec.toArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.mevFileLoaded = false;
            return;
        }
        this.mevFileLoaded = true;
    }

    public boolean isMevFileLoaded() {
        return this.mevFileLoaded;
    }

    public Vector getColumnHeaders() {
        return this.columnHeaders;
    }

    public Vector getColumnAt(int targetColumn) {
        return this.getColumnAt(targetColumn, false);
    }

    public Vector getColumnAt(int targetColumn, boolean withHeaders) {
        Vector columnVector = new Vector(this.dataLinesMap.size() + (withHeaders ? 1 : 0));
        if (targetColumn >= this.columnHeaders.size() || targetColumn < 0) {
            throw new IndexOutOfBoundsException("Column Index out of bounds.");
        }
        if (withHeaders) {
            columnVector.add(this.columnHeaders.elementAt(targetColumn));
        }
        int i = 0;
        while (i < this.dataLinesMap.size()) {
            StringTokenizer st = new StringTokenizer(this.getElementAtIndex(i), "\t");
            int j = 0;
            while (j < targetColumn) {
                st.nextToken();
                ++j;
            }
            columnVector.add(st.nextToken());
            ++i;
        }
        return columnVector;
    }

    public Vector getColumnNamed(String columnName) throws FieldNotFoundException {
        return this.getColumnNamed(columnName, false);
    }

    public Vector getColumnNamed(String columnName, boolean withHeaders) throws FieldNotFoundException {
        Vector columnHeaders = this.getColumnHeaders();
        if (columnHeaders.contains(columnName)) {
            return this.getColumnAt(columnHeaders.indexOf(columnName), withHeaders);
        }
        throw new FieldNotFoundException("Field " + columnName + " not found.");
    }

    public String getLineAt(int rawTargetLine) {
        return (String)this.rawLines.elementAt(rawTargetLine);
    }

    public String getElementAtIndex(int index) {
        return this.getLineAt(this.dataLinesMap.intElementAt(index));
    }

    public String getElementAtRC(int row, int column) {
        return new String();
    }

    public String getElementById(String id) throws FieldNotFoundException {
        String element = null;
        try {
            element = this.getElementByField(UNIQUE_ID_STRING, id);
            return element;
        }
        catch (FieldNotFoundException fnfe) {
            throw new FieldNotFoundException("Unique Identifier field (UID) not found.");
        }
    }

    public String getElementByField(String fieldName, String value) throws FieldNotFoundException {
        Vector targetColumn = this.getColumnNamed(fieldName);
        if (targetColumn == null) {
            throw new FieldNotFoundException("Field " + fieldName + " not found.");
        }
        int i = 0;
        while (i < targetColumn.size()) {
            if (((String)targetColumn.elementAt(i)).equals(value)) {
                return this.getElementAtIndex(i);
            }
            ++i;
        }
        return null;
    }

    public Vector getElementsByField(String fieldName, String value) throws FieldNotFoundException {
        Vector targetColumn = this.getColumnNamed(fieldName);
        Vector<String> matchesVector = null;
        if (targetColumn == null) {
            throw new FieldNotFoundException("Field " + fieldName + " not found.");
        }
        int i = 0;
        while (i < targetColumn.size()) {
            if (((String)targetColumn.elementAt(i)).equals(value)) {
                if (matchesVector == null) {
                    matchesVector = new Vector<String>();
                }
                matchesVector.add(this.getElementAtIndex(i));
            }
            ++i;
        }
        return matchesVector;
    }

    public String[][] getDataMatrix() {
        return this.getDataMatrix(false);
    }

    public String[][] getDataMatrix(boolean withHeaders) {
        int i;
        Vector columnHeaders = this.getColumnHeaders();
        int hc = withHeaders ? 1 : 0;
        String[][] matrix = new String[this.dataLinesMap.size() + hc][columnHeaders.size()];
        if (withHeaders) {
            i = 0;
            while (i < columnHeaders.size()) {
                matrix[0][i] = (String)columnHeaders.elementAt(i);
                ++i;
            }
        }
        i = hc;
        while (i < matrix.length) {
            String currentLine = this.getElementAtIndex(i - hc);
            StringTokenizer st = new StringTokenizer(currentLine, "\t");
            int j = 0;
            while (j < matrix[i].length) {
                matrix[i][j] = st.nextToken();
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public Object[] getCommentLineArray() {
        return this.commentLineArray;
    }

    private static class IntVector
    extends Vector {
        private IntVector() {
        }

        public void add(int element) {
            super.add(new Integer(element));
        }

        public int intElementAt(int index) {
            return (Integer)super.elementAt(index);
        }
    }
}

