/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.util.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.tigr.midas.display.AlertDialogPane;
import org.tigr.midas.display.Midas;
import org.tigr.midas.engine.Parameter;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.util.GBA;
import org.tigr.midas.util.swing.WholeNumberField;

public class SAMPermutationsNumberEditor
extends DefaultCellEditor {
    public SAMPermutationsNumberEditor(JButton b) {
        super(new JTextField(b.getText()));
        b.setText("Specify the random permutations number");
        this.editorComponent = b;
        this.setClickCountToStart(1);
        b.setBackground(Color.white);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDialog d = new JDialog(Midas.frame, "SAM Permutation Numbers", true);
                JPanel p1 = new JPanel();
                p1.setBackground(Color.white);
                p1.setLayout(new GridBagLayout());
                JRadioButton numberButton = new JRadioButton("Only perform this number of random permutations: ");
                JRadioButton allPermButton = new JRadioButton("Use all possible unique permutations (" + MathTools.pow2(Parameter.pFolderFilesVec.size()) + ")");
                numberButton.setBackground(Color.white);
                allPermButton.setBackground(Color.white);
                numberButton.setSelected(true);
                ButtonGroup group = new ButtonGroup();
                group.add(numberButton);
                group.add(allPermButton);
                WholeNumberField permNumberField = new WholeNumberField(Parameter.pSAMPermutationsNumber, 6);
                GBA gba = new GBA();
                gba.add(p1, numberButton, 0, 0, 1, 1, 0, 0, 1, 10, 0, 0, 0, 0);
                gba.add(p1, permNumberField, 1, 0, 1, 1, 1, 0, 1, 10, 0, 0, 0, 0);
                gba.add(p1, allPermButton, 0, 1, 2, 1, 1, 0, 1, 10, 0, 0, 0, 0);
                JPanel p2 = new JPanel();
                p2.setBackground(Color.white);
                p2.add(p1);
                JButton okButton = new JButton(" OK ");
                okButton.addActionListener(new ActionListener(this, allPermButton, d, permNumberField){
                    private final /* synthetic */ JRadioButton val$allPermButton;
                    private final /* synthetic */ JDialog val$d;
                    private final /* synthetic */ WholeNumberField val$permNumberField;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$allPermButton = val$allPermButton;
                        this.val$d = val$d;
                        this.val$permNumberField = val$permNumberField;
                    }

                    public void actionPerformed(ActionEvent evt) {
                        if (this.val$allPermButton.isSelected()) {
                            AlertDialogPane aPane = new AlertDialogPane(0, "Please be aware that the performance might be very slow if your \n experiment size is big ");
                            Parameter.pSAMAllUniquePerm = true;
                            Parameter.pSAMPermutationsNumber = (int)MathTools.pow2(Parameter.pFolderFilesVec.size());
                            this.val$d.dispose();
                        } else {
                            Parameter.pSAMAllUniquePerm = false;
                            Parameter.pSAMPermutationsNumber = this.val$permNumberField.getValue();
                            this.val$d.dispose();
                        }
                    }
                });
                p2.add(okButton);
                d.getContentPane().add(p2);
                d.setSize(new Dimension(445, 120));
                d.setResizable(false);
                d.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2);
                d.setVisible(true);
                SAMPermutationsNumberEditor.this.fireEditingStopped();
            }
        });
    }

    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    public Object getCellEditorValue() {
        if (Parameter.pSAMAllUniquePerm) {
            return Integer.toString(Parameter.pSAMPermutationsNumber) + " unique";
        }
        return Integer.toString(Parameter.pSAMPermutationsNumber) + " random";
    }
}

