/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.api.pub;

import com.zerog.ia.api.pub.CustomError;
import com.zerog.ia.api.pub.I18NAccess;
import com.zerog.ia.api.pub.IAProxy;
import com.zerog.ia.api.pub.InstallShieldUniversal10AndOlderRegistry;
import com.zerog.ia.api.pub.InstallShieldUniversalRegistry;
import com.zerog.ia.api.pub.InstallerAccess;
import com.zerog.ia.api.pub.InstallerControl;
import com.zerog.ia.api.pub.InstallerResources;
import com.zerog.ia.api.pub.ProgressAccess;
import com.zerog.ia.api.pub.ReplayVariableService;
import com.zerog.ia.api.pub.ResourceAccess;
import com.zerog.ia.api.pub.RollbackRegister;
import com.zerog.ia.api.pub.ServiceAccess;
import com.zerog.ia.api.pub.SimpleRegistryManager;
import com.zerog.ia.api.pub.SolutionInstallServices;
import com.zerog.ia.api.pub.VariableAccess;
import com.zerog.ia.api.pub.registry.ProductRegistryService;
import com.zerog.ia.installer.Installer;
import com.zerog.ia.installer.util.service.ServiceManagerFacade;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;

public class InstallerProxy
implements ResourceAccess,
VariableAccess,
I18NAccess,
InstallerAccess,
InstallerControl,
ServiceAccess,
IAProxy,
ProgressAccess {
    private Installer installer;
    private ResourceAccess ra;
    private VariableAccess va;
    private I18NAccess i18na;
    private InstallerAccess ia;
    private InstallerControl ic;
    private ProgressAccess progressAccess = null;

    public InstallerProxy(Installer installer) {
        this(installer, new ZeroGi2(), new ZeroGi3(), new ZeroGi4(), new ZeroGta(), new ZeroGi5(installer));
    }

    public InstallerProxy(Installer installer, ResourceAccess resourceAccess, VariableAccess variableAccess, I18NAccess i18NAccess, InstallerAccess installerAccess, InstallerControl installerControl) {
        this.installer = installer;
        if (resourceAccess == null || variableAccess == null || i18NAccess == null || installerAccess == null || installerControl == null) {
            System.err.println("InstallerProxy: Some proxy component implementations were null");
            throw new IllegalArgumentException("Some proxy component implementations were null");
        }
        this.ra = resourceAccess;
        this.va = variableAccess;
        this.i18na = i18NAccess;
        this.ia = installerAccess;
        this.ic = installerControl;
    }

    public void setProgressAccess(ProgressAccess progressAccess) {
        this.progressAccess = progressAccess;
    }

    public URL getResource(String string) {
        return this.ra.getResource(string);
    }

    public File getTempDirectory() throws IOException {
        return this.ra.getTempDirectory();
    }

    public String substitute(String string) {
        return this.va.substitute(string);
    }

    public File saveURLContentToFile(URL uRL) throws IOException {
        return this.ra.saveURLContentToFile(uRL);
    }

    public Object getVariable(String string) {
        return this.va.getVariable(string);
    }

    public Enumeration getVariables() {
        return this.va.getVariables();
    }

    public Object setVariable(String string, Object object) {
        return this.va.setVariable(string, object);
    }

    public Object getEncryptedVariable(String string) {
        return this.va.getEncryptedVariable(string);
    }

    public String getValue(String string, Locale locale) {
        return this.i18na.getValue(string, locale);
    }

    public String getValue(String string) {
        return this.i18na.getValue(string);
    }

    public DataOutput getLogOutput() {
        return this.ia.getLogOutput();
    }

    public String getLogOutputAsString() {
        return this.ia.getLogOutputAsString();
    }

    public void abortInstallation(int n) {
        this.ic.abortInstallation(n);
    }

    public void setProgressPercentage(float f) {
        if (this.progressAccess != null) {
            this.progressAccess.setProgressPercentage(f);
        }
    }

    public void setProgressStatusText(String string) {
        if (this.progressAccess != null) {
            this.progressAccess.setProgressStatusText(string);
        }
    }

    public void setProgressTitle(String string) {
        if (this.progressAccess != null) {
            this.progressAccess.setProgressTitle(string);
        }
    }

    public void setProgressDescription(String string) {
        if (this.progressAccess != null) {
            this.progressAccess.setProgressDescription(string);
        }
    }

    public Object getService(Class clazz) {
        Object object = null;
        if (clazz.equals(SimpleRegistryManager.class)) {
            object = ZeroGr8.a();
        } else if (clazz.equals(InstallerResources.class)) {
            object = ZeroGh8.a();
        } else if (clazz.equals(CustomError.class)) {
            object = ZeroGsa.a();
        } else if (clazz.equals(RollbackRegister.class)) {
            object = ZeroGtb.a();
        } else if (clazz.equals(SolutionInstallServices.class)) {
            object = ZeroGs9.a(this.installer);
        } else if (clazz.equals(InstallShieldUniversalRegistry.class)) {
            object = ZeroGsb.a();
        } else if (clazz.equals(InstallShieldUniversal10AndOlderRegistry.class)) {
            object = ZeroGsc.a();
        } else if (clazz.equals(ReplayVariableService.class)) {
            object = ZeroGsg.a();
        } else if (clazz.equals(ProductRegistryService.class)) {
            object = ZeroGtc.a();
            ((ZeroGtc)object).a(this.installer, false);
        } else {
            object = ServiceManagerFacade.getInstance().getService(clazz);
        }
        return object;
    }
}

