/*
 * Decompiled with CFR 0.152.
 */
package blrevcomp;

import blrevcomp.BufferedTextInputFile;
import blrevcomp.BufferedTextOutputFile;
import java.util.HashMap;

public class BioSeq {
    public int MAXSEQ = 1000000;
    public String Name = new String("");
    public char SFlag = (char)62;
    public char[] seq = new char[this.MAXSEQ];
    public int LEN = 0;
    NAType Stype;
    Nuchar Nuc;

    boolean newSeqFound(BufferedTextInputFile In) {
        return !In.EOF && (In.currentLine.startsWith(">") || In.currentLine.startsWith("#"));
    }

    public boolean readFasta(BufferedTextInputFile In) {
        this.LEN = 0;
        this.Name = "";
        boolean OKAY = false;
        while (!this.newSeqFound(In) && !In.EOF) {
            In.nextLine();
        }
        if (this.newSeqFound(In)) {
            OKAY = true;
            this.SFlag = In.currentLine.charAt(0);
            int RIGHT = In.currentLine.indexOf(32);
            if (RIGHT == -1) {
                RIGHT = In.currentLine.length();
            }
            this.Name = In.currentLine.substring(1, RIGHT);
            In.nextLine();
            while (!In.EOF && !this.newSeqFound(In)) {
                for (int i = 0; i < In.currentLine.length(); ++i) {
                    char CH = In.currentLine.charAt(i);
                    if (CH == ' ') continue;
                    this.seq[this.LEN] = CH;
                    ++this.LEN;
                }
                In.nextLine();
            }
        }
        this.Stype = this.getNAType();
        this.Nuc = new Nuchar();
        this.Nuc.Nuchar(this.Stype);
        return OKAY;
    }

    void writeSingleLine(BufferedTextOutputFile Out) {
        for (int j = 0; j < this.LEN; ++j) {
            Out.writeChar(this.seq[j]);
        }
    }

    public void writeRAW(BufferedTextOutputFile Out, char STRAND, int SENSE, HashMap N, int WIDTH) {
        int THISLINE;
        int POS = SENSE == 1 ? 0 : this.LEN - 1;
        for (int NUCSPRINTED = 0; NUCSPRINTED < this.LEN; NUCSPRINTED += THISLINE) {
            THISLINE = WIDTH;
            if (THISLINE + NUCSPRINTED > this.LEN) {
                THISLINE = this.LEN - NUCSPRINTED;
            }
            for (int I = 1; I <= THISLINE; ++I) {
                Out.writeChar((Character)N.get(Character.valueOf(this.seq[POS])));
                POS += SENSE;
            }
            Out.writeln("");
        }
    }

    public void writeFasta(BufferedTextOutputFile Out, String SUFFIX, char STRAND, int SENSE, int WIDTH) {
        Out.writeln(this.SFlag + this.Name + SUFFIX);
        if (STRAND == 'i') {
            this.writeRAW(Out, STRAND, SENSE, this.Nuc.INuc, WIDTH);
        } else {
            this.writeRAW(Out, STRAND, SENSE, this.Nuc.CNuc, WIDTH);
        }
    }

    NAType getNAType() {
        boolean Found = false;
        for (int I = 0; !Found && I < this.LEN; ++I) {
            if (this.seq[I] != 'U' && this.seq[I] != 'u') continue;
            Found = true;
        }
        if (Found) {
            return NAType.RNA;
        }
        return NAType.DNA;
    }

    public class Nuchar {
        public HashMap<Character, Character> INuc = new HashMap();
        public HashMap<Character, Character> CNuc = new HashMap();

        void Nuchar(NAType Stype) {
            this.INuc.put(Character.valueOf('A'), Character.valueOf('A'));
            this.INuc.put(Character.valueOf('a'), Character.valueOf('a'));
            this.INuc.put(Character.valueOf('G'), Character.valueOf('G'));
            this.INuc.put(Character.valueOf('g'), Character.valueOf('g'));
            this.INuc.put(Character.valueOf('C'), Character.valueOf('C'));
            this.INuc.put(Character.valueOf('c'), Character.valueOf('c'));
            this.INuc.put(Character.valueOf('T'), Character.valueOf('T'));
            this.INuc.put(Character.valueOf('t'), Character.valueOf('t'));
            this.INuc.put(Character.valueOf('U'), Character.valueOf('U'));
            this.INuc.put(Character.valueOf('u'), Character.valueOf('u'));
            this.INuc.put(Character.valueOf('R'), Character.valueOf('R'));
            this.INuc.put(Character.valueOf('r'), Character.valueOf('r'));
            this.INuc.put(Character.valueOf('D'), Character.valueOf('D'));
            this.INuc.put(Character.valueOf('d'), Character.valueOf('d'));
            this.INuc.put(Character.valueOf('V'), Character.valueOf('V'));
            this.INuc.put(Character.valueOf('v'), Character.valueOf('v'));
            this.INuc.put(Character.valueOf('M'), Character.valueOf('M'));
            this.INuc.put(Character.valueOf('m'), Character.valueOf('m'));
            this.INuc.put(Character.valueOf('K'), Character.valueOf('K'));
            this.INuc.put(Character.valueOf('k'), Character.valueOf('k'));
            this.INuc.put(Character.valueOf('B'), Character.valueOf('B'));
            this.INuc.put(Character.valueOf('b'), Character.valueOf('b'));
            this.INuc.put(Character.valueOf('H'), Character.valueOf('H'));
            this.INuc.put(Character.valueOf('h'), Character.valueOf('h'));
            this.INuc.put(Character.valueOf('Y'), Character.valueOf('Y'));
            this.INuc.put(Character.valueOf('y'), Character.valueOf('y'));
            this.INuc.put(Character.valueOf('W'), Character.valueOf('W'));
            this.INuc.put(Character.valueOf('w'), Character.valueOf('w'));
            this.INuc.put(Character.valueOf('S'), Character.valueOf('S'));
            this.INuc.put(Character.valueOf('s'), Character.valueOf('s'));
            this.INuc.put(Character.valueOf('N'), Character.valueOf('N'));
            this.INuc.put(Character.valueOf('n'), Character.valueOf('n'));
            this.INuc.put(Character.valueOf('-'), Character.valueOf('-'));
            this.INuc.put(Character.valueOf('-'), Character.valueOf('-'));
            if (Stype.equals((Object)NAType.DNA)) {
                this.CNuc.put(Character.valueOf('A'), Character.valueOf('T'));
                this.CNuc.put(Character.valueOf('a'), Character.valueOf('t'));
            } else {
                this.CNuc.put(Character.valueOf('A'), Character.valueOf('U'));
                this.CNuc.put(Character.valueOf('a'), Character.valueOf('u'));
            }
            this.CNuc.put(Character.valueOf('G'), Character.valueOf('C'));
            this.CNuc.put(Character.valueOf('g'), Character.valueOf('c'));
            this.CNuc.put(Character.valueOf('C'), Character.valueOf('G'));
            this.CNuc.put(Character.valueOf('c'), Character.valueOf('g'));
            this.CNuc.put(Character.valueOf('T'), Character.valueOf('A'));
            this.CNuc.put(Character.valueOf('t'), Character.valueOf('a'));
            this.CNuc.put(Character.valueOf('U'), Character.valueOf('A'));
            this.CNuc.put(Character.valueOf('u'), Character.valueOf('a'));
            this.CNuc.put(Character.valueOf('R'), Character.valueOf('Y'));
            this.CNuc.put(Character.valueOf('r'), Character.valueOf('y'));
            this.CNuc.put(Character.valueOf('D'), Character.valueOf('H'));
            this.CNuc.put(Character.valueOf('d'), Character.valueOf('h'));
            this.CNuc.put(Character.valueOf('V'), Character.valueOf('B'));
            this.CNuc.put(Character.valueOf('v'), Character.valueOf('b'));
            this.CNuc.put(Character.valueOf('M'), Character.valueOf('K'));
            this.CNuc.put(Character.valueOf('m'), Character.valueOf('k'));
            this.CNuc.put(Character.valueOf('K'), Character.valueOf('M'));
            this.CNuc.put(Character.valueOf('k'), Character.valueOf('m'));
            this.CNuc.put(Character.valueOf('B'), Character.valueOf('V'));
            this.CNuc.put(Character.valueOf('b'), Character.valueOf('v'));
            this.CNuc.put(Character.valueOf('H'), Character.valueOf('D'));
            this.CNuc.put(Character.valueOf('h'), Character.valueOf('d'));
            this.CNuc.put(Character.valueOf('Y'), Character.valueOf('R'));
            this.CNuc.put(Character.valueOf('y'), Character.valueOf('r'));
            this.CNuc.put(Character.valueOf('W'), Character.valueOf('S'));
            this.CNuc.put(Character.valueOf('w'), Character.valueOf('s'));
            this.CNuc.put(Character.valueOf('S'), Character.valueOf('w'));
            this.CNuc.put(Character.valueOf('s'), Character.valueOf('w'));
            this.CNuc.put(Character.valueOf('N'), Character.valueOf('N'));
            this.CNuc.put(Character.valueOf('n'), Character.valueOf('n'));
            this.CNuc.put(Character.valueOf('-'), Character.valueOf('-'));
            this.CNuc.put(Character.valueOf('-'), Character.valueOf('-'));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NAType {
        DNA,
        RNA;

    }
}

