/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.plugins;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.plugins.PluginWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader {
    private static Hashtable<String, PluginWrapper> plugins = new Hashtable();

    public static Map<String, PluginWrapper> getPluginHash() {
        return new Hashtable<String, PluginWrapper>(plugins);
    }

    public static Collection<PluginWrapper> getPlugins(Class<?> type) {
        ArrayList<PluginWrapper> list = new ArrayList<PluginWrapper>();
        for (PluginWrapper plugin : plugins.values()) {
            if (plugin == null || !plugin.isA(type)) continue;
            list.add(plugin);
        }
        return list;
    }

    public static PluginWrapper getPlugin(String string) {
        return plugins.get(string);
    }

    public static void loadPlugins(String directory) {
        String className = "";
        File pluginDirectory = new File(directory);
        if (pluginDirectory.exists() && pluginDirectory.isDirectory()) {
            for (File file : pluginDirectory.listFiles()) {
                try {
                    if (file.exists() && file.canRead() && file.isFile() && file.getName().toLowerCase().endsWith(".class")) {
                        className = file.getName().substring(0, file.getName().length() - 6);
                        PluginLoader.loadClass(pluginDirectory.toURL(), className);
                        continue;
                    }
                    if (file.exists() && file.canRead() && file.isFile() && file.getName().endsWith(".jar")) {
                        PluginLoader.loadJar(file);
                        continue;
                    }
                    if (!file.exists() || !file.canRead() || !file.isDirectory()) continue;
                    PluginLoader.loadPlugins(file.getAbsolutePath());
                }
                catch (Throwable th) {
                    BLMain.error("Error loading the file: " + file.getAbsolutePath(), "loadPlugins");
                    th.printStackTrace();
                }
            }
        }
    }

    private static void loadJar(File file) throws IOException {
        Enumeration<JarEntry> entries = null;
        JarFile jarfile = new JarFile(file);
        JarEntry entry = null;
        String className = "";
        entries = jarfile.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().toLowerCase().endsWith(".class")) continue;
            className = entry.getName().substring(0, entry.getName().length() - 6);
            className = className.replace("/", ".");
            PluginLoader.loadClass(file.toURL(), className);
        }
    }

    private static void loadClass(URL url, String name) {
        try {
            Class<?> currentClass = new URLClassLoader(new URL[]{url}).loadClass(name);
            if (currentClass != null) {
                plugins.put(name, new PluginWrapper(name, currentClass));
                for (Class<?> c : currentClass.getDeclaredClasses()) {
                    PluginLoader.loadClass(url, c.getName());
                }
            }
        }
        catch (Throwable th) {
            BLMain.error("Error loading the class: " + url.getPath() + " (" + name + ")");
            th.printStackTrace();
        }
    }
}

