/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.ezmenu;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.plugins.PluginLoader;
import org.biolegato.core.plugins.PluginWrapper;
import org.biolegato.core.plugintypes.MenuType;
import org.biolegato.ezmenu.ActionThread;
import org.biolegato.ezmenu.variables.GDEChoiceList;
import org.biolegato.ezmenu.variables.GDEChooser;
import org.biolegato.ezmenu.variables.GDEComboBox;
import org.biolegato.ezmenu.variables.GDEFileChooser;
import org.biolegato.ezmenu.variables.GDESlider;
import org.biolegato.ezmenu.variables.GDETempFile;
import org.biolegato.ezmenu.variables.GDETextField;
import org.biolegato.ezmenu.variables.GDEVariable;
import org.biolegato.ezmenu.variables.GDEWidgetVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EZRunWindow
implements Runnable {
    private LinkedList<Map<String, Object>> variables;
    private JDialog runWindow = null;
    private String command = "";
    private LinkedList<GDETempFile> files = new LinkedList();
    private HashMap<String, GDEWidgetVariable> widgets = new HashMap();
    private static final long serialVersionUID = 7526472295622777007L;

    public EZRunWindow(String name, String command, Action[] buttons, LinkedList<Map<String, Object>> variables) {
        this.command = command;
        this.variables = variables;
        boolean isDisplayWindow = false;
        GDEVariable variable = null;
        Box variablePane = new Box(3);
        for (Map map : variables) {
            variable = EZRunWindow.createVariable(map);
            if (variable instanceof GDETempFile) {
                this.files.add((GDETempFile)variable);
                continue;
            }
            if (!(variable instanceof GDEWidgetVariable)) continue;
            variablePane.add((GDEWidgetVariable)variable);
            this.widgets.put(variable.getName().toLowerCase(), (GDEWidgetVariable)variable);
        }
        if (!this.widgets.isEmpty() || buttons.length > 0) {
            this.runWindow = new JDialog(BLMain.getJFrame(), "BioLegato: " + name, true);
            Object panel = null;
            Box box = new Box(3);
            Box buttonPane = new Box(2);
            this.runWindow.setContentPane(new JScrollPane(box));
            box.add(variablePane);
            box.add(buttonPane);
            this.runWindow.setMinimumSize(new Dimension(50, 50));
            this.runWindow.setSize(new Dimension(100, 100));
            this.runWindow.setLocationRelativeTo(BLMain.getJFrame());
            this.runWindow.setVisible(false);
            buttonPane.add(new JButton(new ActionThread("Run", this)));
            for (Action button : buttons) {
                buttonPane.add(new JButton(button));
            }
            this.runWindow.pack();
            this.runWindow.setVisible(true);
            this.runWindow.setDefaultCloseOperation(2);
        } else {
            new Thread(this).start();
        }
    }

    @Override
    public void run() {
        String search = "";
        String run = this.command;
        for (Map map : this.variables) {
            search = map.get("name").toString().toLowerCase();
            if (!this.widgets.containsKey(search)) continue;
            map.put("default", this.widgets.get(search).getValue());
        }
        if (this.runWindow != null) {
            this.runWindow.dispose();
        }
        run = this.replaceArguments(run);
        BLMain.shellCommand((String)run, (String)"");
        for (GDETempFile gDETempFile : this.files) {
            gDETempFile.close();
        }
        this.runWindow = null;
    }

    private String replaceArguments(String run) {
        int start = -1;
        int end = -1;
        String name = "";
        String value = "";
        while ((start = run.indexOf(36, start)) >= 0) {
            for (end = start + 1; end < run.length() && this.isDigit(run.charAt(end)); ++end) {
            }
            name = run.substring(start + 1, end).toLowerCase();
            value = "";
            if (this.widgets.containsKey(name)) {
                value = this.widgets.get(name).getValue().toString();
                run = (start == 0 ? "" : run.substring(0, start)) + value + (end >= run.length() ? "" : run.substring(end));
                --start;
                continue;
            }
            ++start;
        }
        for (GDETempFile file : this.files) {
            start = -1;
            end = -1;
            if (file.getName() == null || file.getName().equals("")) continue;
            name = file.getName();
            value = file.getValue().toString();
            while ((start = run.indexOf(name, end + 1)) >= 0) {
                end = start + name.length();
                if (start != 0 && !this.notDigit(run.charAt(start - 1)) || end < run.length() && !this.notDigit(run.charAt(end))) continue;
                run = (start == 0 ? "" : run.substring(0, start)) + value + (end >= run.length() ? "" : run.substring(end));
                end = start - 1;
            }
        }
        return run;
    }

    public static final GDEVariable createVariable(Map data) {
        String type = null;
        GDEVariable result = null;
        if (data.containsKey("type")) {
            type = data.get("type").toString().trim();
            if ("slider".equalsIgnoreCase(type)) {
                result = new GDESlider(data);
            } else if ("choice_menu".equalsIgnoreCase(type)) {
                result = new GDEComboBox(data);
            } else if ("choice_list".equalsIgnoreCase(type)) {
                BLMain.warning((String)"Using deprecated menu widget \"choice_list\"");
                result = new GDEChoiceList(data);
            } else if ("chooser".equalsIgnoreCase(type)) {
                result = new GDEChooser((Map<String, Object>)data);
            } else if ("text".equalsIgnoreCase(type)) {
                result = new GDETextField(data);
            } else if ("tempfile".equalsIgnoreCase(type)) {
                result = new GDETempFile(data);
            } else if ("file_chooser".equalsIgnoreCase(type)) {
                result = new GDEFileChooser(data);
            } else if (type != null) {
                for (PluginWrapper plugin : PluginLoader.getPlugins(GDEWidgetVariable.class)) {
                    if (!type.equalsIgnoreCase("" + plugin.smethod("getType"))) continue;
                    result = (GDEWidgetVariable)plugin.create(new Class[]{Map.class}, new Object[]{data});
                }
            }
        }
        if (result == null) {
            BLMain.error((String)("Invalid variable type: " + type + " (check your plugin directory, properties file, and menu files for possible errors)"), (String)(MenuType.class.getCanonicalName() + ".createVariable"));
        }
        return result;
    }

    private boolean notDigit(char test) {
        return !(test >= '0' && test <= '9' || test >= 'a' && test <= 'z' || test >= 'A' && test <= 'Z');
    }

    private boolean isDigit(char test) {
        return test >= '0' && test <= '9' || test >= 'a' && test <= 'z' || test >= 'A' && test <= 'Z';
    }
}

