/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.ezmenu.variables;

import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.biolegato.ezmenu.variables.GDEWidgetVariable;

public class GDESlider
extends GDEWidgetVariable
implements ChangeListener {
    private JSlider slider = null;
    private JSpinner spinner = null;
    private static final long serialVersionUID = 7526472295622776161L;

    public GDESlider(Map data) {
        super(data);
        int defaultValue = 0;
        int minimum = 0;
        int maximum = 5000;
        if (data.containsKey("description")) {
            this.add(new JLabel(data.get("description").toString() + ":"));
        }
        if (data.containsKey("minimum") && data.get("minimum") instanceof Integer) {
            minimum = (Integer)data.get("minimum");
        }
        if (data.containsKey("maximum") && data.get("maximum") instanceof Integer) {
            maximum = (Integer)data.get("maximum");
        }
        if (data.containsKey("default")) {
            try {
                defaultValue = Integer.parseInt(data.get("default").toString());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this.spinner = new JSpinner(new SpinnerNumberModel(defaultValue, minimum, maximum, 1));
        this.spinner.addChangeListener(this);
        this.add(this.spinner);
        this.add(new JLabel("" + minimum));
        this.slider = new JSlider(0, minimum, maximum, defaultValue);
        this.slider.addChangeListener(this);
        this.add(this.slider);
        this.add(new JLabel("" + maximum));
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JSpinner) {
            this.slider.setValue(((Number)this.spinner.getValue()).intValue());
        } else {
            this.spinner.setValue(this.slider.getValue());
        }
    }

    public static String getType() {
        return "slider";
    }

    public Object getValue() {
        return this.spinner.getValue().toString();
    }
}

