/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.main;

import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.text.BadLocationException;
import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.plugins.PluginLoader;
import org.biolegato.core.plugins.PluginWrapper;
import org.biolegato.core.plugintypes.DataCanvas;
import org.biolegato.core.plugintypes.DataFormat;
import org.biolegato.core.plugintypes.MenuType;
import org.biolegato.core.plugintypes.PropertiesExtension;
import org.biolegato.core.properties.BLProperties;
import org.biolegato.core.properties.PropertiesListener;

public final class BLMain {
    public static final String NAME = "BioLegato";
    public static final String PROGRAM_DIR = new File(BLMain.class.getProtectionDomain().getCodeSource().getLocation().getPath()).isDirectory() ? BLMain.class.getProtectionDomain().getCodeSource().getLocation().getPath() : new File(new File(BLMain.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent()).getPath();
    public static final String CURRENT_DIR = System.getProperty("user.dir");
    public static final String VERSION = "0.7.0";
    public static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    public static final int DOUBLE_CLICK_TIME = 300;
    public static final long serialVersionUID = 7526472295622776147L;
    private static JFrame window = null;
    private static BLProperties properties = null;
    private static SeqDoc mainSeqDoc = new SeqDoc();
    private static JTabbedPane canvasPane = null;
    private static Hashtable<String, JMenu> menuHeadings = new Hashtable();

    public static void main(String[] args) {
        DataCanvas currentCanvas = null;
        Object currentMenuLoader = null;
        properties = new BLProperties();
        PluginLoader.loadPlugins(BLMain.envreplace(BLMain.getProperty("plugins")));
        BLMain.processArgs(args);
        for (PluginWrapper plugin : PluginLoader.getPlugins(PropertiesExtension.class)) {
            properties.addExtension((PropertiesExtension)plugin.create(new Class[]{BLProperties.class}, new Object[]{properties}));
        }
        canvasPane = new JTabbedPane();
        window = new JFrame(NAME);
        window.add(canvasPane);
        window.setJMenuBar(new JMenuBar());
        BLMain.addMenuItem("File", new JMenuItem(new AbstractAction("Open..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                this.putValue("MnemonicKey", new Integer(79));
            }

            public void actionPerformed(ActionEvent evt) {
                JFileChooser openDialog = new JFileChooser();
                openDialog.setCurrentDirectory(new File(System.getProperty("user.dir")));
                openDialog.setAcceptAllFileFilterUsed(true);
                DataFormat.addFormats(openDialog, BLMain.getProperty("default.fileformat").toString());
                if (openDialog.showOpenDialog(window) == 0 && openDialog.getSelectedFile() != null && openDialog.getSelectedFile().exists() && openDialog.getSelectedFile().isFile()) {
                    try {
                        if (openDialog.getFileFilter() != null && !openDialog.getFileFilter().equals(openDialog.getAcceptAllFileFilter())) {
                            BLMain.addData(((DataFormat)openDialog.getFileFilter()).readFile(openDialog.getSelectedFile()));
                        } else {
                            BLMain.addData(DataFormat.auto(openDialog.getSelectedFile()));
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        }));
        BLMain.addMenuItem("File", new JMenuItem(new AbstractAction("Save As..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                this.putValue("MnemonicKey", new Integer(83));
            }

            public void actionPerformed(ActionEvent evt) {
                JFileChooser saveDialog = new JFileChooser();
                saveDialog.setCurrentDirectory(new File(System.getProperty("user.dir")));
                saveDialog.setAcceptAllFileFilterUsed(false);
                DataFormat.addFormats(saveDialog, BLMain.getProperty("default.fileformat").toString());
                if (!(saveDialog.showSaveDialog(window) != 0 || saveDialog.getSelectedFile() == null || saveDialog.getSelectedFile().exists() && JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Overwritehttp://www.harmonyhomestead.com/index_files/tip1.htm", 2, 3) == 2)) {
                    try {
                        ((DataFormat)saveDialog.getFileFilter()).writeFile(saveDialog.getSelectedFile(), BLMain.getAllData());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        }));
        for (PluginWrapper plugin : PluginLoader.getPlugins(MenuType.class)) {
            plugin.smethod("loadMenu");
        }
        BLMain.addMenuItem("Help", new JMenuItem(new AbstractAction("About..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                this.putValue("MnemonicKey", new Integer(65));
            }

            public void actionPerformed(ActionEvent evt) {
                BLMain.aboutPopup();
            }
        }));
        BLMain.addMenuItem("File", new JMenuItem(new AbstractAction("Properties..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                this.putValue("MnemonicKey", new Integer(80));
            }

            public void actionPerformed(ActionEvent evt) {
                properties.showPropertiesWindow(window);
            }
        }));
        BLMain.addMenuItem("File", new JMenuItem(new AbstractAction("Exit"){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                this.putValue("MnemonicKey", new Integer(88));
            }

            public void actionPerformed(ActionEvent evt) {
                window.dispose();
            }
        }));
        for (PluginWrapper plugin : PluginLoader.getPlugins(DataCanvas.class)) {
            currentCanvas = (DataCanvas)plugin.create();
            if (currentCanvas == null) continue;
            canvasPane.addChangeListener(currentCanvas);
            canvasPane.add(currentCanvas.getTabName(), currentCanvas);
            if (currentCanvas.getTabName() == null || !currentCanvas.getTabName().equalsIgnoreCase(BLMain.getProperty("default.canvas"))) continue;
            canvasPane.setSelectedComponent(currentCanvas);
        }
        window.pack();
        window.setVisible(true);
        window.setLocationRelativeTo(null);
        window.setDefaultCloseOperation(2);
    }

    private static void processArgs(String[] args) {
        String value = "";
        File fileIn = null;
        String argument = null;
        Object dataIn = null;
        if (args != null) {
            for (String rawarg : args) {
                if (rawarg == null) continue;
                fileIn = new File(rawarg);
                if (fileIn != null && fileIn.exists() && fileIn.isFile() && fileIn.canRead()) {
                    BLMain.addData(DataFormat.auto(fileIn));
                    continue;
                }
                if (!rawarg.startsWith("/") && !rawarg.startsWith("-")) continue;
                argument = rawarg;
                if (argument.startsWith("--") && argument.length() > 2) {
                    argument = argument.substring(2);
                } else if ((argument.startsWith("/") || argument.startsWith("-")) && argument.length() > 1) {
                    argument = argument.substring(1);
                }
                if (argument.indexOf(61) > 0) {
                    value = argument.substring(argument.indexOf(61) + 1);
                    argument = argument.substring(0, argument.indexOf(61));
                }
                if ("help".equals(argument = argument.toLowerCase().trim()) || "h".equals(argument) || "?".equals(argument)) {
                    System.out.println("Usage: biolegato [options] [files]\nUse --optionlist  to see a detailed list of options\nUse --manpage     to see BioLegato's manpage");
                    System.exit(0);
                    continue;
                }
                if ("optionlist".equals(argument)) {
                    System.out.println("+-------------+------------------------------------------------------+\n| Option      | Description                                          |\n+-------------+------------------------------------------------------+\n| help,?      | Displays usage information for BioLegato             |\n| manpage,man | Displays the manpage entry for BioLegato             |\n| optionlist  | Displays the list of options for using BioLegato     |\n| version,v   | Displays the version information for BioLegato       |\n| pipe,p,in   | Inserts input from standard input into the canvas    |\n| debug       | Enables BioLegato's debug mode                       |\n| plugins     | Displays a list of loaded plugins                    |\n| properties  | Displays a list of BioLegato's properties            |\n+-------------+------------------------------------------------------+\n");
                    System.exit(0);
                    continue;
                }
                if ("manpage".equals(argument) || "man".equals(argument)) {
                    System.out.println("NAME\n    Bio Legato - A customizable GUI for running programs\n\nVERSION\n    Version 0.7.0\n\nSYNOPSIS\n    biolegato [options] [files]\n\nDESCRIPTION\n    BioLegato is a customizable GUI for running programs.\n    Its initial intent is to be a replacement for GDE; however\n    with its large plugin API, it may be customized to run more\n    than just CLI programs.\n\n    With the versitility of BioLegato's plugin interface, it\n    supports a wide range of file formats which may be added to\n    at any time through addition of plugins.\n\nOPTIONS\n  NOTE: All command line parameters are case insensitive\n        and may optionally begin with -, --, or / to prevent\n        confusion with filenames\n\n    help,h,?\n        Displays usage information for BioLegato\n    manpage,man\n        Displays the manpage entry for BioLegato (this screen)\n    optionlist\n        Displays the list of options for using BioLegato\n    version,v\n        Displays the version information for BioLegato\n    pipe,p,in\n        Inserts input from standard input into the canvas\n    debug\n        Enables BioLegato's debug mode\n    plugins\n        Displays a list of loaded plugins\n    properties\n        Displays a list of BioLegato's properties\n\nUSAGE EXAMPLES\n    biolegato\n\n    biolegato insequence.gb\n\n    biolegato --debug\n    biolegato /debug\n    biolegato -debug\n\n    biolegato --plugins --properties --debug\n\n    biolegato --plugins /properties -debug insequence.gb\n\nENVIRONMENT VARIABLES\n    BioLegato searches for the following environment variables.  If they don't exist BioLegato sets them to defaults.\n\n      Variable             Default value\n        BIOLEGATO_HOME       <the path of the current working directory>\n\nPROPERTIES\n    BioLegato supports the followind properties:\n\n      Property             Description\n        debug                determines whether or not to display debug information\n        plugins              sets the plugin directory\n        temp                 sets the temporary files directory\n        font.size            determines the default font size for objects in BioLegato\n        font.type            determines the default font type for objects in BioLegato\n        shell.name           determines the shell to execute\n        shell.parameter      determines the parameter for directing the shell to execute a command\n        pwd.properties       determines whether or not to read the properties file located in the current working directory\n        user.properties      determines whether or not to read the user's propery files (located in the user's home directory\n        user.plugins         determines whether or not to read the user's plugin files (located in the user's home directory\n        default.canvas       determines the default canvas to show on startup\n        default.fileformat   determines the default file format for open/save dialogs\n        GDE.menu             determines whether or not to read the GDE menu files (backwards compatibility mode)\n        GDE.help.viewer      determines which file to feed the help file to\n        GDE.help.path        the location to search for the help files\n        undo                 whether or not to enable undo support\n        undo.size            whether or not to enable undo support\n\n    This properties class will read properties files from the directory containing BioLegato, the user directory and finally\n    the directory BioLegato was launched from.  Please note that you can disable reading of properties files\n    from the user directory via. \"user.properties\"; likewise you can disable reading properties files in the directory BioLegato\n    was launched from via. \"pwd.properties\"\n    NOTE: for path properties BioLegato will replace all $'s with the appropriate environment variables if set.\n\nSUPPORTED PLUGINS\n    Currently BioLegato supports the following main types of Plugins:\n\n        Canvases\n           extends the class: org.biolegato.core.plugintypes.DataCanvas\n        File formats\n           extends the class: org.biolegato.core.plugintypes.DataFormat\n        Menu types\n           extends the class: org.biolegato.core.plugintypes.MenuType\n        Properties\n           extends the class: org.biolegato.core.plugintypes.PropertiesExtension\n\n    For more information about plugins, please consult the BioLegato API\n\nFILES\n    biolegato\n        Script to run BioLegato\n    biolegato.jar\n        BioLegato's core java code\n    changelog.txt\n        BioLegato's revision history\n    plugins/GDE_Menu.jar        Provides backward compatibility with GDE menus\n    plugins/GDE_anvas.jar        Provides GDE style multiple alignment canvas\n    plugins/GDEFile.class        Provides internal file support for GDE files\n    plugins/GDEFlatFile.class        Provides internal file support for GDE flatfiles\n    plugins/GenBankFile2008.class        Provides internal file support for GenBank files (2008 standard copliant)\n    plugins/FastA.class        Provides internal file support for FastA files\n\nFILE FORMATS\n    All file formats in BioLegato are supported through plugins.\n    Below is a list of file formats supported by a default\n    installation of BioLegato (with all standard plugins):\n\n        BioLegato flatfiles\n        FastA files\n        GDE flatfiles\n        GDE format files\n        GenBank files (2008 standard compliant)\n\nBUGS\n    There are currently no known bugs in this version of BioLegato\n\n    Please report all bugs to: Graham Alvare <alvare@cc.umanitoba.ca>\nAUTHORS\n    Dr. Brian Fristensky\n    Department of Plant Science\n    University of Manitoba\n    Winnipeg, MB  Canada R3T 2N2\n\n    Email: frist@cc.umanitoba.ca\n    Web: http://home.cc.umanitoba.ca/~frist\n\n    Graham Alvare\n    Department of Plant Science\n    University of Manitoba\n    Winnipeg, MB  Canada R3T 2N2\n\n    Email: alvare@cc.umanitoba.ca\n    Web: http://home.cc.umanitoba.ca/~alvare\n");
                    System.exit(0);
                    continue;
                }
                if ("version".equals(argument) || "v".equals(argument)) {
                    System.out.println("BioLegato v0.7.0");
                    System.exit(0);
                    continue;
                }
                if ("pipe".equals(argument) || "p".equals(argument) || "in".equals(argument)) {
                    try {
                        BLMain.addData(DataFormat.auto(System.in));
                    }
                    catch (Throwable ex) {
                        BLMain.error("An error occurred reading canvas data from System.in", "processArgs");
                    }
                    continue;
                }
                if ("debug".equals(argument)) {
                    properties.setProperty("debug", "true");
                    continue;
                }
                if ("plugins".equals(argument)) {
                    String[] pluginList;
                    System.out.println("(Current plugins path: " + BLMain.getProperty("plugins") + ")");
                    System.out.println("-- listing plugins loaded --");
                    for (String pluginName : pluginList = PluginLoader.getPluginHash().keySet().toArray(new String[0])) {
                        System.out.println("Plugin: " + pluginName);
                    }
                    System.out.println("-- end of plugin list --");
                    continue;
                }
                if ("properties".equals(argument)) {
                    System.out.println("**********");
                    System.out.println("PROPERTIES");
                    System.out.println("**********");
                    properties.list(System.out);
                    continue;
                }
                BLMain.error("Unknown argument: " + rawarg, "processArgs");
            }
        }
        if ("true".equalsIgnoreCase(BLMain.getProperty("debug"))) {
            BLMain.message("Command line arguments read successfully", "processArgs");
        }
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    public static String getProperty(String property) {
        return properties.getProperty(property);
    }

    public static Sequence[] getClipboard() {
        String string = "";
        Sequence[] clipboard = null;
        Sequence[] result = null;
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null) {
                if (t.isDataFlavorSupported(SeqDoc.seqDocFlavour)) {
                    clipboard = ((SeqDoc)t.getTransferData(SeqDoc.seqDocFlavour)).toArray();
                    result = new Sequence[clipboard.length];
                    for (int count = 0; count < clipboard.length; ++count) {
                        result[count] = new Sequence(clipboard[count]);
                    }
                } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    string = (String)t.getTransferData(DataFlavor.stringFlavor);
                    result = DataFormat.auto(new BufferedReader(new StringReader(string)));
                }
            }
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    public static void setClipboard(Sequence[] copy) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new SeqDoc(copy), null);
    }

    public static SeqDoc getSeqDoc() {
        return mainSeqDoc;
    }

    public static Sequence[] getData() throws BadLocationException {
        return ((DataCanvas)canvasPane.getSelectedComponent()).getData();
    }

    public static Sequence[] getAllData() throws BadLocationException {
        return BLMain.getSeqDoc().toArray();
    }

    public static void addData(Sequence[] dataAdd) {
        if (dataAdd != null) {
            for (Sequence seq : dataAdd) {
                BLMain.getSeqDoc().addSequence(BLMain.getSeqDoc().getLineCount(), seq);
            }
        }
    }

    public static JFrame getJFrame() {
        return window;
    }

    public static JMenu addMenuHeading(String name) {
        JMenu heading = menuHeadings.get(name);
        if (heading == null) {
            heading = new JMenu(name);
            if (name != null && name.length() >= 1 && (name.charAt(0) >= 'a' && name.charAt(0) <= 'z' || name.charAt(0) >= 'A' && name.charAt(0) <= 'Z')) {
                heading.setMnemonic(name.charAt(0));
            }
            menuHeadings.put(name, heading);
            window.getJMenuBar().add(heading);
        }
        return heading;
    }

    public static JMenu addMenuHeading(int order, String name) {
        JMenu heading = BLMain.addMenuHeading(name);
        if (window.getJMenuBar().getComponentIndex(heading) != order) {
            window.getJMenuBar().remove(heading);
            window.getJMenuBar().add((Component)heading, order);
        }
        return heading;
    }

    public static void addMenuItem(String headingName, JMenuItem menuItem) {
        BLMain.addMenuHeading(headingName).add(menuItem);
    }

    public static void aboutPopup() {
        JOptionPane.showMessageDialog(window, "BioLegato version 0.7.0\nby Graham Alvare and Brian Fristensky\nUniveristy of Manitoba 2008-2010", "About BioLegato", 3);
    }

    public static void addPropertiesListener(String key, PropertiesListener listener) {
        properties.addPropertiesListener(key, listener);
    }

    public static Process safeExecute(String cmd) {
        Process result = null;
        StringBuffer message = new StringBuffer();
        String[] execute = new String[]{cmd};
        if (properties.getProperty("shell.name") != null) {
            execute = properties.getProperty("shell.parameter") != null ? new String[]{properties.getProperty("shell.name"), properties.getProperty("shell.parameter"), cmd} : new String[]{properties.getProperty("shell.name"), cmd};
        }
        if ("true".equalsIgnoreCase(BLMain.getProperty("debug"))) {
            for (String parameter : execute) {
                message.append(parameter + " ");
            }
            BLMain.message(message.toString(), "safeExecute");
        }
        try {
            result = Runtime.getRuntime().exec(execute);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void shellCommand(String cmd, String data) {
        int result = -65535;
        final Process process = BLMain.safeExecute(cmd);
        if (process != null) {
            try {
                if (data != null) {
                    new OutputStreamWriter(process.getOutputStream()).write(data);
                }
                new Thread(){

                    public void run() {
                        String line = "";
                        BufferedReader reader = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                            while ((line = reader.readLine()) != null) {
                                System.out.println(line);
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }.start();
                new Thread(){

                    public void run() {
                        String line = "";
                        BufferedReader reader = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                            while ((line = reader.readLine()) != null) {
                                System.err.println(line);
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }.start();
                if ("true".equalsIgnoreCase(BLMain.getProperty("debug"))) {
                    BLMain.message("BioLegato: Command executed successfully, returned: " + process.waitFor(), "shellCommand");
                } else {
                    process.waitFor();
                }
            }
            catch (Throwable e) {
                BLMain.error("BioLegato: error executing command: " + cmd, "shellCommand");
                e.printStackTrace();
            }
        }
    }

    public static void error(String message) {
        BLMain.error(message, null);
    }

    public static void error(String message, String location) {
        System.err.println(NAME + (location != null && !"".equals(location.trim()) ? " (" + location + ")" : "") + ": ERROR --- " + message);
    }

    public static void warning(String message) {
        BLMain.warning(message, null);
    }

    public static void warning(String message, String location) {
        System.err.println(NAME + (location != null && !"".equals(location.trim()) ? " (" + location + ")" : "") + ": WARNING --- " + message);
    }

    public static void message(String message) {
        BLMain.message(message, null);
    }

    public static void message(String message, String location) {
        System.out.println(NAME + (location != null && !"".equals(location.trim()) ? " (" + location + ")" : "") + ": " + message);
    }

    public static String readStream(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        StringBuffer result = new StringBuffer();
        while (line != null) {
            result.append(line).append("\n");
            line = reader.readLine();
        }
        return result.toString();
    }

    public static boolean testNumber(char[] test) {
        boolean result = false;
        if (test.length > 0) {
            result = true;
            for (int count = 0; result && count < test.length; result &= Character.isDigit(test[count]), ++count) {
            }
        }
        return result;
    }

    public static String envreplace(String change) {
        int start = 0;
        int end = -1;
        String replace = null;
        String variable = "";
        if (change != null) {
            while ((start = change.indexOf(36, start)) >= start && start > -1) {
                for (end = start + 1; end < change.length() && (change.charAt(end) == '_' || Character.isLetter(change.charAt(end))); ++end) {
                }
                variable = change.substring(start + 1, end);
                replace = System.getenv(variable);
                if (variable.equalsIgnoreCase("BIOLEGATO_HOME")) {
                    replace = replace == null || "".equals(replace.trim()) || !new File(replace).exists() ? CURRENT_DIR : new File(replace).getAbsolutePath();
                }
                if (replace != null) {
                    change = change.substring(0, start) + replace + change.substring(end);
                    continue;
                }
                ++start;
            }
        }
        return change;
    }
}

