/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractMath;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.Mapping;

public final class ArrayMath
extends AbstractMath {
    private ArrayMath() {
    }

    public static double[] apply(Mapping mapping, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            dArray2[n] = mapping.map(dArray[n]);
            ++n;
        }
        return dArray2;
    }

    public static double[][] apply(Mapping mapping, double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        int n = 0;
        while (n < dArray.length) {
            dArrayArray[n] = ArrayMath.apply(mapping, dArray[n]);
            ++n;
        }
        return dArrayArray;
    }

    public static Complex[] apply(ComplexMapping complexMapping, Complex[] complexArray) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray2[n] = complexMapping.map(complexArray[n]);
            ++n;
        }
        return complexArray2;
    }

    public static Complex[][] apply(ComplexMapping complexMapping, Complex[][] complexArray) {
        Complex[][] complexArray2 = new Complex[complexArray.length][];
        int n = 0;
        while (n < complexArray.length) {
            complexArray2[n] = ArrayMath.apply(complexMapping, complexArray[n]);
            ++n;
        }
        return complexArray2;
    }

    public static double[] normalize(double[] dArray) {
        return ArrayMath.scalarMultiply(1.0 / ArrayMath.norm(dArray), dArray);
    }

    public static double[] setLengthFromEnd(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        int n2 = n - dArray.length < 0 ? dArray.length - n : 0;
        System.arraycopy(dArray, n2, dArray2, -dArray.length + n + n2, dArray.length - n2);
        return dArray2;
    }

    public static double[] setLengthFromBeginning(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        int n2 = n - dArray.length < 0 ? dArray.length - n : 0;
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length - n2);
        return dArray2;
    }

    public static double[] copy(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public static double[][] copy(double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        int n = 0;
        while (n < dArray.length) {
            dArrayArray[n] = ArrayMath.copy(dArray[n]);
            ++n;
        }
        return dArrayArray;
    }

    public static double variance(double[] dArray) {
        double d = ArrayMath.mean(dArray);
        double d2 = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d2 += (dArray[n] - d) * (dArray[n] - d);
            ++n;
        }
        return d2 / (double)(dArray.length - 1);
    }

    public static double covariance(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + dArray.length + ", " + dArray2.length);
        }
        double d = ArrayMath.mean(dArray);
        double d2 = ArrayMath.mean(dArray2);
        double d3 = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d3 += (dArray[n] - d) * (dArray2[n] - d2);
            ++n;
        }
        return d3 / (double)(dArray.length - 1);
    }

    public static double correlation(double[] dArray, double[] dArray2) {
        double d = Math.sqrt(ArrayMath.variance(dArray) * ArrayMath.variance(dArray2));
        if (d != 0.0) {
            return ArrayMath.covariance(dArray, dArray2) / d;
        }
        if (ArrayMath.variance(dArray) == 0.0 && ArrayMath.variance(dArray2) == 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double mean(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! The array must have at least one element.");
        }
        return ArrayMath.mass(dArray) / (double)dArray.length;
    }

    public static double standardDeviation(double[] dArray) {
        return Math.sqrt(ArrayMath.variance(dArray));
    }

    public static double[] sortMinToMax(double[] dArray) {
        double[] dArray2 = ArrayMath.copy(dArray);
        ArrayMath.QuickSortMinToMax(dArray2, 0, dArray2.length - 1);
        return dArray2;
    }

    public static double[] sortMaxToMin(double[] dArray) {
        double[] dArray2 = ArrayMath.copy(dArray);
        ArrayMath.QuickSortMaxToMin(dArray2, 0, dArray2.length - 1);
        return dArray2;
    }

    public static double percentile(double[] dArray, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Percentile must be between 0 and 1 : " + d);
        }
        double[] dArray2 = ArrayMath.sortMinToMax(dArray);
        int n = (int)Math.floor(d * (double)(dArray2.length - 1));
        double d2 = d * (double)(dArray2.length - 1) - Math.floor(d * (double)(dArray2.length - 1));
        if (n == dArray2.length - 1) {
            return dArray2[dArray2.length - 1];
        }
        return dArray2[n] * (1.0 - d2) + dArray2[n + 1] * d2;
    }

    public static double median(double[] dArray) {
        return ArrayMath.percentile(dArray, 0.5);
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            return false;
        }
        int n = 0;
        while (n < dArray.length) {
            if (Math.abs(dArray[n] - dArray2[n]) > GlobalSettings.ZERO_TOL) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static double[] abs(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            dArray2[n] = Math.abs(dArray[n]);
            ++n;
        }
        return dArray2;
    }

    public static double[][] abs(double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        int n = 0;
        while (n < dArray.length) {
            dArrayArray[n] = ArrayMath.abs(dArray[n]);
            ++n;
        }
        return dArrayArray;
    }

    public static double max(double[] dArray) {
        double d = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            if (d < dArray[n]) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public static double max(double[][] dArray) {
        double d = ArrayMath.max(dArray[0]);
        int n = 1;
        while (n < dArray.length) {
            if (d < ArrayMath.max(dArray[n])) {
                d = ArrayMath.max(dArray[n]);
            }
            ++n;
        }
        return d;
    }

    public static double min(double[] dArray) {
        double d = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            if (d > dArray[n]) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public static double min(double[][] dArray) {
        double d = ArrayMath.min(dArray[0]);
        int n = 1;
        while (n < dArray.length) {
            if (d > ArrayMath.min(dArray[n])) {
                d = ArrayMath.min(dArray[n]);
            }
            ++n;
        }
        return d;
    }

    public static double[] mod(Complex[] complexArray) {
        double[] dArray = new double[complexArray.length];
        int n = 0;
        while (n < complexArray.length) {
            dArray[n] = complexArray[n].mod();
            ++n;
        }
        return dArray;
    }

    public static double[][] mod(Complex[][] complexArray) {
        double[][] dArrayArray = new double[complexArray.length][];
        int n = 0;
        while (n < complexArray.length) {
            dArrayArray[n] = ArrayMath.mod(complexArray[n]);
            ++n;
        }
        return dArrayArray;
    }

    public static double norm(double[] dArray) {
        return Math.sqrt(ArrayMath.sumSquares(dArray));
    }

    public static double sumSquares(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n] * dArray[n];
            ++n;
        }
        return d;
    }

    public static double sumSquares(double[][] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            int n2 = 0;
            while (n2 < dArray[n].length) {
                d += dArray[n][n2] * dArray[n][n2];
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public static double scalarProduct(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + dArray.length + ", " + dArray2.length);
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! Arrays must have at least one element.");
        }
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n] * dArray2[n];
            ++n;
        }
        return d;
    }

    public static double scalarProduct(double[][] dArray, double[][] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + dArray.length + ", " + dArray2.length);
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! Arrays must have at least one element.");
        }
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += ArrayMath.scalarProduct(dArray[n], dArray2[n]);
            ++n;
        }
        return d;
    }

    public static double[] extract(int n, int n2, double[] dArray) {
        if (n < 0 || n2 < 0 || n > dArray.length - 1 || n2 > dArray.length - 1) {
            throw new IllegalArgumentException("The parameters are incorrect : " + n + ", " + n2 + ", " + dArray.length);
        }
        if (n2 > n) {
            double[] dArray2 = new double[n2 - n + 1];
            System.arraycopy(dArray, n, dArray2, 0, n2 - n + 1);
            return dArray2;
        }
        double[] dArray3 = new double[-n2 + n + 1];
        int n3 = n2;
        while (n3 <= n) {
            dArray3[n - n3] = dArray[n3];
            ++n3;
        }
        return dArray3;
    }

    public static double[] invert(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            dArray2[dArray.length - 1 - n] = dArray[n];
            ++n;
        }
        return dArray2;
    }

    public static double[] padding(int n, int n2, double[] dArray) {
        if (dArray.length + n2 > n || n2 < 0) {
            throw new IllegalArgumentException("Array is to long for this : " + n + ", " + n2 + ", " + dArray.length);
        }
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, n2, dArray.length);
        return dArray2;
    }

    public static double[] add(double[] dArray, double d, double[] dArray2, int n) {
        if (dArray2.length > dArray.length) {
            throw new IllegalArgumentException("Second array must be shorter or equal to the first one : " + dArray.length + ", " + dArray2.length);
        }
        double[] dArray3 = ArrayMath.copy(dArray);
        int n2 = n;
        while (n2 < n + dArray2.length) {
            int n3 = n2;
            dArray3[n3] = dArray3[n3] + d * dArray2[n2 - n];
            ++n2;
        }
        return dArray3;
    }

    public static double[] add(double[] dArray, double d) {
        double[] dArray2 = ArrayMath.copy(dArray);
        int n = 0;
        while (n < dArray2.length) {
            int n2 = n++;
            dArray2[n2] = dArray2[n2] + d;
        }
        return dArray2;
    }

    public static double[][] transpose(double[][] dArray) {
        double[][] dArray2 = new double[dArray[0].length][dArray.length];
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n].length != dArray[0].length) {
                throw new IllegalArgumentException("The array is not a matrix.");
            }
            int n2 = 0;
            while (n2 < dArray[0].length) {
                dArray2[n2][n] = dArray[n][n2];
                ++n2;
            }
            ++n;
        }
        return dArray2;
    }

    public static double[] range(double d, double d2, double d3) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The argument step should be positive: " + d3 + " < 0");
        }
        if (d == d2) {
            double[] dArray = new double[]{d};
            return dArray;
        }
        int n = new Double(Math.abs(d - d2) / d3).intValue() + 1;
        double[] dArray = new double[n];
        dArray[0] = d;
        if (d > d2) {
            d3 = -d3;
        }
        int n2 = 1;
        while (n2 < n) {
            dArray[n2] = dArray[n2 - 1] + d3;
            ++n2;
        }
        return dArray;
    }

    public static double[] range(double d, double d2) {
        return ArrayMath.range(d, d2, 1.0);
    }

    public static double[] range(double d) {
        return ArrayMath.range(0.0, d);
    }

    public static double[] add(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("To add two arrays, they must have the same length : " + dArray.length + ", " + dArray2.length);
        }
        double[] dArray3 = ArrayMath.copy(dArray);
        int n = 0;
        while (n < dArray.length) {
            int n2 = n;
            dArray3[n2] = dArray3[n2] + dArray2[n];
            ++n;
        }
        return dArray3;
    }

    public static double[] subtract(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("To add two arrays, they must have the same length : " + dArray.length + ", " + dArray2.length);
        }
        double[] dArray3 = ArrayMath.copy(dArray);
        int n = 0;
        while (n < dArray.length) {
            int n2 = n;
            dArray3[n2] = dArray3[n2] - dArray2[n];
            ++n;
        }
        return dArray3;
    }

    public static double[] scalarMultiply(double d, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            dArray2[n] = d * dArray[n];
            ++n;
        }
        return dArray2;
    }

    public static String toString(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer(dArray.length);
        int n = 0;
        while (n < dArray.length - 1) {
            stringBuffer.append(dArray[n]);
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.append(dArray[n]);
        return stringBuffer.toString();
    }

    public static String toString(double[][] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < dArray.length) {
            stringBuffer.append(ArrayMath.toString(dArray[n]));
            stringBuffer.append(System.getProperty("line.separator"));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static double mass(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        return d;
    }

    public static double[] scalarMultiplyFast(double d, double[] dArray) {
        if (d == 0.0) {
            return new double[dArray.length];
        }
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            dArray2[n] = d != 0.0 && dArray[n] != 0.0 ? dArray[n] * d : 0.0;
            ++n;
        }
        return dArray2;
    }

    public static void print(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            System.out.println("array [" + n + "] = " + dArray[n]);
            ++n;
        }
    }

    public static void print(double[][] dArray) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = 0;
            while (n2 < dArray[n].length) {
                System.out.println("array [" + n + "][" + n2 + "] = " + dArray[n][n2]);
                ++n2;
            }
            ++n;
        }
    }

    public static int[] setLengthFromEnd(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        int n2 = n - nArray.length < 0 ? nArray.length - n : 0;
        System.arraycopy(nArray, n2, nArray2, -nArray.length + n + n2, nArray.length - n2);
        return nArray2;
    }

    public static int[] setLengthFromBeginning(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        int n2 = n - nArray.length < 0 ? nArray.length - n : 0;
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length - n2);
        return nArray2;
    }

    public static int[] copy(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static int[][] copy(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        int n = 0;
        while (n < nArray.length) {
            nArrayArray[n] = ArrayMath.copy(nArray[n]);
            ++n;
        }
        return nArrayArray;
    }

    public static double variance(int[] nArray) {
        double d = ArrayMath.mean(nArray);
        double d2 = 0.0;
        int n = 0;
        while (n < nArray.length) {
            d2 += ((double)nArray[n] - d) * ((double)nArray[n] - d);
            ++n;
        }
        return d2 / (double)(nArray.length - 1);
    }

    public static double covariance(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + nArray.length + ", " + nArray2.length);
        }
        double d = ArrayMath.mean(nArray);
        double d2 = ArrayMath.mean(nArray2);
        double d3 = 0.0;
        int n = 0;
        while (n < nArray.length) {
            d3 += ((double)nArray[n] - d) * ((double)nArray2[n] - d2);
            ++n;
        }
        return d3 / (double)(nArray.length - 1);
    }

    public static double correlation(int[] nArray, int[] nArray2) {
        double d = Math.sqrt(ArrayMath.variance(nArray) * ArrayMath.variance(nArray2));
        if (d != 0.0) {
            return ArrayMath.covariance(nArray, nArray2) / d;
        }
        if (ArrayMath.variance(nArray) == 0.0 && ArrayMath.variance(nArray2) == 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double mean(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! The array must have at least one element.");
        }
        return (double)ArrayMath.mass(nArray) / (double)nArray.length;
    }

    public static double standardDeviation(int[] nArray) {
        return Math.sqrt(ArrayMath.variance(nArray));
    }

    public static int[] sortMinToMax(int[] nArray) {
        int[] nArray2 = ArrayMath.copy(nArray);
        ArrayMath.QuickSortMinToMax(nArray2, 0, nArray2.length - 1);
        return nArray2;
    }

    public static int[] sortMaxToMin(int[] nArray) {
        int[] nArray2 = ArrayMath.copy(nArray);
        ArrayMath.QuickSortMaxToMin(nArray2, 0, nArray2.length - 1);
        return nArray2;
    }

    public static String toString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(nArray.length);
        int n = 0;
        while (n < nArray.length - 1) {
            stringBuffer.append(nArray[n]);
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.append(nArray[n]);
        return stringBuffer.toString();
    }

    public static String toString(int[][] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            stringBuffer.append(ArrayMath.toString(nArray[n]));
            stringBuffer.append(System.getProperty("line.separator"));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static double percentile(int[] nArray, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Percentile must be between 0 and 1 : " + d);
        }
        int[] nArray2 = ArrayMath.sortMinToMax(nArray);
        int n = (int)Math.floor(d * (double)(nArray2.length - 1));
        double d2 = d * (double)(nArray2.length - 1) - Math.floor(d * (double)(nArray2.length - 1));
        if (n == nArray2.length - 1) {
            return nArray2[nArray2.length - 1];
        }
        return (double)nArray2[n] * (1.0 - d2) + (double)nArray2[n + 1] * d2;
    }

    public static double median(int[] nArray) {
        return ArrayMath.percentile(nArray, 0.5);
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != nArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static int[] abs(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = Math.abs(nArray[n]);
            ++n;
        }
        return nArray2;
    }

    public static int[][] abs(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        int n = 0;
        while (n < nArray.length) {
            nArrayArray[n] = ArrayMath.abs(nArray[n]);
            ++n;
        }
        return nArrayArray;
    }

    public static int max(int[] nArray) {
        int n = nArray[0];
        int n2 = 1;
        while (n2 < nArray.length) {
            if (n < nArray[n2]) {
                n = nArray[n2];
            }
            ++n2;
        }
        return n;
    }

    public static int max(int[][] nArray) {
        int n = ArrayMath.max(nArray[0]);
        int n2 = 1;
        while (n2 < nArray.length) {
            if (n < ArrayMath.max(nArray[n2])) {
                n = ArrayMath.max(nArray[n2]);
            }
            ++n2;
        }
        return n;
    }

    public static int min(int[] nArray) {
        int n = nArray[0];
        int n2 = 1;
        while (n2 < nArray.length) {
            if (n > nArray[n2]) {
                n = nArray[n2];
            }
            ++n2;
        }
        return n;
    }

    public static int min(int[][] nArray) {
        int n = ArrayMath.min(nArray[0]);
        int n2 = 1;
        while (n2 < nArray.length) {
            if (n > ArrayMath.min(nArray[n2])) {
                n = ArrayMath.min(nArray[n2]);
            }
            ++n2;
        }
        return n;
    }

    public static double norm(int[] nArray) {
        return Math.sqrt(ArrayMath.sumSquares(nArray));
    }

    public static int sumSquares(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n += nArray[n2] * nArray[n2];
            ++n2;
        }
        return n;
    }

    public static int sumSquares(int[][] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = 0;
            while (n3 < nArray[n2].length) {
                n += nArray[n2][n3] * nArray[n2][n3];
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    public static int scalarProduct(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + nArray.length + ", " + nArray2.length);
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! Arrays must have at least one element.");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n += nArray[n2] * nArray2[n2];
            ++n2;
        }
        return n;
    }

    public static double scalarProduct(int[][] nArray, int[][] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + nArray.length + ", " + nArray2.length);
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! Arrays must have at least one element.");
        }
        double d = 0.0;
        int n = 0;
        while (n < nArray.length) {
            d += (double)ArrayMath.scalarProduct(nArray[n], nArray2[n]);
            ++n;
        }
        return d;
    }

    public static int[] extract(int n, int n2, int[] nArray) {
        if (n < 0 || n2 < 0 || n > nArray.length - 1 || n2 > nArray.length - 1) {
            throw new IllegalArgumentException("The parameters are incorrect : " + n + ", " + n2 + ", " + nArray.length);
        }
        if (n2 > n) {
            int[] nArray2 = new int[n2 - n + 1];
            System.arraycopy(nArray, n, nArray2, 0, n2 - n + 1);
            return nArray2;
        }
        int[] nArray3 = new int[-n2 + n + 1];
        int n3 = n2;
        while (n3 <= n) {
            nArray3[n - n3] = nArray[n3];
            ++n3;
        }
        return nArray3;
    }

    public static int[] invert(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[nArray.length - 1 - n] = nArray[n];
            ++n;
        }
        return nArray2;
    }

    public static int[] padding(int n, int n2, int[] nArray) {
        if (nArray.length + n2 > n || n2 < 0) {
            throw new IllegalArgumentException("The array is too long for this : " + n + ", " + n2 + ", " + nArray.length);
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, n2, nArray.length);
        return nArray2;
    }

    public static int[] add(int[] nArray, double d, int[] nArray2, int n) {
        if (nArray2.length > nArray.length) {
            throw new IllegalArgumentException("Second array must be shorter or equal to the first one : " + nArray.length + ", " + nArray2.length);
        }
        int[] nArray3 = ArrayMath.copy(nArray);
        int n2 = n;
        while (n2 < n + nArray2.length) {
            int n3 = n2;
            nArray3[n3] = (int)((double)nArray3[n3] + d * (double)nArray2[n2 - n]);
            ++n2;
        }
        return nArray3;
    }

    public static int[] add(int[] nArray, int n) {
        int[] nArray2 = ArrayMath.copy(nArray);
        int n2 = 0;
        while (n2 < nArray2.length) {
            int n3 = n2++;
            nArray2[n3] = nArray2[n3] + n;
        }
        return nArray2;
    }

    public static int[] range(int n, int n2) {
        return ArrayMath.range(n, n2, 1);
    }

    public static int[] range(int n) {
        return ArrayMath.range(0, n);
    }

    public static int[] range(int n, int n2, int n3) {
        if (n3 <= 0) {
            throw new IllegalArgumentException("The argument step should be positive: " + n3 + " < 0");
        }
        if (n == n2) {
            int[] nArray = new int[]{n};
            return nArray;
        }
        int n4 = new Double(Math.abs(n - n2) / n3).intValue();
        int[] nArray = new int[n4];
        nArray[0] = n;
        if (n > n2) {
            n3 = -n3;
        }
        int n5 = 1;
        while (n5 < n4) {
            nArray[n5] = nArray[n5 - 1] + n3;
            ++n5;
        }
        return nArray;
    }

    public static int[][] transpose(int[][] nArray) {
        int[][] nArray2 = new int[nArray[0].length][nArray.length];
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n].length != nArray[0].length) {
                throw new IllegalArgumentException("The array is not a matrix.");
            }
            int n2 = 0;
            while (n2 < nArray[0].length) {
                nArray2[n2][n] = nArray[n][n2];
                ++n2;
            }
            ++n;
        }
        return nArray2;
    }

    public static int[] add(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("To add two arrays, they must have the same length : " + nArray.length + ", " + nArray2.length);
        }
        int[] nArray3 = ArrayMath.copy(nArray);
        int n = 0;
        while (n < nArray.length) {
            int n2 = n;
            nArray3[n2] = nArray3[n2] + nArray2[n];
            ++n;
        }
        return nArray3;
    }

    public static int[] subtract(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("To add two arrays, they must have the same length : " + nArray.length + ", " + nArray2.length);
        }
        int[] nArray3 = ArrayMath.copy(nArray);
        int n = 0;
        while (n < nArray.length) {
            int n2 = n;
            nArray3[n2] = nArray3[n2] - nArray2[n];
            ++n;
        }
        return nArray3;
    }

    public static int mass(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n += nArray[n2];
            ++n2;
        }
        return n;
    }

    public static double[] scalarMultiply(double d, int[] nArray) {
        double[] dArray = new double[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            dArray[n] = (double)nArray[n] * d;
            ++n;
        }
        return dArray;
    }

    public static double[] scalarMultiplyFast(double d, int[] nArray) {
        if (d == 0.0) {
            return new double[nArray.length];
        }
        double[] dArray = new double[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            dArray[n] = d != 0.0 && nArray[n] != 0 ? (double)nArray[n] * d : 0.0;
            ++n;
        }
        return dArray;
    }

    public static void print(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            System.out.println("array [" + n + "] = " + nArray[n]);
            ++n;
        }
    }

    public static void print(int[][] nArray) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                System.out.println("array [" + n + "][" + n2 + "] = " + nArray[n][n2]);
                ++n2;
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void QuickSortMinToMax(int[] var0, int var1_1, int var2_2) {
        block5: {
            var3_3 = var1_1;
            var4_4 = var2_2;
            if (var2_2 <= var1_1) break block5;
            var5_5 = var0[(int)Math.round((double)(var1_1 + var2_2) / 2.0)];
            ** GOTO lbl16
            {
                ++var3_3;
                do {
                    if (var3_3 < var2_2 && var0[var3_3] < var5_5) continue block0;
                    while (var4_4 > var1_1 && var0[var4_4] > var5_5) {
                        --var4_4;
                    }
                    if (var3_3 > var4_4) continue;
                    ArrayMath.swap(var0, var3_3, var4_4);
                    ++var3_3;
                    --var4_4;
lbl16:
                    // 3 sources

                } while (var3_3 <= var4_4);
            }
            if (var1_1 < var4_4) {
                ArrayMath.QuickSortMinToMax(var0, var1_1, var4_4);
            }
            if (var3_3 < var2_2) {
                ArrayMath.QuickSortMinToMax(var0, var3_3, var2_2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void QuickSortMaxToMin(int[] var0, int var1_1, int var2_2) {
        block5: {
            var3_3 = var1_1;
            var4_4 = var2_2;
            if (var2_2 <= var1_1) break block5;
            var5_5 = var0[(int)Math.round((double)(var1_1 + var2_2) / 2.0)];
            ** GOTO lbl16
            {
                ++var3_3;
                do {
                    if (var3_3 < var2_2 && var0[var3_3] > var5_5) continue block0;
                    while (var4_4 > var1_1 && var0[var4_4] < var5_5) {
                        --var4_4;
                    }
                    if (var3_3 > var4_4) continue;
                    ArrayMath.swap(var0, var3_3, var4_4);
                    ++var3_3;
                    --var4_4;
lbl16:
                    // 3 sources

                } while (var3_3 <= var4_4);
            }
            if (var1_1 < var4_4) {
                ArrayMath.QuickSortMaxToMin(var0, var1_1, var4_4);
            }
            if (var3_3 < var2_2) {
                ArrayMath.QuickSortMaxToMin(var0, var3_3, var2_2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void QuickSortMinToMax(double[] var0, int var1_1, int var2_2) {
        block5: {
            var3_3 = var1_1;
            var4_4 = var2_2;
            if (var2_2 <= var1_1) break block5;
            var5_5 = var0[(int)Math.round((double)(var1_1 + var2_2) / 2.0)];
            ** GOTO lbl16
            {
                ++var3_3;
                do {
                    if (var3_3 < var2_2 && var0[var3_3] < var5_5) continue block0;
                    while (var4_4 > var1_1 && var0[var4_4] > var5_5) {
                        --var4_4;
                    }
                    if (var3_3 > var4_4) continue;
                    ArrayMath.swap(var0, var3_3, var4_4);
                    ++var3_3;
                    --var4_4;
lbl16:
                    // 3 sources

                } while (var3_3 <= var4_4);
            }
            if (var1_1 < var4_4) {
                ArrayMath.QuickSortMinToMax(var0, var1_1, var4_4);
            }
            if (var3_3 < var2_2) {
                ArrayMath.QuickSortMinToMax(var0, var3_3, var2_2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void QuickSortMaxToMin(double[] var0, int var1_1, int var2_2) {
        block5: {
            var3_3 = var1_1;
            var4_4 = var2_2;
            if (var2_2 <= var1_1) break block5;
            var5_5 = var0[(int)Math.round((double)(var1_1 + var2_2) / 2.0)];
            ** GOTO lbl16
            {
                ++var3_3;
                do {
                    if (var3_3 < var2_2 && var0[var3_3] > var5_5) continue block0;
                    while (var4_4 > var1_1 && var0[var4_4] < var5_5) {
                        --var4_4;
                    }
                    if (var3_3 > var4_4) continue;
                    ArrayMath.swap(var0, var3_3, var4_4);
                    ++var3_3;
                    --var4_4;
lbl16:
                    // 3 sources

                } while (var3_3 <= var4_4);
            }
            if (var1_1 < var4_4) {
                ArrayMath.QuickSortMaxToMin(var0, var1_1, var4_4);
            }
            if (var3_3 < var2_2) {
                ArrayMath.QuickSortMaxToMin(var0, var3_3, var2_2);
            }
        }
    }

    private static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private static void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }
}

