/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.ComplexVector;
import JSci.maths.Double3Vector;
import JSci.maths.DoubleVector;
import JSci.maths.Integer3Vector;
import JSci.maths.MathVector;
import JSci.maths.VectorDimensionException;

public class Complex3Vector
extends ComplexVector {
    public Complex3Vector() {
        super(3);
    }

    public Complex3Vector(double[] dArray, double[] dArray2) {
        super(dArray, dArray2);
    }

    public Complex3Vector(Complex complex, Complex complex2, Complex complex3) {
        super(3);
        this.vectorRe[0] = complex.real();
        this.vectorIm[0] = complex.imag();
        this.vectorRe[1] = complex2.real();
        this.vectorIm[1] = complex2.imag();
        this.vectorRe[2] = complex3.real();
        this.vectorIm[2] = complex3.imag();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Complex3Vector) {
            Complex3Vector complex3Vector = (Complex3Vector)object;
            return Math.abs(this.vectorRe[0] - complex3Vector.vectorRe[0]) <= GlobalSettings.ZERO_TOL && Math.abs(this.vectorIm[0] - complex3Vector.vectorIm[0]) <= GlobalSettings.ZERO_TOL && Math.abs(this.vectorRe[1] - complex3Vector.vectorRe[1]) <= GlobalSettings.ZERO_TOL && Math.abs(this.vectorIm[1] - complex3Vector.vectorIm[1]) <= GlobalSettings.ZERO_TOL && Math.abs(this.vectorRe[2] - complex3Vector.vectorRe[2]) <= GlobalSettings.ZERO_TOL && Math.abs(this.vectorIm[2] - complex3Vector.vectorIm[2]) <= GlobalSettings.ZERO_TOL;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(Complex.toString(this.vectorRe[0], this.vectorIm[0])).append(',').append(Complex.toString(this.vectorRe[1], this.vectorIm[1])).append(',').append(Complex.toString(this.vectorRe[2], this.vectorIm[2]));
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public DoubleVector real() {
        return new Double3Vector(this.vectorRe);
    }

    public DoubleVector imag() {
        return new Double3Vector(this.vectorIm);
    }

    public Complex getComponent(int n) {
        if (n >= 0 && n < 3) {
            return new Complex(this.vectorRe[n], this.vectorIm[n]);
        }
        throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
    }

    public void setComponent(int n, Complex complex) {
        if (n < 0 || n >= 3) {
            throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
        }
        this.vectorRe[n] = complex.real();
        this.vectorIm[n] = complex.imag();
    }

    public void setComponent(int n, double d, double d2) {
        if (n < 0 || n >= 3) {
            throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
        }
        this.vectorRe[n] = d;
        this.vectorIm[n] = d2;
    }

    public double norm() {
        return Math.sqrt(this.vectorRe[0] * this.vectorRe[0] + this.vectorIm[0] * this.vectorIm[0] + this.vectorRe[1] * this.vectorRe[1] + this.vectorIm[1] * this.vectorIm[1] + this.vectorRe[2] * this.vectorRe[2] + this.vectorIm[2] * this.vectorIm[2]);
    }

    public double infNorm() {
        double d = this.vectorRe[1] * this.vectorRe[1] + this.vectorIm[1] * this.vectorIm[1];
        double d2 = this.vectorRe[0] * this.vectorRe[0] + this.vectorIm[0] * this.vectorIm[0];
        if (d > d2) {
            d2 = d;
        }
        if ((d = this.vectorRe[2] * this.vectorRe[2] + this.vectorIm[2] * this.vectorIm[2]) > d2) {
            d2 = d;
        }
        return Math.sqrt(d2);
    }

    public ComplexVector conjugate() {
        double[] dArray = new double[]{-this.vectorIm[0], -this.vectorIm[1], -this.vectorIm[2]};
        return new Complex3Vector(this.vectorRe, dArray);
    }

    public Complex3Vector add(Complex3Vector complex3Vector) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = this.vectorRe[0] + complex3Vector.vectorRe[0];
        dArray2[0] = this.vectorIm[0] + complex3Vector.vectorIm[0];
        dArray[1] = this.vectorRe[1] + complex3Vector.vectorRe[1];
        dArray2[1] = this.vectorIm[1] + complex3Vector.vectorIm[1];
        dArray[2] = this.vectorRe[2] + complex3Vector.vectorRe[2];
        dArray2[2] = this.vectorIm[2] + complex3Vector.vectorIm[2];
        return new Complex3Vector(dArray, dArray2);
    }

    public Complex3Vector add(Double3Vector double3Vector) {
        double[] dArray = new double[]{this.vectorRe[0] + double3Vector.vector[0], this.vectorRe[1] + double3Vector.vector[1], this.vectorRe[2] + double3Vector.vector[2]};
        return new Complex3Vector(dArray, this.vectorIm);
    }

    public Complex3Vector add(Integer3Vector integer3Vector) {
        double[] dArray = new double[]{this.vectorRe[0] + (double)integer3Vector.vector[0], this.vectorRe[1] + (double)integer3Vector.vector[1], this.vectorRe[2] + (double)integer3Vector.vector[2]};
        return new Complex3Vector(dArray, this.vectorIm);
    }

    public Complex3Vector subtract(Complex3Vector complex3Vector) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = this.vectorRe[0] - complex3Vector.vectorRe[0];
        dArray2[0] = this.vectorIm[0] - complex3Vector.vectorIm[0];
        dArray[1] = this.vectorRe[1] - complex3Vector.vectorRe[1];
        dArray2[1] = this.vectorIm[1] - complex3Vector.vectorIm[1];
        dArray[2] = this.vectorRe[2] - complex3Vector.vectorRe[2];
        dArray2[2] = this.vectorIm[2] - complex3Vector.vectorIm[2];
        return new Complex3Vector(dArray, dArray2);
    }

    public Complex3Vector subtract(Double3Vector double3Vector) {
        double[] dArray = new double[]{this.vectorRe[0] - double3Vector.vector[0], this.vectorRe[1] - double3Vector.vector[1], this.vectorRe[2] - double3Vector.vector[2]};
        return new Complex3Vector(dArray, this.vectorIm);
    }

    public Complex3Vector subtract(Integer3Vector integer3Vector) {
        double[] dArray = new double[]{this.vectorRe[0] - (double)integer3Vector.vector[0], this.vectorRe[1] - (double)integer3Vector.vector[1], this.vectorRe[2] - (double)integer3Vector.vector[2]};
        return new Complex3Vector(dArray, this.vectorIm);
    }

    public ComplexVector scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = this.vectorRe[0] * d - this.vectorIm[0] * d2;
        dArray2[0] = this.vectorRe[0] * d2 + this.vectorIm[0] * d;
        dArray[1] = this.vectorRe[1] * d - this.vectorIm[1] * d2;
        dArray2[1] = this.vectorRe[1] * d2 + this.vectorIm[1] * d;
        dArray[2] = this.vectorRe[2] * d - this.vectorIm[2] * d2;
        dArray2[2] = this.vectorRe[2] * d2 + this.vectorIm[2] * d;
        return new Complex3Vector(dArray, dArray2);
    }

    public ComplexVector scalarMultiply(double d) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = d * this.vectorRe[0];
        dArray2[0] = d * this.vectorIm[0];
        dArray[1] = d * this.vectorRe[1];
        dArray2[1] = d * this.vectorIm[1];
        dArray[2] = d * this.vectorRe[2];
        dArray2[2] = d * this.vectorIm[2];
        return new Complex3Vector(dArray, dArray2);
    }

    public ComplexVector scalarDivide(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        if (Math.abs(d) < Math.abs(d2)) {
            double d3 = d / d2;
            double d4 = d * d3 + d2;
            dArray[0] = (this.vectorRe[0] * d3 + this.vectorIm[0]) / d4;
            dArray2[0] = (this.vectorIm[0] * d3 - this.vectorRe[0]) / d4;
            dArray[1] = (this.vectorRe[1] * d3 + this.vectorIm[1]) / d4;
            dArray2[1] = (this.vectorIm[1] * d3 - this.vectorRe[1]) / d4;
            dArray[2] = (this.vectorRe[2] * d3 + this.vectorIm[2]) / d4;
            dArray2[2] = (this.vectorIm[2] * d3 - this.vectorRe[2]) / d4;
        } else {
            double d5 = d2 / d;
            double d6 = d + d2 * d5;
            dArray[0] = (this.vectorRe[0] + this.vectorIm[0] * d5) / d6;
            dArray2[0] = (this.vectorIm[0] - this.vectorRe[0] * d5) / d6;
            dArray[1] = (this.vectorRe[1] + this.vectorIm[1] * d5) / d6;
            dArray2[1] = (this.vectorIm[1] - this.vectorRe[1] * d5) / d6;
            dArray[2] = (this.vectorRe[2] + this.vectorIm[2] * d5) / d6;
            dArray2[2] = (this.vectorIm[2] - this.vectorRe[2] * d5) / d6;
        }
        return new Complex3Vector(dArray, dArray2);
    }

    public ComplexVector scalarDivide(double d) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = this.vectorRe[0] / d;
        dArray2[0] = this.vectorIm[0] / d;
        dArray[1] = this.vectorRe[1] / d;
        dArray2[1] = this.vectorIm[1] / d;
        dArray[2] = this.vectorRe[2] / d;
        dArray2[2] = this.vectorIm[2] / d;
        return new Complex3Vector(dArray, dArray2);
    }

    public Complex scalarProduct(Complex3Vector complex3Vector) {
        return new Complex(this.vectorRe[0] * complex3Vector.vectorRe[0] + this.vectorIm[0] * complex3Vector.vectorIm[0] + this.vectorRe[1] * complex3Vector.vectorRe[1] + this.vectorIm[1] * complex3Vector.vectorIm[1] + this.vectorRe[2] * complex3Vector.vectorRe[2] + this.vectorIm[2] * complex3Vector.vectorIm[2], this.vectorIm[0] * complex3Vector.vectorRe[0] - this.vectorRe[0] * complex3Vector.vectorIm[0] + this.vectorIm[1] * complex3Vector.vectorRe[1] - this.vectorRe[1] * complex3Vector.vectorIm[1] + this.vectorIm[2] * complex3Vector.vectorRe[2] - this.vectorRe[2] * complex3Vector.vectorIm[2]);
    }

    public Complex3Vector multiply(Complex3Vector complex3Vector) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = this.vectorRe[1] * complex3Vector.vectorRe[2] - this.vectorIm[1] * complex3Vector.vectorIm[2] - this.vectorRe[2] * complex3Vector.vectorRe[1] + this.vectorIm[2] * complex3Vector.vectorIm[1];
        dArray2[0] = this.vectorRe[1] * complex3Vector.vectorIm[2] + this.vectorIm[1] * complex3Vector.vectorRe[2] - this.vectorRe[2] * complex3Vector.vectorIm[1] - this.vectorIm[2] * complex3Vector.vectorRe[1];
        dArray[1] = this.vectorRe[2] * complex3Vector.vectorRe[0] - this.vectorIm[2] * complex3Vector.vectorIm[0] - this.vectorRe[0] * complex3Vector.vectorRe[2] + this.vectorIm[0] * complex3Vector.vectorIm[2];
        dArray2[1] = this.vectorRe[2] * complex3Vector.vectorIm[0] + this.vectorIm[2] * complex3Vector.vectorRe[0] - this.vectorRe[0] * complex3Vector.vectorIm[2] - this.vectorIm[0] * complex3Vector.vectorRe[2];
        dArray[2] = this.vectorRe[0] * complex3Vector.vectorRe[1] - this.vectorIm[0] * complex3Vector.vectorIm[1] - this.vectorRe[1] * complex3Vector.vectorRe[0] + this.vectorIm[1] * complex3Vector.vectorIm[0];
        dArray2[2] = this.vectorRe[0] * complex3Vector.vectorIm[1] + this.vectorIm[0] * complex3Vector.vectorRe[1] - this.vectorRe[1] * complex3Vector.vectorIm[0] - this.vectorIm[1] * complex3Vector.vectorRe[0];
        return new Complex3Vector(dArray, dArray2);
    }

    public ComplexVector mapComponents(ComplexMapping complexMapping) {
        return new Complex3Vector(complexMapping.map(this.vectorRe[0], this.vectorIm[0]), complexMapping.map(this.vectorRe[1], this.vectorIm[1]), complexMapping.map(this.vectorRe[2], this.vectorIm[2]));
    }
}

