/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.ComplexMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleDiagonalMatrix;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.ExtraMath;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerSquareMatrix;
import JSci.maths.IntegerTridiagonalMatrix;
import JSci.maths.IntegerVector;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public final class IntegerDiagonalMatrix
extends IntegerTridiagonalMatrix {
    protected static final int DIAGONAL = 4;

    protected IntegerDiagonalMatrix(int n, int n2) {
        super(n, n2);
    }

    public IntegerDiagonalMatrix(int n) {
        this(n, 4);
        this.matrix = new int[1][n];
        this.diag = this.matrix[0];
    }

    public IntegerDiagonalMatrix(int[][] nArray) {
        this(nArray.length);
        if (nArray.length == nArray[0].length) {
            int n = 0;
            while (n < this.numRows) {
                this.diag[n] = nArray[n][n];
                ++n;
            }
        } else {
            this.matrix = null;
            throw new MatrixDimensionException("Array must be square.");
        }
    }

    public IntegerDiagonalMatrix(int[] nArray) {
        this(nArray.length, 4);
        this.matrix = new int[1][];
        this.matrix[0] = nArray;
        this.diag = this.matrix[0];
    }

    public static IntegerDiagonalMatrix identity(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = 1;
            ++n2;
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IntegerDiagonalMatrix && this.numRows == ((IntegerDiagonalMatrix)object).rows()) {
            IntegerDiagonalMatrix integerDiagonalMatrix = (IntegerDiagonalMatrix)object;
            int n = 0;
            while (n < this.numRows) {
                if (this.diag[n] != integerDiagonalMatrix.getElement(n, n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public DoubleMatrix toDoubleMatrix() {
        double[] dArray = new double[this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[n] = this.diag[n];
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public ComplexMatrix toComplexMatrix() {
        double[] dArray = new double[this.numRows];
        double[] dArray2 = new double[this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[n] = this.diag[n];
            ++n;
        }
        return new ComplexDiagonalMatrix(dArray, dArray2);
    }

    public int getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n == n2) {
                return this.diag[n];
            }
            return 0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, int n3) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols || n != n2) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.diag[n] = n3;
    }

    public boolean isSymmetric() {
        return true;
    }

    public boolean isUnitary() {
        return this.multiply(this).equals(IntegerDiagonalMatrix.identity(this.numRows));
    }

    public int det() {
        int n = this.diag[0];
        int n2 = 1;
        while (n2 < this.numRows) {
            n *= this.diag[n2];
            ++n2;
        }
        return n;
    }

    public int trace() {
        int n = this.diag[0];
        int n2 = 1;
        while (n2 < this.numRows) {
            n += this.diag[n2];
            ++n2;
        }
        return n;
    }

    public int infNorm() {
        int n = Math.abs(this.diag[0]);
        int n2 = 1;
        while (n2 < this.numRows) {
            int n3 = Math.abs(this.diag[n2]);
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public double frobeniusNorm() {
        double d = this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            d = ExtraMath.hypot(d, this.diag[n]);
            ++n;
        }
        return d;
    }

    public IntegerMatrix add(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(integerMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(integerMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(integerMatrix);
            }
        }
        if (this.numRows == integerMatrix.rows() && this.numCols == integerMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                int[] nArray2 = nArray[n3];
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + this.diag[n3];
                ++n3;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerSquareMatrix rawAdd(IntegerMatrix integerMatrix) {
        if (this.numRows == integerMatrix.numRows && this.numCols == integerMatrix.numCols) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                System.arraycopy(integerMatrix.matrix[n], 0, nArray[n], 0, this.numRows);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.numCols) {
                int[] nArray2 = nArray[n2];
                int n3 = n2;
                nArray2[n3] = nArray2[n3] + this.diag[n2];
                ++n2;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix add(IntegerSquareMatrix integerSquareMatrix) {
        switch (integerSquareMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(integerSquareMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(integerSquareMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(integerSquareMatrix);
            }
        }
        if (this.numRows == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                int[] nArray2 = nArray[n3];
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + this.diag[n3];
                ++n3;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix add(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        switch (integerTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawAddTridiagonal(integerTridiagonalMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(integerTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (n == integerTridiagonalMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.diag[0] = this.diag[0] + integerTridiagonalMatrix.getElement(0, 0);
            integerTridiagonalMatrix2.udiag[0] = integerTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix2.ldiag[n2] = integerTridiagonalMatrix.getElement(n2, n2 - 1);
                integerTridiagonalMatrix2.diag[n2] = this.diag[n2] + integerTridiagonalMatrix.getElement(n2, n2);
                integerTridiagonalMatrix2.udiag[n2] = integerTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            integerTridiagonalMatrix2.ldiag[n] = integerTridiagonalMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix2.diag[n] = this.diag[n] + integerTridiagonalMatrix.getElement(n, n);
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix rawAddTridiagonal(IntegerMatrix integerMatrix) {
        if (this.numRows == integerMatrix.numRows) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(this.numRows);
            System.arraycopy(integerMatrix.matrix[0], 0, integerTridiagonalMatrix.ldiag, 0, integerMatrix.matrix[0].length);
            System.arraycopy(integerMatrix.matrix[2], 0, integerTridiagonalMatrix.udiag, 0, integerMatrix.matrix[2].length);
            integerTridiagonalMatrix.diag[0] = this.diag[0] + integerMatrix.matrix[1][0];
            int n = 1;
            while (n < this.numRows) {
                integerTridiagonalMatrix.diag[n] = this.diag[n] + integerMatrix.matrix[1][n];
                ++n;
            }
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix add(IntegerDiagonalMatrix integerDiagonalMatrix) {
        return this.rawAddDiagonal(integerDiagonalMatrix);
    }

    private IntegerDiagonalMatrix rawAddDiagonal(IntegerMatrix integerMatrix) {
        if (this.numRows == integerMatrix.numRows) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] + integerMatrix.matrix[0][0];
            int n = 1;
            while (n < this.numRows) {
                nArray[n] = this.diag[n] + integerMatrix.matrix[0][n];
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerMatrix subtract(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(integerMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(integerMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(integerMatrix);
            }
        }
        if (this.numRows == integerMatrix.rows() && this.numCols == integerMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = -integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = -integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                int[] nArray2 = nArray[n3];
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + this.diag[n3];
                ++n3;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerSquareMatrix rawSubtract(IntegerMatrix integerMatrix) {
        if (this.numRows == integerMatrix.numRows && this.numCols == integerMatrix.numCols) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = -integerMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = -integerMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                int[] nArray2 = nArray[n3];
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + this.diag[n3];
                ++n3;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix subtract(IntegerSquareMatrix integerSquareMatrix) {
        switch (integerSquareMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(integerSquareMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(integerSquareMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(integerSquareMatrix);
            }
        }
        if (this.numRows == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = -integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = -integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                int[] nArray2 = nArray[n3];
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + this.diag[n3];
                ++n3;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix subtract(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        switch (integerTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawSubtractTridiagonal(integerTridiagonalMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(integerTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (n == integerTridiagonalMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.diag[0] = this.diag[0] - integerTridiagonalMatrix.getElement(0, 0);
            integerTridiagonalMatrix2.udiag[0] = -integerTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix2.ldiag[n2] = -integerTridiagonalMatrix.getElement(n2, n2 - 1);
                integerTridiagonalMatrix2.diag[n2] = this.diag[n2] - integerTridiagonalMatrix.getElement(n2, n2);
                integerTridiagonalMatrix2.udiag[n2] = -integerTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            integerTridiagonalMatrix2.ldiag[n] = -integerTridiagonalMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix2.diag[n] = this.diag[n] - integerTridiagonalMatrix.getElement(n, n);
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix rawSubtractTridiagonal(IntegerMatrix integerMatrix) {
        int n = this.numRows;
        if (n == integerMatrix.numRows) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix.diag[0] = this.diag[0] - integerMatrix.matrix[1][0];
            integerTridiagonalMatrix.udiag[0] = -integerMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix.ldiag[n2] = -integerMatrix.matrix[0][n2];
                integerTridiagonalMatrix.diag[n2] = this.diag[n2] - integerMatrix.matrix[1][n2];
                integerTridiagonalMatrix.udiag[n2] = -integerMatrix.matrix[2][n2];
                ++n2;
            }
            integerTridiagonalMatrix.ldiag[n] = -integerMatrix.matrix[0][n];
            integerTridiagonalMatrix.diag[n] = this.diag[n] - integerMatrix.matrix[1][n];
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix subtract(IntegerDiagonalMatrix integerDiagonalMatrix) {
        return this.rawSubtractDiagonal(integerDiagonalMatrix);
    }

    private IntegerDiagonalMatrix rawSubtractDiagonal(IntegerMatrix integerMatrix) {
        if (this.numRows == integerMatrix.numRows) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] - integerMatrix.matrix[0][0];
            int n = 1;
            while (n < this.numRows) {
                nArray[n] = this.diag[n] - integerMatrix.matrix[0][n];
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerMatrix scalarMultiply(int n) {
        int[] nArray = new int[this.numRows];
        nArray[0] = n * this.diag[0];
        int n2 = 1;
        while (n2 < this.numRows) {
            nArray[n2] = n * this.diag[n2];
            ++n2;
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public IntegerVector multiply(IntegerVector integerVector) {
        if (this.numCols == integerVector.dimension()) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] * integerVector.getComponent(0);
            int n = 1;
            while (n < this.numRows) {
                nArray[n] = this.diag[n] * integerVector.getComponent(n);
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public IntegerMatrix multiply(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(integerMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(integerMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(integerMatrix);
            }
        }
        if (this.numCols == integerMatrix.rows()) {
            int[][] nArray = new int[this.numRows][integerMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.diag[n] * integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < integerMatrix.columns()) {
                    nArray[n][n2] = this.diag[n] * integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerMatrix rawMultiply(IntegerMatrix integerMatrix) {
        if (this.numCols == integerMatrix.numRows) {
            int[][] nArray = new int[this.numRows][integerMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.diag[n] * integerMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < integerMatrix.numCols) {
                    nArray[n][n2] = this.diag[n] * integerMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix multiply(IntegerSquareMatrix integerSquareMatrix) {
        switch (integerSquareMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(integerSquareMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(integerSquareMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(integerSquareMatrix);
            }
        }
        if (this.numCols == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.numRows][integerSquareMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.diag[n] * integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < integerSquareMatrix.columns()) {
                    nArray[n][n2] = this.diag[n] * integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerSquareMatrix rawMultiply(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numCols == integerSquareMatrix.numRows) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.diag[n] * integerSquareMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.diag[n] * integerSquareMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix multiply(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        switch (integerTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawMultiplyTridiagonal(integerTridiagonalMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(integerTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (n == integerTridiagonalMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.diag[0] = this.diag[0] * integerTridiagonalMatrix.getElement(0, 0);
            integerTridiagonalMatrix2.udiag[0] = this.diag[0] * integerTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix2.ldiag[n2] = this.diag[n2] * integerTridiagonalMatrix.getElement(n2, n2 - 1);
                integerTridiagonalMatrix2.diag[n2] = this.diag[n2] * integerTridiagonalMatrix.getElement(n2, n2);
                integerTridiagonalMatrix2.udiag[n2] = this.diag[n2] * integerTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            integerTridiagonalMatrix2.ldiag[n] = this.diag[n] * integerTridiagonalMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix2.diag[n] = this.diag[n] * integerTridiagonalMatrix.getElement(n, n);
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerSquareMatrix rawMultiplyTridiagonal(IntegerMatrix integerMatrix) {
        int n = this.numRows;
        if (n == integerMatrix.numRows) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix.diag[0] = this.diag[0] * integerMatrix.matrix[1][0];
            integerTridiagonalMatrix.udiag[0] = this.diag[0] * integerMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix.ldiag[n2] = this.diag[n2] * integerMatrix.matrix[0][n2];
                integerTridiagonalMatrix.diag[n2] = this.diag[n2] * integerMatrix.matrix[1][n2];
                integerTridiagonalMatrix.udiag[n2] = this.diag[n2] * integerMatrix.matrix[2][n2];
                ++n2;
            }
            integerTridiagonalMatrix.ldiag[n] = this.diag[n] * integerMatrix.matrix[0][n];
            integerTridiagonalMatrix.diag[n] = this.diag[n] * integerMatrix.matrix[1][n];
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix multiply(IntegerDiagonalMatrix integerDiagonalMatrix) {
        return this.rawMultiplyDiagonal(integerDiagonalMatrix);
    }

    private IntegerDiagonalMatrix rawMultiplyDiagonal(IntegerMatrix integerMatrix) {
        if (this.numCols == integerMatrix.numRows) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] * integerMatrix.matrix[0][0];
            int n = 1;
            while (n < this.numRows) {
                nArray[n] = this.diag[n] * integerMatrix.matrix[0][n];
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Matrix transpose() {
        return this;
    }

    public DoubleSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        if (nArray == null) {
            nArray = new int[this.numRows + 1];
        }
        int n = 0;
        while (n < this.numRows) {
            nArray[n] = n;
            ++n;
        }
        nArray[this.numRows] = 1;
        this.LU = new DoubleDiagonalMatrix[2];
        this.LU[0] = DoubleDiagonalMatrix.identity(this.numRows);
        this.LU[1] = (DoubleDiagonalMatrix)this.toDoubleMatrix();
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleDiagonalMatrix[2];
        double[] dArray = new double[this.numRows];
        dArray[0] = Math.sqrt(this.diag[0]);
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = Math.sqrt(this.diag[n]);
            ++n;
        }
        doubleSquareMatrixArray[0] = new DoubleDiagonalMatrix(dArray);
        doubleSquareMatrixArray[1] = doubleSquareMatrixArray[0];
        return doubleSquareMatrixArray;
    }
}

