/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.algebras;

import JSci.maths.Complex;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.Double3Vector;
import JSci.maths.DoubleVector;
import JSci.maths.VectorDimensionException;
import JSci.maths.algebras.LieAlgebra;
import JSci.maths.fields.ComplexField;

public final class sp2_RDim2
extends LieAlgebra {
    private static final Complex[][] t1 = new Complex[][]{{Complex.ZERO, ComplexField.HALF}, {ComplexField.HALF, Complex.ZERO}};
    private static final Complex[][] t2 = new Complex[][]{{Complex.ZERO, ComplexField.HALF}, {ComplexField.MINUS_HALF, Complex.ZERO}};
    private static final Complex[][] t3 = new Complex[][]{{ComplexField.HALF, Complex.ZERO}, {Complex.ZERO, ComplexField.MINUS_HALF}};
    private static final ComplexSquareMatrix[] basisMatrices = new ComplexSquareMatrix[]{new ComplexSquareMatrix(t1), new ComplexSquareMatrix(t2), new ComplexSquareMatrix(t3)};
    private static sp2_RDim2 _instance;
    static /* synthetic */ Class class$JSci$maths$algebras$sp2_RDim2;

    private sp2_RDim2() {
        super("sp(2,R) [2]");
    }

    public static final sp2_RDim2 getInstance() {
        if (_instance == null) {
            Class clazz = class$JSci$maths$algebras$sp2_RDim2 == null ? (class$JSci$maths$algebras$sp2_RDim2 = sp2_RDim2.class$("JSci.maths.algebras.sp2_RDim2")) : class$JSci$maths$algebras$sp2_RDim2;
            synchronized (clazz) {
                if (_instance == null) {
                    _instance = new sp2_RDim2();
                }
            }
        }
        return _instance;
    }

    public ComplexSquareMatrix getElement(DoubleVector doubleVector) {
        ComplexMatrix complexMatrix = basisMatrices[0].scalarMultiply(doubleVector.getComponent(0));
        complexMatrix = complexMatrix.add(basisMatrices[1].scalarMultiply(doubleVector.getComponent(1)));
        complexMatrix = complexMatrix.add(basisMatrices[2].scalarMultiply(doubleVector.getComponent(2)));
        return (ComplexSquareMatrix)complexMatrix.scalarMultiply(Complex.I);
    }

    public DoubleVector multiply(DoubleVector doubleVector, DoubleVector doubleVector2) {
        if (!(doubleVector instanceof Double3Vector) || !(doubleVector2 instanceof Double3Vector)) {
            throw new VectorDimensionException("Vectors must be 3-vectors.");
        }
        return new Double3Vector(doubleVector.getComponent(2) * doubleVector2.getComponent(1) - doubleVector.getComponent(1) * doubleVector2.getComponent(2), doubleVector.getComponent(2) * doubleVector2.getComponent(0) - doubleVector.getComponent(0) * doubleVector2.getComponent(2), doubleVector.getComponent(1) * doubleVector2.getComponent(0) - doubleVector.getComponent(0) * doubleVector2.getComponent(1));
    }

    public ComplexSquareMatrix[] basis() {
        return basisMatrices;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

