/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.statistics.OutOfRangeException;

public abstract class ProbabilityDistribution {
    public abstract double probability(double var1);

    public abstract double cumulative(double var1);

    public abstract double inverse(double var1);

    protected final void checkRange(double d, double d2, double d3) {
        if (d < d2 || d > d3) {
            throw new OutOfRangeException("The argument of the distribution method should be between " + d2 + " and " + d3 + ".");
        }
    }

    protected final void checkRange(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException("The argument of the distribution method should be between 0.0 and 1.0.");
        }
    }

    protected final double findRoot(double d, double d2, double d3, double d4) {
        double d5 = d2;
        double d6 = d2;
        double d7 = 1000.0;
        int n = 0;
        while (Math.abs(d7) > 1.0E-10 && n++ < 150) {
            double d8 = this.cumulative(d5) - d;
            if (d8 < 0.0) {
                d3 = d5;
            } else {
                d4 = d5;
            }
            double d9 = this.probability(d5);
            if (d9 != 0.0) {
                d7 = d8 / d9;
                d6 = d5 - d7;
            }
            if (d6 < d3 || d6 > d4 || d9 == 0.0) {
                d6 = (d3 + d4) / 2.0;
                d7 = d6 - d5;
            }
            d5 = d6;
        }
        return d5;
    }
}

