/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.math;

public class Univariate {
    private float Q1;
    private float Q3;
    private float[] dummy_data_;
    public float[] five;
    private boolean isSorted = false;
    private float max;
    private float mean;
    private float median;
    private float min;
    private int n;
    private float[] sortx;
    private float stdev;
    private float[] summary = new float[6];
    private float variance;
    private float[] x;
    private float[] x1;

    public Univariate(float[] data) {
        this.five = new float[5];
        this.removeNaNs(data);
        this.n = this.x.length;
        this.createSummaryStats();
    }

    public float SE() {
        return (float)Math.sqrt(this.variance / (float)this.n);
    }

    public int[] between(float t1, float t2) {
        int[] indices = new int[]{this.compare(t1), this.compare(t2)};
        return indices;
    }

    public int compare(float t) {
        int index = this.n - 1;
        boolean found = false;
        int i = 0;
        while (i < this.n && !found) {
            if (this.sortx[i] > t) {
                index = i;
                found = true;
            }
            ++i;
        }
        return index;
    }

    private void createSummaryStats() {
        this.mean = 0.0f;
        int i = 0;
        while (i < this.n) {
            this.mean += this.x[i];
            ++i;
        }
        this.mean /= (float)this.n;
        this.variance = this.variance();
        this.stdev = this.stdev();
        float sumxx = 0.0f;
        this.variance = 0.0f;
        i = 0;
        while (i < this.n) {
            sumxx += this.x[i] * this.x[i];
            ++i;
        }
        if (this.n > 1) {
            this.variance = (sumxx - (float)this.n * this.mean * this.mean) / (float)(this.n - 1);
        }
        this.stdev = (float)Math.sqrt(this.variance);
    }

    public float elementAt(int index) {
        float element = 0.0f;
        try {
            element = this.x[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {}
        return element;
    }

    public float[] getData() {
        return this.x;
    }

    public int indexOf(float element) {
        int index = -1;
        int i = 0;
        while (i < this.n) {
            if ((double)Math.abs(this.x[i] - element) < 1.0E-6) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public float max() {
        if (!this.isSorted) {
            this.sortx = this.sort();
        }
        return this.sortx[this.n - 1];
    }

    public float mean() {
        return this.mean;
    }

    public float median() {
        return this.quant(0.5f);
    }

    public float min() {
        if (!this.isSorted) {
            this.sortx = this.sort();
        }
        return this.sortx[0];
    }

    public float quant(float q) {
        if (!this.isSorted) {
            this.sortx = this.sort();
        }
        if (q > 1.0f || q < 0.0f) {
            return 0.0f;
        }
        float index = (float)(this.n + 1) * q;
        if (index - (float)((int)index) == 0.0f) {
            return this.sortx[(int)index - 1];
        }
        return q * this.sortx[(int)Math.floor(index) - 1] + (1.0f - q) * this.sortx[(int)Math.ceil(index) - 1];
    }

    private void removeNaNs(float[] data) {
        int len_1 = data.length;
        int len_2 = 0;
        this.dummy_data_ = new float[len_1];
        int i = 0;
        while (i < len_1) {
            float value = data[i];
            if (!Float.isNaN(value)) {
                this.dummy_data_[len_2] = value;
                ++len_2;
            }
            ++i;
        }
        this.x = new float[len_2];
        int i2 = 0;
        while (i2 < len_2) {
            this.x[i2] = this.dummy_data_[i2];
            ++i2;
        }
    }

    public int size() {
        return this.n;
    }

    public float[] sort() {
        this.sortx = (float[])this.x.clone();
        int incr = (int)((double)this.n * 0.5);
        while (incr >= 1) {
            int i = incr;
            while (i < this.n) {
                float temp = this.sortx[i];
                int j = i;
                while (j >= incr && temp < this.sortx[j - incr]) {
                    this.sortx[j] = this.sortx[j - incr];
                    j -= incr;
                }
                this.sortx[j] = temp;
                ++i;
            }
            incr /= 2;
        }
        this.isSorted = true;
        return this.sortx;
    }

    public float stdev() {
        return this.stdev;
    }

    public float[] subset(int[] indices) {
        int k = indices.length;
        int i = 0;
        float[] elements = new float[k];
        try {
            i = 0;
            while (i < k) {
                elements[i] = this.x[k];
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Index " + i + " does not exist in data.");
            e.printStackTrace();
        }
        return elements;
    }

    public float[] summary() {
        this.summary[0] = this.n;
        this.summary[1] = this.mean;
        this.summary[2] = this.variance;
        this.summary[3] = this.stdev;
        this.summary[4] = (float)Math.sqrt(this.variance / (float)this.n);
        this.summary[5] = this.mean / this.summary[4];
        return this.summary;
    }

    public float variance() {
        return this.variance;
    }
}

