/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.normalize;

import at.tugraz.genome.arraynormcore.microarrayobjects.ExperimentData;
import at.tugraz.genome.arraynormcore.normalize.NormalizeMethod;
import at.tugraz.genome.math.MathFunctions;

public class LowessRegressionMethod
implements NormalizeMethod {
    public float[] calculateLowess(float[] x_in, float[] y_in, int neighbours, float span) {
        int num_genes = x_in.length;
        float x_min_ = MathFunctions.min(x_in);
        float x_max_ = MathFunctions.max(x_in);
        float x_range_ = x_max_ - x_min_;
        int num_neighbours_ = num_genes / 50;
        float span_ = x_range_ / 10.0f;
        float[] x_neighbours = new float[num_neighbours_];
        float[] y_neighbours = new float[num_neighbours_];
        float[] x_out = new float[num_genes];
        float[] y_out = new float[num_genes];
        int cnt_i = 0;
        while (cnt_i < num_genes) {
            float value = x_in[cnt_i];
            if (!Float.isNaN(value)) {
                float distance = 0.0f;
                int points = 0;
                int cnt_j = 0;
                while (cnt_j < num_genes) {
                    float dist_1;
                    float value_1 = x_in[cnt_j];
                    if (!Float.isNaN(value_1) && (cnt_j > cnt_i || cnt_j < cnt_i) && (dist_1 = Math.abs(value - x_in[cnt_j])) < span_ && points < num_neighbours_) {
                        x_neighbours[points] = x_in[cnt_j];
                        y_neighbours[points] = y_in[cnt_j];
                        if (distance < dist_1) {
                            distance = dist_1;
                        }
                        ++points;
                    }
                    ++cnt_j;
                }
                float[] x_2 = MathFunctions.zerosArray(num_neighbours_);
                int i = 0;
                while (i < points) {
                    x_2[i] = value;
                    ++i;
                }
                float[] d_1 = new float[num_neighbours_];
                d_1 = MathFunctions.subtractArrays(x_2, x_neighbours);
                float[] b_1 = new float[num_neighbours_];
                b_1 = MathFunctions.divideArrayByConst(d_1, distance);
                b_1 = MathFunctions.absoluteArray(b_1);
                float sum_w = MathFunctions.sum(b_1);
                b_1 = MathFunctions.powerArray(b_1, 3);
                float[] o_1 = MathFunctions.onesArray(num_neighbours_);
                float[] weight = new float[num_neighbours_];
                weight = MathFunctions.subtractArrays(o_1, b_1);
                weight = MathFunctions.powerArray(weight, 3);
                sum_w = MathFunctions.sum(weight);
                float sum_x_neig = MathFunctions.sum(x_neighbours);
                float[] dummy_product = MathFunctions.innerProduct(weight, x_neighbours);
                float sum_wx = MathFunctions.sum(dummy_product);
                dummy_product = MathFunctions.innerProduct(weight, y_neighbours);
                float sum_wy = MathFunctions.sum(dummy_product);
                float[] dummy_powered = MathFunctions.powerArray(x_neighbours, 2);
                dummy_product = MathFunctions.innerProduct(weight, dummy_powered);
                float sum_wx2 = MathFunctions.sum(dummy_product);
                dummy_powered = MathFunctions.powerArray(y_neighbours, 2);
                dummy_product = MathFunctions.innerProduct(weight, dummy_powered);
                float sum_wy2 = MathFunctions.sum(dummy_product);
                dummy_product = MathFunctions.innerProduct(x_neighbours, y_neighbours);
                dummy_product = MathFunctions.innerProduct(weight, dummy_product);
                float sum_wxy = MathFunctions.sum(dummy_product);
                float numerator = sum_w * sum_wxy - sum_wx * sum_wy;
                float del_1 = sum_w * sum_wx2 - (float)Math.pow(sum_wx, 2.0);
                float del_2 = sum_w * sum_wy2 - (float)Math.pow(sum_wy, 2.0);
                float slope = numerator / del_1;
                float intercept = (sum_wx2 * sum_wy - sum_wx * sum_wxy) / del_1;
                x_out[cnt_i] = value;
                y_out[cnt_i] = slope * x_in[cnt_i] + intercept;
            }
            ++cnt_i;
        }
        return y_out;
    }

    public void normalize(ExperimentData.ExpClass exp_class) {
        float[] const_1;
        float[] result_y;
        float[] a_in;
        float[] dummy_3;
        float[] m_in;
        float[] dummy_2;
        float[] dummy_1;
        int num_spots = exp_class.num_spots_;
        int num_normal_slides = exp_class.num_normal_slides_;
        int num_dysw_slides = exp_class.num_dysw_slides_;
        int slide_cnt = 0;
        while (slide_cnt < num_normal_slides) {
            dummy_1 = (float[])exp_class.expclass_normal_data_[slide_cnt][0].clone();
            dummy_2 = (float[])exp_class.expclass_normal_data_[slide_cnt][1].clone();
            m_in = MathFunctions.ratioOfArrays(dummy_1, dummy_2);
            m_in = MathFunctions.log2(m_in);
            dummy_3 = MathFunctions.addArrays(MathFunctions.log2(dummy_1), MathFunctions.log2(dummy_2));
            a_in = MathFunctions.multArrayWithConst(dummy_3, 0.5f);
            result_y = this.calculateLowess(a_in, m_in, 0, 0.0f);
            const_1 = MathFunctions.exp2(result_y);
            exp_class.expclass_normal_data_[slide_cnt][1] = MathFunctions.innerProduct(exp_class.expclass_normal_data_[slide_cnt][1], const_1);
            ++slide_cnt;
        }
        slide_cnt = 0;
        while (slide_cnt < num_dysw_slides) {
            dummy_1 = (float[])exp_class.expclass_dysw_data_[slide_cnt][0].clone();
            dummy_2 = (float[])exp_class.expclass_dysw_data_[slide_cnt][1].clone();
            m_in = MathFunctions.ratioOfArrays(dummy_1, dummy_2);
            m_in = MathFunctions.log2(m_in);
            dummy_3 = MathFunctions.addArrays(MathFunctions.log2(dummy_1), MathFunctions.log2(dummy_2));
            a_in = MathFunctions.multArrayWithConst(dummy_3, 0.5f);
            result_y = this.calculateLowess(a_in, m_in, 0, 0.0f);
            const_1 = MathFunctions.exp2(result_y);
            exp_class.expclass_dysw_data_[slide_cnt][1] = MathFunctions.innerProduct(exp_class.expclass_dysw_data_[slide_cnt][1], const_1);
            ++slide_cnt;
        }
    }
}

