/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.normalize;

import at.tugraz.genome.arraynormcore.microarrayobjects.ExperimentData;
import at.tugraz.genome.arraynormcore.normalize.NormalizeMethod;
import at.tugraz.genome.math.MathFunctions;

public class SelfnormMethod
implements NormalizeMethod {
    private static float[][] averageDyeswapped(ExperimentData.ExpClass exp_class) {
        float mean_temp = 0.0f;
        int row = 3;
        int num_spots = exp_class.num_spots_;
        int num_dys_slids = exp_class.num_dysw_slides_;
        float[][] help_matrix = new float[num_dys_slids][num_spots];
        float[] temp = new float[num_dys_slids];
        float[][] ave_data = new float[3][num_spots];
        int k_ = 0;
        while (k_ < 2) {
            int he = 0;
            while (he < num_dys_slids) {
                help_matrix[he] = exp_class.expclass_dysw_data_[he][k_];
                ++he;
            }
            int j_ = 0;
            while (j_ < num_spots) {
                int i_ = 0;
                while (i_ < num_dys_slids) {
                    temp[i_] = help_matrix[i_][j_];
                    ++i_;
                }
                ave_data[k_][j_] = mean_temp = MathFunctions.mean(temp);
                ++j_;
            }
            ++k_;
        }
        ave_data[2] = MathFunctions.ratioOfArrays(ave_data[0], ave_data[1]);
        return ave_data;
    }

    public void normalize(ExperimentData.ExpClass exp_class) {
        if (exp_class.all_dyeswapped_) {
            System.out.println("selfnormalisation not possible, all are dyeswapped...");
        } else if (!exp_class.any_dyeswapt_) {
            System.out.println("selfnormalisation not possible, none are dyeswapped...");
        } else {
            int num_normal = exp_class.num_normal_slides_;
            int num_dysw = exp_class.num_dysw_slides_;
            int[] pindex_normal = exp_class.pairs_index_normal_;
            int[] pindex_dysw = exp_class.pairs_index_dysw_;
            if (num_normal == pindex_normal.length) {
                System.out.println("hepp, correct number of normal slides");
            } else {
                System.out.println("uje, no correct number of normal slides");
            }
            if (num_dysw == pindex_dysw.length) {
                System.out.println("hepp, correct number of dysw slides");
            } else {
                System.out.println("uje, no correct number of dysw slides");
            }
            float[][] ave_dysw = SelfnormMethod.averageDyeswapped(exp_class);
            int cnt_i = 0;
            while (cnt_i < num_normal) {
                if (pindex_normal[cnt_i] == 0) {
                    SelfnormMethod.selfNormEngine(exp_class.expclass_normal_data_[cnt_i], ave_dysw);
                    exp_class.expclass_dysw_data_[cnt_i][0] = ave_dysw[0];
                    exp_class.expclass_dysw_data_[cnt_i][1] = ave_dysw[1];
                } else if (pindex_normal[cnt_i] != 0) {
                    int cnt_j = 0;
                    while (cnt_j < num_dysw) {
                        if (pindex_normal[cnt_i] == pindex_dysw[cnt_j]) {
                            System.out.println("pair found:: slide_norm " + cnt_i + " slide_dysw " + cnt_j);
                            SelfnormMethod.selfNormEngine(exp_class.expclass_normal_data_[cnt_i], exp_class.expclass_dysw_data_[cnt_j]);
                        } else if (pindex_normal[cnt_i] != pindex_dysw[cnt_j]) {
                            System.out.println("no matching pindex at " + pindex_dysw[cnt_j]);
                        }
                        ++cnt_j;
                    }
                }
                ++cnt_i;
            }
        }
        exp_class.class_norm_method_ = "selfnorm";
    }

    private static void selfNormEngine(float[][] normal, float[][] dysw) {
        int num_spots = normal[0].length;
        float[][] normal_corr = new float[3][num_spots];
        float[] denom = new float[num_spots];
        float[] nom = new float[num_spots];
        float[] cy5_n = normal[0];
        float[] cy3_n = normal[1];
        float[] cy5_d = dysw[0];
        float[] cy3_d = dysw[1];
        normal_corr[0] = cy5_n;
        nom = MathFunctions.innerProduct(cy5_n, cy5_d);
        denom = MathFunctions.innerProduct(cy3_n, cy3_d);
        nom = MathFunctions.ratioOfArrays(nom, denom);
        nom = MathFunctions.sqrtArray(nom);
        normal_corr[1] = MathFunctions.innerProduct(cy3_n, nom);
        normal_corr[2] = MathFunctions.ratioOfArrays(normal_corr[0], normal_corr[1]);
        normal[0] = normal_corr[0];
        normal[1] = normal_corr[1];
        normal[2] = normal_corr[2];
        dysw[0] = normal_corr[1];
        dysw[1] = normal_corr[0];
        dysw[2] = MathFunctions.ratioOfArrays(dysw[0], dysw[1]);
    }
}

