/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.plot;

import at.tugraz.genome.arraynormcore.math.NormalZeroOneDistribution;
import at.tugraz.genome.arraynormcore.math.Univariate;
import at.tugraz.genome.arraynormcore.microarrayobjects.ExperimentData;
import at.tugraz.genome.math.MathFunctions;
import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.data.JCDefaultDataSource;
import java.util.Arrays;

public class VisualDataModel
implements ChartDataModel {
    private JCDefaultDataSource[] allslidesboxpl_datamodel_ = null;
    private JCDefaultDataSource[] boxpl_datamodel_ = null;
    private JCDefaultDataSource classwise_ma_datamodel_ = null;
    int[] ctrl_marks_;
    private JCDefaultDataSource diagnostics_g_model_ = null;
    private JCDefaultDataSource diagnostics_r_model_ = null;
    private ExperimentData.ExpClass exp_class_;
    private ExperimentData experiment_;
    private JCDefaultDataSource hist_normaldist_datamodel_ = null;
    private ChartDataModel[] histo_complete_datamodel_ = null;
    private JCDefaultDataSource histo_datamodel_ = null;
    private double histo_max_frequ_;
    private double histo_mean_;
    private double histo_range_x_;
    private double histo_stddev_;
    private JCDefaultDataSource histo_zerolinemodel_ = null;
    float[][] input_data_;
    private JCDefaultDataSource ma_ctrlspots_datamodel_ = null;
    private JCDefaultDataSource ma_datamodel_ = null;
    private JCDefaultDataSource ma_zerolinemodel_ = null;
    int num_spots_;
    private JCDefaultDataSource qq_idealdist_datamodel_ = null;
    private JCDefaultDataSource qq_realdist_datamodel_ = null;
    private ChartDataModel[] qqplot_complete_datamodel_ = null;
    private JCDefaultDataSource scat_ctrlspots_datamodel_ = null;
    private JCDefaultDataSource scat_datamodel_ = null;
    private JCDefaultDataSource scat_zerolinemodel_ = null;
    double[][] x_in_;
    double[][] y_in_;

    public VisualDataModel(ExperimentData experiment) {
        int cnter = 0;
        System.out.println("[VisualDataModel::constructor 2]");
        this.experiment_ = experiment;
        this.num_spots_ = experiment.experiment_class_[0].num_spots_;
        int num_slides = experiment.num_slides_;
        int num_classes = experiment.num_expe_classes_;
        this.input_data_ = new float[num_slides][this.num_spots_];
        int i = 0;
        while (i < num_classes) {
            float[] ratiodumy;
            float[] f532dumy;
            float[] f635dumy;
            int j = 0;
            while (j < experiment.experiment_class_[i].num_normal_slides_) {
                f635dumy = (float[])experiment.experiment_class_[i].expclass_normal_data_[j][0].clone();
                f532dumy = (float[])experiment.experiment_class_[i].expclass_normal_data_[j][1].clone();
                ratiodumy = MathFunctions.ratioOfArrays(f635dumy, f532dumy);
                System.out.println("[VisualDataModel::constructor] -> dummy ratio mean = " + MathFunctions.mean(ratiodumy));
                System.out.println("[VisualDataModel::constructor] -> dummy ratio median = " + MathFunctions.median(ratiodumy));
                ratiodumy = MathFunctions.log2(ratiodumy);
                this.input_data_[cnter] = (float[])ratiodumy.clone();
                ++cnter;
                ++j;
            }
            int k = 0;
            while (k < experiment.experiment_class_[i].num_dysw_slides_) {
                f635dumy = (float[])experiment.experiment_class_[i].expclass_dysw_data_[k][0].clone();
                f532dumy = (float[])experiment.experiment_class_[i].expclass_dysw_data_[k][1].clone();
                ratiodumy = MathFunctions.ratioOfArrays(f635dumy, f532dumy);
                ratiodumy = MathFunctions.log2(ratiodumy);
                this.input_data_[cnter] = (float[])ratiodumy.clone();
                ++cnter;
                ++k;
            }
            ++i;
        }
    }

    public VisualDataModel(float[][] input_dat, ExperimentData.ExpClass exp_class) {
        int x = input_dat.length;
        int y = input_dat[0].length;
        System.out.println("[VisualDataModel::constructor1] -> x = " + x + "  ,  y = " + y);
        this.input_data_ = (float[][])input_dat.clone();
        this.exp_class_ = exp_class;
        this.num_spots_ = this.input_data_[0].length;
        this.ctrl_marks_ = new int[this.num_spots_];
        this.ctrl_marks_ = exp_class.is_ctrl_;
    }

    public ChartDataModel[] createBoxplotAllSlidesDataModel() {
        ChartDataView allslidesboxplot_view = new ChartDataView();
        allslidesboxplot_view.setName("ShareView");
        float[][] dummy_1 = (float[][])this.input_data_.clone();
        int num_boxes = dummy_1.length;
        Univariate[] boxes_dat = new Univariate[num_boxes];
        float[] min = new float[num_boxes];
        float[] max = new float[num_boxes];
        float[] q_1 = new float[num_boxes];
        float[] med = new float[num_boxes];
        float[] mean = new float[num_boxes];
        float[] q_3 = new float[num_boxes];
        float[] iq_range = new float[num_boxes];
        float[] l_f = new float[num_boxes];
        float[] u_f = new float[num_boxes];
        int[] lw_i = new int[num_boxes];
        int[] uw_i = new int[num_boxes];
        int i = 0;
        while (i < num_boxes) {
            float[] temp = dummy_1[i];
            boxes_dat[i] = new Univariate(temp);
            float meee = MathFunctions.mean(temp);
            float meeedian = MathFunctions.median(temp);
            System.out.println("[VisualDataModel::createBoxplotAllSlides] -> meee = " + meee);
            System.out.println("[VisualDataModel::createBoxplotAllSlides] -> meeedian = " + meeedian);
            System.out.println("[VisualDataModel::createBoxplotAllSlides] -> boxdatmean = " + boxes_dat[i].mean());
            System.out.println("[VisualDataModel::createBoxplotAllSlides] -> boxdatmedian = " + boxes_dat[i].median());
            System.out.println("[VisualDataModel::createBoxplotAllSlides] -> boxquantile50 = " + boxes_dat[i].quant(0.5f));
            System.out.println("----------------------------------------------------------------------------------------");
            int num_rel_vals = MathFunctions.countReliableValues(boxes_dat[i].getData());
            if (num_rel_vals < 1) {
                boxes_dat[i] = null;
                boxes_dat[i] = new Univariate(MathFunctions.zerosArray(10));
            }
            min[i] = boxes_dat[i].min();
            max[i] = boxes_dat[i].max();
            ++i;
        }
        float[][] data_sorted = new float[num_boxes][1];
        int count = 0;
        while (count < num_boxes) {
            data_sorted[count] = boxes_dat[count].sort();
            q_1[count] = boxes_dat[count].quant(0.25f);
            med[count] = boxes_dat[count].quant(0.5f);
            q_3[count] = boxes_dat[count].quant(0.75f);
            iq_range[count] = q_3[count] - q_1[count];
            l_f[count] = med[count] - 1.5f * iq_range[count];
            u_f[count] = med[count] + 1.5f * iq_range[count];
            lw_i[count] = boxes_dat[count].compare(l_f[count]);
            uw_i[count] = boxes_dat[count].compare(u_f[count]);
            mean[count] = boxes_dat[count].mean();
            ++count;
        }
        double[] lf = new double[num_boxes];
        double[] uf = new double[num_boxes];
        double[] lwi = new double[num_boxes];
        double[] uwi = new double[num_boxes];
        double[] x_ser = new double[num_boxes];
        double[] box_med = new double[num_boxes];
        double[] box_mean = new double[num_boxes];
        double[] whisk_up = new double[num_boxes];
        double[] whisk_lo = new double[num_boxes];
        int i2 = 0;
        while (i2 < num_boxes) {
            lf[i2] = data_sorted[i2][lw_i[i2]];
            uf[i2] = data_sorted[i2][uw_i[i2]];
            lwi[i2] = q_1[i2];
            uwi[i2] = q_3[i2];
            x_ser[i2] = i2 + 1;
            box_med[i2] = med[i2];
            box_mean[i2] = mean[i2];
            whisk_up[i2] = data_sorted[i2][uw_i[i2]];
            whisk_lo[i2] = data_sorted[i2][lw_i[i2]];
            ++i2;
        }
        this.allslidesboxpl_datamodel_ = new JCDefaultDataSource[5];
        JCDefaultDataSource boxes = new JCDefaultDataSource();
        JCDefaultDataSource medians = new JCDefaultDataSource();
        JCDefaultDataSource means = new JCDefaultDataSource();
        JCDefaultDataSource whiskers = new JCDefaultDataSource();
        JCDefaultDataSource zero_line = new JCDefaultDataSource();
        double[][] box_ser1 = new double[4][num_boxes];
        box_ser1[0] = lf;
        box_ser1[1] = uf;
        box_ser1[2] = lwi;
        box_ser1[3] = uwi;
        boxes.setYSeries(0, box_ser1[0]);
        boxes.setYSeries(1, box_ser1[1]);
        boxes.setYSeries(2, box_ser1[2]);
        boxes.setYSeries(3, box_ser1[3]);
        boxes.setXSeries(0, x_ser);
        boxes.setName("boxplot");
        double[][] med_x = new double[1][num_boxes];
        double[][] med_y = new double[1][num_boxes];
        med_y[0] = box_med;
        med_x[0] = x_ser;
        medians.setData(med_x, med_y);
        double[][] mean_x = new double[1][num_boxes];
        double[][] mean_y = new double[1][num_boxes];
        mean_y[0] = box_mean;
        mean_x[0] = x_ser;
        means.setData(mean_x, mean_y);
        double[][] whisks = new double[2][num_boxes];
        whisks[0] = whisk_up;
        whisks[1] = whisk_lo;
        whiskers.setData(med_x, whisks);
        double[][] zerol_x = new double[1][2];
        double[][] zerol_y = new double[1][2];
        zerol_x[0][0] = 1.0;
        zerol_x[0][1] = num_boxes + 1;
        zerol_y[0][0] = 0.0;
        zerol_y[0][1] = 0.0;
        zero_line.setData(zerol_x, zerol_y);
        this.allslidesboxpl_datamodel_[0] = boxes;
        this.allslidesboxpl_datamodel_[1] = medians;
        this.allslidesboxpl_datamodel_[2] = whiskers;
        this.allslidesboxpl_datamodel_[3] = zero_line;
        this.allslidesboxpl_datamodel_[4] = means;
        return this.allslidesboxpl_datamodel_;
    }

    public ChartDataModel[] createBoxplotDataModel() {
        ChartDataView boxplot_view = new ChartDataView();
        boxplot_view.setName("ShareView");
        float[] dummy_1 = MathFunctions.ratioOfArrays(this.input_data_[0], this.input_data_[1]);
        dummy_1 = MathFunctions.log2(dummy_1);
        float[][] dummy_2 = this.exp_class_.splitExpClassDataIntoBlocs(dummy_1);
        int num_boxes = dummy_2.length;
        Univariate[] boxes_dat = new Univariate[num_boxes];
        float[] min = new float[num_boxes];
        float[] max = new float[num_boxes];
        float[] q_1 = new float[num_boxes];
        float[] med = new float[num_boxes];
        float[] mean = new float[num_boxes];
        float[] q_3 = new float[num_boxes];
        float[] iq_range = new float[num_boxes];
        float[] l_f = new float[num_boxes];
        float[] u_f = new float[num_boxes];
        int[] lw_i = new int[num_boxes];
        int[] uw_i = new int[num_boxes];
        int i = 0;
        while (i < num_boxes) {
            float[] temp = dummy_2[i];
            boxes_dat[i] = new Univariate(temp);
            int num_rel_vals = MathFunctions.countReliableValues(boxes_dat[i].getData());
            if (num_rel_vals < 1) {
                boxes_dat[i] = null;
                boxes_dat[i] = new Univariate(MathFunctions.zerosArray(10));
            }
            min[i] = boxes_dat[i].min();
            max[i] = boxes_dat[i].max();
            ++i;
        }
        float[][] data_sorted = new float[num_boxes][1];
        int count = 0;
        while (count < num_boxes) {
            data_sorted[count] = boxes_dat[count].sort();
            q_1[count] = boxes_dat[count].quant(0.25f);
            med[count] = boxes_dat[count].quant(0.5f);
            q_3[count] = boxes_dat[count].quant(0.75f);
            iq_range[count] = q_3[count] - q_1[count];
            l_f[count] = med[count] - 1.5f * iq_range[count];
            u_f[count] = med[count] + 1.5f * iq_range[count];
            lw_i[count] = boxes_dat[count].compare(l_f[count]);
            uw_i[count] = boxes_dat[count].compare(u_f[count]);
            mean[count] = boxes_dat[count].mean();
            ++count;
        }
        double[] lf = new double[num_boxes];
        double[] uf = new double[num_boxes];
        double[] lwi = new double[num_boxes];
        double[] uwi = new double[num_boxes];
        double[] x_ser = new double[num_boxes];
        double[] box_med = new double[num_boxes];
        double[] box_mean = new double[num_boxes];
        double[] whisk_up = new double[num_boxes];
        double[] whisk_lo = new double[num_boxes];
        int i2 = 0;
        while (i2 < num_boxes) {
            lf[i2] = data_sorted[i2][lw_i[i2]];
            uf[i2] = data_sorted[i2][uw_i[i2]];
            lwi[i2] = q_1[i2];
            uwi[i2] = q_3[i2];
            x_ser[i2] = i2 + 1;
            box_med[i2] = med[i2];
            box_mean[i2] = mean[i2];
            whisk_up[i2] = data_sorted[i2][uw_i[i2]];
            whisk_lo[i2] = data_sorted[i2][lw_i[i2]];
            ++i2;
        }
        this.boxpl_datamodel_ = new JCDefaultDataSource[5];
        JCDefaultDataSource boxes = new JCDefaultDataSource();
        JCDefaultDataSource medians = new JCDefaultDataSource();
        JCDefaultDataSource means = new JCDefaultDataSource();
        JCDefaultDataSource whiskers = new JCDefaultDataSource();
        JCDefaultDataSource zero_line = new JCDefaultDataSource();
        double[][] box_ser1 = new double[4][num_boxes];
        box_ser1[0] = lf;
        box_ser1[1] = uf;
        box_ser1[2] = lwi;
        box_ser1[3] = uwi;
        boxes.setYSeries(0, box_ser1[0]);
        boxes.setYSeries(1, box_ser1[1]);
        boxes.setYSeries(2, box_ser1[2]);
        boxes.setYSeries(3, box_ser1[3]);
        boxes.setXSeries(0, x_ser);
        boxes.setName("boxplot");
        double[][] med_x = new double[1][num_boxes];
        double[][] med_y = new double[1][num_boxes];
        med_y[0] = box_med;
        med_x[0] = x_ser;
        medians.setData(med_x, med_y);
        double[][] mean_x = new double[1][num_boxes];
        double[][] mean_y = new double[1][num_boxes];
        mean_y[0] = box_mean;
        mean_x[0] = x_ser;
        means.setData(mean_x, mean_y);
        double[][] whisks = new double[2][num_boxes];
        whisks[0] = whisk_up;
        whisks[1] = whisk_lo;
        whiskers.setData(med_x, whisks);
        double[][] zerol_x = new double[1][2];
        double[][] zerol_y = new double[1][2];
        zerol_x[0][0] = 1.0;
        zerol_x[0][1] = num_boxes + 1;
        zerol_y[0][0] = 0.0;
        zerol_y[0][1] = 0.0;
        zero_line.setData(zerol_x, zerol_y);
        this.boxpl_datamodel_[0] = boxes;
        this.boxpl_datamodel_[1] = medians;
        this.boxpl_datamodel_[2] = whiskers;
        this.boxpl_datamodel_[3] = zero_line;
        this.boxpl_datamodel_[4] = means;
        return this.boxpl_datamodel_;
    }

    public ChartDataModel[] createCompleteHistoDataModel() {
        this.histo_complete_datamodel_ = new ChartDataModel[3];
        ChartDataModel hist1 = this.createHistoDataModel();
        ChartDataModel hist2 = this.createHistoZerolineModel();
        ChartDataModel hist3 = this.createHistoNormalDistDataModel(this.getHistoMean(), this.getHistoRange(), this.getHistoStddev(), this.getHistoMaxFrequ());
        this.histo_complete_datamodel_[0] = hist1;
        this.histo_complete_datamodel_[1] = hist2;
        this.histo_complete_datamodel_[2] = hist3;
        return this.histo_complete_datamodel_;
    }

    public ChartDataModel createDiagnosticZerolineModel() {
        double x_min = MathFunctions.min(this.diagnostics_r_model_.getXSeries(0));
        double x_max = MathFunctions.max(this.diagnostics_r_model_.getXSeries(0));
        double[][] x_in = new double[1][2];
        double[][] y_in = new double[1][2];
        x_in[0][0] = x_min;
        x_in[0][1] = x_max;
        y_in[0][0] = 0.5;
        y_in[0][1] = 0.5;
        this.ma_zerolinemodel_ = new JCDefaultDataSource();
        this.ma_zerolinemodel_.setData(x_in, y_in);
        this.ma_zerolinemodel_.setName("Line y = 0.5");
        return this.ma_zerolinemodel_;
    }

    public ChartDataModel createGreenDiagnosticsModel() {
        double[][] x_in = new double[1][this.num_spots_];
        double[][] y_in = new double[1][this.num_spots_];
        int i = 0;
        while (i < this.num_spots_) {
            x_in[0][i] = i;
            y_in[0][i] = this.input_data_[1][i];
            if (Float.isNaN(this.input_data_[1][i])) {
                y_in[0][i] = Double.MAX_VALUE;
            }
            ++i;
        }
        this.diagnostics_g_model_ = new JCDefaultDataSource();
        this.diagnostics_g_model_.setData(x_in, y_in);
        this.diagnostics_g_model_.setName("Green channel");
        return this.diagnostics_g_model_;
    }

    public ChartDataModel createHistoDataModel() {
        float[] dummy_1 = MathFunctions.ratioOfArrays(this.input_data_[0], this.input_data_[1]);
        dummy_1 = MathFunctions.log2(dummy_1);
        System.out.println("[VisualDataModel::createHistoDataModel] -> dummy1mean = " + MathFunctions.mean(dummy_1));
        System.out.println("[VisualDataModel::createHistoDataModel] -> dummy1median = " + MathFunctions.median(dummy_1));
        float min_x = MathFunctions.min(dummy_1);
        float max_x = MathFunctions.max(dummy_1);
        float max_y = 0.0f;
        int samp_size = dummy_1.length;
        int bins = (int)Math.ceil(1.0 + Math.log(samp_size) / Math.log(2.0));
        float[] bin_bounds = new float[(bins *= 2) + 1];
        float[] bin_cumulative = new float[bins + 1];
        float[] bin_counts = new float[bins];
        float bin_width = (max_x - min_x) / (float)bins;
        int i = 0;
        while (i <= bins) {
            bin_bounds[i] = min_x + bin_width * (float)i;
            ++i;
        }
        bin_cumulative[0] = 0.0f;
        int i2 = 1;
        while (i2 <= bins) {
            bin_cumulative[i2] = 0.0f;
            int j = 0;
            while (j < samp_size) {
                if (dummy_1[j] <= bin_bounds[i2]) {
                    int n = i2;
                    bin_cumulative[n] = bin_cumulative[n] + 1.0f;
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < bins) {
            bin_counts[i3] = (bin_cumulative[i3 + 1] - bin_cumulative[i3]) / (bin_width * (float)samp_size);
            if (i3 == 0) {
                max_y = bin_counts[0];
            } else if (bin_counts[i3] > max_y) {
                max_y = bin_counts[i3];
            }
            ++i3;
        }
        float[][] histo_x = new float[1][bins];
        float[][] histo_y = new float[1][bins];
        double[][] x_in = new double[1][bins];
        double[][] y_in = new double[1][bins];
        int i4 = 0;
        while (i4 < bins) {
            histo_x[0][i4] = (bin_bounds[i4] + bin_bounds[i4 + 1]) / 2.0f;
            ++i4;
        }
        histo_y[0] = bin_counts;
        int i5 = 0;
        while (i5 < bins) {
            x_in[0][i5] = histo_x[0][i5];
            y_in[0][i5] = histo_y[0][i5];
            ++i5;
        }
        this.histo_range_x_ = Math.abs(MathFunctions.min(x_in[0])) + Math.abs(MathFunctions.max(x_in[0]));
        this.histo_stddev_ = MathFunctions.stddeviation(dummy_1);
        this.histo_mean_ = MathFunctions.mean(dummy_1);
        this.histo_max_frequ_ = MathFunctions.max(y_in[0]);
        this.histo_datamodel_ = new JCDefaultDataSource();
        this.histo_datamodel_.setData(x_in, y_in);
        this.histo_datamodel_.setName("log2(R/G)");
        return this.histo_datamodel_;
    }

    public ChartDataModel createHistoNormalDistDataModel(double histmean, double histrange, double stddev, double max) {
        int samp_size = this.input_data_[0].length;
        NormalZeroOneDistribution normaldist = new NormalZeroOneDistribution((float)histmean, (float)stddev, samp_size);
        float[] dummy_1 = normaldist.getDistribution();
        float min_x = MathFunctions.min(dummy_1);
        float max_x = MathFunctions.max(dummy_1);
        float max_y = 0.0f;
        int bins = (int)Math.ceil(1.0 + Math.log(samp_size) / Math.log(2.0));
        float[] bin_bounds = new float[(bins *= 2) + 1];
        float[] bin_cumulative = new float[bins + 1];
        float[] bin_counts = new float[bins];
        float bin_width = (max_x - min_x) / (float)bins;
        int i = 0;
        while (i <= bins) {
            bin_bounds[i] = min_x + bin_width * (float)i;
            ++i;
        }
        bin_cumulative[0] = 0.0f;
        int i2 = 1;
        while (i2 <= bins) {
            bin_cumulative[i2] = 0.0f;
            int j = 0;
            while (j < samp_size) {
                if (dummy_1[j] <= bin_bounds[i2]) {
                    int n = i2;
                    bin_cumulative[n] = bin_cumulative[n] + 1.0f;
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < bins) {
            bin_counts[i3] = (bin_cumulative[i3 + 1] - bin_cumulative[i3]) / (bin_width * (float)samp_size);
            if (i3 == 0) {
                max_y = bin_counts[0];
            } else if (bin_counts[i3] > max_y) {
                max_y = bin_counts[i3];
            }
            ++i3;
        }
        float[][] histo_x = new float[1][bins];
        float[][] histo_y = new float[1][bins];
        double[][] x_in = new double[1][bins];
        double[][] y_in = new double[1][bins];
        int i4 = 0;
        while (i4 < bins) {
            histo_x[0][i4] = (bin_bounds[i4] + bin_bounds[i4 + 1]) / 2.0f;
            ++i4;
        }
        histo_y[0] = bin_counts;
        float max_cnt = MathFunctions.max(bin_counts);
        int i5 = 0;
        while (i5 < bins) {
            x_in[0][i5] = histo_x[0][i5];
            y_in[0][i5] = (double)histo_y[0][i5] * max / (double)max_cnt;
            ++i5;
        }
        this.hist_normaldist_datamodel_ = new JCDefaultDataSource();
        this.hist_normaldist_datamodel_.setData(x_in, y_in);
        this.hist_normaldist_datamodel_.setName("N(0,1)");
        return this.hist_normaldist_datamodel_;
    }

    public ChartDataModel createHistoZerolineModel() {
        double[][] x_in = new double[1][2];
        double[][] y_in = new double[1][2];
        x_in[0][0] = 0.0;
        x_in[0][1] = 0.0;
        y_in[0][0] = 0.0;
        y_in[0][1] = 1.0;
        this.histo_zerolinemodel_ = new JCDefaultDataSource();
        this.histo_zerolinemodel_.setData(x_in, y_in);
        this.histo_zerolinemodel_.setName("log2(R/G) = 0");
        return this.histo_zerolinemodel_;
    }

    public ChartDataModel createMACtrlSpotsModel() {
        int num_ctrls = this.exp_class_.num_ctrls_;
        double[][] x_in = new double[1][num_ctrls];
        double[][] y_in = new double[1][num_ctrls];
        double[][] m_in = new double[1][num_ctrls];
        double[][] a_in = new double[1][num_ctrls];
        if (this.exp_class_.num_ctrls_ > 1) {
            int cnt = 0;
            int i = 0;
            while (i < this.num_spots_) {
                if (this.exp_class_.is_ctrl_[i] != 0) {
                    x_in[0][cnt] = this.input_data_[0][i];
                    y_in[0][cnt] = this.input_data_[1][i];
                    ++cnt;
                }
                ++i;
            }
            m_in[0] = MathFunctions.ratioOfArrays(x_in[0], y_in[0]);
            m_in[0] = MathFunctions.log2(m_in[0]);
            a_in[0] = MathFunctions.addArrays(MathFunctions.log2(x_in[0]), MathFunctions.log2(y_in[0]));
            a_in[0] = MathFunctions.multArrayWithConst(a_in[0], 0.5);
            this.ma_ctrlspots_datamodel_ = new JCDefaultDataSource();
            this.ma_ctrlspots_datamodel_.setData(a_in, m_in);
            this.ma_ctrlspots_datamodel_.setName("Controls");
        }
        return this.ma_ctrlspots_datamodel_;
    }

    public ChartDataModel createMADataModel() {
        float temp1 = 0.0f;
        float temp2 = 0.0f;
        this.x_in_ = new double[1][this.num_spots_];
        this.y_in_ = new double[1][this.num_spots_];
        double[][] m_in = new double[1][this.num_spots_];
        double[][] a_in = new double[1][this.num_spots_];
        int i = 0;
        while (i < this.num_spots_) {
            temp1 = this.input_data_[0][i];
            temp2 = this.input_data_[1][i];
            if (temp1 != 0.0f && temp2 != 0.0f) {
                this.x_in_[0][i] = temp1;
                this.y_in_[0][i] = temp2;
            } else {
                this.x_in_[0][i] = Double.NaN;
                this.y_in_[0][i] = Double.NaN;
            }
            ++i;
        }
        m_in[0] = MathFunctions.ratioOfArrays(this.x_in_[0], this.y_in_[0]);
        m_in[0] = MathFunctions.log2(m_in[0]);
        a_in[0] = MathFunctions.innerProduct(this.x_in_[0], this.y_in_[0]);
        a_in[0] = MathFunctions.sqrtArray(a_in[0]);
        a_in[0] = MathFunctions.log2(a_in[0]);
        this.ma_datamodel_ = new JCDefaultDataSource();
        this.ma_datamodel_.setData(a_in, m_in);
        this.ma_datamodel_.setName("Spots");
        return this.ma_datamodel_;
    }

    public ChartDataModel createMADataModelClasswise(int cla) {
        int points = 0;
        float temp1 = 0.0f;
        float temp2 = 0.0f;
        points = this.experiment_.final_exp_log2_ratios_[cla].length;
        float[] dummy_x = new float[points];
        float[] dummy_y = new float[points];
        dummy_x = (float[])this.experiment_.final_exp_avalues_[cla].clone();
        dummy_y = (float[])this.experiment_.final_exp_log2_ratios_[cla].clone();
        double[][] m_in = new double[1][points];
        double[][] a_in = new double[1][points];
        int i = 0;
        while (i < this.num_spots_) {
            temp1 = dummy_x[i];
            temp2 = dummy_y[i];
            if (temp1 != 0.0f && temp2 != 0.0f) {
                a_in[0][i] = temp1;
                m_in[0][i] = temp2;
            } else {
                a_in[0][i] = Double.NaN;
                m_in[0][i] = Double.NaN;
            }
            ++i;
        }
        this.ma_datamodel_ = new JCDefaultDataSource();
        this.ma_datamodel_.setData(a_in, m_in);
        this.ma_datamodel_.setName("");
        return this.ma_datamodel_;
    }

    public ChartDataModel createMAZerolineModel() {
        double x_min = MathFunctions.min(this.ma_datamodel_.getXSeries(0));
        double x_max = MathFunctions.max(this.ma_datamodel_.getXSeries(0));
        double[][] x_in = new double[1][2];
        double[][] y_in = new double[1][2];
        x_in[0][0] = x_min;
        x_in[0][1] = x_max;
        y_in[0][0] = 0.0;
        y_in[0][1] = 0.0;
        this.ma_zerolinemodel_ = new JCDefaultDataSource();
        this.ma_zerolinemodel_.setData(x_in, y_in);
        this.ma_zerolinemodel_.setName("Line log2(R/G) = 0");
        return this.ma_zerolinemodel_;
    }

    public ChartDataModel[] createQQPlotDataModel() {
        int num_quants = 20;
        float[] dummy_1 = MathFunctions.ratioOfArrays(this.input_data_[0], this.input_data_[1]);
        dummy_1 = MathFunctions.log2(dummy_1);
        int samp_size = MathFunctions.countReliableValues(dummy_1);
        float mean = MathFunctions.mean(dummy_1);
        float stddev = MathFunctions.stddeviation(dummy_1);
        NormalZeroOneDistribution basis_dist = new NormalZeroOneDistribution(mean, stddev, samp_size);
        float[] dummy_2 = basis_dist.getDistribution();
        Arrays.sort(dummy_1);
        Arrays.sort(dummy_2);
        int quant_pcnt = samp_size / num_quants;
        double[][] x_in_real = new double[1][samp_size];
        double[][] y_in_real = new double[1][samp_size];
        this.qq_realdist_datamodel_ = new JCDefaultDataSource();
        double hole_val = this.qq_realdist_datamodel_.getHoleValue();
        int i = 0;
        while (i < samp_size - 1) {
            x_in_real[0][i] = dummy_2[i];
            y_in_real[0][i] = dummy_1[i];
            if (Double.isNaN(y_in_real[0][i])) {
                x_in_real[0][i] = hole_val;
                y_in_real[0][i] = hole_val;
            }
            ++i;
        }
        double[][] x_in_ideal = new double[1][2];
        double[][] y_in_ideal = new double[1][2];
        x_in_ideal[0][0] = dummy_2[0];
        y_in_ideal[0][0] = dummy_2[0];
        x_in_ideal[0][1] = dummy_2[samp_size - 1];
        y_in_ideal[0][1] = dummy_2[samp_size - 1];
        this.qq_realdist_datamodel_.setData(x_in_real, y_in_real);
        this.qq_realdist_datamodel_.setName("QQ realdist");
        this.qq_idealdist_datamodel_ = new JCDefaultDataSource();
        this.qq_idealdist_datamodel_.setData(x_in_ideal, y_in_ideal);
        this.qq_idealdist_datamodel_.setName("QQ normaldist");
        this.qqplot_complete_datamodel_ = new ChartDataModel[2];
        this.qqplot_complete_datamodel_[0] = this.qq_realdist_datamodel_;
        this.qqplot_complete_datamodel_[1] = this.qq_idealdist_datamodel_;
        return this.qqplot_complete_datamodel_;
    }

    public ChartDataModel createRedDiagnosticsModel() {
        double[][] x_in = new double[1][this.num_spots_];
        double[][] y_in = new double[1][this.num_spots_];
        int i = 0;
        while (i < this.num_spots_) {
            x_in[0][i] = i;
            y_in[0][i] = this.input_data_[0][i];
            if (Float.isNaN(this.input_data_[0][i])) {
                y_in[0][i] = Double.MAX_VALUE;
            }
            ++i;
        }
        this.diagnostics_r_model_ = new JCDefaultDataSource();
        this.diagnostics_r_model_.setData(x_in, y_in);
        this.diagnostics_r_model_.setName("Red channel");
        return this.diagnostics_r_model_;
    }

    public ChartDataModel createScatCtrlSpotsModel() {
        int num_ctrls = this.exp_class_.num_ctrls_;
        double temp1 = 0.0;
        double temp2 = 0.0;
        double[][] x_in_ = new double[1][num_ctrls];
        double[][] y_in_ = new double[1][num_ctrls];
        if (this.exp_class_.num_ctrls_ > 1) {
            int cnt = 0;
            int i = 0;
            while (i < this.num_spots_) {
                if (this.exp_class_.is_ctrl_[i] != 0) {
                    x_in_[0][cnt] = this.input_data_[0][i];
                    y_in_[0][cnt] = this.input_data_[1][i];
                    ++cnt;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < num_ctrls) {
                temp1 = x_in_[0][i2];
                temp2 = y_in_[0][i2];
                if (!Double.isNaN(temp1) && !Double.isNaN(temp2)) {
                    x_in_[0][i2] = temp1;
                    y_in_[0][i2] = temp2;
                } else {
                    x_in_[0][i2] = Double.NaN;
                    y_in_[0][i2] = Double.NaN;
                }
                ++i2;
            }
            x_in_[0] = MathFunctions.log2(x_in_[0]);
            y_in_[0] = MathFunctions.log2(y_in_[0]);
            this.scat_ctrlspots_datamodel_ = new JCDefaultDataSource();
            this.scat_ctrlspots_datamodel_.setData(x_in_, y_in_);
            this.scat_ctrlspots_datamodel_.setName("Controls");
        }
        return this.scat_ctrlspots_datamodel_;
    }

    public ChartDataModel createScatDataModel() {
        float temp1 = 0.0f;
        float temp2 = 0.0f;
        this.x_in_ = new double[1][this.num_spots_];
        this.y_in_ = new double[1][this.num_spots_];
        this.scat_datamodel_ = new JCDefaultDataSource();
        double hole_val = this.scat_datamodel_.getHoleValue();
        int i = 0;
        while (i < this.num_spots_) {
            temp1 = this.input_data_[0][i];
            temp2 = this.input_data_[1][i];
            if (!Float.isNaN(temp1) && !Float.isNaN(temp2)) {
                this.x_in_[0][i] = temp1;
                this.y_in_[0][i] = temp2;
            } else {
                this.x_in_[0][i] = Double.NaN;
                this.y_in_[0][i] = Double.NaN;
            }
            ++i;
        }
        this.x_in_[0] = MathFunctions.log2(this.x_in_[0]);
        this.y_in_[0] = MathFunctions.log2(this.y_in_[0]);
        this.scat_datamodel_.setData(this.x_in_, this.y_in_);
        this.scat_datamodel_.setName("Spots");
        return this.scat_datamodel_;
    }

    public ChartDataModel createScatZerolineModel() {
        float[] dumy0 = MathFunctions.log2(this.input_data_[0]);
        float[] dumy1 = MathFunctions.log2(this.input_data_[1]);
        double x_min = MathFunctions.min(dumy0);
        double x_max = MathFunctions.max(dumy0);
        double y_min = MathFunctions.min(dumy1);
        double y_max = MathFunctions.max(dumy1);
        double xy_origin = Math.min(x_min, y_min);
        double[][] x_in = new double[1][2];
        double[][] y_in = new double[1][2];
        x_in[0][0] = xy_origin;
        x_in[0][1] = x_max;
        y_in[0][0] = xy_origin;
        y_in[0][1] = x_max;
        this.scat_zerolinemodel_ = new JCDefaultDataSource();
        this.scat_zerolinemodel_.setData(x_in, y_in);
        this.scat_zerolinemodel_.setName("Line log2(R/G) = 1");
        return this.scat_zerolinemodel_;
    }

    public double getHistoMaxFrequ() {
        return this.histo_max_frequ_;
    }

    public double getHistoMean() {
        return this.histo_mean_;
    }

    public double getHistoRange() {
        return this.histo_range_x_;
    }

    public double getHistoStddev() {
        return this.histo_stddev_;
    }

    public int getNumSeries() {
        return 1;
    }

    public double[] getXSeries(int index) {
        return this.x_in_[0];
    }

    public double[] getYSeries(int index) {
        return this.y_in_[0];
    }
}

