/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.transform;

import at.tugraz.genome.arraynormcore.microarrayobjects.MicroArrayData;
import at.tugraz.genome.math.MathFunctions;
import java.util.Vector;

public class AllLogTransforms {
    public static Vector linlogShift(Vector in, int lolim, int uplim, float cutoff) {
        int r_len = 0;
        int g_len = 0;
        float[] red = new float[r_len];
        float[] green = new float[g_len];
        red = (float[])in.get(0);
        green = (float[])in.get(1);
        if (MathFunctions.min(red) <= 0.0f | MathFunctions.min(green) <= 0.0f) {
            System.out.println("one or more elements zero");
            return null;
        }
        r_len = red.length;
        g_len = green.length;
        Vector<float[]> out_linlogshifted = new Vector<float[]>();
        Vector c = new Vector();
        float[] c_arr = new float[r_len];
        float[] sad = new float[r_len];
        float offset = 0.0f;
        int offset_index = 0;
        float[] x1 = new float[r_len];
        float[] x2 = new float[r_len];
        float[] dummy = new float[r_len];
        c = MathFunctions.createLinSpacedVector(lolim, uplim, 100);
        c_arr = (float[])c.get(0);
        int i = 0;
        while (i < 100) {
            x1 = MathFunctions.subtractFromArray(red, c_arr[i]);
            x2 = MathFunctions.addToArray(green, c_arr[i]);
            x1 = AllLogTransforms.linlogTransform(x1, cutoff);
            x2 = AllLogTransforms.linlogTransform(x2, cutoff);
            dummy = MathFunctions.subtractArrays(x1, x2);
            sad[i] = MathFunctions.sum(MathFunctions.subtractFromArray(dummy, MathFunctions.median(dummy)));
            ++i;
        }
        offset_index = MathFunctions.find(sad, MathFunctions.min(sad), 0);
        offset = -c_arr[offset_index];
        red = MathFunctions.addToArray(red, offset);
        green = MathFunctions.subtractFromArray(green, offset);
        red = AllLogTransforms.linlogTransform(red, cutoff);
        green = AllLogTransforms.linlogTransform(green, cutoff);
        out_linlogshifted.add(red);
        out_linlogshifted.add(green);
        return out_linlogshifted;
    }

    public static float[] linlogTransform(float[] x_in, float cutoff) {
        int x_len = x_in.length;
        float[] x_out = new float[x_len];
        float cutoff_value = MathFunctions.max(x_in) * cutoff;
        float cutoff_value_log = (float)Math.log(cutoff_value) / 0.6931472f;
        if (MathFunctions.min(x_in) <= 0.0f) {
            System.out.println("one or more elements zero");
            return null;
        }
        int count = 0;
        while (count < x_len) {
            if (x_in[count] <= cutoff_value) {
                x_out[count] = x_in[count] / cutoff_value + cutoff_value_log;
            } else if (x_in[count] > cutoff_value) {
                x_out[count] = (float)Math.log(x_in[count]) / 0.6931472f;
            }
            ++count;
        }
        return x_out;
    }

    public static void logTransform(MicroArrayData ma_object, int log_mode) {
        int data_len = ma_object.num_spots_;
        switch (log_mode) {
            case 0: {
                float[] cy5_array = ma_object.getF635median_();
                float[] cy3_array = ma_object.getF532median_();
                System.out.println("logging the red");
                int count = 0;
                while (count < data_len) {
                    ma_object.DataMatrix_[count][0] = (float)Math.log(cy5_array[count]) / 0.6931472f;
                    ++count;
                }
                System.out.println("logging the green");
                count = 0;
                while (count < data_len) {
                    ma_object.DataMatrix_[count][2] = (float)Math.log(cy3_array[count]) / 0.6931472f;
                    ++count;
                }
                break;
            }
            case 1: {
                float[] cy5_array = ma_object.getF635median_();
                int count = 0;
                while (count < data_len) {
                    ma_object.DataMatrix_[count][0] = (float)Math.log(cy5_array[count]) / 0.6931472f;
                    ++count;
                }
                break;
            }
            case 2: {
                float[] cy3_array = ma_object.getF532median_();
                int count = 0;
                while (count < data_len) {
                    ma_object.DataMatrix_[count][2] = (float)Math.log(cy3_array[count]) / 0.6931472f;
                    ++count;
                }
                break;
            }
            default: {
                float[] cy5_array = ma_object.getF635median_();
                float[] cy3_array = ma_object.getF532median_();
                int count = 0;
                while (count < data_len) {
                    ma_object.DataMatrix_[count][0] = (float)Math.log(cy5_array[count]) / 0.6931472f;
                    ++count;
                }
                count = 0;
                while (count < data_len) {
                    ma_object.DataMatrix_[count][2] = (float)Math.log(cy3_array[count]) / 0.6931472f;
                    ++count;
                }
                break block0;
            }
        }
    }

    public static float[] logTransform(float[] in) {
        return MathFunctions.log2(in);
    }
}

