/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormgui.gui;

import at.tugraz.genome.arraynormgui.gui.LeafInfo;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DynamicTree
extends JPanel {
    private String lineStyle = "Horizontal";
    protected DefaultMutableTreeNode root_node_;
    protected JTree the_tree_;
    private Toolkit toolkit_ = Toolkit.getDefaultToolkit();
    protected DefaultTreeModel tree_model_;

    public DynamicTree() {
        this.root_node_ = new DefaultMutableTreeNode(new LeafInfo("Navigation Tree", 1000, 0, 0));
        this.tree_model_ = new DefaultTreeModel(this.root_node_);
        this.tree_model_.addTreeModelListener(new DynamicTreeModelListener());
        this.the_tree_ = new JTree(this.tree_model_);
        this.the_tree_.setEditable(false);
        this.the_tree_.setRootVisible(true);
        this.the_tree_.setShowsRootHandles(true);
        this.the_tree_.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.the_tree_);
        this.the_tree_.putClientProperty("JTree.lineStyle", "Angled");
        this.setLayout(new GridLayout(1, 0));
        this.add(this.the_tree_);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child, boolean should_be_visible) {
        DefaultMutableTreeNode child_node = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = this.root_node_;
        }
        this.tree_model_.insertNodeInto(child_node, parent, parent.getChildCount());
        if (should_be_visible) {
            this.the_tree_.scrollPathToVisible(new TreePath(child_node.getPath()));
        }
        return child_node;
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child) {
        return this.addObject(parent, child, false);
    }

    public DefaultMutableTreeNode addObject(Object child) {
        DefaultMutableTreeNode parent_node = null;
        TreePath parent_path = this.the_tree_.getSelectionPath();
        parent_node = parent_path == null ? this.root_node_ : (DefaultMutableTreeNode)parent_path.getLastPathComponent();
        return this.addObject(parent_node, child, true);
    }

    public void clear() {
        this.root_node_.removeAllChildren();
        this.tree_model_.reload();
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public void expandAll() {
        TreeNode root = (TreeNode)this.the_tree_.getModel().getRoot();
        this.expandAll(this.the_tree_, new TreePath(root), true);
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode current_node;
        MutableTreeNode parent;
        TreePath current_selection = this.the_tree_.getSelectionPath();
        if (current_selection != null && (parent = (MutableTreeNode)(current_node = (DefaultMutableTreeNode)current_selection.getLastPathComponent()).getParent()) != null) {
            this.tree_model_.removeNodeFromParent(current_node);
            return;
        }
        this.toolkit_.beep();
    }

    public void removeNodeX(DefaultMutableTreeNode node_x) {
        this.tree_model_.removeNodeFromParent(node_x);
    }

    class DynamicTreeModelListener
    implements TreeModelListener {
        DynamicTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
            try {
                int index = e.getChildIndices()[0];
                node = (DefaultMutableTreeNode)node.getChildAt(index);
            }
            catch (NullPointerException exc) {
            }
        }

        public void treeNodesInserted(TreeModelEvent e) {
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
        }
    }
}

